/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.Statement;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.test.BlankParsedSection;
import org.hsqldb.test.CountParsedSection;
import org.hsqldb.test.DisplaySection;
import org.hsqldb.test.ExceptionParsedSection;
import org.hsqldb.test.IgnoreParsedSection;
import org.hsqldb.test.ParsedSection;
import org.hsqldb.test.ResultSetParsedSection;
import org.hsqldb.test.SilentParsedSection;
import org.hsqldb.test.UpdateParsedSection;

public class TestUtil {
    static void testScript(Connection connection, String string) {
        try {
            Statement statement = connection.createStatement();
            File file = new File(string);
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            HsqlArrayList hsqlArrayList = null;
            TestUtil.print("Opened test script file: " + file.getAbsolutePath());
            int n = 1;
            while (true) {
                boolean bl = false;
                String string2 = lineNumberReader.readLine();
                if (string2 == null) break;
                if ((string2 = string2.substring(0, StringUtil.rTrimSize(string2))).length() == 0 || string2.startsWith("--")) continue;
                if (string2.startsWith("/*")) {
                    bl = true;
                }
                if (string2.charAt(0) != ' ' && string2.charAt(0) != '*') {
                    bl = true;
                }
                if (bl) {
                    if (hsqlArrayList != null) {
                        TestUtil.testSection(statement, hsqlArrayList, n);
                    }
                    hsqlArrayList = new HsqlArrayList();
                    n = lineNumberReader.getLineNumber();
                }
                hsqlArrayList.add(string2);
            }
            if (hsqlArrayList != null) {
                TestUtil.testSection(statement, hsqlArrayList, n);
            }
            statement.close();
            TestUtil.print("Processed lines: " + lineNumberReader.getLineNumber());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestUtil.print("test script file error: " + exception.getMessage());
        }
    }

    static void test(Statement statement, String string, int n) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        hsqlArrayList.add(string);
        TestUtil.testSection(statement, hsqlArrayList, n);
    }

    static void print(String string) {
        System.out.println(string);
    }

    private static void testSection(Statement statement, HsqlArrayList hsqlArrayList, int n) {
        ParsedSection parsedSection = TestUtil.parsedSectionFactory(hsqlArrayList);
        if (parsedSection == null) {
            TestUtil.print("The section starting at line " + n + " could not be parsed, " + "and so was not processed.\n");
        } else if (parsedSection instanceof IgnoreParsedSection) {
            TestUtil.print("Line " + n + ": " + parsedSection.getResultString());
        } else if (parsedSection instanceof DisplaySection) {
            TestUtil.print(parsedSection.getResultString());
        } else if (!parsedSection.test(statement)) {
            TestUtil.print("section starting at line " + n);
            TestUtil.print("returned an unexpected result:");
            TestUtil.print(parsedSection.toString());
        }
    }

    private static ParsedSection parsedSectionFactory(HsqlArrayList hsqlArrayList) {
        char c = ' ';
        String[] stringArray = null;
        String string = (String)hsqlArrayList.get(0);
        if (string.startsWith("/*")) {
            c = string.charAt(2);
            if (!ParsedSection.isValidCode(c)) {
                return null;
            }
            if (Character.isUpperCase(c) && Boolean.getBoolean("IgnoreCodeCase")) {
                c = Character.toLowerCase(c);
            }
            string = string.substring(3);
        }
        int n = 0;
        if (string.trim().length() > 0) {
            stringArray = new String[hsqlArrayList.size()];
            stringArray[0] = string;
        } else {
            stringArray = new String[hsqlArrayList.size() - 1];
            n = 1;
        }
        for (int i = 1 - n; i < stringArray.length; ++i) {
            stringArray[i] = (String)hsqlArrayList.get(i + n);
        }
        switch (c) {
            case 'u': {
                return new UpdateParsedSection(stringArray);
            }
            case 's': {
                return new SilentParsedSection(stringArray);
            }
            case 'r': {
                return new ResultSetParsedSection(stringArray);
            }
            case 'c': {
                return new CountParsedSection(stringArray);
            }
            case 'd': {
                return new DisplaySection(stringArray);
            }
            case 'e': {
                return new ExceptionParsedSection(stringArray);
            }
            case ' ': {
                return new BlankParsedSection(stringArray);
            }
        }
        return new IgnoreParsedSection(stringArray, c);
    }
}

