/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestTimestamp
extends TestCase {
    Connection conn = null;
    TimeZone timeZone = null;
    long id = 10L;
    String checkTimestamp = "2003-09-04 16:42:58";
    String checkTimestampOra = "2003-09-04 16:42:58";
    private String nameTable = null;
    private static Timestamp testTS = new Timestamp(System.currentTimeMillis());

    public TestTimestamp(String string) {
        super(string);
    }

    private void initOracle() throws Exception {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        this.conn = DriverManager.getConnection("jdbc:oracle:thin:@oracle:1521:MILL", "aaa", "qqq");
        this.conn.setAutoCommit(false);
    }

    private void initHypersonic() throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        this.conn = DriverManager.getConnection("jdbc:hsqldb:mem:.", "sa", "");
        this.conn.setAutoCommit(false);
    }

    private void checkExceptionTableExistsOracle(SQLException sQLException) {
    }

    private void checkExceptionTableExistsHsql(SQLException sQLException) {
        Assert.assertTrue((String)"Error code of SQLException is wrong", (sQLException.getErrorCode() == -21 ? 1 : 0) != 0);
    }

    public void testHypersonic() throws Exception {
        this.nameTable = "\"AAA_TEST\"";
        this.setTimeZone();
        this.initHypersonic();
        this.dropAllTables();
        this.createTestTable("CREATE TABLE " + this.nameTable + " (T timestamp, id DECIMAL)");
        try {
            this.createTestTable("CREATE TABLE " + this.nameTable + " (T timestamp, id DECIMAL)");
        }
        catch (SQLException sQLException) {
            this.checkExceptionTableExistsHsql(sQLException);
        }
        this.createTestTable("create table \"CASH_CURRENCY\" ( \"ID_CURRENCY\" bigint NOT NULL , \"ID_SITE\" bigint )");
        this.createTestTable("create table \"CASH_CURR_VALUE\" ( \"ID_CURRENCY\" bigint NOT NULL , \"DATE_CHANGE\" TIMESTAMP DEFAULT sysdate, \"CURS\" bigint, \"ID_CURVAL\" DECIMAL NOT NULL )");
        this.insertTestData();
        this.conn.createStatement().executeUpdate("INSERT INTO \"CASH_CURR_VALUE\" VALUES(134,'2003-09-04 16:42:58.729',1.01,155)");
        this.conn.createStatement().executeUpdate("INSERT INTO \"CASH_CURR_VALUE\" VALUES(135,'" + this.checkTimestamp + "',34.51,156)");
        this.doTest();
        this.conn.close();
        this.conn = null;
    }

    private void dropAllTables() throws Exception {
        this.dropTestTable(this.nameTable);
        this.dropTestTable("\"SITE_LIST_SITE\"");
        this.dropTestTable("\"SITE_VIRTUAL_HOST\"");
        this.dropTestTable("\"SITE_SUPPORT_LANGUAGE\"");
        this.dropTestTable("\"CASH_CURRENCY\"");
        this.dropTestTable("\"CASH_CURR_VALUE\"");
    }

    private void doTest() throws Exception {
        PreparedStatement preparedStatement = this.conn.prepareStatement("select max(T) T1 from " + this.nameTable + " where ID=?");
        preparedStatement.setLong(1, this.id);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = resultSet.next();
        Assert.assertTrue((String)"Record in DB not found", (boolean)bl);
        Timestamp timestamp = resultSet.getTimestamp("T1");
        preparedStatement.close();
        preparedStatement = null;
        Assert.assertTrue((String)"Timestamp not found", (timestamp != null ? 1 : 0) != 0);
        Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        cloneable.setTimeZone(this.timeZone);
        Object object = cloneable.format(timestamp);
        String string = cloneable.format(testTS);
        System.out.println("db timestamp " + (String)object + ", test timestamp " + string);
        Assert.assertTrue((String)"Timestamp is wrong", (boolean)((String)object).equals(string));
        cloneable = this.getCurrentCurs();
        Assert.assertTrue((String)"Timestamp curs not found", (cloneable != null ? 1 : 0) != 0);
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        ((DateFormat)object).setTimeZone(this.timeZone);
        string = ((DateFormat)object).format((Date)cloneable);
        Assert.assertTrue((String)"Timestamp curs is wrong", (boolean)string.equals(this.checkTimestamp));
        System.out.println("db timestamp curs " + string + ", test timestamp curs " + this.checkTimestamp);
    }

    private void insertTestData() throws Exception {
        this.conn.createStatement().executeUpdate("INSERT INTO \"CASH_CURRENCY\" VALUES(134,23)");
        this.conn.createStatement().executeUpdate("INSERT INTO \"CASH_CURRENCY\" VALUES(135,23)");
        PreparedStatement preparedStatement = this.conn.prepareStatement("insert into " + this.nameTable + "(T, ID) values (?, ?)");
        preparedStatement.setTimestamp(1, testTS);
        preparedStatement.setLong(2, this.id);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = null;
        this.conn.commit();
    }

    private void createTestTable(String string) throws Exception {
        Statement statement = this.conn.createStatement();
        statement.execute(string);
        statement.close();
        statement = null;
    }

    private void dropTestTable(String string) throws Exception {
        String string2 = "drop table " + string;
        Statement statement = this.conn.createStatement();
        try {
            statement.execute(string2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        statement = null;
    }

    private void setTimeZone() {
        this.timeZone = TimeZone.getTimeZone("Asia/Irkutsk");
        TimeZone.setDefault(this.timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getCurrentCurs() throws Exception {
        Timestamp timestamp;
        Timestamp timestamp2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string;
        long l;
        long l2;
        block10: {
            Timestamp timestamp3;
            l2 = 134L;
            l = 23L;
            string = "select max(f.DATE_CHANGE) LAST_DATE from  CASH_CURR_VALUE f, CASH_CURRENCY b where f.ID_CURRENCY=b.ID_CURRENCY and b.ID_SITE=? and f.ID_CURRENCY=? ";
            preparedStatement = null;
            resultSet = null;
            timestamp2 = null;
            try {
                preparedStatement = this.conn.prepareStatement(string);
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, l2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    timestamp2 = resultSet.getTimestamp("LAST_DATE");
                    break block10;
                }
                timestamp3 = null;
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                resultSet.close();
                preparedStatement.close();
                resultSet = null;
                preparedStatement = null;
                throw throwable;
            }
            resultSet.close();
            preparedStatement.close();
            resultSet = null;
            preparedStatement = null;
            return timestamp3;
        }
        Timestamp timestamp4 = null;
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        System.out.println("ts in db " + timestamp2);
        if (timestamp2 == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS", Locale.ENGLISH);
            simpleDateFormat.setTimeZone(this.timeZone);
            String string2 = simpleDateFormat.format(timestamp2);
            System.out.println("String ts in db " + string2);
        }
        catch (Throwable throwable) {
            System.out.println("Error get timestamp " + throwable.toString());
        }
        string = "select  a.ID_CURRENCY, a.DATE_CHANGE, a.CURS from CASH_CURR_VALUE a, CASH_CURRENCY b where a.ID_CURRENCY=b.ID_CURRENCY and b.ID_SITE=? and a.ID_CURRENCY=? and DATE_CHANGE = ?";
        preparedStatement = null;
        resultSet = null;
        timestamp4 = null;
        try {
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setTimestamp(3, timestamp2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                double d = resultSet.getDouble("CURS");
                timestamp4 = resultSet.getTimestamp("DATE_CHANGE");
            }
            timestamp = timestamp4;
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            resultSet.close();
            preparedStatement.close();
            resultSet = null;
            preparedStatement = null;
            throw throwable;
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return timestamp;
    }
}

