/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import junit.swingui.TestRunner;
import org.hsqldb.test.TestSelf;

public class TestSubselect
extends TestCase {
    private static final String databaseDriver = "org.hsqldb.jdbcDriver";
    private static final String databaseURL = "jdbc:hsqldb:/hsql/test/subselect";
    private static final String databaseUser = "sa";
    private static final String databasePassword = "";
    private Connection jdbcConnection;
    static /* synthetic */ Class class$org$hsqldb$test$TestSubselect;

    public TestSubselect(String string) {
        super(string);
    }

    protected static Connection getJDBCConnection() throws SQLException {
        return DriverManager.getConnection(databaseURL, databaseUser, databasePassword);
    }

    protected void setUp() throws Exception {
        TestSelf.deleteDatabase("/hsql/test/subselect");
        Class.forName(databaseDriver);
        this.jdbcConnection = TestSubselect.getJDBCConnection();
        this.createDataset();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.jdbcConnection.close();
        this.jdbcConnection = null;
    }

    void createDataset() throws SQLException {
        Statement statement = this.jdbcConnection.createStatement();
        statement.execute("drop table colors if exists; drop table sizes if exists; drop table fruits if exists; drop table trees if exists; ");
        statement.execute("create table colors(id int, val char); insert into colors values(1,'red'); insert into colors values(2,'green'); insert into colors values(3,'orange'); insert into colors values(4,'indigo'); create table sizes(id int, val char); insert into sizes values(1,'small'); insert into sizes values(2,'medium'); insert into sizes values(3,'large'); insert into sizes values(4,'odd'); create table fruits(id int, name char, color_id int); insert into fruits values(1, 'golden delicious',2); insert into fruits values(2, 'macintosh',1); insert into fruits values(3, 'red delicious',1); insert into fruits values(4, 'granny smith',2); insert into fruits values(5, 'tangerine',4); create table trees(id int, name char, fruit_id int, size_id int); insert into trees values(1, 'small golden delicious tree',1,1); insert into trees values(2, 'large macintosh tree',2,3); insert into trees values(3, 'large red delicious tree',3,3); insert into trees values(4, 'small red delicious tree',3,1); insert into trees values(5, 'medium granny smith tree',4,2); ");
        statement.close();
    }

    private static void compareResults(String string, String[] stringArray, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        int n = 0;
        while (resultSet.next()) {
            TestSubselect.assertTrue((String)("Statement <" + string + "> returned too many rows."), (n < stringArray.length ? 1 : 0) != 0);
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong value."), (String)stringArray[n], (String)resultSet.getString(1));
            ++n;
        }
        TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong number of rows."), (int)stringArray.length, (int)n);
    }

    public void testSimpleJoin() throws SQLException {
        String string = "select trees.id, trees.name, sizes.val, fruits.name, colors.val from trees, sizes, fruits, colors where trees.size_id = sizes.id and trees.fruit_id = fruits.id and fruits.color_id = colors.id order by 1";
        int n = 5;
        String[] stringArray = new String[]{"small golden delicious tree", "large macintosh tree", "large red delicious tree", "small red delicious tree", "medium granny smith tree"};
        String[] stringArray2 = new String[]{"small", "large", "large", "small", "medium"};
        String[] stringArray3 = new String[]{"golden delicious", "macintosh", "red delicious", "red delicious", "granny smith"};
        String[] stringArray4 = new String[]{"green", "red", "red", "red", "green"};
        Statement statement = this.jdbcConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        String[] stringArray5 = new String[n];
        String[] stringArray6 = new String[n];
        String[] stringArray7 = new String[n];
        String[] stringArray8 = new String[n];
        int n2 = 0;
        while (resultSet.next()) {
            TestSubselect.assertTrue((String)("Statement <" + string + "> returned too many rows."), (n2 <= n ? 1 : 0) != 0);
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned rows in wrong order."), (int)(1 + n2), (int)resultSet.getInt(1));
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong value."), (String)stringArray[n2], (String)resultSet.getString(2));
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong value."), (String)stringArray2[n2], (String)resultSet.getString(3));
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong value."), (String)stringArray3[n2], (String)resultSet.getString(4));
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong value."), (String)stringArray4[n2], (String)resultSet.getString(5));
            ++n2;
        }
        TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong number of rows."), (int)n, (int)n2);
    }

    public void testWhereClausesColliding() throws SQLException {
        String string = "select name from fruits where id in (select fruit_id from trees where id < 3) order by name";
        String[] stringArray = new String[]{"golden delicious", "macintosh"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testWhereClausesCollidingWithAliases() throws SQLException {
        String string = "select a.name from fruits a where a.id in (select b.fruit_id from trees b where b.id < 3) order by name";
        String[] stringArray = new String[]{"golden delicious", "macintosh"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testHiddenCollision() throws SQLException {
        String string = "select name from fruits where id in (select fruit_id from trees) order by name";
        String[] stringArray = new String[]{"golden delicious", "granny smith", "macintosh", "red delicious"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testHiddenCollisionWithAliases() throws SQLException {
        String string = "select a.name from fruits a where a.id in (select b.fruit_id from trees b) order by a.name";
        String[] stringArray = new String[]{"golden delicious", "granny smith", "macintosh", "red delicious"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testWhereSelectColliding() throws SQLException {
        String string = "select val from colors where id in (select id from trees where fruit_id = 3) order by val";
        String[] stringArray = new String[]{"indigo", "orange"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testWhereSelectCollidingWithAliases() throws SQLException {
        String string = "select a.val from colors a where a.id in (select b.id from trees b where b.fruit_id = 3) order by a.val";
        String[] stringArray = new String[]{"indigo", "orange"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testSameTable() throws SQLException {
        String string = "select name from trees where id in (select id from trees where fruit_id = 3) order by name";
        String[] stringArray = new String[]{"large red delicious tree", "small red delicious tree"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testSameTableWithAliases() throws SQLException {
        String string = "select a.name from trees a where a.id in (select b.id from trees b where b.fruit_id = 3) order by a.name";
        String[] stringArray = new String[]{"large red delicious tree", "small red delicious tree"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testSameTableWithJoin() throws SQLException {
        String string = "select sizes.val from trees, sizes where sizes.id = trees.size_id and trees.id in (select id from trees where fruit_id = 3) order by sizes.val";
        String[] stringArray = new String[]{"large", "small"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testAndedSubselects() throws SQLException {
        String string = "select name from trees where size_id in (select id from sizes where val = 'large') and fruit_id in (select id from fruits where color_id = 1) order by name";
        String[] stringArray = new String[]{"large macintosh tree", "large red delicious tree"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testNestedSubselects() throws SQLException {
        String string = "select name from trees where fruit_id in (select id from fruits where color_id in (select id from colors where val = 'red')) order by name";
        String[] stringArray = new String[]{"large macintosh tree", "large red delicious tree", "small red delicious tree"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testNotIn() throws SQLException {
        String string = "select name from fruits where id not in (select fruit_id from trees) order by name";
        String[] stringArray = new String[]{"tangerine"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testNotInSameTableAndColumn() throws SQLException {
        String string = "select name from fruits where id not in (select id from fruits where color_id > 1 ) order by name";
        String[] stringArray = new String[]{"macintosh", "red delicious"};
        TestSubselect.compareResults(string, stringArray, this.jdbcConnection);
    }

    public void testAliasScope() throws SQLException {
        String string = "select a.val, b.name from sizes a, trees b where a.id = b.size_id and b.id in (select a.id from trees a, fruits b where a.fruit_id = b.id and b.name='red delicious') order by a.val";
        String[] stringArray = new String[]{"large", "small"};
        String[] stringArray2 = new String[]{"large red delicious tree", "small red delicious tree"};
        TestSubselect.assertEquals((String)"Programmer error: expected arrays should be of equal length.", (int)stringArray.length, (int)stringArray2.length);
        Statement statement = this.jdbcConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        int n = 0;
        while (resultSet.next()) {
            TestSubselect.assertTrue((String)("Statement <" + string + "> returned too many rows."), (n < stringArray.length ? 1 : 0) != 0);
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong value."), (String)stringArray[n], (String)resultSet.getString(1));
            TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong value."), (String)stringArray2[n], (String)resultSet.getString(2));
            ++n;
        }
        TestSubselect.assertEquals((String)("Statement <" + string + "> returned wrong number of rows."), (int)stringArray.length, (int)n);
    }

    public static void main(String[] stringArray) throws IOException {
        TestRunner.run((Class)(class$org$hsqldb$test$TestSubselect == null ? (class$org$hsqldb$test$TestSubselect = TestSubselect.class$("org.hsqldb.test.TestSubselect")) : class$org$hsqldb$test$TestSubselect));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

