/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class TestSubQueriesInPreparedStatements {
    public static void main(String[] stringArray) throws Exception {
        TestSubQueriesInPreparedStatements.test();
    }

    public static void test() throws Exception {
        Driver driver = (Driver)Class.forName("org.hsqldb.jdbcDriver").newInstance();
        DriverManager.registerDriver(driver);
        Connection connection = DriverManager.getConnection("jdbc:hsqldb:mem:test", "sa", "");
        Statement statement = connection.createStatement();
        PreparedStatement preparedStatement = connection.prepareStatement("drop table t if exists");
        boolean bl = preparedStatement.execute();
        preparedStatement = connection.prepareStatement("create table t(i decimal)");
        int n = preparedStatement.executeUpdate();
        preparedStatement = connection.prepareStatement("insert into t values(?)");
        for (int i = 0; i < 100; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        preparedStatement = connection.prepareStatement("select * from (select * from t where i < ?)");
        System.out.println("Expecting: 0..3");
        preparedStatement.setInt(1, 4);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getInt(1));
        }
        System.out.println("Expecting: 0..4");
        preparedStatement.setInt(1, 5);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getInt(1));
        }
        preparedStatement = connection.prepareStatement("select sum(i) from (select i from t where i between ? and ?)");
        System.out.println("Expecting: 9");
        preparedStatement.setInt(1, 4);
        preparedStatement.setInt(2, 5);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getInt(1));
        }
        System.out.println("Expecting: 15");
        preparedStatement.setInt(2, 6);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getInt(1));
        }
        preparedStatement = connection.prepareStatement("select * from (select i as c1 from t where i < ?) a, (select i as c2 from t where i < ?) b");
        System.out.println("Expecting: (0,0)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 1);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println("(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + ")");
        }
        System.out.println("Expecting: ((0,0), (0,1), (1,0), (1,1)");
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 2);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println("(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + ")");
        }
        System.out.println("Expecting: ((0,0) .. (3,3)");
        preparedStatement.setInt(1, 4);
        preparedStatement.setInt(2, 4);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println("(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + ")");
        }
    }
}

