/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.hsqldb.test.SqlToolHarness;

public class TestSqlTool
extends TestCase {
    SqlToolHarness harness = new SqlToolHarness();
    static /* synthetic */ Class class$org$hsqldb$test$TestSqlTool;

    private void runTestsInList(String string) throws Exception {
        SqlFileList sqlFileList = new SqlFileList(string);
        for (int i = 0; i < sqlFileList.size(); ++i) {
            TestSqlFile testSqlFile = sqlFileList.getSqlFile(i);
            TestSqlTool.assertTrue((String)(testSqlFile.description + " (" + testSqlFile.file + ')'), (boolean)this.harness.execute(testSqlFile.file));
        }
    }

    public void testHistory() throws Exception {
        this.runTestsInList("testHistory.list");
    }

    public void testEditing() throws Exception {
        this.runTestsInList("testEditing.list");
    }

    public void testArgs() throws Exception {
        this.runTestsInList("testArgs.list");
    }

    public void testComments() throws Exception {
        this.runTestsInList("testComments.list");
    }

    public void testPL() throws Exception {
        this.runTestsInList("testPL.list");
    }

    public void testSpecials() throws Exception {
        this.runTestsInList("testSpecials.list");
    }

    public void testSQL() throws Exception {
        this.runTestsInList("testSQL.list");
    }

    public TestSqlTool(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].startsWith("--gui")) {
            junit.swingui.TestRunner.run((Class)(class$org$hsqldb$test$TestSqlTool == null ? (class$org$hsqldb$test$TestSqlTool = TestSqlTool.class$("org.hsqldb.test.TestSqlTool")) : class$org$hsqldb$test$TestSqlTool));
        } else {
            TestRunner testRunner = new TestRunner();
            System.exit(TestRunner.run((Test)testRunner.getTest((class$org$hsqldb$test$TestSqlTool == null ? (class$org$hsqldb$test$TestSqlTool = TestSqlTool.class$("org.hsqldb.test.TestSqlTool")) : class$org$hsqldb$test$TestSqlTool).getName())).wasSuccessful() ? 0 : 1);
        }
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestSqlTool("testHistory"));
        testSuite.addTest((Test)new TestSqlTool("testEditing"));
        testSuite.addTest((Test)new TestSqlTool("testArgs"));
        testSuite.addTest((Test)new TestSqlTool("testComments"));
        testSuite.addTest((Test)new TestSqlTool("testPL"));
        testSuite.addTest((Test)new TestSqlTool("testSpecials"));
        testSuite.addTest((Test)new TestSqlTool("testSQL"));
        return testSuite;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SqlFileList
    extends ArrayList {
        public SqlFileList(String string) throws IOException {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                String string3 = string2.replaceFirst("#.*", "").trim();
                if (string3.length() < 1) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                if (stringTokenizer.countTokens() < 2) {
                    throw new IOException("Bad line no. " + n + " in list file '" + string + "'");
                }
                this.add(new TestSqlFile(stringTokenizer.nextToken(), stringTokenizer.nextToken("")));
            }
            bufferedReader.close();
        }

        public TestSqlFile getSqlFile(int n) {
            return (TestSqlFile)this.get(n);
        }
    }

    private class TestSqlFile {
        public File file;
        public String description;

        public TestSqlFile(String string, String string2) throws IOException {
            this.file = new File(string);
            if (!this.file.isFile()) {
                throw new IOException("'" + this.file + "' is not a file");
            }
            this.description = string2;
        }
    }
}

