/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.hsqldb.test.TestSelf;

public class TestSqlPersistent
extends TestCase {
    String url = "jdbc:hsqldb:/hsql/test/testpersistent";
    String user;
    String password;
    Statement sStatement;
    Connection cConnection;

    public TestSqlPersistent(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.user = "sa";
        this.password = "";
        this.sStatement = null;
        this.cConnection = null;
        TestSelf.deleteDatabase("/hsql/test/testpersistent");
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.cConnection = DriverManager.getConnection(this.url, this.user, this.password);
            this.sStatement = this.cConnection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("TestSqlPersistence.setUp() error: " + exception.getMessage());
        }
    }

    public void testInsertObject() {
        String string = null;
        Integer n = null;
        Double[] doubleArray = null;
        byte[] byArray = null;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        boolean bl = false;
        String string2 = "DB operation completed";
        try {
            int n2;
            String string3 = "DROP TABLE PREFERENCE IF EXISTS;CREATE CACHED TABLE PREFERENCE (User_Id INTEGER NOT NULL, Pref_Name VARCHAR(30) NOT NULL, Pref_Value OBJECT NOT NULL, DateCreated DATETIME DEFAULT NOW NOT NULL, PRIMARY KEY(User_Id, Pref_Name) )";
            this.sStatement.execute(string3);
            string3 = "INSERT INTO PREFERENCE (User_Id,Pref_Name,Pref_Value,DateCreated) VALUES (?,?,?,current_timestamp)";
            PreparedStatement preparedStatement = this.cConnection.prepareStatement(string3);
            string = "String Value for Preference 1";
            n = new Integer(1000);
            doubleArray = new Double[]{new Double(1.0), new Double(Double.NaN), new Double(Double.NEGATIVE_INFINITY), new Double(Double.POSITIVE_INFINITY)};
            byArray = new byte[]{1, 2, 3, 4, 5, 6};
            preparedStatement.setInt(1, 1);
            preparedStatement.setString(2, "String Type Object 1");
            preparedStatement.setObject(3, (Object)string, 1111);
            preparedStatement.execute();
            preparedStatement.setInt(1, 2);
            preparedStatement.setString(2, "Integer Type Object 2");
            preparedStatement.setObject(3, n);
            preparedStatement.execute();
            preparedStatement.setInt(1, 3);
            preparedStatement.setString(2, "Array Type Object 3");
            preparedStatement.setObject(3, doubleArray);
            preparedStatement.execute();
            preparedStatement.setInt(1, 3);
            preparedStatement.setString(2, "byte Array Type Object 3");
            preparedStatement.setObject(3, (Object)byArray, 1111);
            preparedStatement.execute();
            ResultSet resultSet = this.sStatement.executeQuery("SELECT * FROM PREFERENCE");
            boolean bl2 = resultSet.next();
            String string4 = resultSet.getString(2);
            System.out.println(string4);
            InputStream inputStream = resultSet.getUnicodeStream(2);
            while ((n2 = inputStream.read()) > -1) {
                n2 = inputStream.read();
                System.out.print((char)n2);
            }
            System.out.println();
            inputStream = resultSet.getAsciiStream(2);
            while ((n2 = inputStream.read()) > -1) {
                System.out.print((char)n2);
            }
            System.out.println();
            object = resultSet.getObject(3);
            resultSet.next();
            object2 = resultSet.getObject(3);
            resultSet.next();
            object3 = resultSet.getObject(3);
            bl = resultSet.wasNull();
            String string5 = (String)object;
            Integer n3 = (Integer)object2;
            Double[] doubleArray2 = (Double[])object3;
            string3 = "DELETE FROM PREFERENCE WHERE user_id = ?";
            PreparedStatement preparedStatement2 = this.cConnection.prepareStatement(string3);
            preparedStatement2.setString(1, "2");
            int n4 = preparedStatement2.executeUpdate();
            preparedStatement2.close();
            preparedStatement2 = this.cConnection.prepareStatement("SELECT user_id FROM PREFERENCE WHERE user_id=?");
            preparedStatement2.setString(1, "2");
            resultSet = preparedStatement2.executeQuery();
            while (resultSet.next()) {
                System.out.println(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl3 = true;
        TestSqlPersistent.assertEquals((boolean)true, (boolean)bl3);
    }

    public void testSelectObject() throws IOException {
        AutoCloseable autoCloseable;
        Object object;
        String string = null;
        Integer n = null;
        Double[] doubleArray = null;
        byte[] byArray = null;
        String string2 = null;
        Integer n2 = null;
        Double[] doubleArray2 = null;
        boolean bl = false;
        String string3 = "DB operation completed";
        try {
            String string4 = "DROP TABLE TESTOBJECT IF EXISTS;CREATE CACHED TABLE TESTOBJECT (ID INTEGER NOT NULL IDENTITY, STOREDOBJECT OTHER, STOREDBIN BINARY )";
            this.sStatement.execute(string4);
            string4 = "INSERT INTO TESTOBJECT (STOREDOBJECT, STOREDBIN) VALUES (?,?)";
            object = this.cConnection.prepareStatement(string4);
            string = "Test String Value";
            n = new Integer(1000);
            doubleArray = new Double[]{new Double(1.0), new Double(Double.NaN), new Double(Double.NEGATIVE_INFINITY), new Double(Double.POSITIVE_INFINITY)};
            byArray = new byte[]{1, 2, 3};
            object.setObject(1, (Object)string, 1111);
            object.setBytes(2, byArray);
            object.execute();
            object.setObject(1, (Object)n, 1111);
            object.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            object.execute();
            object.setObject(1, (Object)doubleArray, 1111);
            object.execute();
            autoCloseable = this.sStatement.executeQuery("SELECT * FROM TESTOBJECT");
            boolean bl2 = autoCloseable.next();
            string2 = (String)autoCloseable.getObject(2);
            autoCloseable.next();
            n2 = (Integer)autoCloseable.getObject(2);
            autoCloseable.next();
            doubleArray2 = (Double[])autoCloseable.getObject(2);
            String string5 = string2;
            Integer n3 = n2;
            Double[] doubleArray3 = doubleArray2;
            for (int i = 0; i < doubleArray.length; ++i) {
                if (doubleArray[i].equals(doubleArray2[i])) continue;
                System.out.println("array mismatch: " + doubleArray[i] + " : " + doubleArray2[i]);
            }
            autoCloseable.close();
            object.close();
            string4 = "SELECT * FROM TESTOBJECT WHERE STOREDOBJECT = ?";
            object = this.cConnection.prepareStatement(string4);
            object.setObject(1, new Integer(1000));
            autoCloseable = object.executeQuery();
            autoCloseable.next();
            Object object2 = autoCloseable.getObject(2);
            autoCloseable.next();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
        boolean bl3 = string.equals(string2) && n.equals(n2) && Arrays.equals((Object[])doubleArray, (Object[])doubleArray2);
        TestSqlPersistent.assertEquals((boolean)true, (boolean)bl3);
        try {
            object = "drop table objects if exists";
            autoCloseable = this.cConnection.prepareStatement((String)object);
            autoCloseable.execute();
            object = "create cached table objects (object_id INTEGER IDENTITY,object_name VARCHAR(128) NOT NULL,role_name VARCHAR(128) NOT NULL,value LONGVARBINARY NOT NULL,description LONGVARCHAR)";
            autoCloseable = this.cConnection.prepareStatement((String)object);
            autoCloseable.execute();
            object = "INSERT INTO objects VALUES(1, 'name','role',?,'description')";
            autoCloseable = this.cConnection.prepareStatement((String)object);
            autoCloseable.setBytes(1, new byte[]{1, 2, 3, 4, 5});
            autoCloseable.executeUpdate();
            object = "UPDATE objects SET value = ? AND description = ? WHERE object_name = ? AND role_name = ?";
            autoCloseable = this.cConnection.prepareStatement((String)object);
            autoCloseable.setBytes(1, new byte[]{1, 2, 3, 4, 5});
            autoCloseable.setString(2, "desc");
            autoCloseable.setString(3, "new");
            autoCloseable.setString(4, "role");
            autoCloseable.executeUpdate();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
    }

    protected void tearDown() {
        try {
            this.cConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("TestSql.tearDown() error: " + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        TestResult testResult = new TestResult();
        TestSqlPersistent testSqlPersistent = new TestSqlPersistent("testInsertObject");
        TestSqlPersistent testSqlPersistent2 = new TestSqlPersistent("testSelectObject");
        testSqlPersistent.run(testResult);
        testSqlPersistent2.run(testResult);
        System.out.println("TestSqlPersistent error count: " + testResult.failureCount());
    }
}

