/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.TestResult;
import org.hsqldb.test.TestBase;

public class TestSql
extends TestBase {
    Statement stmnt;
    PreparedStatement pstmnt;
    Connection connection;
    String getColumnName = "false";

    public TestSql(String string) {
        super(string);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.connection = super.newConnection();
            this.stmnt = this.connection.createStatement();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMetaData() {
        String string = "DROP TABLE ADDRESSBOOK IF EXISTS; DROP TABLE ADDRESSBOOK_CATEGORY IF EXISTS; DROP TABLE USER IF EXISTS;";
        String string2 = "CREATE TABLE USER(USER_ID INTEGER NOT NULL PRIMARY KEY,LOGIN_ID VARCHAR(128) NOT NULL,USER_NAME VARCHAR(254) DEFAULT ' ' NOT NULL,CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,UPDATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,LAST_ACCESS_DATE TIMESTAMP,CONSTRAINT IXUQ_LOGIN_ID0 UNIQUE(LOGIN_ID))";
        String string3 = "CREATE TABLE ADDRESSBOOK_CATEGORY(USER_ID INTEGER NOT NULL,CATEGORY_ID INTEGER DEFAULT 0 NOT NULL,CATEGORY_NAME VARCHAR(60) DEFAULT '' NOT NULL,CONSTRAINT SYS_PK_ADDRESSBOOK_CATEGORY PRIMARY KEY(USER_ID,CATEGORY_ID),CONSTRAINT FK_ADRBKCAT1 FOREIGN KEY(USER_ID) REFERENCES USER(USER_ID) ON DELETE CASCADE)";
        String string4 = "CREATE TABLE ADDRESSBOOK(USER_ID INTEGER NOT NULL,ADDRESSBOOK_ID INTEGER NOT NULL,CATEGORY_ID INTEGER DEFAULT 0 NOT NULL,FIRST VARCHAR(64) DEFAULT '' NOT NULL,LAST VARCHAR(64) DEFAULT '' NOT NULL,NOTE VARCHAR(128) DEFAULT '' NOT NULL,CONSTRAINT SYS_PK_ADDRESSBOOK PRIMARY KEY(USER_ID,ADDRESSBOOK_ID),CONSTRAINT FK_ADRBOOK1 FOREIGN KEY(USER_ID,CATEGORY_ID) REFERENCES ADDRESSBOOK_CATEGORY(USER_ID,CATEGORY_ID) ON DELETE CASCADE)";
        String string5 = "1";
        String string6 = "2";
        String string7 = "3";
        String string8 = "4";
        String string9 = "5";
        try {
            int n;
            this.stmnt.execute(string);
            this.stmnt.execute(string2);
            this.stmnt.execute(string3);
            this.stmnt.execute(string4);
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            System.out.println(databaseMetaData.getDatabaseProductName());
            System.out.println(databaseMetaData.getDatabaseProductVersion());
            System.out.println(databaseMetaData.getDefaultTransactionIsolation());
            System.out.println(databaseMetaData.getDriverMajorVersion());
            System.out.println(databaseMetaData.getDriverMinorVersion());
            System.out.println(databaseMetaData.getDriverName());
            System.out.println(databaseMetaData.getDriverVersion());
            System.out.println(databaseMetaData.getExtraNameCharacters());
            System.out.println(databaseMetaData.getIdentifierQuoteString());
            System.out.println(databaseMetaData.getMaxBinaryLiteralLength());
            System.out.println(databaseMetaData.getMaxCatalogNameLength());
            System.out.println(databaseMetaData.getMaxColumnsInGroupBy());
            System.out.println(databaseMetaData.getMaxColumnsInIndex());
            System.out.println(databaseMetaData.getMaxColumnsInOrderBy());
            System.out.println(databaseMetaData.getMaxColumnsInSelect());
            System.out.println(databaseMetaData.getMaxColumnsInTable());
            System.out.println(databaseMetaData.getMaxConnections());
            System.out.println(databaseMetaData.getMaxCursorNameLength());
            System.out.println(databaseMetaData.getMaxIndexLength());
            System.out.println(databaseMetaData.getMaxProcedureNameLength());
            System.out.println(databaseMetaData.getMaxRowSize());
            System.out.println(databaseMetaData.getMaxSchemaNameLength());
            System.out.println(databaseMetaData.getMaxStatementLength());
            System.out.println(databaseMetaData.getMaxStatements());
            System.out.println(databaseMetaData.getMaxTableNameLength());
            System.out.println(databaseMetaData.getMaxUserNameLength());
            System.out.println(databaseMetaData.getNumericFunctions());
            System.out.println(databaseMetaData.getProcedureTerm());
            System.out.println(databaseMetaData.getSchemaTerm());
            System.out.println(databaseMetaData.getSearchStringEscape());
            System.out.println(databaseMetaData.getSQLKeywords());
            System.out.println(databaseMetaData.getStringFunctions());
            System.out.println(databaseMetaData.getSystemFunctions());
            System.out.println(databaseMetaData.getTimeDateFunctions());
            System.out.println(databaseMetaData.getURL());
            System.out.println(databaseMetaData.getUserName());
            System.out.println(0);
            System.out.println(databaseMetaData.isCatalogAtStart());
            System.out.println(databaseMetaData.isReadOnly());
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, "USER");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Object object = "";
            while (resultSet.next()) {
                for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
                    object = (String)object + resultSet.getString(n + 1) + ":";
                }
                object = (String)object + "\n";
            }
            resultSet.close();
            System.out.println((String)object);
            resultSet = databaseMetaData.getBestRowIdentifier(null, null, "USER", 0, true);
            resultSetMetaData = resultSet.getMetaData();
            object = "";
            while (resultSet.next()) {
                for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
                    object = (String)object + resultSet.getString(n + 1) + ":";
                }
                object = (String)object + "\n";
            }
            resultSet.close();
            System.out.println((String)object);
            resultSet = databaseMetaData.getImportedKeys(null, null, "ADDRESSBOOK");
            resultSetMetaData = resultSet.getMetaData();
            string5 = "";
            while (resultSet.next()) {
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    string5 = string5 + resultSet.getString(i + 1) + ":";
                }
                string5 = string5 + "\n";
            }
            resultSet.close();
            System.out.println(string5);
            resultSet = databaseMetaData.getCrossReference(null, null, "ADDRESSBOOK_CATEGORY", null, null, "ADDRESSBOOK");
            resultSetMetaData = resultSet.getMetaData();
            string6 = "";
            while (resultSet.next()) {
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    string6 = string6 + resultSet.getString(i + 1) + ":";
                }
                string6 = string6 + "\n";
            }
            resultSet.close();
            System.out.println(string6);
            resultSet = databaseMetaData.getExportedKeys(null, null, "USER");
            resultSetMetaData = resultSet.getMetaData();
            string7 = "";
            while (resultSet.next()) {
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    string7 = string7 + resultSet.getString(i + 1) + ":";
                }
                string7 = string7 + "\n";
            }
            resultSet.close();
            System.out.println(string7);
            resultSet = databaseMetaData.getCrossReference(null, null, "USER", null, null, "ADDRESSBOOK_CATEGORY");
            resultSetMetaData = resultSet.getMetaData();
            string8 = "";
            while (resultSet.next()) {
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    string8 = string8 + resultSet.getString(i + 1) + ":";
                }
                string8 = string8 + "\n";
            }
            resultSet.close();
            System.out.println(string8);
            this.stmnt.execute("DROP TABLE T IF EXISTS;");
            this.stmnt.executeQuery("CREATE TABLE T (I IDENTITY, A CHAR(20), B CHAR(20));");
            this.stmnt.executeQuery("INSERT INTO T VALUES (NULL, 'get_column_name', '" + this.getColumnName + "');");
            resultSet = this.stmnt.executeQuery("SELECT I, A, B, A \"aliasA\", B \"aliasB\" FROM T;");
            resultSetMetaData = resultSet.getMetaData();
            string9 = "";
            while (resultSet.next()) {
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    string9 = string9 + resultSetMetaData.getColumnName(i + 1) + ":" + resultSet.getString(i + 1) + ":";
                }
                string9 = string9 + "\n";
            }
            resultSet.close();
            resultSet = this.stmnt.executeQuery("SELECT I, A, B, A \"aliasA\", B \"aliasB\" FROM T;");
            resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    string9 = string9 + resultSetMetaData.getColumnLabel(i + 1) + ":" + resultSet.getString(i + 1) + ":";
                }
                string9 = string9 + "\n";
            }
            System.out.println(string9);
            System.out.println("first column identity: " + resultSetMetaData.isAutoIncrement(1));
            resultSetMetaData.isCaseSensitive(1);
            resultSetMetaData.isCurrency(1);
            resultSetMetaData.isDefinitelyWritable(1);
            resultSetMetaData.isNullable(1);
            resultSetMetaData.isReadOnly(1);
            resultSetMetaData.isSearchable(1);
            resultSetMetaData.isSigned(1);
            resultSetMetaData.isWritable(1);
            resultSet.close();
            this.pstmnt = this.connection.prepareStatement("INSERT INTO T VALUES (?,?,?)");
            this.pstmnt.setString(1, null);
            this.pstmnt.setString(2, "test");
            this.pstmnt.setString(3, "test2");
            this.pstmnt.executeUpdate();
            this.pstmnt = this.connection.prepareStatement("call identity()");
            object = this.pstmnt.executeQuery();
            object.next();
            n = object.getInt(1);
            System.out.println("call identity(): " + n);
            object.close();
        }
        catch (SQLException sQLException) {
            TestSql.fail((String)sQLException.getMessage());
        }
        System.out.println("testMetaData complete");
        TestSql.assertEquals((String)string5, (String)string6);
        TestSql.assertEquals((String)string7, (String)string8);
    }

    public void testDoubleNaN() {
        double d = 0.0;
        boolean bl = false;
        String string = "DB operation completed";
        String string2 = "DROP TABLE t1 IF EXISTS;CREATE TABLE t1 ( d DECIMAL, f DOUBLE, l BIGINT, i INTEGER, s SMALLINT, t TINYINT, dt DATE DEFAULT CURRENT_DATE, ti TIME DEFAULT CURRENT_TIME, ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP );";
        try {
            int n;
            this.stmnt.execute(string2);
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO t1 (d,f,l,i,s,t,dt,ti,ts) VALUES (?,?,?,?,?,?,?,?,?)");
            preparedStatement.setString(1, "0.2");
            preparedStatement.setDouble(2, 0.2);
            preparedStatement.setLong(3, Long.MAX_VALUE);
            preparedStatement.setInt(4, Integer.MAX_VALUE);
            preparedStatement.setInt(5, Short.MAX_VALUE);
            preparedStatement.setInt(6, 0);
            preparedStatement.setDate(7, new Date(System.currentTimeMillis()));
            preparedStatement.setTime(8, new Time(System.currentTimeMillis()));
            preparedStatement.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
            preparedStatement.execute();
            preparedStatement.setInt(1, 0);
            preparedStatement.setDouble(2, Double.NaN);
            preparedStatement.setLong(3, Long.MIN_VALUE);
            preparedStatement.setInt(4, Integer.MIN_VALUE);
            preparedStatement.setInt(5, Short.MIN_VALUE);
            preparedStatement.setInt(6, 0);
            preparedStatement.setTimestamp(7, new Timestamp(System.currentTimeMillis() + 1L));
            preparedStatement.setTime(8, new Time(System.currentTimeMillis() + 1L));
            preparedStatement.setDate(9, new Date(System.currentTimeMillis() + 1L));
            preparedStatement.execute();
            preparedStatement.setInt(1, 0);
            preparedStatement.setDouble(2, Double.POSITIVE_INFINITY);
            preparedStatement.setInt(4, Integer.MIN_VALUE);
            preparedStatement.setObject(5, Boolean.TRUE);
            preparedStatement.setBoolean(5, true);
            preparedStatement.setObject(5, (Object)new Short(2), 5);
            preparedStatement.setObject(6, (Object)new Integer(2), -6);
            preparedStatement.setObject(7, new Date(System.currentTimeMillis() + 2L));
            preparedStatement.setObject(8, new Time(System.currentTimeMillis() + 2L));
            preparedStatement.setObject(9, new Timestamp(System.currentTimeMillis() + 2L));
            preparedStatement.execute();
            preparedStatement.setObject(1, (Object)new Float(0.0f), 4);
            preparedStatement.setObject(4, (Object)new Float(1.0f), 4);
            preparedStatement.setDouble(2, Double.NEGATIVE_INFINITY);
            preparedStatement.execute();
            ResultSet resultSet = this.stmnt.executeQuery("SELECT d, f, l, i, s*2, t FROM t1");
            boolean bl2 = resultSet.next();
            d = resultSet.getDouble(2);
            int n2 = resultSet.getInt(4);
            if (resultSet.next()) {
                d = resultSet.getDouble(2);
                bl = Double.isNaN(d);
                n2 = resultSet.getInt(4);
                n2 = resultSet.getInt(1);
            }
            if (resultSet.next()) {
                d = resultSet.getDouble(2);
                boolean bl3 = bl = bl && d == Double.POSITIVE_INFINITY;
            }
            if (resultSet.next()) {
                d = resultSet.getDouble(2);
                boolean bl4 = bl = bl && d == Double.NEGATIVE_INFINITY;
            }
            if ((resultSet = this.stmnt.executeQuery("SELECT MAX(i) FROM t1")).next()) {
                n = resultSet.getInt(1);
                System.out.println("Max value for i: " + n);
            }
            this.stmnt.execute("drop table CDTYPE if exists");
            resultSet = this.stmnt.executeQuery("CREATE TABLE cdType (ID INTEGER NOT NULL, name VARCHAR(50), PRIMARY KEY(ID))");
            resultSet = this.stmnt.executeQuery("SELECT MAX(ID) FROM cdType");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
                System.out.println("Max value for ID: " + n);
            } else {
                System.out.println("Max value for ID not returned");
            }
            this.stmnt.executeUpdate("INSERT INTO cdType VALUES (10,'Test String');");
            this.stmnt.executeQuery("CALL IDENTITY();");
            try {
                this.stmnt.executeUpdate("INSERT INTO cdType VALUES (10,'Test String');");
            }
            catch (SQLException sQLException) {
                this.stmnt.execute("ROLLBACK");
                this.connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            TestSql.fail((String)sQLException.getMessage());
        }
        System.out.println("testDoubleNaN complete");
        TestSql.assertEquals((boolean)true, (boolean)bl);
    }

    public void testAny() {
        try {
            String string = "drop table PRICE_RELATE_USER_ORDER_V2 if exists;create table PRICE_RELATE_USER_ORDER_V2 (ID_ORDER_V2 BIGINT, ID_USER NUMERIC, DATE_CREATE TIMESTAMP)";
            String string2 = "insert into PRICE_RELATE_USER_ORDER_V2 (ID_ORDER_V2, ID_USER, DATE_CREATE) values (?, ?, ?)";
            Statement statement = this.connection.createStatement();
            statement.execute(string);
            PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
            preparedStatement.setLong(1, 1L);
            preparedStatement.setNull(2, 2);
            preparedStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.out.println("TestSql.testAny() error: " + sQLException.getMessage());
        }
        System.out.println("testAny complete");
    }

    public void testBinds() {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("drop table test if exists");
            preparedStatement.execute();
            preparedStatement = this.connection.prepareStatement("create table test (id integer)");
            preparedStatement.execute();
            preparedStatement = this.connection.prepareStatement("insert into test values (10)");
            preparedStatement.execute();
            preparedStatement = this.connection.prepareStatement("insert into test values (20)");
            preparedStatement.execute();
            preparedStatement = this.connection.prepareStatement("select count(*) from test where ? is null");
            preparedStatement.setString(1, "hello");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            TestSql.assertEquals((int)0, (int)n);
            preparedStatement = this.connection.prepareStatement("select limit ? 1  id from test");
            preparedStatement.setInt(1, 0);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
            TestSql.assertEquals((int)10, (int)n);
            preparedStatement.setInt(1, 1);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            n = resultSet.getInt(1);
            TestSql.assertEquals((int)20, (int)n);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.out.println("TestSql.testBinds() error: " + sQLException.getMessage());
        }
    }

    public void testX1() {
        Object object;
        String string = "create table lo_attribute ( learningid varchar(15) not null, ordering integer not null,attribute_value_data varchar(85) null,constraint PK_LO_ATTR primary key (learningid, ordering))";
        try {
            object = this.connection.createStatement();
            object.execute("drop table lo_attribute if exists");
            object.execute(string);
            object.execute("insert into lo_attribute values('abcd', 10, 'cdef')");
            object.execute("insert into lo_attribute values('bcde', 20, 'cdef')");
        }
        catch (SQLException sQLException) {
            TestSql.assertEquals((int)0, (int)1);
        }
        try {
            object = "update lo_attribute set  ordering = (ordering - 1) where ordering > ?";
            PreparedStatement preparedStatement = this.connection.prepareStatement((String)object);
            preparedStatement.setInt(1, 10);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            TestSql.assertEquals((int)0, (int)1);
        }
        try {
            this.connection.setAutoCommit(false);
            object = this.connection.setSavepoint("savepoint");
            this.connection.createStatement().executeQuery("CALL true;");
            this.connection.rollback((Savepoint)object);
        }
        catch (SQLException sQLException) {
            TestSql.assertEquals((int)0, (int)1);
        }
    }

    public void testUnionColumnTypes() {
        try {
            Connection connection = this.newConnection();
            Statement statement = connection.createStatement();
            statement.execute("DROP TABLE test1 IF EXISTS");
            statement.execute("DROP TABLE test2 IF EXISTS");
            statement.execute("CREATE TABLE test1 (id int, b1 boolean)");
            statement.execute("CREATE TABLE test2 (id int)");
            statement.execute("INSERT INTO test1 VALUES(1,true)");
            statement.execute("INSERT INTO test2 VALUES(2)");
            ResultSet resultSet = statement.executeQuery("select id,null as b1 from test2 union select id, b1 from test1");
            Boolean[] booleanArray = new Boolean[2];
            int n = 0;
            while (resultSet.next()) {
                boolean bl = resultSet.getBoolean(2);
                booleanArray[n] = bl;
                if (resultSet.wasNull()) {
                    booleanArray[n] = null;
                }
                ++n;
            }
            n = booleanArray[0] == null && booleanArray[1] == Boolean.TRUE || booleanArray[0] == Boolean.TRUE && booleanArray[1] == null ? 1 : 0;
            TestSql.assertTrue(n != 0);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.out.println("TestSql.testUnionColumnType() error: " + sQLException.getMessage());
        }
    }

    protected void tearDown() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("TestSql.tearDown() error: " + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        TestResult testResult = new TestResult();
        TestSql testSql = new TestSql("testMetaData");
        TestSql testSql2 = new TestSql("testDoubleNaN");
        TestSql testSql3 = new TestSql("testAny");
        testSql.run(testResult);
        testSql2.run(testResult);
        testSql3.run(testResult);
        System.out.println("TestSql error count: " + testResult.failureCount());
    }
}

