/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.awt.Rectangle;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import org.hsqldb.jdbcDriver;
import org.hsqldb.lib.Sort;
import org.hsqldb.test.TestUtil;

class TestSelf
extends TestUtil {
    static byte[] b1 = new byte[]{0, 1, -128, 44, 12};
    static byte[] b2 = new byte[]{10, 127};

    TestSelf() {
    }

    public static void main(String[] stringArray) {
        String string;
        TestSelf.print("Usage: TestSelf [records [-m]] (-m means in-memory only)");
        int n = 500;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        boolean bl = true;
        boolean bl2 = false;
        if (stringArray.length >= 2 && (string = stringArray[1]).equals("-m")) {
            bl = false;
        }
        TestSelf.test(n, bl);
    }

    static void test(int n, boolean bl) {
        try {
            DriverManager.registerDriver(new jdbcDriver());
            if (bl) {
                TestSelf.testPersistence();
                TestSelf.deleteDatabase("test2");
                TestSelf.test("jdbc:hsqldb:test2", "sa", "", true);
                TestSelf.testPerformance("jdbc:hsqldb:test2", "sa", "", n, true);
            }
            TestSelf.test("jdbc:hsqldb:.", "sa", "", false);
            TestSelf.testPerformance("jdbc:hsqldb:.", "sa", "", n, false);
        }
        catch (Exception exception) {
            TestSelf.print("TestSelf error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    static void delete(String string) {
        try {
            new File(string).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void deleteDatabase(String string) {
        TestSelf.delete(string + ".backup");
        TestSelf.delete(string + ".properties");
        TestSelf.delete(string + ".script");
        TestSelf.delete(string + ".data");
        TestSelf.delete(string + ".log");
    }

    static void test(String string, String string2, String string3, boolean bl) throws Exception {
        String string4 = bl ? "Persistent" : "Memory";
        TestSelf.print(string4);
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, string2, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestSelf.print("TestSelf init error: " + exception.getMessage());
        }
        TestSelf.testMainScript(connection, bl);
        TestSelf.testTabProfile(connection, bl);
        TestSelf.testMarotest(connection, bl);
        connection.createStatement().execute("SHUTDOWN");
        connection.close();
    }

    static void testPersistence() {
        TestSelf.deleteDatabase("test1");
        try {
            String string = "jdbc:hsqldb:test1;sql.enforce_strict_size=true";
            String string2 = "sa";
            String string3 = "";
            Connection connection = null;
            String string4 = new File("TestSelf.txt").getAbsolutePath();
            String[] stringArray = new File(new File(string4).getParent()).list();
            Sort.sort(stringArray, new Sort.StringComparator(), 0, stringArray.length - 1);
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                if (!string5.startsWith("TestSelf") || !string5.endsWith(".txt") || string5.equals("TestSelf.txt")) continue;
                TestSelf.print("Openning DB");
                connection = DriverManager.getConnection(string, string2, string3);
                TestSelf.testScript(connection, string5);
                connection.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestSelf.print("TestSelf init error: " + exception.getMessage());
        }
    }

    static void testMainScript(Connection connection, boolean bl) {
        String string = bl ? "Persistent" : "Memory";
        TestSelf.print(string + " TestScript");
        String string2 = "TestSelf.txt";
        TestSelf.testScript(connection, string2);
    }

    static void testTabProfile(Connection connection, boolean bl) {
        Statement statement = null;
        String string = "";
        boolean bl2 = false;
        String string2 = bl ? "Persistent" : "Memory";
        TestSelf.print(string2 + " TabProfile");
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestSelf.print("TabProfile init error: " + exception.getMessage());
            return;
        }
        try {
            boolean bl3;
            int n;
            string = "create table TabProfile(id int primary key,car char,won bit,licence varbinary,name char,sex char,chance double,birthday date,temp char)";
            statement.execute(string);
            string = "insert into TabProfile values ( ?, ?, ?, ?,'\"John\" the bird''s best friend', 'M',?,?,'')";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, 10);
            preparedStatement.setString(2, "Matchcartoon");
            preparedStatement.setBoolean(3, true);
            preparedStatement.setBytes(4, b1);
            preparedStatement.setDouble(5, 50.5);
            preparedStatement.setNull(6, 91);
            preparedStatement.executeUpdate();
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, -2);
            preparedStatement.setString(2, "\"Birdie\"'s car ?");
            preparedStatement.setBoolean(3, false);
            byte[] byArray = new byte[]{10, 127};
            preparedStatement.setBytes(4, byArray);
            preparedStatement.setDouble(5, -3.1415E-20);
            Calendar calendar = Calendar.getInstance();
            calendar.set(2000, 2, 29);
            preparedStatement.setDate(6, new Date(calendar.getTime().getTime()));
            preparedStatement.executeUpdate();
            TestSelf.readTabProfileTest(statement);
            string = "select \"org.hsqldb.lib.ArrayUtil.containsAt\"(licence,0, ?) from TabProfile";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBytes(1, byArray);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            boolean bl4 = resultSet.getBoolean(1);
            resultSet.next();
            boolean bl5 = resultSet.getBoolean(1);
            string = "update tabprofile set temp = \"org.hsqldb.lib.StringConverter.byteToHex\"(licence)";
            statement.executeUpdate(string);
            string = "select \"org.hsqldb.lib.StringConverter.hexToByte\"(temp) from TabProfile order by id desc";
            resultSet = statement.executeQuery(string);
            resultSet.next();
            byte[] byArray2 = resultSet.getBytes(1);
            for (n = 0; n < byArray2.length; ++n) {
                if (b1[n] == byArray2[n]) continue;
                bl3 = true;
            }
            resultSet.next();
            byte[] byArray3 = resultSet.getBytes(1);
            for (n = 0; n < byArray3.length; ++n) {
                if (byArray[n] == byArray3[n]) continue;
                bl3 = true;
            }
            string = "create table obj(id int,o object)";
            statement.execute(string);
            string = "insert into obj values(?,?)";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, 1);
            int[] nArray = new int[]{1, 2, 3};
            preparedStatement.setObject(2, nArray);
            preparedStatement.executeUpdate();
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, 2);
            Rectangle rectangle = new Rectangle(10, 11, 12, 13);
            preparedStatement.setObject(2, rectangle);
            preparedStatement.executeUpdate();
            resultSet = statement.executeQuery("SELECT o FROM obj ORDER BY id DESC");
            resultSet.next();
            Rectangle rectangle2 = (Rectangle)resultSet.getObject(1);
            if (rectangle2.x != 10 || rectangle2.y != 11 || rectangle2.width != 12 || rectangle2.height != 13) {
                throw new Exception("Object data error: Rectangle");
            }
            resultSet.next();
            int[] nArray2 = (int[])resultSet.getObject(1);
            if (nArray2[0] != 1 || nArray2[1] != 2 || nArray2[2] != 3 || nArray2.length != 3) {
                throw new Exception("Object data error: int[]");
            }
            statement.close();
        }
        catch (Exception exception) {
            TestSelf.print("");
            TestSelf.print("TabProfile error: " + exception);
            TestSelf.print("with SQL command: " + string);
            exception.printStackTrace();
        }
    }

    static void readTabProfileTest(Statement statement) throws Exception {
        String string = "select * from TabProfile where id=-2";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        if (!resultSet.getString(2).equals("\"Birdie\"'s car ?")) {
            throw new Exception("Unicode error.");
        }
        boolean bl = false;
        byte[] byArray = resultSet.getBytes(4);
        for (int i = 0; i < byArray.length; ++i) {
            if (b2[i] == byArray[i]) continue;
            bl = true;
        }
        resultSet.close();
        string = "select * from TabProfile where id=10";
        resultSet = statement.executeQuery(string);
        resultSet.next();
        byte[] byArray2 = resultSet.getBytes(4);
        for (int i = 0; i < byArray2.length; ++i) {
            if (b1[i] == byArray2[i]) continue;
            bl = true;
        }
        resultSet.close();
    }

    static void testMarotest(Connection connection, boolean bl) {
        Statement statement = null;
        String string = "";
        boolean bl2 = false;
        String string2 = bl ? "Persistent" : "Memory";
        TestSelf.print(string2 + " Marotest");
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestSelf.print("Marotest init error: " + exception.getMessage());
        }
        try {
            string = "CREATE TABLE marotest (id int PRIMARY KEY, dat int);INSERT INTO marotest VALUES (1,0);INSERT INTO marotest VALUES (2,0);INSERT INTO marotest VALUES (2,0);";
            try {
                statement.execute(string);
                string = "";
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.equals("")) {
                throw new Exception("Duplicate key gave no error on insert");
            }
            try {
                string = "UPDATE marotest SET id=1, dat=-1 WHERE dat=0";
                statement.execute(string);
                string = "";
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.equals("")) {
                throw new Exception("Duplicate key gave no error on update");
            }
            int n = 0;
            string = "SELECT *, id as marotest_id FROM marotest";
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                resultSet.getFloat(1);
                resultSet.getString("ID");
                resultSet.getInt("DAT");
                resultSet.getInt("MAROTEST_ID");
                if (resultSet.getShort("DAT") != 0) {
                    throw new Exception("Bad update worked");
                }
                resultSet.getLong("DAT");
                resultSet.getString(2);
                resultSet.getObject("ID");
                resultSet.clearWarnings();
                try {
                    resultSet.getTimestamp("Timestamp?");
                    n = 99;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            resultSet.close();
            if (n != 2) {
                throw new Exception("Should have 2 but has " + n + " rows");
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, "DBO", "MAROTEST", "%");
            while (resultSet.next()) {
                string = resultSet.getString(4).trim();
                int n2 = resultSet.getInt(5);
                string = string + n2 + resultSet.getString("TYPE_NAME");
                n2 = resultSet.getInt(7);
                n2 = resultSet.getInt(9);
                n2 = resultSet.getInt(11);
                if ((string = string.toUpperCase()).equals("ID4INTEGER") || string.equals("DAT4INTEGER")) continue;
                throw new Exception("Wrong database meta data");
            }
            string = "DROP TABLE marotest";
            statement.execute(string);
            statement.close();
        }
        catch (Exception exception) {
            TestSelf.print("");
            TestSelf.print("Marotest error: " + exception);
            TestSelf.print("with SQL command: " + string);
            exception.printStackTrace();
        }
    }

    static void testPerformance(String string, String string2, String string3, int n, boolean bl) throws Exception {
        if (bl) {
            TestSelf.deleteDatabase("test2");
        }
        Statement statement = null;
        Connection connection = null;
        String string4 = "";
        boolean bl2 = false;
        String string5 = bl ? "Persistent" : "Memory";
        TestSelf.print(string5 + " Performance");
        try {
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TestSelf.print("TestSelf init error: " + exception.getMessage());
        }
        try {
            int n2;
            int n3;
            string4 = "CREATE CACHED TABLE Addr(ID INT PRIMARY KEY,First CHAR,Name CHAR,ZIP INT)";
            statement.execute(string4);
            string4 = "CREATE INDEX iName ON Addr(Name)";
            statement.execute(string4);
            string4 = "SET WRITE_DELAY TRUE";
            statement.execute(string4);
            long l = System.currentTimeMillis();
            for (n3 = 0; n3 < n; ++n3) {
                string4 = "INSERT INTO Addr VALUES(" + n3 + ",'Marcel" + n3 + "'," + "'Renggli" + (n - n3 - n3 % 31) + "'," + (3000 + n3 % 100) + ")";
                if (statement.executeUpdate(string4) != 1) {
                    throw new Exception("Insert failed");
                }
                if (n3 % 100 != 0) continue;
                TestSelf.printStatus("insert   ", n3, n, l);
            }
            TestSelf.printStatus("insert   ", n, n, l);
            TestSelf.print("");
            string4 = "SELECT COUNT(*) FROM Addr";
            ResultSet resultSet = statement.executeQuery(string4);
            resultSet.next();
            n3 = resultSet.getInt(1);
            if (n3 != n) {
                throw new Exception("Count should be " + n + " but is " + n3);
            }
            if (bl) {
                connection.close();
                connection = DriverManager.getConnection(string, string2, string3);
                statement = connection.createStatement();
            }
            l = System.currentTimeMillis();
            for (n2 = 0; n2 < n; ++n2) {
                string4 = "UPDATE Addr SET Name='Robert" + (n2 + n2 % 31) + "' WHERE ID=" + n2;
                if (statement.executeUpdate(string4) != 1) {
                    throw new Exception("Update failed");
                }
                if (n2 % 100 != 0) continue;
                TestSelf.printStatus("updated  ", n2, n, l);
            }
            TestSelf.printStatus("update   ", n, n, l);
            TestSelf.print("");
            if (bl) {
                string4 = "SHUTDOWN IMMEDIATELY";
                statement.execute(string4);
                connection.close();
                connection = DriverManager.getConnection(string, string2, string3);
                statement = connection.createStatement();
            }
            l = System.currentTimeMillis();
            for (n2 = 0; n2 < n; ++n2) {
                string4 = "DELETE FROM Addr WHERE ID=" + (n - 1 - n2);
                if (statement.executeUpdate(string4) != 1) {
                    throw new Exception("Delete failed");
                }
                if (n2 % 100 != 0) continue;
                TestSelf.printStatus("deleting ", n2, n, l);
            }
            TestSelf.printStatus("delete   ", n, n, l);
            TestSelf.print("");
            statement.execute("DROP TABLE Addr");
        }
        catch (Exception exception) {
            TestSelf.print("");
            TestSelf.print("TestSelf error: " + exception);
            TestSelf.print("with SQL command: " + string4);
            exception.printStackTrace();
        }
        connection.close();
        TestSelf.print("Test finished");
    }

    static void printStatus(String string, int n, int n2, long l) {
        System.out.print(string + ": " + n + "/" + n2 + " " + 100 * n / n2 + "% ");
        long l2 = System.currentTimeMillis();
        if (l2 > l) {
            System.out.print((long)(n * 1000) / (l2 - l));
        }
        System.out.print(" rows/s                \r");
    }
}

