/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.hsqldb.Trigger;

public class TestSchemaParse
extends TestCase
implements Trigger {
    Connection con = null;
    Statement statement;
    private static final String ipref = "INFORMATION_SCHEMA.";
    private boolean shutdownTested = false;
    private static final int SQL_ABORT = -1234;
    private static final int SQL_INITIAL = -1233;
    private static final int SQL_FAIL = -1;
    static /* synthetic */ Class class$org$hsqldb$jdbcDriver;
    static /* synthetic */ Class class$org$hsqldb$test$TestSchemaParse;

    protected void setUp() throws Exception {
        (class$org$hsqldb$jdbcDriver == null ? (class$org$hsqldb$jdbcDriver = TestSchemaParse.class$("org.hsqldb.jdbcDriver")) : class$org$hsqldb$jdbcDriver).getName();
        this.con = DriverManager.getConnection("jdbc:hsqldb:mem:parsetest", "sa", "");
        this.statement = this.con.createStatement();
        this.execSQL("SET AUTOCOMMIT false", 0);
        this.execSQL("CREATE TABLE tsttbl (i INT, vc VARCHAR)", 0);
        this.execSQL("CREATE TABLE bigtbl (i INT, vc VARCHAR, i101 INT, i102 INT, i103 INT, i104 INT, i105 INT, i106 INT, i107 INT, i108 INT, i109 INT, i110 INT, i111 INT, i112 INT, i113 INT, i114 INT, i115 INT, i116 INT, i117 INT, i118 INT, i119 INT)", 0);
        this.execSQL("INSERT INTO tsttbl VALUES (1, 'one')", 1);
        this.execSQL("INSERT INTO tsttbl VALUES (2, 'two')", 1);
        this.execSQL("CREATE TABLE joinedtbl (i2 INT, vc2 VARCHAR)", 0);
        this.execSQL("INSERT INTO joinedtbl VALUES (2, 'zwei')", 1);
        this.execSQL("CREATE TABLE indexedtbl (i3 INT, vc3 VARCHAR)", 0);
        this.execSQL("INSERT INTO indexedtbl VALUES (3, 'tres')", 1);
        this.execSQL("CREATE TABLE triggedtbl (i4 INT, vc4 VARCHAR)", 0);
        this.execSQL("INSERT INTO triggedtbl VALUES (4, 'quatro')", 1);
        this.execSQL("CREATE ALIAS tstali FOR \"org.hsqldb.test.BlaineTrig.capitalize\"", 0);
        this.execSQL("CREATE UNIQUE INDEX tstind ON indexedtbl (i3)", 0);
        this.execSQL("CREATE SEQUENCE tstseq", 0);
        this.execSQL("CREATE TRIGGER tsttrig AFTER INSERT ON triggedtbl CALL \"org.hsqldb.test.BlaineTrig\"", 0);
        this.execSQL("CREATE USER tstuser PASSWORD fake", 0);
        this.execSQL("CREATE TABLE constrainedtbl (i6 INT, vc6 VARCHAR, CONSTRAINT ucons UNIQUE(i6))", 0);
        this.execSQL("CREATE TABLE primarytbl (i8 INT, i18 INT, vc8 VARCHAR, UNIQUE(i8), UNIQUE(i18))", 0);
        this.execSQL("CREATE TABLE foreigntbl (i7 INT, vc7 VARCHAR, CONSTRAINT tstfk FOREIGN KEY (i7) REFERENCES primarytbl (i8))", 0);
        this.execSQL("CREATE TABLE playtbl (i9 INT, vc9 VARCHAR)", 0);
        this.execSQL("CREATE TABLE toindextbl (i10 INT, vc10 VARCHAR)", 0);
        this.execSQL("INSERT INTO toindextbl VALUES (10, 'zehn')", 1);
        this.execSQL("CREATE VIEW tstview AS SELECT * FROM tsttbl WHERE i < 10", 0);
        this.execSQL("COMMIT", 0);
    }

    protected void tearDown() throws Exception {
        this.execSQL("SHUTDOWN", this.shutdownTested);
        if (this.con != null) {
            this.con.close();
        }
    }

    public void test2pTables() throws Exception {
        String string = "public.";
        this.execSQL("DROP VIEW tstview", 0);
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT i FROM " + string + "tsttbl WHERE i IN (1, 2, 3)"));
        this.execSQL("SELECT * INTO " + string + "newtbl FROM tsttbl", 2);
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT admin FROM INFORMATION_SCHEMA.system_users"));
        TestSchemaParse.assertEquals((String)"Sub-query", (int)1, (int)this.queryRowCount("SELECT vc FROM " + string + "tsttbl WHERE i = (\n" + "    SELECT i2 FROM " + string + "joinedtbl\n" + ")"));
        TestSchemaParse.assertEquals((String)"Join", (int)1, (int)this.queryRowCount("SELECT vc FROM " + string + "tsttbl, " + string + "joinedtbl\n" + "WHERE tsttbl.i = joinedtbl.i2\n" + "AND joinedtbl.vc2 = 'zwei'"));
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT ali.i FROM " + string + "tsttbl ali WHERE ali.i IN (1, 2, 3)"));
        this.execSQL("SELECT * INTO " + string + "newtbl2 FROM tsttbl ali", 2);
        this.execSQL("SELECT * INTO newtbl3 FROM " + string + "tsttbl ali", 2);
        this.execSQL("SELECT * INTO " + string + "newtbl4 FROM " + string + "tsttbl ali", 2);
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT ali.admin FROM INFORMATION_SCHEMA.system_users ali"));
        TestSchemaParse.assertEquals((String)"Sub-query", (int)1, (int)this.queryRowCount("SELECT ali.vc FROM " + string + "tsttbl ali WHERE i = (\n" + "    SELECT bali.i2 FROM " + string + "joinedtbl bali\n" + ")"));
        TestSchemaParse.assertEquals((String)"Join", (int)1, (int)this.queryRowCount("SELECT ali.vc FROM " + string + "tsttbl ali, " + string + "joinedtbl bali\n" + "WHERE ali.i = bali.i2\n" + "AND bali.vc2 = 'zwei'"));
        this.execSQL("ALTER TABLE " + string + "playtbl RENAME TO " + string + "renamedtbl", 0);
        this.execSQL("ALTER TABLE " + string + "renamedtbl RENAME TO " + string + "playtbl", 0);
        this.execSQL("ALTER TABLE " + string + "constrainedtbl ADD CONSTRAINT con1 CHECK (i6 > 4)", 0);
        this.execSQL("ALTER TABLE " + string + "tsttbl ADD COLUMN vco1 VARCHAR", 0);
        this.execSQL("ALTER TABLE " + string + "tsttbl DROP COLUMN vco1", 0);
        this.execSQL("ALTER TABLE " + string + "tsttbl ADD COLUMN vco1 VARCHAR", 0);
        this.execSQL("ALTER TABLE " + string + "tsttbl ALTER COLUMN vco1 RENAME TO j1", 0);
        this.execSQL("ALTER TABLE " + string + "constrainedtbl DROP CONSTRAINT con1", 0);
        this.execSQL("ALTER TABLE " + string + "foreigntbl DROP CONSTRAINT tstfk", 0);
        this.execSQL("ALTER TABLE " + string + "foreigntbl ADD CONSTRAINT tstfk FOREIGN KEY " + "(i7) REFERENCES primarytbl (i8)", 0);
        this.execSQL("ALTER TABLE " + string + "playtbl ADD CONSTRAINT ucons9 UNIQUE (i9)", 0);
        this.execSQL("DROP TABLE " + string + "playtbl", 0);
        this.execSQL("SET TABLE " + string + "tsttbl READONLY true", 0);
        this.execSQL("SET TABLE " + string + "tsttbl READONLY false", 0);
        this.execSQL("CREATE TABLE " + string + "tsttbly (i INT, vc VARCHAR)", 0);
        this.execSQL("CREATE CACHED TABLE " + string + "tsttblx (i INT, vc VARCHAR)", 0);
        this.execSQL("CREATE TABLE constrz (i6 INT, vc6 VARCHAR, CONSTRAINT uconsz UNIQUE(i6))", 0);
        this.execSQL("CREATE TABLE forztbl (i7 INT, vc7 VARCHAR, CONSTRAINT tstfkz FOREIGN KEY (i7) REFERENCES primarytbl (i8))", 0);
        this.execSQL("UPDATE " + string + "tsttbl SET vc = 'eleven' WHERE i = 1", 1);
        this.execSQL("DELETE FROM  " + string + "tsttbl WHERE i = 1", 1);
        this.execSQL("GRANT ALL ON " + string + "tsttbl TO tstuser", 0);
        this.execSQL("REVOKE ALL ON " + string + "tsttbl FROM tstuser", 0);
    }

    public void test2pViews() throws Exception {
        String string = "public.";
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT i FROM " + string + "tstview WHERE i IN (1, 2, 3)"));
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT i FROM tstview"));
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT ali.i FROM tstview ali"));
        TestSchemaParse.assertEquals((String)"Sub-query", (int)1, (int)this.queryRowCount("SELECT vc FROM " + string + "tstview WHERE i = (\n" + "    SELECT i2 FROM " + string + "joinedtbl\n" + ")"));
        TestSchemaParse.assertEquals((String)"Join", (int)1, (int)this.queryRowCount("SELECT vc FROM " + string + "tstview, " + string + "joinedtbl\n" + "WHERE tstview.i = joinedtbl.i2\n" + "AND joinedtbl.vc2 = 'zwei'"));
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT i FROM " + string + "tstview ali WHERE ali.i IN (1, 2, 3)"));
        this.execSQL("CREATE VIEW " + string + "tstview2 AS SELECT * FROM tsttbl WHERE i < 10", 0);
        this.execSQL("GRANT ALL ON " + string + "tstview TO tstuser", 0);
        this.execSQL("REVOKE ALL ON " + string + "tstview FROM tstuser", 0);
        this.execSQL("DROP VIEW tstview", 0);
    }

    public void test2pSequences() throws Exception {
        String string = "public.";
        this.execSQL("CREATE SEQUENCE " + string + "tstseq2", 0);
        this.execSQL("ALTER SEQUENCE " + string + "tstseq RESTART WITH 23", 0);
        TestSchemaParse.assertEquals((int)1, (int)this.queryRowCount("SELECT next value FOR " + string + "tstseq FROM tsttbl WHERE i = 1"));
        this.execSQL("DROP SEQUENCE " + string + "tstseq", 0);
    }

    public void test2pConstraints() throws Exception {
        String string = "public.";
        this.execSQL("CREATE TABLE constbl1 (i11 INT, vc12 VARCHAR, CONSTRAINT " + string + "uconsw UNIQUE(vc12))", 0);
        this.execSQL("CREATE TABLE constbl2 (i11 INT, vc12 VARCHAR, CONSTRAINT " + string + "chk CHECK (i11 > 4))", 0);
        this.execSQL("CREATE TABLE for2tbl (i7 INT, vc7 VARCHAR, CONSTRAINT " + string + "tstfk2 FOREIGN KEY (i7) REFERENCES primarytbl (i8))", 0);
        this.execSQL("CREATE TABLE for3tbl (i7 INT, vc7 VARCHAR, CONSTRAINT " + string + "tstpk2 PRIMARY KEY (i7))", 0);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT " + string + "con1 CHECK (i6 > 4)", 0);
        this.execSQL("ALTER TABLE foreigntbl ADD CONSTRAINT " + string + "tstfkm FOREIGN KEY " + "(i7) REFERENCES primarytbl (i18)", 0);
        this.execSQL("ALTER TABLE for3tbl DROP CONSTRAINT " + string + "tstpk2", 0);
    }

    public void test2pIndexes() throws Exception {
        String string = "public.";
        this.execSQL("CREATE UNIQUE INDEX playind ON playtbl (i9)", 0);
        this.execSQL("CREATE UNIQUE INDEX bigind ON bigtbl (i)", 0);
        this.execSQL("CREATE UNIQUE INDEX " + string + "tstind2 ON tsttbl (i)", 0);
        this.execSQL("ALTER INDEX " + string + "playind RENAME TO renamedind", 0);
        this.execSQL("ALTER INDEX " + string + "renamedind RENAME TO " + string + "tstind22", 0);
        this.execSQL("ALTER INDEX tstind RENAME TO " + string + "renamedind", 0);
        this.execSQL("DROP INDEX " + string + "bigind", 0);
    }

    public void test2pAliases() throws Exception {
        String string = "public.";
        int n = 0;
        n = -1234;
        this.execSQL("CREATE ALIAS " + string + "tstalias " + "FOR \"org.hsqldb.test.BlaineTrig.capitalize\"", n);
    }

    public void test2pTriggers() throws Exception {
        String string = "public.";
        this.execSQL("CREATE TRIGGER " + string + "tsttrig2 AFTER INSERT ON triggedtbl " + "CALL \"org.hsqldb.test.BlaineTrig\"", 0);
        this.execSQL("DROP TRIGGER " + string + "tsttrig", 0);
    }

    public void testSanityCheck() throws Exception {
        int n = -1234;
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT i FROM tstview"));
        this.execSQL("DROP VIEW tstview", 0);
        this.execSQL("CREATE CACHED TABLE cachtbl (i INT, vc VARCHAR)", 0);
        this.execSQL("SET TABLE tsttbl READONLY true", 0);
        this.execSQL("SET TABLE tsttbl READONLY false", 0);
        this.execSQL("INSERT INTO tsttbl VALUES (11, 'eleven')", 1);
        TestSchemaParse.assertEquals((int)1, (int)this.queryRowCount("SELECT i FROM tsttbl WHERE i = 1"));
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT i FROM tsttbl WHERE i IN (1, 2, 3)"));
        this.execSQL("ALTER SEQUENCE tstseq RESTART WITH 13", 0);
        this.execSQL("ALTER TABLE playtbl RENAME TO renamedtbl", 0);
        this.execSQL("ALTER TABLE renamedtbl RENAME TO playtbl", 0);
        this.execSQL("DROP INDEX tstind", 0);
        this.execSQL("DROP TABLE bigtbl", 0);
        this.execSQL("DROP SEQUENCE tstseq", 0);
        this.execSQL("SET LOGSIZE 5", 0);
        this.execSQL("SET PROPERTY \"hsqldb.first_identity\" 4", -1234);
        this.execSQL("UPDATE tsttbl SET vc = 'eleven' WHERE i = 1", 1);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT con1 CHECK (i6 > 4)", 0);
        this.execSQL("COMMIT", 0);
        this.execSQL("DELETE FROM tsttbl WHERE i < 10", 2);
        TestSchemaParse.assertEquals((int)1, (int)this.queryRowCount("SELECT i FROM tsttbl"));
        this.execSQL("ROLLBACK", 0);
        TestSchemaParse.assertEquals((int)3, (int)this.queryRowCount("SELECT i FROM tsttbl"));
        this.execSQL("ALTER TABLE tsttbl ADD COLUMN vco1 VARCHAR", 0);
        this.execSQL("ALTER TABLE tsttbl DROP COLUMN vco1", 0);
        this.execSQL("CREATE UNIQUE INDEX tstind ON tsttbl (i)", 0);
        this.execSQL("SET AUTOCOMMIT true", 0);
        this.execSQL("SET AUTOCOMMIT false", 0);
        this.execSQL("SET IGNORECASE true", 0);
        this.execSQL("SET IGNORECASE false", 0);
        this.execSQL("SET PASSWORD blah", 0);
        this.execSQL("SET PASSWORD 'blah'", 0);
        this.execSQL("SET REFERENTIAL_INTEGRITY true", 0);
        this.execSQL("GRANT ALL ON playtbl TO tstuser", 0);
        this.execSQL("REVOKE ALL ON playtbl FROM tstuser", 0);
        this.execSQL("ALTER INDEX tstind RENAME TO renamedind", 0);
        this.execSQL("ALTER INDEX renamedind RENAME TO tstind", 0);
        this.execSQL("ALTER USER tstuser SET PASSWORD frank", 0);
        this.execSQL("ALTER USER tstuser SET PASSWORD 'frank'", 0);
        this.execSQL("ALTER TABLE tsttbl ADD COLUMN vco1 VARCHAR", 0);
        this.execSQL("ALTER TABLE tsttbl ALTER COLUMN vco1 RENAME TO j1", 0);
        this.execSQL("ALTER TABLE constrainedtbl DROP CONSTRAINT con1", 0);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", 0);
        this.execSQL("ALTER TABLE foreigntbl ADD CONSTRAINT tstfk FOREIGN KEY (i7) REFERENCES primarytbl (i8)", 0);
        TestSchemaParse.assertEquals((String)"Sub-query", (int)1, (int)this.queryRowCount("SELECT vc FROM tsttbl WHERE i = (\n    SELECT i2 FROM joinedtbl\n)"));
        TestSchemaParse.assertEquals((String)"Join", (int)1, (int)this.queryRowCount("SELECT vc FROM tsttbl, joinedtbl WHERE tsttbl.i = joinedtbl.i2\nAND joinedtbl.vc2 = 'zwei'"));
        TestSchemaParse.assertEquals((String)"Over-specified Query 1", (int)1, (int)this.queryRowCount("SELECT tsttbl.i FROM tsttbl WHERE tsttbl.i = 1"));
        TestSchemaParse.assertEquals((String)"Over-specified Query 2", (int)1, (int)this.queryRowCount("SELECT tsttbl.i FROM tsttbl WHERE i = 1"));
        TestSchemaParse.assertEquals((String)"Over-specified Query 3", (int)1, (int)this.queryRowCount("SELECT i FROM tsttbl WHERE tsttbl.i = 1"));
        TestSchemaParse.assertEquals((String)"Trivial Label/alias 1", (int)1, (int)this.queryRowCount("SELECT i FROM tsttbl ali WHERE i = 1"));
        TestSchemaParse.assertEquals((String)"Trivial Label/alias 2", (int)1, (int)this.queryRowCount("SELECT i FROM tsttbl AS ali WHERE i = 1"));
        TestSchemaParse.assertEquals((String)"Trivial Label/alias 3", (int)1, (int)this.queryRowCount("SELECT ali.i FROM tsttbl ali WHERE i = 1"));
        TestSchemaParse.assertEquals((String)"Trivial Label/alias 4", (int)1, (int)this.queryRowCount("SELECT i FROM tsttbl ali WHERE ali.i = 1"));
        TestSchemaParse.assertEquals((String)"Trivial Label/alias 5", (int)1, (int)this.queryRowCount("SELECT ali.i FROM tsttbl ali WHERE ali.i = 1"));
        TestSchemaParse.assertEquals((String)"Join w/Labels/aliases 1", (int)1, (int)this.queryRowCount("SELECT vc FROM tsttbl ali1, joinedtbl ali2\nWHERE i = i2 AND vc2 = 'zwei'"));
        TestSchemaParse.assertEquals((String)"Join w/Labels/aliases 2", (int)1, (int)this.queryRowCount("SELECT vc FROM tsttbl ali1, joinedtbl ali2\nWHERE ali1.i = i2 AND ali2.vc2 = 'zwei'"));
        TestSchemaParse.assertEquals((String)"Join w/Labels/aliases 3", (int)1, (int)this.queryRowCount("SELECT ali1.vc FROM tsttbl ali1, joinedtbl ali2\nWHERE ali1.i = i2 AND ali2.vc2 = 'zwei'"));
        TestSchemaParse.assertEquals((String)"Join w/Labels/aliases 4", (int)1, (int)this.queryRowCount("SELECT ali1.vc FROM tsttbl ali1, joinedtbl ali2\nWHERE i = i2 AND vc2 = 'zwei'"));
        this.execSQL("SET PROPERTY \"hsqldb.first_identity\" 5 bad", n);
        this.execSQL("CHECKPOINT bad", n);
        this.execSQL("INSERT INTO tsttbl(i, vc) VALUES (12, 'twelve')", 1);
        this.execSQL("SELECT * INTO newtbl FROM tsttbl", 4);
    }

    public void testTwoPartKeywords() throws Exception {
        this.multiPartKeywords("public.");
    }

    public void testThreePartKeywords() throws Exception {
        this.multiPartKeywords("alpha.public.");
    }

    public void multiPartKeywords(String string) throws Exception {
        int n = -1234;
        boolean bl = string.lastIndexOf(46) != string.indexOf(46);
        this.execSQL("DROP VIEW tstview", 0);
        this.execSQL("CREATE TABLE adroptbl (i INT, vc VARCHAR)", 0);
        this.execSQL("CREATE TABLE bdroptbl (i INT, vc VARCHAR)", 0);
        this.execSQL("CREATE UNIQUE INDEX adropind ON adroptbl (i)", 0);
        this.execSQL("CREATE UNIQUE INDEX bdropind ON bdroptbl (i)", 0);
        this.execSQL("CREATE SEQUENCE bdropseq", 0);
        this.execSQL("CREATE SEQUENCE adropseq", 0);
        this.execSQL("CREATE TRIGGER adroptrig AFTER INSERT ON adroptbl CALL \"org.hsqldb.test.BlaineTrig\"", 0);
        this.execSQL("CREATE TRIGGER bdroptrig AFTER INSERT ON bdroptbl CALL \"org.hsqldb.test.BlaineTrig\"", 0);
        this.execSQL("CREATE VIEW adropviewx AS SELECT * FROM adroptbl", 0);
        this.execSQL("CREATE VIEW bdropviewx AS SELECT * FROM bdroptbl", 0);
        this.execSQL("ALTER TABLE playtbl ADD COLUMN newc VARCHAR", 0);
        this.execSQL("SET TABLE tsttbl READONLY false", 0);
        this.execSQL("SET TABLE tsttbl READONLY " + string + "true", n);
        this.execSQL(string + "CREATE SEQUENCE tstseqa", n);
        this.execSQL(string + "SET PROPERTY \"hsqldb.first_identity\" 4", n);
        this.execSQL("SET " + string + "PROPERTY \"hsqldb.first_identity\" 4", n);
        this.execSQL("SELECT i FROM tsttbl WHERE i = " + string + "1", n);
        this.execSQL("SELECT i FROM tsttbl WHERE vc = " + string + "'1.3'", n);
        this.execSQL("SELECT i FROM tsttbl WHERE vc = " + string + "1", n);
        this.execSQL("SELECT i FROM tsttbl WHERE i = " + string + "'1.3'", n);
        this.execSQL("SELECT i FROM tsttbl WHERE " + string + "1 = " + string + "1", n);
        this.execSQL("SELECT i FROM tsttbl WHERE " + string + "'1.3' = " + string + "'1.3'", n);
        this.execSQL("SELECT i FROM tsttbl WHERE " + string + "true = " + string + "true", n);
        this.execSQL("SELECT i FROM tsttbl WHERE i " + string + "IN (2, 4)", n);
        this.execSQL("SELECT i FROM tsttbl WHERE i < 3 y.AND i > 0", n);
        this.execSQL("SELECT i FROM tsttbl WHERE i < y.3 AND i > 0", n);
        this.execSQL("INSERT INTO tsttbl VALUES (" + string + "1, 'one')", n);
        this.execSQL("CREATE VIEW tstviewx AS SELECT " + string + "* FROM tsttbl WHERE i < 10", n);
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL("INSERT INTO tsttbl VALUES (1, " + string + "'one')", n);
        this.execSQL("CREATE UNIQUE INDEX tstinda ON toindextbl (" + string + "i10)", n);
        this.execSQL("DROP INDEX tstinda IF EXISTS", 0);
        this.execSQL("CREATE VIEW tstviewx AS SELECT * FROM tsttbl WHERE i < " + string + "10", n);
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL("xDROP VIEW adropview", n);
        this.execSQL("DROP xVIEW bdropview", n);
        this.execSQL("xDROP TRIGGER adroptrig", n);
        this.execSQL("DROP xTRIGGER bdroptrig", n);
        this.execSQL("xDROP INDEX adropind", n);
        this.execSQL("DROP xINDEX bdropind", n);
        this.execSQL("xDROP TABLE adroptbl", n);
        this.execSQL("DROP xTABLE bdroptbl", n);
        this.execSQL("xDROP SEQUENCE adropseq", n);
        this.execSQL("DROP xSEQUENCE bdropseq", n);
        this.execSQL("SET LOGSIZE " + string + "5", n);
        this.execSQL(string + "SET TABLE texttbl SOURCE \"test.csv;fs=|\"", n);
        this.execSQL("SET " + string + "TABLE texttbl SOURCE \"test.csv;fs=|\"", n);
        this.execSQL("SET TABLE texttbl " + string + "SOURCE \"test.csv;fs=|\"", n);
        this.execSQL("SET TABLE texttbl SOURCE " + string + "\"test.csv;fs=|\"", n);
        this.execSQL("UPDATE tsttbl SET vc = " + string + "'eleven' WHERE i = 1", n);
        this.execSQL("UPDATE tsttbl SET vc = 'eleven' WHERE i = " + string + "1", n);
        this.execSQL("ALTER SEQUENCE tstseq RESTART WITH " + string + "13", n);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT con1 CHECK (i6 > " + string + "4)", n);
        this.execSQL(string + "INSERT INTO tsttbl VALUES (1, 'one')", n);
        this.execSQL("INSERT " + string + "INTO tsttbl VALUES (1, 'one')", n);
        if (!bl) {
            n = 1;
        }
        this.execSQL("INSERT INTO " + string + "tsttbl VALUES (1, 'one')", n);
        n = -1234;
        this.execSQL(string + "DELETE FROM tsttbl WHERE i < 10", n);
        this.execSQL("SELECT vc FROM " + string + "tsttbl, " + string + "joinedtbl WHERE tsttbl.i = joinedtbl.i2\n" + "AND joinedtbl.vc2 = 'zwei'", bl ? -1234 : -1);
        this.execSQL(string + "SELECT i FROM tsttbl", n);
        this.execSQL("SELECT i " + string + "FROM tsttbl", n);
        this.execSQL("SELECT i FROM tsttbl " + string + "WHERE i > 0", n);
        this.execSQL(string + "CREATE ALIAS alpha.tstalia " + "FOR \"org.hsqldb.test.BlaineTrig.capitalize\"", n);
        this.execSQL("CREATE " + string + "ALIAS tstalib " + "FOR \"org.hsqldb.test.BlaineTrig.capitalize\"", n);
        this.execSQL("CREATE ALIAS tstalic " + string + "FOR \"org.hsqldb.test.BlaineTrig.capitalize\"", n);
        this.execSQL("CREATE ALIAS tstalid FOR " + string + "\"org.hsqldb.test.BlaineTrig.capitalize\"", n);
        this.execSQL("ALTER " + string + "TABLE playtbl DROP COLUMN newc", n);
        this.execSQL("CREATE " + string + "SEQUENCE tstseqb", n);
        this.execSQL("CREATE " + string + "TRIGGER tsttrigx AFTER INSERT ON triggedtbl CALL '" + "org.hsqldb.test.BlaineTrig'", n);
        this.execSQL("CREATE " + string + "USER tstusera PASSWORD fake", n);
        this.execSQL("CREATE VIEW tstviewx " + string + "AS SELECT * FROM tsttbl WHERE i < 10", n);
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL("CREATE UNIQUE " + string + "INDEX tstinda ON toindextbl (i10)", n);
        this.execSQL("DROP INDEX tstinda IF EXISTS", 0);
        this.execSQL("CREATE " + string + "INDEX tstinda ON toindextbl (i10)", n);
        this.execSQL("DROP INDEX tstinda IF EXISTS", 0);
        this.execSQL("CREATE TRIGGER tsttrigy " + string + "AFTER INSERT ON triggedtbl CALL \"" + "org.hsqldb.test.BlaineTrig\"", n);
        this.execSQL("CREATE USER tstuserb " + string + "PASSWORD fake", n);
        this.execSQL("CREATE VIEW tstviewx AS " + string + "SELECT * FROM tsttbl WHERE i < 10", n);
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL("CREATE UNIQUE INDEX tstinda " + string + "ON toindextbl (i10)", n);
        this.execSQL("DROP INDEX tstinda IF EXISTS", 0);
        this.execSQL("CREATE TRIGGER tsttrigz AFTER " + string + "INSERT ON triggedtbl CALL \"" + "org.hsqldb.test.BlaineTrig\"", n);
        this.execSQL("CREATE VIEW tstviewx AS SELECT * " + string + "FROM tsttbl WHERE i < 10", n);
        if (!bl) {
            n = 0;
        }
        this.execSQL("CREATE USER tstuserc PASSWORD " + string + "fake", n);
        n = -1234;
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL("CREATE TRIGGER tsttriga AFTER INSERT " + string + "ON triggedtbl CALL \"" + "org.hsqldb.test.BlaineTrig\"", n);
        this.execSQL("CREATE TRIGGER tsttrigb AFTER INSERT ON triggedtbl " + string + "CALL \"" + "org.hsqldb.test.BlaineTrig\"", n);
        this.execSQL("CREATE VIEW tstviewx AS SELECT * FROM tsttbl " + string + "WHERE i < 10", n);
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL("CREATE TRIGGER tsttrigc AFTER INSERT ON triggedtbl CALL " + string + "\"org.hsqldb.test.BlaineTrig'", n);
        this.execSQL("CREATE " + string + "UNIQUE INDEX tstindx ON toindextbl (i10)", n);
        this.execSQL("DROP INDEX tstinda IF EXISTS", 0);
        this.execSQL("CREATE " + string + "VIEW tstviewx AS SELECT * FROM tsttbl WHERE i < 10", n);
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL(string + "CREATE USER tstuserd PASSWORD fake", n);
        this.execSQL(string + "CREATE TRIGGER tsttrigd AFTER INSERT ON triggedtbl CALL \"" + "org.hsqldb.test.BlaineTrig\"", n);
        this.execSQL(string + "CREATE VIEW tstviewx AS SELECT * FROM tsttbl WHERE i < 10", n);
        this.execSQL("DROP VIEW tstviewx IF EXISTS", 0);
        this.execSQL(string + "CREATE UNIQUE INDEX tstinda ON toindextbl (i10)", n);
        this.execSQL("DROP INDEX tstinda IF EXISTS", 0);
        this.execSQL("CREATE TABLE t1 (i " + string + "INT, vc VARCHAR)", n);
        this.execSQL("DROP TABLE t1 IF EXISTS", 0);
        this.execSQL("CREATE TABLE t1 (i INT, vc " + string + "VARCHAR)", n);
        this.execSQL("DROP TABLE t1 IF EXISTS", 0);
        this.execSQL(string + "CREATE TABLE t1 (i INT, vc VARCHAR)", n);
        this.execSQL("DROP TABLE t1 IF EXISTS", 0);
        this.execSQL("CREATE " + string + "TABLE t1 (i INT, vc VARCHAR)", n);
        this.execSQL("DROP TABLE t1 IF EXISTS", 0);
        this.execSQL("CREATE TABLE t1 (i " + string + "INT, vc VARCHAR)", n);
        this.execSQL("DROP TABLE t1 IF EXISTS", 0);
        this.execSQL("CREATE TABLE t1 (i INT, vc " + string + "VARCHAR)", n);
        this.execSQL("DROP TABLE t1 IF EXISTS", 0);
        this.execSQL("DELETE " + string + "FROM tsttbl WHERE i < 10", n);
        if (!bl) {
            n = 3;
        }
        this.execSQL("DELETE FROM tsttbl " + string + "WHERE i < 10", n);
        n = -1234;
        this.execSQL(string + "SET AUTOCOMMIT true", n);
        this.execSQL("SET " + string + "AUTOCOMMIT true", n);
        this.execSQL("SET AUTOCOMMIT false", 0);
        this.execSQL(string + "SET IGNORECASE true", n);
        this.execSQL("SET " + string + "IGNORECASE true", n);
        this.execSQL(string + "SET LOGSIZE 5", n);
        this.execSQL("SET " + string + "LOGSIZE 5", n);
        this.execSQL(string + "SET PASSWORD blah", n);
        this.execSQL("SET " + string + "PASSWORD blah", n);
        this.execSQL(string + "SET REFERENTIAL_INTEGRITY true", n);
        this.execSQL("SET " + string + "REFERENTIAL_INTEGRITY true", n);
        this.execSQL(string + "SET SCRIPTFORMAT text", n);
        this.execSQL("SET " + string + "SCRIPTFORMAT text", n);
        this.execSQL(string + "SET TABLE tsttbl READONLY true", n);
        this.execSQL("SET " + string + "TABLE tsttbl READONLY true", n);
        this.execSQL("SET TABLE tsttbl READONLY false", 0);
        this.execSQL(string + "GRANT ALL ON playtbl TO tstuser", n);
        this.execSQL("GRANT " + string + "ALL ON playtbl TO tstuser", n);
        this.execSQL("GRANT ALL " + string + "ON playtbl TO tstuser", n);
        this.execSQL("GRANT ALL ON playtbl " + string + "TO tstuser", n);
        if (!bl) {
            n = 0;
        }
        this.execSQL("GRANT ALL ON playtbl TO " + string + "tstuser", n);
        n = -1234;
        this.execSQL(string + "REVOKE ALL ON playtbl FROM tstuser", n);
        this.execSQL("REVOKE " + string + "ALL ON playtbl FROM tstuser", n);
        this.execSQL("REVOKE ALL " + string + "ON playtbl FROM tstuser", n);
        this.execSQL("REVOKE ALL ON playtbl " + string + "FROM tstuser", n);
        if (!bl) {
            n = 0;
        }
        this.execSQL("REVOKE ALL ON playtbl FROM " + string + "tstuser", n);
        n = -1234;
        this.execSQL("GRANT ALL ON playtbl TO tstuser", 0);
        this.execSQL(string + "COMMIT", n);
        this.execSQL(string + "ROLLBACK", n);
        this.execSQL(string + "UPDATE tsttbl SET vc = 'eleven' WHERE i = 1", n);
        this.execSQL("UPDATE tsttbl " + string + "SET vc = 'eleven' WHERE i = 1", n);
        this.execSQL("UPDATE tsttbl SET vc = 'eleven' " + string + "WHERE i = 1", n);
        this.execSQL(string + "ALTER INDEX tstind RENAME TO renamedind", n);
        this.execSQL("ALTER INDEX tstind " + string + "RENAME TO renamedind", n);
        this.execSQL("ALTER " + string + "INDEX tstind RENAME TO renamedind", n);
        this.execSQL("ALTER INDEX tstind RENAME " + string + "TO renamedind", n);
        this.execSQL(string + "ALTER SEQUENCE tstseq RESTART WITH 13", n);
        this.execSQL("ALTER " + string + "SEQUENCE tstseq RESTART WITH 13", n);
        this.execSQL("ALTER SEQUENCE tstseq " + string + "RESTART WITH 13", n);
        this.execSQL("ALTER SEQUENCE tstseq RESTART " + string + "WITH 13", n);
        if (!bl) {
            n = 0;
        }
        this.execSQL("ALTER USER tstuser SET PASSWORD " + string + "frank", n);
        n = -1234;
        this.execSQL(string + "ALTER USER tstuser SET PASSWORD frank", n);
        this.execSQL("ALTER " + string + "USER tstuser SET PASSWORD frank", n);
        this.execSQL("ALTER USER tstuser " + string + "SET PASSWORD frank", n);
        this.execSQL("ALTER USER tstuser SET " + string + "PASSWORD frank", n);
        this.execSQL(string + "ALTER TABLE tsttbl ADD COLUMN vco1 VARCHAR", n);
        this.execSQL("ALTER " + string + "TABLE tsttbl ADD COLUMN vco2 VARCHAR", n);
        this.execSQL("ALTER TABLE tsttbl " + string + "ADD COLUMN vco3 VARCHAR", n);
        this.execSQL("ALTER TABLE tsttbl ADD " + string + "COLUMN vco4 VARCHAR", n);
        this.execSQL("ALTER TABLE tsttbl ADD " + string + "COLUMN vco5 " + string + "VARCHAR", n);
        this.execSQL("ALTER TABLE bigtbl DROP " + string + "COLUMN i103", n);
        this.execSQL("ALTER TABLE bigtbl " + string + "DROP COLUMN i102", n);
        this.execSQL(string + "ALTER TABLE bigtbl DROP COLUMN i101", n);
        this.execSQL(string + "ALTER TABLE bigtbl ALTER COLUMN i104 RENAME TO j1", n);
        this.execSQL("ALTER " + string + "TABLE bigtbl ALTER COLUMN i105 RENAME TO j2", n);
        this.execSQL("ALTER TABLE bigtbl " + string + "ALTER COLUMN i106 RENAME TO j3", n);
        this.execSQL("ALTER TABLE bigtbl ALTER " + string + "COLUMN i107 RENAME TO j4", n);
        this.execSQL("ALTER TABLE bigtbl ALTER COLUMN i108 " + string + "RENAME TO j5", n);
        this.execSQL("ALTER TABLE bigtbl ALTER COLUMN i109 RENAME " + string + "TO j6", n);
        this.execSQL(string + "ALTER TABLE constrainedtbl ADD CONSTRAINT con2 CHECK (i6 > 4)", n);
        this.execSQL("ALTER " + string + "TABLE constrainedtbl ADD CONSTRAINT con3 CHECK (i6 > 4)", n);
        this.execSQL("ALTER TABLE constrainedtbl " + string + "ADD CONSTRAINT con4 CHECK (i6 > 4)", n);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT con1 CHECK (i6 > 4)", true);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT con2 CHECK (i6 > 4)", true);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT con3 CHECK (i6 > 4)", true);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT con4 CHECK (i6 > 4)", true);
        this.execSQL("ALTER TABLE constrainedtbl ADD " + string + "CONSTRAINT con5 CHECK (i6 > 4)", n);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT con6 " + string + "CHECK (i6 > 4)", n);
        this.execSQL("ALTER TABLE constrainedtbl DROP CONSTRAINT ucons", true);
        this.execSQL(string + "ALTER TABLE constrainedtbl ADD CONSTRAINT ucons UNIQUE (i6)", n);
        this.execSQL("ALTER TABLE constrainedtbl DROP CONSTRAINT ucons", true);
        this.execSQL("ALTER " + string + "TABLE constrainedtbl ADD CONSTRAINT ucons UNIQUE (i6)", n);
        this.execSQL("ALTER TABLE constrainedtbl DROP CONSTRAINT ucons", true);
        this.execSQL("ALTER TABLE constrainedtbl " + string + "ADD CONSTRAINT ucons UNIQUE (i6)", n);
        this.execSQL("ALTER TABLE constrainedtbl DROP CONSTRAINT ucons", true);
        this.execSQL("ALTER TABLE constrainedtbl ADD " + string + "CONSTRAINT ucons UNIQUE (i6)", n);
        this.execSQL("ALTER TABLE constrainedtbl DROP CONSTRAINT ucons", true);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT ucons " + string + "UNIQUE (i6)", n);
        this.execSQL("ALTER TABLE constrainedtbl ADD CONSTRAINT ucons UNIQUE (i6)", true);
        this.execSQL(string + "ALTER TABLE playtbl RENAME TO renamedtbl", n);
        this.execSQL("ALTER TABLE renamedtbl RENAME TO playtbl", true);
        this.execSQL("ALTER " + string + "TABLE playtbl RENAME TO renamedtbl", n);
        this.execSQL("ALTER TABLE renamedtbl RENAME TO playtbl", true);
        this.execSQL("ALTER TABLE playtbl " + string + "RENAME TO renamedtbl", n);
        this.execSQL("ALTER TABLE renamedtbl RENAME TO playtbl", true);
        this.execSQL("ALTER TABLE playtbl RENAME " + string + "TO renamedtbl", n);
        this.execSQL(string + "ALTER TABLE constrainedtbl DROP CONSTRAINT con1", n);
        this.execSQL("ALTER " + string + "TABLE constrainedtbl DROP CONSTRAINT con2", n);
        this.execSQL("ALTER TABLE constrainedtbl " + string + "DROP CONSTRAINT con3", n);
        this.execSQL("ALTER TABLE constrainedtbl DROP " + string + "CONSTRAINT con4", n);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", true);
        this.execSQL(string + "ALTER TABLE foreigntbl ADD CONSTRAINT tstfk FOREIGN KEY " + "(i7) REFERENCES primarytbl (i8)", n);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", true);
        this.execSQL("ALTER " + string + "TABLE foreigntbl ADD CONSTRAINT tstfk FOREIGN KEY " + "(i7) REFERENCES primarytbl (i8)", n);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", true);
        this.execSQL("ALTER TABLE foreigntbl " + string + "ADD CONSTRAINT tstfk FOREIGN KEY " + "(i7) REFERENCES primarytbl (i8)", n);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", true);
        this.execSQL("ALTER TABLE foreigntbl ADD " + string + "CONSTRAINT tstfk FOREIGN KEY " + "(i7) REFERENCES primarytbl (i8)", n);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", true);
        this.execSQL("ALTER TABLE foreigntbl ADD CONSTRAINT tstfk " + string + "FOREIGN KEY " + "(i7) REFERENCES primarytbl (i8)", n);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", true);
        this.execSQL("ALTER TABLE foreigntbl ADD CONSTRAINT tstfk FOREIGN " + string + "KEY " + "(i7) REFERENCES primarytbl (i8)", n);
        this.execSQL("ALTER TABLE foreigntbl DROP CONSTRAINT tstfk", true);
        this.execSQL("ALTER TABLE foreigntbl ADD CONSTRAINT tstfk FOREIGN KEY (i7) " + string + "REFERENCES primarytbl (i8)", n);
        this.shutdownTested = true;
        this.execSQL("SHUTDOWN IMMEDIATELY", 0);
    }

    public void testThreePartNames() throws Exception {
        this.execSQL("SELECT public.tsttbl.i FROM public.beta.tsttbl\nWHERE public.tsttbl.i = 1", -1234);
    }

    public void testBasicQueries() throws Exception {
        String string = "public.";
        TestSchemaParse.assertEquals((int)2, (int)this.queryRowCount("SELECT i FROM " + string + "tsttbl"));
        TestSchemaParse.assertEquals((int)1, (int)this.queryRowCount("SELECT vc FROM " + string + "tsttbl WHERE i = 1"));
        TestSchemaParse.assertEquals((int)1, (int)this.queryRowCount("SELECT vc FROM " + string + "tsttbl WHERE i = (\n" + "    SELECT i2 FROM " + string + "joinedtbl\n" + ")"));
    }

    private void execSQL(String string, boolean bl) throws SQLException {
        block2: {
            try {
                this.statement.execute(string);
                this.statement.getUpdateCount();
            }
            catch (SQLException sQLException) {
                if (bl) break block2;
                throw sQLException;
            }
        }
    }

    private void execSQL(String string, String string2, int n) {
        int n2 = -1233;
        try {
            this.statement.execute(string2);
            n2 = this.statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            n2 = -1234;
        }
        TestSchemaParse.assertEquals((String)string, (int)n, (int)n2);
    }

    private void execSQL(String string, int n) {
        this.execSQL(string, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryRowCount(String string) throws SQLException {
        int n = 0;
        if (!this.statement.execute(string)) {
            return n;
        }
        ResultSet resultSet = this.statement.getResultSet();
        try {
            while (resultSet.next()) {
                ++n;
            }
        }
        finally {
            resultSet.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tableRowCount(String string) throws SQLException {
        String string2 = "SELECT count(*) FROM " + string;
        if (!this.statement.execute(string2)) {
            return 0;
        }
        ResultSet resultSet = this.statement.getResultSet();
        try {
            if (!resultSet.next()) {
                throw new SQLException("0 rows returned by (" + string2 + ')');
            }
            int n = resultSet.getInt(1);
            if (resultSet.next()) {
                throw new SQLException("> 1 row returned by (" + string2 + ')');
            }
            int n2 = n;
            return n2;
        }
        finally {
            resultSet.close();
        }
    }

    public TestSchemaParse() {
    }

    public TestSchemaParse(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].startsWith("-g")) {
            junit.swingui.TestRunner.run((Class)(class$org$hsqldb$test$TestSchemaParse == null ? (class$org$hsqldb$test$TestSchemaParse = TestSchemaParse.class$("org.hsqldb.test.TestSchemaParse")) : class$org$hsqldb$test$TestSchemaParse));
        } else {
            TestRunner testRunner = new TestRunner();
            System.exit(TestRunner.run((Test)testRunner.getTest((class$org$hsqldb$test$TestSchemaParse == null ? (class$org$hsqldb$test$TestSchemaParse = TestSchemaParse.class$("org.hsqldb.test.TestSchemaParse")) : class$org$hsqldb$test$TestSchemaParse).getName())).wasSuccessful() ? 0 : 1);
        }
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestSchemaParse("testSanityCheck"));
        testSuite.addTest((Test)new TestSchemaParse("testTwoPartKeywords"));
        testSuite.addTest((Test)new TestSchemaParse("testThreePartKeywords"));
        testSuite.addTest((Test)new TestSchemaParse("testThreePartNames"));
        testSuite.addTest((Test)new TestSchemaParse("testBasicQueries"));
        testSuite.addTest((Test)new TestSchemaParse("test2pTables"));
        testSuite.addTest((Test)new TestSchemaParse("test2pViews"));
        testSuite.addTest((Test)new TestSchemaParse("test2pSequences"));
        testSuite.addTest((Test)new TestSchemaParse("test2pIndexes"));
        testSuite.addTest((Test)new TestSchemaParse("test2pAliases"));
        testSuite.addTest((Test)new TestSchemaParse("test2pConstraints"));
        testSuite.addTest((Test)new TestSchemaParse("test2pTriggers"));
        return testSuite;
    }

    public void fire(int n, String string, String string2, Object[] objectArray, Object[] objectArray2) {
    }

    public static String capitalize(String string) {
        return string.toUpperCase();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

