/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import junit.framework.TestResult;
import org.hsqldb.test.TestBase;

public class TestLikePredicateOptimizations
extends TestBase {
    public TestLikePredicateOptimizations(String string) {
        super(string);
    }

    public void test() throws Exception {
        Connection connection = this.newConnection();
        Statement statement = connection.createStatement();
        statement.execute("drop table test if exists");
        String string = "create table test(name varchar(255))";
        statement.execute(string);
        string = "insert into test values(?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (int i = 0; i < 10000; ++i) {
            preparedStatement.setString(1, "name" + i);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        string = "select count(*) from test where name = null";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        int n = resultSet.getInt(1);
        string = "select count(*) from test where name like null";
        preparedStatement = connection.prepareStatement(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n2 = resultSet.getInt(1);
        TestLikePredicateOptimizations.assertEquals((String)("\"" + string + "\""), (int)n, (int)n2);
        string = "select count(*) from test where name = ''";
        resultSet = statement.executeQuery(string);
        resultSet.next();
        n = resultSet.getInt(1);
        string = "select count(*) from test where name like ''";
        preparedStatement = connection.prepareStatement(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        n2 = resultSet.getInt(1);
        TestLikePredicateOptimizations.assertEquals((String)("\"" + string + "\""), (int)n, (int)n2);
        string = "select count(*) from test where name is not null";
        resultSet = statement.executeQuery(string);
        resultSet.next();
        n = resultSet.getInt(1);
        string = "select count(*) from test where name like '%'";
        preparedStatement = connection.prepareStatement(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        n2 = resultSet.getInt(1);
        TestLikePredicateOptimizations.assertEquals((String)("\"" + string + "\""), (int)n, (int)n2);
        string = "select count(*) from test where left(name, 6) = 'name44'";
        resultSet = statement.executeQuery(string);
        resultSet.next();
        n = resultSet.getInt(1);
        string = "select count(*) from test where name like 'name44%'";
        preparedStatement = connection.prepareStatement(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        n2 = resultSet.getInt(1);
        TestLikePredicateOptimizations.assertEquals((String)("\"" + string + "\""), (int)n, (int)n2);
        string = "select count(*) from test where left(name,5) = 'name4' and right(name,1) = 5";
        resultSet = statement.executeQuery(string);
        resultSet.next();
        n = resultSet.getInt(1);
        string = "select count(*) from test where name like 'name4%5'";
        preparedStatement = connection.prepareStatement(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        n2 = resultSet.getInt(1);
        TestLikePredicateOptimizations.assertEquals((String)("\"" + string + "\""), (int)n, (int)n2);
        statement.execute("drop table test1 if exists");
        string = "CREATE TABLE test1 (col VARCHAR(30))";
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.execute();
        string = "INSERT INTO test1 (col) VALUES ('one')";
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.execute();
        string = "SELECT * FROM test1 WHERE ( col LIKE ? )";
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.setString(1, "one");
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string2 = resultSet.getString("COL");
        string = "SELECT * FROM test1 WHERE ( col LIKE 'one' )";
        preparedStatement = connection.prepareStatement(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string3 = resultSet.getString("COL");
        TestLikePredicateOptimizations.assertEquals((String)("\"" + string + "\""), (String)string3, (String)string2);
    }

    public static void main(String[] stringArray) throws Exception {
        TestResult testResult = new TestResult();
        TestLikePredicateOptimizations testLikePredicateOptimizations = new TestLikePredicateOptimizations("test");
        testLikePredicateOptimizations.run(testResult);
        int n = testResult.failureCount();
        System.out.println("TestLikePredicateOptimizations failure count: " + n);
        Enumeration enumeration = testResult.failures();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }
}

