/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.util.Random;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.StopWatch;

public class TestLibSpeed {
    static final String[][] sNumeric = new String[][]{{"ABS", "org.hsqldb.Library.abs"}, {"ACOS", "java.lang.Math.acos"}, {"ASIN", "java.lang.Math.asin"}, {"ATAN", "java.lang.Math.atan"}, {"ATAN2", "java.lang.Math.atan2"}, {"CEILING", "java.lang.Math.ceil"}, {"COS", "java.lang.Math.cos"}, {"COT", "org.hsqldb.Library.cot"}, {"DEGREES", "java.lang.Math.toDegrees"}, {"EXP", "java.lang.Math.exp"}, {"FLOOR", "java.lang.Math.floor"}, {"LOG", "java.lang.Math.log"}, {"LOG10", "org.hsqldb.Library.log10"}, {"MOD", "org.hsqldb.Library.mod"}, {"PI", "org.hsqldb.Library.pi"}, {"POWER", "java.lang.Math.pow"}, {"RADIANS", "java.lang.Math.toRadians"}, {"RAND", "java.lang.Math.random"}, {"ROUND", "org.hsqldb.Library.round"}, {"SIGN", "org.hsqldb.Library.sign"}, {"SIN", "java.lang.Math.sin"}, {"SQRT", "java.lang.Math.sqrt"}, {"TAN", "java.lang.Math.tan"}, {"TRUNCATE", "org.hsqldb.Library.truncate"}, {"BITAND", "org.hsqldb.Library.bitand"}, {"BITOR", "org.hsqldb.Library.bitor"}, {"ROUNDMAGIC", "org.hsqldb.Library.roundMagic"}};
    static HashSet hashSet = new HashSet();
    static DoubleIntIndex doubleIntLookup = new DoubleIntIndex(sNumeric.length, false);
    static IntKeyIntValueHashMap intKeyIntValueHashLookup = new IntKeyIntValueHashMap();
    static IntValueHashMap intValueHashLookup = new IntValueHashMap(sNumeric.length);
    static IntKeyHashMap intKeyHashLookup = new IntKeyHashMap();
    static int count;

    public TestLibSpeed() {
        Random random = new Random();
        StopWatch stopWatch = new StopWatch();
        int n = 0;
        System.out.println("set lookup ");
        for (int i = 0; i < 3; ++i) {
            int n2;
            int n3;
            int n4;
            stopWatch.zero();
            for (n4 = 0; n4 < count; ++n4) {
                for (n3 = 0; n3 < sNumeric.length; ++n3) {
                    n2 = random.nextInt(sNumeric.length);
                    hashSet.contains(sNumeric[n2][0]);
                    n += n2;
                }
            }
            System.out.println("HashSet contains " + stopWatch.elapsedTime());
            stopWatch.zero();
            for (n4 = 0; n4 < count; ++n4) {
                for (n3 = 0; n3 < sNumeric.length; ++n3) {
                    n2 = random.nextInt(sNumeric.length);
                    intKeyIntValueHashLookup.get(n2, -1);
                    n += n2;
                }
            }
            System.out.println("IntKeyIntValueHashMap Lookup with array " + stopWatch.elapsedTime());
            stopWatch.zero();
            for (n4 = 0; n4 < count; ++n4) {
                for (n3 = 0; n3 < sNumeric.length; ++n3) {
                    n2 = random.nextInt(sNumeric.length);
                    intKeyHashLookup.get(n2);
                    n += n2;
                }
            }
            System.out.println("IntKeyHashMap Lookup " + stopWatch.elapsedTime());
            stopWatch.zero();
            for (n4 = 0; n4 < count; ++n4) {
                for (n3 = 0; n3 < sNumeric.length; ++n3) {
                    n2 = random.nextInt(sNumeric.length);
                    doubleIntLookup.findFirstEqualKeyIndex(n2);
                    n += n2;
                }
            }
            System.out.println("DoubleIntTable Lookup " + stopWatch.elapsedTime());
            stopWatch.zero();
            for (n4 = 0; n4 < count; ++n4) {
                for (n3 = 0; n3 < sNumeric.length; ++n3) {
                    n2 = random.nextInt(sNumeric.length);
                    intValueHashLookup.get((Object)sNumeric[n2][0], 0);
                    n += n2;
                }
            }
            System.out.println("IntKeyIntValueHashMap Lookup " + stopWatch.elapsedTime());
            stopWatch.zero();
            for (n4 = 0; n4 < count; ++n4) {
                for (n3 = 0; n3 < sNumeric.length; ++n3) {
                    n2 = random.nextInt(sNumeric.length);
                    n += n2;
                }
            }
            System.out.println("emptyOp " + stopWatch.elapsedTime());
            stopWatch.zero();
            for (n4 = 0; n4 < count; ++n4) {
                for (n3 = 0; n3 < sNumeric.length; ++n3) {
                    n2 = random.nextInt(sNumeric.length);
                    doubleIntLookup.findFirstEqualKeyIndex(n2);
                    n += n2;
                }
            }
            System.out.println("DoubleIntTable Lookup " + stopWatch.elapsedTime());
            stopWatch.zero();
            System.out.println("Object Cache Test " + stopWatch.elapsedTime());
        }
    }

    public static void main(String[] stringArray) {
        TestLibSpeed testLibSpeed = new TestLibSpeed();
    }

    static {
        doubleIntLookup.setKeysSearchTarget();
        Random random = new Random();
        int[] nArray = new int[2];
        for (int i = 0; i < sNumeric.length; ++i) {
            hashSet.add(sNumeric[i][0]);
            intKeyIntValueHashLookup.put(random.nextInt(sNumeric.length), i);
            intKeyHashLookup.put(i, new Integer(i));
            doubleIntLookup.add(random.nextInt(sNumeric.length), i);
            intValueHashLookup.put(sNumeric[i][0], random.nextInt(sNumeric.length));
        }
        count = 100000;
    }
}

