/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.hsqldb.WebServer;

public class TestJDBCSavepoints
extends TestCase {
    String serverProps = "database.0=mem:test;silent=true;trace=false";
    String url = "jdbc:hsqldb:http://localhost";
    String user;
    String password;
    Statement stmt;
    Connection conn1;
    Connection conn2;
    WebServer server;

    public TestJDBCSavepoints(String string) {
        super(string);
    }

    protected void setUp() {
        this.user = "sa";
        this.password = "";
        this.stmt = null;
        this.conn1 = null;
        this.conn2 = null;
        this.server = new WebServer();
        this.server.putPropertiesFromString(this.serverProps);
        this.server.setLogWriter(null);
        this.server.start();
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.conn1 = DriverManager.getConnection(this.url, this.user, this.password);
            this.conn2 = DriverManager.getConnection(this.url, this.user, this.password);
            this.stmt = this.conn1.createStatement();
        }
        catch (Exception exception) {
            System.out.println((Object)((Object)this) + ".setUp() error: " + exception.getMessage());
        }
    }

    protected void tearDown() {
        try {
            this.conn1.close();
        }
        catch (Exception exception) {
            System.out.println((Object)((Object)this) + ".tearDown() error: " + exception.getMessage());
        }
        try {
            this.conn2.close();
        }
        catch (Exception exception) {
            System.out.println((Object)((Object)this) + ".tearDown() error: " + exception.getMessage());
        }
        this.server.stop();
    }

    public void testJDBCSavepoints() throws Exception {
        int n;
        int n2 = 0;
        String string = "drop table t if exists";
        this.stmt.executeUpdate(string);
        string = "create table t(id int, fn varchar, ln varchar, zip int)";
        this.stmt.executeUpdate(string);
        this.conn1.setAutoCommit(true);
        this.conn1.setAutoCommit(false);
        string = "insert into t values(?,?,?,?)";
        PreparedStatement preparedStatement = this.conn1.prepareStatement(string);
        preparedStatement.setString(2, "Mary");
        preparedStatement.setString(3, "Peterson-Clancy");
        for (n = 0; n < 10; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(4, n);
            preparedStatement.executeUpdate();
        }
        Savepoint savepoint = this.conn1.setSavepoint("savepoint1");
        while (n < 20) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(4, n);
            preparedStatement.executeUpdate();
            ++n;
        }
        Savepoint savepoint2 = this.conn1.setSavepoint("savepoint2");
        while (n < 30) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(4, n);
            preparedStatement.executeUpdate();
            ++n;
        }
        Savepoint savepoint3 = this.conn1.setSavepoint("savepoint3");
        while (n < 40) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(4, n);
            preparedStatement.executeUpdate();
            ++n;
        }
        Savepoint savepoint4 = this.conn1.setSavepoint("savepoint4");
        while (n < 50) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(4, n);
            preparedStatement.executeUpdate();
            ++n;
        }
        Savepoint savepoint5 = this.conn1.setSavepoint("savepoint5");
        Savepoint savepoint6 = this.conn1.setSavepoint("savepoint6");
        Savepoint savepoint7 = this.conn1.setSavepoint("savepoint7");
        ResultSet resultSet = this.stmt.executeQuery("select count(*) from t");
        resultSet.next();
        n2 = resultSet.getInt(1);
        resultSet.close();
        String string2 = "select count(*) from t value";
        try {
            TestJDBCSavepoints.assertEquals((String)string2, (int)50, (int)n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn2.setAutoCommit(false);
        this.conn2.setSavepoint("savepoint1");
        this.conn2.setSavepoint("savepoint2");
        string2 = "savepoint released succesfully on non-originating connection";
        try {
            this.conn2.releaseSavepoint(savepoint2);
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.conn2.rollback(savepoint);
            string2 = "succesful rollback to savepoint on non-originating connection";
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = "direct execution of <release savepoint> statement failed to release JDBC-created SQL-savepoint with identical savepoint name";
        try {
            this.conn2.createStatement().executeUpdate("release savepoint \"savepoint2\"");
        }
        catch (Exception exception) {
            try {
                TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        string2 = "direct execution of <rollback to savepoint> statement failed to roll back to existing JDBC-created SQL-savepoint with identical savepoint name";
        try {
            this.conn2.createStatement().executeUpdate("rollback to savepoint \"savepoint1\"");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        this.conn1.releaseSavepoint(savepoint6);
        string2 = "savepoint released succesfully > 1 times";
        try {
            this.conn1.releaseSavepoint(savepoint6);
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = "savepoint released successfully after preceding savepoint released";
        try {
            this.conn1.releaseSavepoint(savepoint7);
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = "preceding same-point savepoint destroyed by following savepoint release";
        try {
            this.conn1.releaseSavepoint(savepoint5);
        }
        catch (Exception exception) {
            try {
                TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        this.conn1.rollback(savepoint4);
        resultSet = this.stmt.executeQuery("select count(*) from t");
        resultSet.next();
        n2 = resultSet.getInt(1);
        resultSet.close();
        string2 = "select * rowcount after 50 inserts - 10 rolled back:";
        try {
            TestJDBCSavepoints.assertEquals((String)string2, (int)40, (int)n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = "savepoint rolled back succesfully > 1 times";
        try {
            this.conn1.rollback(savepoint4);
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn1.rollback(savepoint3);
        resultSet = this.stmt.executeQuery("select count(*) from t");
        resultSet.next();
        n2 = resultSet.getInt(1);
        resultSet.close();
        string2 = "select count(*) after 50 inserts - 20 rolled back:";
        try {
            TestJDBCSavepoints.assertEquals((String)string2, (int)30, (int)n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = "savepoint released succesfully after use in rollback";
        try {
            this.conn1.releaseSavepoint(savepoint3);
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn1.rollback(savepoint);
        string2 = "savepoint rolled back without raising an exception after rollback to a preceeding savepoint";
        try {
            this.conn1.rollback(savepoint2);
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn1.rollback();
        string2 = "savepoint released succesfully when it should have been destroyed by a full rollback";
        try {
            this.conn1.releaseSavepoint(savepoint);
            TestJDBCSavepoints.assertTrue((String)string2, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn1.setAutoCommit(false);
        savepoint = this.conn1.setSavepoint("savepoint1");
        this.conn1.rollback();
        this.conn1.setAutoCommit(false);
        this.conn1.createStatement().executeUpdate("savepoint \"savepoint1\"");
        this.conn1.setAutoCommit(false);
        savepoint = this.conn1.setSavepoint("savepoint1");
        this.conn1.createStatement().executeUpdate("savepoint \"savepoint1\"");
        this.conn1.setAutoCommit(false);
        savepoint = this.conn1.setSavepoint("savepoint1");
        this.conn1.createStatement().executeUpdate("savepoint \"savepoint1\"");
    }

    public static void main(String[] stringArray) throws Exception {
        TestResult testResult = new TestResult();
        TestJDBCSavepoints testJDBCSavepoints = new TestJDBCSavepoints("testJDBCSavepoints");
        testJDBCSavepoints.run(testResult);
        int n = testResult.failureCount();
        System.out.println("TestJDBCSavepoints failure count: " + n);
        Enumeration enumeration = testResult.failures();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }
}

