/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import junit.framework.TestResult;
import org.hsqldb.test.TestBase;

public class TestINPredicateParameterizationAndCorrelation
extends TestBase {
    public TestINPredicateParameterizationAndCorrelation(String string) {
        super(string);
    }

    public void test() throws Exception {
        Connection connection = this.newConnection();
        Statement statement = connection.createStatement();
        statement.execute("drop table test if exists");
        String string = "create table test(id int)";
        statement.execute(string);
        string = "insert into test values(?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        string = "select count(*) from test where id in(?,?)";
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.setInt(1, 0);
        preparedStatement.setInt(2, 9);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = 2;
        int n2 = resultSet.getInt(1);
        string = "\"select count(*) from test where id in(0,9)\"";
        TestINPredicateParameterizationAndCorrelation.assertEquals((String)string, (int)n, (int)n2);
        string = "select count(*) from test a, test b where 0 in(a.id, b.id)";
        resultSet = statement.executeQuery(string);
        resultSet.next();
        n = resultSet.getInt(1);
        string = "select count(*) from test a, test b where ? in (a.id, b.id)";
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.setInt(1, 0);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        n2 = resultSet.getInt(1);
        string = "\"select count(*) from test a, test b where 0 in (a.id, b.id)\"";
        TestINPredicateParameterizationAndCorrelation.assertEquals((String)string, (int)n, (int)n2);
        try {
            string = "select count(*) from test a, test b where ? in(?, b.id)";
            preparedStatement = connection.prepareStatement(string);
            TestINPredicateParameterizationAndCorrelation.assertTrue((String)("expected exception preparing \"" + string + "\""), (boolean)false);
        }
        catch (Exception exception) {
            TestINPredicateParameterizationAndCorrelation.assertTrue((String)exception.toString(), (boolean)true);
        }
        try {
            string = "select count(*) from test a, test b where a.id in(?, ?)";
            preparedStatement = connection.prepareStatement(string);
        }
        catch (Exception exception) {
            TestINPredicateParameterizationAndCorrelation.assertTrue((String)("unexpected exception preparing \"" + string + "\":" + exception), (boolean)false);
        }
        string = "select count(*) from (select * from test where id in (1,2)) a,(select * from test where id in (3,4)) b where a.id < 2 and b.id < 4";
        resultSet = statement.executeQuery(string);
        resultSet.next();
        n = resultSet.getInt(1);
        string = "select count(*) from (select * from test where id in (?,?)) a,(select * from test where id in (?,?)) b where a.id < ? and b.id < ?";
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 2);
        preparedStatement.setInt(3, 3);
        preparedStatement.setInt(4, 4);
        preparedStatement.setInt(5, 2);
        preparedStatement.setInt(6, 4);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        n2 = resultSet.getInt(1);
        TestINPredicateParameterizationAndCorrelation.assertEquals((String)"row count: ", (int)n, (int)n2);
    }

    public static void main(String[] stringArray) throws Exception {
        TestResult testResult = new TestResult();
        TestINPredicateParameterizationAndCorrelation testINPredicateParameterizationAndCorrelation = new TestINPredicateParameterizationAndCorrelation("test");
        testINPredicateParameterizationAndCorrelation.run(testResult);
        int n = testResult.failureCount();
        System.out.println("TestINPredicateParameterizationAndCorrelation failure count: " + n);
        Enumeration enumeration = testResult.failures();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }
}

