/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.StopWatch;

public class TestHashStructures
extends TestCase {
    Random randomgen = new Random();

    public TestHashStructures(String string) {
        super(string);
    }

    public void testHashMap() throws Exception {
        boolean bl = false;
        int n = 33;
        HashMap hashMap = new HashMap();
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        java.util.HashMap hashMap2 = new java.util.HashMap();
        try {
            this.populateBySerialIntKeys(hashMap2, hashMap, n);
            this.compareByUIterator(hashMap2, hashMap);
            this.compareByHIterator(hashMap2, hashMap);
            this.populateByRandomIntKeys(hashMap2, hashMap, n);
            this.compareByUIterator(hashMap2, hashMap);
            this.compareByHIterator(hashMap2, hashMap);
            this.depopulateRandomly(hashMap2, hashMap, 20);
            this.compareByUIterator(hashMap2, hashMap);
            this.compareByHIterator(hashMap2, hashMap);
            this.populateBySerialIntKeys(hashMap2, hashMap, n);
            this.compareByUIterator(hashMap2, hashMap);
            this.compareByHIterator(hashMap2, hashMap);
            this.depopulateByIterator(hashMap2, hashMap, 20);
            this.compareByUIterator(hashMap2, hashMap);
            this.compareByHIterator(hashMap2, hashMap);
        }
        catch (Exception exception) {
            bl = true;
        }
        TestHashStructures.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testIntKeyHashMap() throws Exception {
        boolean bl = false;
        int n = 33;
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        java.util.HashMap hashMap = new java.util.HashMap();
        try {
            this.populateBySerialIntKeysInt(hashMap, intKeyHashMap, n);
            this.compareByUIteratorInt(hashMap, intKeyHashMap);
            this.populateByRandomIntKeysInt(hashMap, intKeyHashMap, n);
            this.compareByUIteratorInt(hashMap, intKeyHashMap);
            this.compareByHIteratorInt(hashMap, intKeyHashMap);
            this.depopulateByIntIterator(hashMap, intKeyHashMap, 20);
            this.compareByUIteratorInt(hashMap, intKeyHashMap);
            this.compareByHIteratorInt(hashMap, intKeyHashMap);
            this.clearByIntIterator(hashMap, intKeyHashMap);
            this.compareByUIteratorInt(hashMap, intKeyHashMap);
            this.compareByHIteratorInt(hashMap, intKeyHashMap);
            this.populateBySerialIntKeysInt(hashMap, intKeyHashMap, n);
            this.compareByUIteratorInt(hashMap, intKeyHashMap);
            this.compareByHIteratorInt(hashMap, intKeyHashMap);
            this.clearByIntIterator(hashMap, intKeyHashMap);
            this.compareByUIteratorInt(hashMap, intKeyHashMap);
            this.compareByHIteratorInt(hashMap, intKeyHashMap);
        }
        catch (Exception exception) {
            bl = true;
        }
        TestHashStructures.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testHashMappedList() throws Exception {
        boolean bl = false;
        int n = 33;
        HashMappedList hashMappedList = new HashMappedList();
        java.util.HashMap hashMap = new java.util.HashMap();
        try {
            this.populateBySerialIntKeys(hashMap, hashMappedList, n);
            this.compareByUIterator(hashMap, hashMappedList);
            this.compareByHIterator(hashMap, hashMappedList);
            this.populateByRandomIntKeys(hashMap, hashMappedList, n);
            this.compareByUIterator(hashMap, hashMappedList);
            this.compareByHIterator(hashMap, hashMappedList);
            this.depopulateRandomly(hashMap, hashMappedList, 20);
            this.compareByUIterator(hashMap, hashMappedList);
            this.compareByHIterator(hashMap, hashMappedList);
            this.populateByRandomIntKeys(hashMap, hashMappedList, n);
            this.compareByUIterator(hashMap, hashMappedList);
            this.compareByHIterator(hashMap, hashMappedList);
            this.depopulateRandomly(hashMap, hashMappedList, 20);
            this.populateBySerialIntKeys(hashMap, hashMappedList, n);
            this.compareByUIterator(hashMap, hashMappedList);
            this.compareByHIterator(hashMap, hashMappedList);
        }
        catch (Exception exception) {
            bl = true;
        }
        TestHashStructures.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testDoubleIntLookup() throws Exception {
        boolean bl = false;
        int n = 512;
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(12, false);
        try {
            doubleIntIndex.setKeysSearchTarget();
            this.populateBySerialIntKeysInt(doubleIntIndex, intKeyHashMap, n);
            this.compareByHIteratorInt(doubleIntIndex, intKeyHashMap);
            this.populateByRandomIntKeysInt(doubleIntIndex, intKeyHashMap, n);
            this.compareByHIteratorInt(doubleIntIndex, intKeyHashMap);
        }
        catch (Exception exception) {
            bl = true;
        }
        TestHashStructures.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testDoubleIntSpeed() throws Exception {
        boolean bl = false;
        int n = 500;
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(n, false);
        doubleIntIndex.setKeysSearchTarget();
        this.populateByRandomIntKeysInt(doubleIntIndex, intKeyHashMap, n);
        this.compareByHIteratorInt(doubleIntIndex, intKeyHashMap);
        int[] nArray = this.getSampleIntArray(doubleIntIndex, 100);
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        int n3 = 0;
        StopWatch stopWatch = new StopWatch();
        try {
            for (n3 = 0; n3 < 10000; ++n3) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    int n4 = doubleIntIndex.findFirstEqualKeyIndex(nArray[n2]);
                    nArray2[n2] = doubleIntIndex.getValue(n4);
                    doubleIntIndex.remove(n4);
                }
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    doubleIntIndex.addUnique(nArray[n2], nArray2[n2]);
                }
            }
            System.out.println(stopWatch.elapsedTimeToMessage("Double int table times"));
            doubleIntIndex.findFirstEqualKeyIndex(0);
            this.compareByHIteratorInt(doubleIntIndex, intKeyHashMap);
        }
        catch (Exception exception) {
            System.out.println(stopWatch.elapsedTimeToMessage("Double int table error: i =" + n2));
            bl = true;
        }
        TestHashStructures.assertTrue((!bl ? 1 : 0) != 0);
    }

    int[] getSampleIntArray(DoubleIntIndex doubleIntIndex, int n) {
        int[] nArray = new int[n];
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        while (intKeyHashMap.size() < n) {
            int n2 = this.nextIntRandom(this.randomgen, doubleIntIndex.size());
            intKeyHashMap.put(n2, null);
        }
        org.hsqldb.lib.Iterator iterator = intKeyHashMap.keySet().iterator();
        for (int i = 0; i < n; ++i) {
            int n3 = iterator.nextInt();
            nArray[i] = doubleIntIndex.getKey(n3);
        }
        return nArray;
    }

    void populateBySerialIntKeys(java.util.HashMap hashMap, HashMap hashMap2, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            int n2 = this.randomgen.nextInt();
            hashMap.put(new Integer(i), new Integer(n2));
            hashMap2.put(new Integer(i), new Integer(n2));
            if (hashMap.size() == hashMap2.size()) continue;
            throw new Exception("HashMap size mismatch");
        }
    }

    void populateBySerialIntKeysInt(java.util.HashMap hashMap, IntKeyHashMap intKeyHashMap, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            int n2 = this.randomgen.nextInt();
            hashMap.put(new Integer(i), new Integer(n2));
            intKeyHashMap.put(i, new Integer(n2));
            if (hashMap.size() == intKeyHashMap.size()) continue;
            throw new Exception("HashMap size mismatch");
        }
    }

    void populateBySerialIntKeysInt(DoubleIntIndex doubleIntIndex, IntKeyHashMap intKeyHashMap, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            int n2 = this.randomgen.nextInt();
            doubleIntIndex.addUnique(i, n2);
            intKeyHashMap.put(i, new Integer(n2));
            if (doubleIntIndex.size() == intKeyHashMap.size()) continue;
            throw new Exception("HashMap size mismatch");
        }
    }

    void populateByRandomIntKeysInt(DoubleIntIndex doubleIntIndex, IntKeyHashMap intKeyHashMap, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            int n2 = this.randomgen.nextInt();
            doubleIntIndex.addUnique(n2, i);
            intKeyHashMap.put(n2, new Integer(i));
            if (doubleIntIndex.size() == intKeyHashMap.size()) continue;
            throw new Exception("Duplicate random in int lookup");
        }
    }

    void populateByRandomIntKeys(java.util.HashMap hashMap, HashMap hashMap2, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            int n2 = this.randomgen.nextInt();
            hashMap.put(new Integer(n2), new Integer(i));
            hashMap2.put(new Integer(n2), new Integer(i));
            if (hashMap.size() == hashMap2.size()) continue;
            throw new Exception("HashMap size mismatch");
        }
    }

    void populateByRandomIntKeysInt(java.util.HashMap hashMap, IntKeyHashMap intKeyHashMap, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            int n2 = this.randomgen.nextInt();
            hashMap.put(new Integer(n2), new Integer(i));
            intKeyHashMap.put(n2, new Integer(i));
            if (hashMap.size() == intKeyHashMap.size()) continue;
            throw new Exception("HashMap size mismatch");
        }
    }

    void depopulateRandomly(java.util.HashMap hashMap, HashMap hashMap2, int n) throws Exception {
        int n2 = 0;
        int n3 = hashMap.size();
        if (n > n3 / 2) {
            n = n3 / 2;
        }
        while (n2 < n) {
            Iterator iterator = hashMap.keySet().iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                Object k = iterator.next();
                int n5 = this.randomgen.nextInt(n3);
                if (n5 == n4) {
                    iterator.remove();
                    hashMap2.remove(k);
                    ++n2;
                }
                if (hashMap.size() != hashMap2.size()) {
                    throw new Exception("HashMap size mismatch");
                }
                ++n4;
            }
        }
    }

    void depopulateByIterator(java.util.HashMap hashMap, HashMap hashMap2, int n) throws Exception {
        org.hsqldb.lib.Iterator iterator = hashMap2.keySet().iterator();
        System.out.println(hashMap.size());
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            int n3 = this.randomgen.nextInt(2);
            if (n3 == n2 % 2) {
                iterator.remove();
                hashMap.remove(object);
            }
            if (hashMap.size() != hashMap2.size()) {
                throw new Exception("HashMap size mismatch");
            }
            ++n2;
        }
        System.out.println(hashMap.size());
    }

    void depopulateByIntIterator(java.util.HashMap hashMap, IntKeyHashMap intKeyHashMap, int n) throws Exception {
        org.hsqldb.lib.Iterator iterator = intKeyHashMap.keySet().iterator();
        System.out.println(hashMap.size());
        int n2 = 0;
        while (iterator.hasNext()) {
            Integer n3 = new Integer(iterator.nextInt());
            int n4 = this.randomgen.nextInt(2);
            if (n4 == n2 % 2) {
                iterator.remove();
                hashMap.remove(n3);
            }
            if (hashMap.size() != intKeyHashMap.size()) {
                throw new Exception("HashMap size mismatch");
            }
            ++n2;
        }
        System.out.println(hashMap.size());
    }

    void clearByIntIterator(java.util.HashMap hashMap, IntKeyHashMap intKeyHashMap) throws Exception {
        org.hsqldb.lib.Iterator iterator = intKeyHashMap.keySet().iterator();
        System.out.println(hashMap.size());
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = new Integer(iterator.nextInt());
            iterator.remove();
            hashMap.remove(n2);
            if (hashMap.size() != intKeyHashMap.size()) {
                throw new Exception("HashMap size mismatch");
            }
            ++n;
        }
        System.out.println(hashMap.size());
    }

    void compareByUIterator(java.util.HashMap hashMap, HashMap hashMap2) throws Exception {
        Iterator iterator = hashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            Object k = iterator.next();
            Object v = hashMap.get(k);
            if (!v.equals(object = hashMap2.get(k))) {
                throw new Exception("HashMap value mismatch");
            }
            ++n;
        }
    }

    void compareByHIterator(java.util.HashMap hashMap, HashMap hashMap2) throws Exception {
        org.hsqldb.lib.Iterator iterator = hashMap2.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            Object object2 = iterator.next();
            Object v = hashMap.get(object2);
            if (!v.equals(object = hashMap2.get(object2))) {
                throw new Exception("HashMap value mismatch");
            }
            ++n;
        }
    }

    void compareByUIteratorInt(java.util.HashMap hashMap, IntKeyHashMap intKeyHashMap) throws Exception {
        Iterator iterator = hashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            Object k = iterator.next();
            Object v = hashMap.get(k);
            if (!v.equals(object = intKeyHashMap.get((Integer)k))) {
                throw new Exception("HashMap value mismatch");
            }
            ++n;
        }
    }

    void compareByHIteratorInt(java.util.HashMap hashMap, IntKeyHashMap intKeyHashMap) throws Exception {
        org.hsqldb.lib.Iterator iterator = intKeyHashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            Integer n2 = new Integer(iterator.nextInt());
            Object v = hashMap.get(n2);
            if (!v.equals(object = intKeyHashMap.get(n2))) {
                throw new Exception("HashMap value mismatch");
            }
            ++n;
        }
    }

    void compareByHIteratorInt(DoubleIntIndex doubleIntIndex, IntKeyHashMap intKeyHashMap) throws Exception {
        org.hsqldb.lib.Iterator iterator = intKeyHashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = iterator.nextInt();
            int n3 = doubleIntIndex.findFirstEqualKeyIndex(n2);
            int n4 = doubleIntIndex.getValue(n3);
            Integer n5 = (Integer)intKeyHashMap.get(n2);
            if (n5 != n4) {
                throw new Exception("HashMap value mismatch");
            }
            ++n;
        }
    }

    int nextIntRandom(Random random, int n) {
        int n2 = Math.abs(random.nextInt());
        return n2 % n;
    }

    public static void main(String[] stringArray) {
        try {
            TestHashStructures testHashStructures = new TestHashStructures("testHashMap");
            testHashStructures.testHashMap();
            testHashStructures.testIntKeyHashMap();
            testHashStructures.testHashMappedList();
            testHashStructures.testDoubleIntLookup();
            testHashStructures.testDoubleIntSpeed();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

