/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TestGroupByHaving
extends TestCase {
    private static final String databaseDriver = "org.hsqldb.jdbcDriver";
    private static final String databaseURL = "jdbc:hsqldb:mem:.";
    private static final String databaseUser = "sa";
    private static final String databasePassword = "";
    private Connection conn;
    private Statement stmt;
    static /* synthetic */ Class class$org$hsqldb$test$TestGroupByHaving;

    public TestGroupByHaving(String string) {
        super(string);
    }

    protected static Connection getJDBCConnection() throws SQLException {
        return DriverManager.getConnection(databaseURL, databaseUser, databasePassword);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.conn != null) {
            return;
        }
        Class.forName(databaseDriver);
        this.conn = TestGroupByHaving.getJDBCConnection();
        this.stmt = this.conn.createStatement();
        try {
            this.stmt.execute("drop table employee if exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.execute("create table employee(id int, firstname VARCHAR(50), lastname VARCHAR(50), salary decimal(10, 2), superior_id int, CONSTRAINT PK_employee PRIMARY KEY (id), CONSTRAINT FK_superior FOREIGN KEY (superior_id) REFERENCES employee(ID))");
        this.addEmployee(1, "Mike", "Smith", 160000.0, -1);
        this.addEmployee(2, "Mary", "Smith", 140000.0, -1);
        this.addEmployee(10, "Joe", "Divis", 50000.0, 1);
        this.addEmployee(11, "Peter", "Mason", 45000.0, 1);
        this.addEmployee(12, "Steve", "Johnson", 40000.0, 1);
        this.addEmployee(13, "Jim", "Hood", 35000.0, 1);
        this.addEmployee(20, "Jennifer", "Divis", 60000.0, 2);
        this.addEmployee(21, "Helen", "Mason", 50000.0, 2);
        this.addEmployee(22, "Daisy", "Johnson", 40000.0, 2);
        this.addEmployee(23, "Barbara", "Hood", 30000.0, 2);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            this.stmt.execute("drop table employee if exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    private void addEmployee(int n, String string, String string2, double d, int n2) throws Exception {
        this.stmt.execute("insert into employee values(" + n + ", '" + string + "', '" + string2 + "', " + d + ", " + (n2 <= 0 ? "null" : databasePassword + n2) + ")");
    }

    public void testAggregatedGroupBy() throws SQLException {
        String string = "select avg(salary), max(id) from employee group by superior_id order by superior_id ";
        Object[][] objectArray = new Object[][]{{new Double(150000.0), new Integer(2)}, {new Double(42500.0), new Integer(13)}, {new Double(45000.0), new Integer(23)}};
        this.compareResults(string, objectArray, 0);
    }

    public void testAggregatedGroupByHaving1() throws SQLException {
        String string = "select avg(salary), max(id) from employee group by superior_id having max(id) > 5 order by superior_id ";
        Object[][] objectArray = new Object[][]{{new Double(42500.0), new Integer(13)}, {new Double(45000.0), new Integer(23)}};
        this.compareResults(string, objectArray, 0);
    }

    public void testAggregatedGroupByHaving2() throws SQLException {
        String string = "select avg(salary), max(id) from employee group by superior_id having superior_id is not null order by superior_id ";
        Object[][] objectArray = new Object[][]{{new Double(42500.0), new Integer(13)}, {new Double(45000.0), new Integer(23)}};
        this.compareResults(string, objectArray, 0);
    }

    public void testHavingWithoutGroupBy1() throws SQLException {
        String string = "select avg(salary), max(id) from employee having avg(salary) > 1000 ";
        Object[][] objectArray = new Object[][]{{new Double(65000.0), new Integer(23)}};
        this.compareResults(string, objectArray, 0);
    }

    public void testHavingWithoutGroupBy2() throws SQLException {
        String string = "select avg(salary), max(id) from employee having avg(salary) > 1000000 ";
        Object[][] objectArray = new Object[][]{};
        this.compareResults(string, objectArray, 0);
    }

    public void testInvalidHaving() throws SQLException {
        String string = "select avg(salary), max(id) from employee group by lastname having (max(id) > 1) and (superior_id > 1) ";
        Object[][] objectArray = new Object[][]{};
        this.compareResults(string, objectArray, -67);
    }

    private void compareResults(String string, Object[][] objectArray, int n) throws SQLException {
        int n2;
        ResultSet resultSet = null;
        try {
            resultSet = this.stmt.executeQuery(string);
            TestGroupByHaving.assertTrue((String)("Statement <" + string + "> \nexpecting error code: " + n), (0 == n ? 1 : 0) != 0);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != n) {
                sQLException.printStackTrace();
            }
            TestGroupByHaving.assertTrue((String)("Statement <" + string + "> \nthrows wrong error code: " + sQLException.getErrorCode() + " expecting error code: " + n), (sQLException.getErrorCode() == n ? 1 : 0) != 0);
            return;
        }
        int n3 = 0;
        int n4 = n2 = objectArray.length > 0 ? objectArray[0].length : 0;
        while (resultSet.next()) {
            TestGroupByHaving.assertTrue((String)("Statement <" + string + "> \nreturned too many rows."), (n3 < objectArray.length ? 1 : 0) != 0);
            Object[] objectArray2 = objectArray[n3];
            int n5 = 1;
            int n6 = 0;
            while (n6 < n2) {
                Object object = null;
                Object object2 = objectArray2[n6];
                if (object2 == null) {
                    object = resultSet.getString(n5);
                    object = resultSet.wasNull() ? null : object;
                } else if (object2 instanceof String) {
                    object = resultSet.getString(n5);
                } else if (object2 instanceof Double) {
                    object = new Double(resultSet.getString(n5));
                } else if (object2 instanceof Integer) {
                    object = new Integer(resultSet.getInt(n5));
                }
                TestGroupByHaving.assertEquals((String)("Statement <" + string + "> \nreturned wrong value."), (Object)objectArray2[n6], (Object)object);
                ++n6;
                ++n5;
            }
            ++n3;
        }
        TestGroupByHaving.assertEquals((String)("Statement <" + string + "> \nreturned wrong number of rows."), (int)objectArray.length, (int)n3);
    }

    public static void main(String[] stringArray) throws IOException {
        TestRunner.run((Class)(class$org$hsqldb$test$TestGroupByHaving == null ? (class$org$hsqldb$test$TestGroupByHaving = TestGroupByHaving.class$("org.hsqldb.test.TestGroupByHaving")) : class$org$hsqldb$test$TestGroupByHaving));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

