/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import junit.framework.Assert;
import org.hsqldb.test.TestBase;

public class TestDateTime
extends TestBase {
    public TestDateTime(String string) {
        super(string);
    }

    protected void setUp() {
        super.setUp();
        try {
            Connection connection = super.newConnection();
            Statement statement = connection.createStatement();
            statement.execute("drop table time_test if exists");
            statement.execute("drop table date_test if exists");
            statement.execute("create table time_test(time_test time)");
            statement.execute("create table date_test(date_test date)");
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBasicDateSupport() throws Throwable {
        Calendar calendar = Calendar.getInstance();
        Connection connection = super.newConnection();
        int n = 0;
        calendar.set(1995, 9, 15, 1, 2, 3);
        Date date = new Date(calendar.getTime().getTime());
        PreparedStatement preparedStatement = connection.prepareStatement("insert into date_test(date_test) values (?)");
        preparedStatement.setDate(1, date);
        n = preparedStatement.executeUpdate();
        preparedStatement.close();
        Assert.assertEquals((String)"Exactly one record with date data shoud have been inserted.", (int)n, (int)1);
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        ResultSet resultSet = null;
        Date date2 = null;
        int n2 = 0;
        calendar.set(1995, 9, 15, 2, 3, 4);
        Date date3 = new Date(calendar.getTime().getTime());
        preparedStatement2 = connection.prepareStatement("select date_test.* from date_test where date_test = ?");
        preparedStatement2.setDate(1, date3);
        resultSet = preparedStatement2.executeQuery();
        Assert.assertTrue((String)"The inserted date is not in the database.", (boolean)resultSet.next());
        date2 = resultSet.getDate(1);
        preparedStatement3 = connection.prepareStatement("delete from date_test where date_test = ?");
        preparedStatement3.setDate(1, date);
        n2 = preparedStatement3.executeUpdate();
        preparedStatement3.close();
        Assert.assertEquals((String)"Exactly one record with date data shoud have been deleted.", (int)n2, (int)1);
        boolean bl = date2.toString().startsWith(date.toString().substring(0, 10));
        Assert.assertTrue((String)("The date retrieved from database " + DateFormat.getDateTimeInstance().format(date2) + " is not the same as the inserted one " + DateFormat.getDateTimeInstance().format(date)), (boolean)bl);
    }

    public void testBasicTimeSupport() throws Throwable {
        Calendar calendar = Calendar.getInstance();
        Connection connection = super.newConnection();
        int n = 0;
        calendar.set(1995, 9, 15, 1, 2, 3);
        Time time = new Time(calendar.getTime().getTime());
        PreparedStatement preparedStatement = connection.prepareStatement("insert into time_test(time_test) values (?)");
        preparedStatement.setTime(1, time);
        n = preparedStatement.executeUpdate();
        preparedStatement.close();
        Assert.assertEquals((String)"Exactly one record with time data shoud have been inserted.", (int)n, (int)1);
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        ResultSet resultSet = null;
        int n2 = 0;
        preparedStatement2 = connection.prepareStatement("select time_test.* from time_test where time_test = ?");
        calendar.set(1975, 4, 16, 1, 2, 3);
        Time time2 = new Time(calendar.getTime().getTime());
        preparedStatement2.setTime(1, time2);
        resultSet = preparedStatement2.executeQuery();
        Assert.assertTrue((String)"The inserted time is not in the database.", (boolean)resultSet.next());
        Time time3 = resultSet.getTime(1);
        preparedStatement3 = connection.prepareStatement("delete from time_test where time_test = ?");
        preparedStatement3.setTime(1, time);
        n2 = preparedStatement3.executeUpdate();
        Assert.assertEquals((String)"Exactly one record with time data shoud have been deleted.", (int)n2, (int)1);
        Assert.assertNotNull((String)"The inserted time shouldn't be retrieved as null from the database", (Object)time3);
        boolean bl = time3.toString().equals(time.toString());
        Assert.assertTrue((String)("The time retrieved from database " + DateFormat.getDateTimeInstance().format(time3) + " is not the same as the inserted one " + DateFormat.getDateTimeInstance().format(time)), (boolean)bl);
    }
}

