/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.TestResult;
import org.hsqldb.test.TestBase;

public class TestDatabaseMetaData
extends TestBase {
    public TestDatabaseMetaData(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        Connection connection = this.newConnection();
        try {
            Object object;
            Object object2;
            PreparedStatement preparedStatement = connection.prepareStatement("SET PROPERTY \"sql.enforce_strict_size\" true");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("DROP TABLE t1 IF EXISTS");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("CREATE TABLE t1 (cha CHARACTER, dec DECIMAL, doub DOUBLE, lon BIGINT, \"IN\" INTEGER, sma SMALLINT, tin TINYINT, dat DATE DEFAULT CURRENT_DATE, tim TIME DEFAULT CURRENT_TIME, timest TIMESTAMP DEFAULT CURRENT_TIMESTAMP );");
            int n = preparedStatement.executeUpdate();
            TestDatabaseMetaData.assertTrue((String)"expected update count of zero", (n == 0 ? 1 : 0) != 0);
            preparedStatement = connection.prepareStatement("CREATE INDEX t1 ON t1 (cha );");
            n = preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("DROP TABLE t2 IF EXISTS");
            n = preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("CREATE TABLE t2 (cha CHARACTER, dec DECIMAL, doub DOUBLE, lon BIGINT, \"IN\" INTEGER, sma SMALLINT, tin TINYINT, dat DATE DEFAULT CURRENT_DATE, tim TIME DEFAULT CURRENT_TIME, timest TIMESTAMP DEFAULT CURRENT_TIMESTAMP );");
            n = preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("CREATE INDEX t2 ON t2 (cha );");
            n = preparedStatement.executeUpdate();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTablePrivileges(null, null, "T1");
            while (resultSet.next()) {
                System.out.println("Table: " + resultSet.getString(3) + " priv: " + resultSet.getString(6));
            }
            resultSet = databaseMetaData.getIndexInfo(null, null, "T1", false, false);
            while (resultSet.next()) {
                System.out.println("Table: " + resultSet.getString(3) + " IndexName: " + resultSet.getString(6));
            }
            resultSet = databaseMetaData.getIndexInfo(null, null, "T2", false, false);
            while (resultSet.next()) {
                System.out.println("Table: " + resultSet.getString(3) + " IndexName: " + resultSet.getString(6));
            }
            preparedStatement = connection.prepareStatement("DROP INDEX t2 ON t2;");
            n = preparedStatement.executeUpdate();
            resultSet = databaseMetaData.getIndexInfo(null, null, "T2", false, false);
            TestDatabaseMetaData.assertTrue((String)"expected getIndexInfo returns empty resultset", (!resultSet.next() ? 1 : 0) != 0);
            ResultSet resultSet2 = databaseMetaData.getTables(null, null, "T1", new String[]{"TABLE"});
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (resultSet2.next()) {
                object2 = resultSet2.getString("TABLE_NAME").trim().toLowerCase();
                arrayList.add((String)object2);
                ++n2;
            }
            resultSet2.close();
            TestDatabaseMetaData.assertTrue((String)"expected table t1 count of 1", (n2 == 1 ? 1 : 0) != 0);
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = ((String)object2.next()).trim();
                ArrayList<String> arrayList2 = new ArrayList<String>(30);
                resultSet2 = databaseMetaData.getColumns(null, null, ((String)object).toUpperCase(), null);
                n2 = 0;
                while (resultSet2.next()) {
                    arrayList2.add(resultSet2.getString("COLUMN_NAME").trim().toLowerCase());
                    ++n2;
                }
                resultSet2.close();
            }
            preparedStatement = connection.prepareStatement("DROP TABLE t_1 IF EXISTS");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("CREATE TABLE t_1 (cha CHARACTER(10), dec DECIMAL(10,2), doub DOUBLE, lon BIGINT, \"IN\" INTEGER, sma SMALLINT, tin TINYINT, dat DATE DEFAULT CURRENT_DATE, tim TIME DEFAULT CURRENT_TIME, timest TIMESTAMP DEFAULT CURRENT_TIMESTAMP, bool BOOLEAN );");
            n = preparedStatement.executeUpdate();
            TestDatabaseMetaData.assertTrue((String)"expected update count of zero", (n == 0 ? 1 : 0) != 0);
            resultSet2 = databaseMetaData.getTables(null, null, "T\\_1", new String[]{"TABLE"});
            n2 = 0;
            while (resultSet2.next()) {
                object = resultSet2.getString("TABLE_NAME").trim().toLowerCase();
                arrayList.add((String)object);
                ++n2;
            }
            resultSet2.close();
            TestDatabaseMetaData.assertTrue((String)"expected table t_1 count of 1", (n2 == 1 ? 1 : 0) != 0);
            databaseMetaData.getPrimaryKeys(null, null, "T_1");
            databaseMetaData.getImportedKeys(null, null, "T_1");
            databaseMetaData.getCrossReference(null, null, "T_1", null, null, "T_1");
            preparedStatement = connection.prepareStatement("INSERT INTO T_1 (cha, dec, doub) VALUES ('name', 10.23, 0)");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("SELECT * FROM T_1");
            resultSet2 = preparedStatement.executeQuery();
            object = resultSet2.getMetaData();
            int n3 = object.getColumnDisplaySize(1);
            int n4 = object.getColumnDisplaySize(2);
            int n5 = object.getPrecision(2);
            int n6 = object.getScale(1);
            int n7 = object.getScale(2);
            String string = object.getColumnClassName(10);
            boolean bl = n3 == 10 && n4 == 13 && n5 == 10 && n6 == 0 && n7 == 2 && string.equals("java.sql.Timestamp");
            TestDatabaseMetaData.assertTrue((String)"wrong result metadata", (boolean)bl);
            string = object.getColumnClassName(11);
            bl = string.equals("java.lang.Boolean");
            TestDatabaseMetaData.assertTrue((String)"wrong result metadata", (boolean)bl);
            preparedStatement.close();
            connection.close();
        }
        catch (Exception exception) {
            TestDatabaseMetaData.assertTrue((String)"unable to prepare or execute DDL", (boolean)false);
        }
        finally {
            connection.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        TestResult testResult = new TestResult();
        TestDatabaseMetaData testDatabaseMetaData = new TestDatabaseMetaData("test");
        testDatabaseMetaData.run(testResult);
        int n = testResult.failureCount();
        System.out.println("TestDatabaseMetaData failure count: " + n);
        Enumeration enumeration = testResult.failures();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }
}

