/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import junit.framework.TestCase;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlLinkedList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StopWatch;

public class TestDataStructures
extends TestCase {
    private static final int NUMBER_OF_TEST_RUNS = 100000;
    private static final int NUMBER_OF_ITERATIONS_PER_RUN = 80;
    private Random randomGenerator = new Random(System.currentTimeMillis());
    private static final int ADD = 1;
    private static final int ADD_AT = 2;
    private static final int GET = 3;
    private static final int REMOVE = 4;
    private static final int SET = 5;
    private static final int OPTIMIZE = 6;
    private static final int REMOVE_ALL = 7;
    private Vector listCommandsCalled = new Vector(80);

    public TestDataStructures(String string) {
        super(string);
    }

    public void testLists() {
        int n;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlLinkedList hsqlLinkedList = new HsqlLinkedList();
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>(80);
        Integer n2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = null;
        Object object2 = null;
        Object var13_11 = null;
        for (n = 0; n < this.getRandomInt(3, 12); ++n) {
            n2 = this.getRandomInteger();
            hsqlArrayList.add(n2);
            hsqlLinkedList.add(n2);
            vector.addElement(n2);
            vector2.addElement("Add");
        }
        this.compareLists(hsqlArrayList, hsqlLinkedList, vector);
        for (n = 0; n < 80; ++n) {
            int n3 = this.getRandomInt(0, 15);
            switch (n3) {
                case 1: {
                    n2 = this.getRandomInteger();
                    vector2.addElement("Add");
                    hsqlArrayList.add(n2);
                    hsqlLinkedList.add(n2);
                    vector.addElement(n2);
                    break;
                }
                case 2: {
                    n2 = this.getRandomInteger();
                    int n4 = this.getRandomInt(0, vector.size() + 1);
                    vector2.addElement("Add at " + n4);
                    try {
                        hsqlArrayList.add(n4, n2);
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    try {
                        hsqlLinkedList.add(n4, n2);
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    try {
                        vector.insertElementAt(n2, n4);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                    break;
                }
                case 3: {
                    int n4 = this.getRandomInt(0, vector.size() + 1);
                    vector2.addElement("Get " + n4);
                    try {
                        object = hsqlArrayList.get(n4);
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    try {
                        object2 = hsqlLinkedList.get(n4);
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    try {
                        var13_11 = vector.elementAt(n4);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                    break;
                }
                case 4: {
                    int n4 = this.getRandomInt(0, vector.size() + 1);
                    vector2.addElement("Remove " + n4);
                    try {
                        object = hsqlArrayList.remove(n4);
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    try {
                        object2 = hsqlLinkedList.remove(n4);
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    try {
                        var13_11 = vector.elementAt(n4);
                        vector.removeElementAt(n4);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                    break;
                }
                case 5: {
                    n2 = this.getRandomInteger();
                    int n4 = this.getRandomInt(0, vector.size() + 1);
                    vector2.addElement("Set " + n4);
                    try {
                        hsqlArrayList.set(n4, n2);
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    try {
                        hsqlLinkedList.set(n4, n2);
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    try {
                        vector.setElementAt(n2, n4);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                    break;
                }
                case 6: {
                    vector2.addElement("Optimize");
                    hsqlArrayList.trim();
                    vector.trimToSize();
                    break;
                }
                case 7: {
                    if (this.getRandomInt(0, 5) != 4) break;
                    vector2.addElement("Remove all");
                    if (vector.size() == 0) break;
                    for (int i = hsqlArrayList.size() - 1; i >= 0; --i) {
                        hsqlArrayList.remove(i);
                        hsqlLinkedList.remove(i);
                    }
                    vector.removeAllElements();
                    break;
                }
            }
            if (bl || bl2 || bl3) {
                if (!(bl && bl2 && bl3)) {
                    if (!bl || !bl3) {
                        System.out.println("Exception descrepancy with vector and arraylist");
                    } else if (!bl2 || !bl3) {
                        System.out.println("Exception descrepancy with vector and linkedlist");
                    } else {
                        System.out.println("Error in TestDataStructures");
                    }
                    this.printListCommandsCalled(vector2);
                    TestDataStructures.fail((String)"test failed");
                }
                return;
            }
            if (!this.objectEquals(object2, object, var13_11)) {
                System.out.println("Objects returned inconsistent");
                this.printListCommandsCalled(vector2);
                TestDataStructures.fail((String)"test failed");
            }
            this.compareLists(hsqlArrayList, hsqlLinkedList, vector);
        }
    }

    public void compareLists(HsqlArrayList hsqlArrayList, HsqlLinkedList hsqlLinkedList, Vector vector) {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.equalsVector(hsqlArrayList, vector)) {
            System.out.println("Error in array list implementation");
            bl = true;
        }
        if (!this.equalsVector(hsqlLinkedList, vector)) {
            System.out.println("Error in linked list implementation");
            bl2 = true;
        }
        if (bl || bl2) {
            this.printListCommandsCalled(this.listCommandsCalled);
            System.out.flush();
            TestDataStructures.fail((String)"test failed");
            System.exit(0);
        }
    }

    public void printListCommandsCalled(Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            System.out.println((String)vector.elementAt(i));
        }
        System.out.flush();
    }

    private boolean objectEquals(Object object, Object object2, Object object3) {
        if (object == null && object2 == null && object3 == null) {
            return true;
        }
        try {
            if (!object.equals(object3)) {
                System.out.println("LinkList object returned inconsistent");
                return false;
            }
            if (!object2.equals(object3)) {
                System.out.println("ArrayList object returned inconsistent");
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private int getRandomInt(int n, int n2) {
        double d = this.randomGenerator.nextDouble();
        return (int)((double)(n2 - n) * d + 0.5) + n;
    }

    private Integer getRandomInteger() {
        return new Integer(this.getRandomInt(0, 21474836));
    }

    private boolean equalsVector(HsqlList hsqlList, Vector vector) {
        if (hsqlList.size() != vector.size()) {
            return false;
        }
        Iterator iterator = hsqlList.iterator();
        Enumeration enumeration = vector.elements();
        Object object = null;
        Object var6_6 = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object.equals(var6_6 = enumeration.nextElement())) continue;
            return false;
        }
        return true;
    }

    public void testGrowth() {
        int n;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (n = 0; n < 12; ++n) {
            hsqlArrayList.add(new Integer(n));
        }
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            System.out.println(hsqlArrayList.get(n));
        }
        hsqlArrayList = new HsqlArrayList();
        for (n = 0; n < 12; ++n) {
            hsqlArrayList.add(new Integer(n));
        }
        hsqlArrayList.set(11, new Integer(11));
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            System.out.println(hsqlArrayList.get(n));
        }
        Iterator iterator = hsqlArrayList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            System.out.println(n3);
            TestDataStructures.assertEquals((int)n2, (int)n3);
            ++n2;
        }
        TestDataStructures.assertEquals((int)12, (int)hsqlArrayList.size());
    }

    public void testSpeed() {
        int n;
        int n2;
        this.randomGenerator = new Random(System.currentTimeMillis());
        int n3 = 100000;
        int n4 = 1000;
        HsqlArrayList hsqlArrayList = new HsqlArrayList(n3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n3);
        Vector<Integer> vector = new Vector<Integer>(n3);
        Integer n5 = new Integer(this.randomGenerator.nextInt());
        Integer n6 = new Integer(0);
        StopWatch stopWatch = new StopWatch();
        System.out.println(stopWatch.currentElapsedTimeToMessage("time"));
        for (n2 = 0; n2 < n3; ++n2) {
            hsqlArrayList.add(n6);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                hsqlArrayList.set(n2, n6);
            }
        }
        System.out.println(stopWatch.currentElapsedTimeToMessage("time"));
        stopWatch.zero();
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(n6);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                arrayList.set(n2, n6);
            }
        }
        System.out.println(stopWatch.currentElapsedTimeToMessage("time"));
        stopWatch.zero();
        for (n2 = 0; n2 < n3; ++n2) {
            vector.addElement(n6);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                vector.setElementAt(n6, n2);
            }
        }
        System.out.println(stopWatch.currentElapsedTimeToMessage("time"));
    }

    public static void main(String[] stringArray) {
        TestDataStructures testDataStructures = new TestDataStructures("testLists");
        for (int i = 0; i < 100000; ++i) {
            testDataStructures.testLists();
            if (i % 1000 != 0) continue;
            System.out.println("Finished " + i + " tests");
            System.out.flush();
        }
        System.out.println("After 100000 tests of a maximum of 80 list commands each test, the list tests passed");
        testDataStructures.testGrowth();
    }
}

