/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import junit.framework.TestResult;
import org.hsqldb.Collation;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.test.TestBase;

public class TestCollation
extends TestBase {
    Statement statement;
    Connection connection;
    Collation collation;
    Iterator collIterator;
    Iterator localeIterator;

    public TestCollation(String string) {
        super(string);
        this.isNetwork = false;
    }

    protected void setUp() {
        super.setUp();
        try {
            this.connection = super.newConnection();
            this.statement = this.connection.createStatement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.collation = new Collation();
        this.collIterator = this.collation.getCollationsIterator();
        this.localeIterator = this.collation.getLocalesIterator();
    }

    protected void tearDown() {
        try {
            this.statement = this.connection.createStatement();
            this.statement.execute("SHUTDOWN");
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void verifyAvailability() {
        Locale[] localeArray;
        try {
            this.statement.execute(this.getSetCollationStmt("ThisIsDefinatelyNoValidCollationIdentifier"));
            TestCollation.fail((String)"database did not reject invalid collation name");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        int n = 0;
        while (this.collIterator.hasNext()) {
            localeArray = (Locale[])this.collIterator.next();
            try {
                this.statement.execute(this.getSetCollationStmt((String)localeArray));
            }
            catch (SQLException sQLException) {
                TestCollation.fail((String)("could not set collation '" + (String)localeArray + "'\n  exception message: " + sQLException.getMessage()));
            }
            ++n;
        }
        System.out.println("checked " + n + " collations for availability.");
        localeArray = Locale.getAvailableLocales();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < localeArray.length; ++i) {
            String string = localeArray[i].getLanguage();
            if (localeArray[i].getCountry().length() > 0) {
                string = string + "-" + localeArray[i].getCountry();
            }
            hashSet.add(string);
        }
        String string = "";
        int n2 = 0;
        int n3 = 0;
        while (this.localeIterator.hasNext()) {
            String string2 = (String)this.localeIterator.next();
            ++n2;
            if (hashSet.contains(string2)) continue;
            if (string.length() > 0) {
                string = string + "; ";
            }
            string = string + string2;
            ++n3;
        }
        if (string.length() > 0) {
            TestCollation.fail((String)("the following locales are not installed:\n  " + string + "\n  (" + n3 + " out of " + n2 + ")"));
        }
    }

    public void verifyCollation() {
        String string = "";
        String string2 = "";
        while (this.collIterator.hasNext()) {
            String string3 = (String)this.collIterator.next();
            String string4 = this.checkSorting(string3);
            if (string4.length() <= 0) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + string3;
            string2 = string2 + string4;
        }
        if (string.length() > 0) {
            TestCollation.fail((String)("test failed for following collations:\n" + string + "\n" + string2));
        }
    }

    protected final String getSetCollationStmt(String string) {
        return "SET DATABASE COLLATION \"" + string + "\"";
    }

    protected String checkSorting(String string) {
        String string2 = "DROP TABLE WORDLIST IF EXISTS;CREATE TEXT TABLE WORDLIST ( ID INTEGER, WORD VARCHAR );SET TABLE WORDLIST SOURCE \"" + string + ".csv;encoding=UTF-8\"";
        String string3 = "SELECT ID, WORD FROM WORDLIST ORDER BY WORD";
        String string4 = "";
        try {
            this.statement.execute(this.getSetCollationStmt(string));
            this.statement.execute(string2);
            ResultSet resultSet = this.statement.executeQuery(string3);
            while (resultSet.next()) {
                int n;
                int n2 = resultSet.getInt(1);
                if (n2 == (n = resultSet.getRow())) continue;
                String string5 = resultSet.getString(2);
                return "testing collation '" + string + "' failed\n" + "  word              : " + string5 + "\n" + "  expected position : " + n2 + "\n" + "  found position    : " + n + "\n";
            }
        }
        catch (SQLException sQLException) {
            return "testing collation '" + string + "' failed\n  exception message: " + sQLException.getMessage() + "\n";
        }
        return "";
    }

    public static void main(String[] stringArray) {
        TestResult testResult = new TestResult();
        TestCollation testCollation = new TestCollation("verifyAvailability");
        testCollation.run(testResult);
        TestCollation testCollation2 = new TestCollation("verifyCollation");
        testCollation2.run(testResult);
        if (testResult.failureCount() != 0) {
            System.err.println("TestCollation encountered errors:");
            Enumeration enumeration = testResult.failures();
            while (enumeration.hasMoreElements()) {
                System.err.println(enumeration.nextElement().toString());
            }
        } else {
            System.out.println("TestCollation: all fine.");
        }
    }
}

