/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;

public class TestCascade
extends TestCase {
    Connection con;

    public TestCascade(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            TestCascade.createDatabase();
            this.con = DriverManager.getConnection("jdbc:hsqldb:testdb", "sa", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println((Object)((Object)this) + ".setUp() error: " + exception.getMessage());
        }
    }

    protected void tearDown() {
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testDelete() {
        try {
            TestCascade.insertData(this.con);
            Statement statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT COUNT(EIACODXA) FROM CA");
            resultSet.next();
            int n = resultSet.getInt(1);
            resultSet.close();
            TestCascade.deleteXBRecord(this.con);
            resultSet = statement.executeQuery("SELECT COUNT(EIACODXA) FROM CA");
            resultSet.next();
            int n2 = resultSet.getInt(1);
            resultSet.close();
            statement.close();
            TestCascade.assertEquals((int)9, (int)n2);
        }
        catch (SQLException sQLException) {
            TestCascade.assertTrue((String)"SQLException thrown", (boolean)false);
        }
    }

    private static void createDatabase() throws SQLException {
        new File("testdb.backup").delete();
        new File("testdb.data").delete();
        new File("testdb.properties").delete();
        new File("testdb.script").delete();
        Connection connection = DriverManager.getConnection("jdbc:hsqldb:testdb", "sa", "");
        String[] stringArray = new String[]{"CREATE CACHED TABLE XB (EIACODXA VARCHAR(10) NOT NULL, LSACONXB VARCHAR(18) NOT NULL, ALTLCNXB VARCHAR(2) NOT NULL, LCNTYPXB VARCHAR(1) NOT NULL, LCNINDXB VARCHAR(1), LCNAMEXB VARCHAR(19), UPDT_BY VARCHAR(32), LST_UPDT TIMESTAMP, CONSTRAINT XPKXB PRIMARY KEY (EIACODXA, LSACONXB, ALTLCNXB, LCNTYPXB));", "CREATE CACHED TABLE CA ( EIACODXA VARCHAR(10) NOT NULL, LSACONXB VARCHAR(18) NOT NULL, ALTLCNXB VARCHAR(2) NOT NULL, LCNTYPXB VARCHAR(1) NOT NULL, TASKCDCA VARCHAR(7) NOT NULL, TSKFRQCA NUMERIC(7,4), UPDT_BY VARCHAR(32), LST_UPDT TIMESTAMP, CONSTRAINT XPKCA PRIMARY KEY (EIACODXA, LSACONXB, ALTLCNXB, LCNTYPXB, TASKCDCA),        CONSTRAINT R_XB_CA FOREIGN KEY (EIACODXA, LSACONXB, ALTLCNXB, LCNTYPXB) REFERENCES XB ON DELETE CASCADE);"};
        Statement statement = connection.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            statement.executeUpdate(stringArray[i]);
        }
        statement.execute("SHUTDOWN");
        connection.close();
    }

    private static void deleteXBRecord(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("DELETE FROM XB WHERE LSACONXB = 'LEAA' AND EIACODXA = 'T850' AND LCNTYPXB = 'P' AND ALTLCNXB = '00'");
        statement.close();
    }

    private static void insertData(Connection connection) throws SQLException {
        String[] stringArray = new String[]{"INSERT INTO XB VALUES('T850','LEAA','00','P',NULL,'LCN NAME','sa',NOW)", "INSERT INTO XB VALUES('T850','LEAA01','00','P',NULL,'LCN NAME','sa',NOW)", "INSERT INTO XB VALUES('T850','LEAA02','00','P',NULL,'LCN NAME','sa',NOW)", "INSERT INTO XB VALUES('T850','LEAA03','00','P',NULL,'LCN NAME','sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA','00','P','ABCDEFG',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA','00','P','QRSTUJV',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA','00','P','ZZZZZZZ',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA01','00','P','ABCDEFG',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA01','00','P','QRSTUJV',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA01','00','P','ZZZZZZZ',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA02','00','P','ABCDEFG',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA02','00','P','QRSTUJV',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA02','00','P','ZZZZZZZ',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA03','00','P','ABCDEFG',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA03','00','P','QRSTUJV',3.14,'sa',NOW)", "INSERT INTO CA VALUES('T850','LEAA03','00','P','ZZZZZZZ',3.14,'sa',NOW)"};
        Statement statement = connection.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            statement.executeUpdate(stringArray[i]);
        }
    }
}

