/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Random;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.HsqlProperties;

public class TestCacheSize {
    protected boolean filedb = true;
    protected boolean shutdown = true;
    protected String url = "jdbc:hsqldb:";
    protected String filepath = "/hsql/testcache/test";
    boolean reportProgress = false;
    String tableType = "CACHED";
    int cacheScale = 12;
    int cacheSizeScale = 10;
    boolean nioMode = false;
    String logType = "TEXT";
    int writeDelay = 60;
    boolean indexZip = false;
    boolean indexLastName = false;
    boolean addForeignKey = false;
    boolean refIntegrity = true;
    boolean createTempTable = false;
    boolean deleteWhileInsert = false;
    int deleteWhileInsertInterval = 10000;
    int bigrows = 16000;
    int bigops = 16000;
    int smallops = 8000;
    int smallrows = 4095;
    boolean multikeytable = false;
    String user;
    String password;
    Statement sStatement;
    Connection cConnection;
    FileWriter writer;

    private void checkSelects() {
        this.countTestID();
        this.selectID();
        this.selectZipTable();
    }

    private void checkUpdates() {
        this.updateIDLinear();
        this.updateID();
        this.countTestID();
        this.deleteTest();
        this.countTestID();
        this.countZip();
    }

    protected void setUp() {
        try {
            this.writer = new FileWriter("speedtests.html", true);
            this.writer.write("<table>\n");
            this.storeResult(new Date().toString(), 0, 0L, 0L);
            this.storeResult(this.filepath + " " + this.tableType + " " + this.nioMode, this.cacheScale, 0L, 0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.user = "sa";
        this.password = "";
        try {
            this.sStatement = null;
            this.cConnection = null;
            Class.forName("org.hsqldb.jdbcDriver");
            if (this.filedb) {
                TestCacheSize.deleteDatabase(this.filepath);
                this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
                this.sStatement = this.cConnection.createStatement();
                this.sStatement.execute("SET WRITE_DELAY 10");
                this.sStatement.execute("SET CHECKPOINT DEFRAG 10");
                this.sStatement.execute("SET SCRIPTFORMAT " + this.logType);
                this.sStatement.execute("SET LOGSIZE 6");
                this.sStatement.execute("SET PROPERTY \"hsqldb.cache_scale\" " + this.cacheScale);
                this.sStatement.execute("SET PROPERTY \"hsqldb.cache_size_scale\" " + this.cacheSizeScale);
                this.sStatement.execute("SET PROPERTY \"hsqldb.nio_data_file\" " + this.nioMode);
                this.sStatement.execute("SHUTDOWN");
                this.cConnection.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("TestSql.setUp() error: " + exception.getMessage());
        }
    }

    public void testFillUp() {
        StopWatch stopWatch = new StopWatch();
        String string = "DROP TABLE test IF EXISTS";
        String string2 = "DROP TABLE zip IF EXISTS";
        String string3 = "CREATE TABLE zip( zip INT IDENTITY )";
        String string4 = "CREATE " + this.tableType + " TABLE test( id INT IDENTITY," + " firstname VARCHAR(20), " + " lastname VARCHAR(20), " + " zip INTEGER, " + " filler VARCHAR(300))";
        String string5 = "SET TABLE test SOURCE \"test.csv;cache_scale=" + this.cacheScale + "\"";
        String string6 = "CREATE INDEX idx1 ON TEST (lastname)";
        String string7 = "CREATE INDEX idx2 ON TEST (zip)";
        String string8 = "ALTER TABLE test add constraint c1 FOREIGN KEY (zip) REFERENCES zip(zip) ON DELETE CASCADE;";
        String string9 = "CREATE TEMP TABLE temptest( id INT, firstname VARCHAR,  lastname VARCHAR,  zip INTEGER,  filler VARCHAR)";
        String string10 = "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String string11 = "DROP TABLE test2 IF EXISTS";
        String string12 = "CREATE " + this.tableType + " TABLE test2( id1 INT, id2 INT," + " firstname VARCHAR, " + " lastname VARCHAR, " + " zip INTEGER, " + " filler VARCHAR, " + " PRIMARY KEY (id1,id2) )";
        String string13 = "SET TABLE test2 SOURCE \"test2.csv;cache_scale=" + this.cacheScale + "\"";
        try {
            stopWatch.zero();
            this.cConnection = null;
            this.sStatement = null;
            this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
            System.out.println("connection time -- " + stopWatch.elapsedTime());
            stopWatch.zero();
            this.sStatement = this.cConnection.createStatement();
            Random random = new Random();
            this.sStatement.execute(string);
            this.sStatement.execute(string3);
            this.sStatement.execute(string4);
            if (this.tableType.equals("TEXT")) {
                this.sStatement.execute(string5);
            }
            if (this.indexLastName) {
                this.sStatement.execute(string6);
                System.out.println("created index on lastname");
            }
            if (this.indexZip) {
                this.sStatement.execute(string7);
                System.out.println("created index on zip");
            }
            if (this.addForeignKey) {
                this.sStatement.execute(string8);
                System.out.println("added foreign key");
            }
            if (this.createTempTable) {
                this.sStatement.execute(string9);
                System.out.println("created temp table");
            }
            if (this.multikeytable) {
                this.sStatement.execute(string11);
                this.sStatement.execute(string12);
                if (this.tableType.equals("TEXT")) {
                    this.sStatement.execute(string13);
                }
                System.out.println("created multi key table");
            }
            System.out.println("complete setup time -- " + stopWatch.elapsedTime() + " ms");
            this.fillUpBigTable(string10, random);
            if (this.multikeytable) {
                this.fillUpMultiTable(string10, random);
            }
            stopWatch.zero();
            if (this.shutdown) {
                this.sStatement.execute("SHUTDOWN");
                long l = stopWatch.elapsedTime();
                this.storeResult("shutdown", 0, l, 0L);
                System.out.println("shutdown time  -- " + l + " ms");
            }
            this.cConnection.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
    }

    private void fillUpBigTable(String string, Random random) throws SQLException {
        long l;
        int n;
        StopWatch stopWatch = new StopWatch();
        PreparedStatement preparedStatement = this.cConnection.prepareStatement("INSERT INTO zip VALUES(?)");
        for (n = 0; n <= this.smallrows; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        preparedStatement.close();
        this.sStatement.execute("SET REFERENTIAL_INTEGRITY " + this.refIntegrity);
        preparedStatement = this.cConnection.prepareStatement("INSERT INTO test (firstname,lastname,zip,filler) VALUES (?,?,?,?)");
        preparedStatement.setString(1, "Julia");
        preparedStatement.setString(2, "Clancy");
        for (n = 0; n < this.bigrows; ++n) {
            preparedStatement.setInt(3, this.nextIntRandom(random, this.smallrows));
            l = random.nextLong();
            int n2 = (int)l & 0x7F;
            if (n2 > string.length()) {
                n2 = string.length();
            }
            String string2 = string.substring(0, n2);
            preparedStatement.setString(4, l + string2);
            preparedStatement.execute();
            if (this.reportProgress && (n + 1) % 10000 == 0) {
                System.out.println("insert " + (n + 1) + " : " + stopWatch.elapsedTime());
            }
            if (!this.deleteWhileInsert || n == 0 || n % this.deleteWhileInsertInterval != 0) continue;
            this.sStatement.execute("CALL IDENTITY();");
            ResultSet resultSet = this.sStatement.getResultSet();
            resultSet.next();
            int n3 = resultSet.getInt(1);
            this.sStatement.execute("SELECT * INTO TEMP tempt FROM test WHERE id > " + (n3 - 4000));
            this.sStatement.execute("DELETE FROM test WHERE id > " + (n3 - 4000));
            this.sStatement.execute("INSERT INTO test SELECT * FROM tempt");
            this.sStatement.execute("DROP TABLE tempt");
        }
        preparedStatement.close();
        l = stopWatch.elapsedTime();
        long l2 = (long)n * 1000L / (l + 1L);
        this.storeResult("insert", n, l, l2);
        System.out.println("insert time for " + n + " rows -- " + l + " ms -- " + l2 + " tps");
    }

    private void fillUpMultiTable(String string, Random random) throws SQLException {
        int n;
        StopWatch stopWatch = new StopWatch();
        PreparedStatement preparedStatement = this.cConnection.prepareStatement("INSERT INTO test2 (id1, id2, firstname,lastname,zip,filler) VALUES (?,?,?,?,?,?)");
        preparedStatement.setString(3, "Julia");
        preparedStatement.setString(4, "Clancy");
        int n2 = 0;
        for (n = 0; n < this.bigrows; ++n) {
            int n3 = this.nextIntRandom(random, Integer.MAX_VALUE);
            if (n % 1000 == 0) {
                n2 = this.nextIntRandom(random, Integer.MAX_VALUE);
            }
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n3);
            preparedStatement.setInt(5, this.nextIntRandom(random, this.smallrows));
            long l = random.nextLong();
            int n4 = (int)l & 0x7F;
            if (n4 > string.length()) {
                n4 = string.length();
            }
            String string2 = string.substring(0, n4);
            preparedStatement.setString(6, l + string2);
            try {
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            if (!this.reportProgress || (n + 1) % 10000 != 0) continue;
            System.out.println("insert " + (n + 1) + " : " + stopWatch.elapsedTime());
        }
        preparedStatement.close();
        System.out.println("total multi key rows inserted: " + n);
        System.out.println("insert time: " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / (stopWatch.elapsedTime() + 1L));
    }

    protected void tearDown() {
        try {
            this.writer.write("\n</table>\n");
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void checkResults() {
        try {
            StopWatch stopWatch = new StopWatch();
            this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
            long l = stopWatch.elapsedTime();
            this.storeResult("reopen", 0, l, 0L);
            System.out.println("database reopen time -- " + l + " ms");
            stopWatch.zero();
            this.sStatement = this.cConnection.createStatement();
            this.checkSelects();
            this.checkUpdates();
            stopWatch.zero();
            if (this.shutdown) {
                this.sStatement.execute("SHUTDOWN");
                l = stopWatch.elapsedTime();
                this.storeResult("shutdown", 0, l, 0L);
                System.out.println("shutdown time  -- " + l + " ms");
            }
            this.cConnection.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    void selectZip() {
        int n;
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("SELECT TOP 1 firstname,lastname,zip,filler FROM test WHERE zip = ?");
            for (n = 0; n < this.bigops; ++n) {
                preparedStatement.setInt(1, this.nextIntRandom(random, this.smallrows));
                preparedStatement.execute();
                if (n + 1 == 100 && stopWatch.elapsedTime() > 50000L) {
                    bl = true;
                }
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("Select " + (n + 1) + " : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / (stopWatch.elapsedTime() + 1L));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)n * 1000L / (l + 1L);
        this.storeResult("select random zip", n, l, l2);
        System.out.println("select time for random zip " + n + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    void selectID() {
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        int n = 0;
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("SELECT firstname,lastname,zip,filler FROM test WHERE id = ?");
            for (n = 0; n < this.bigops; ++n) {
                preparedStatement.setInt(1, this.nextIntRandom(random, this.bigrows - 1));
                preparedStatement.execute();
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("Select " + (n + 1) + " : " + (stopWatch.elapsedTime() + 1L));
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)n * 1000L / (l + 1L);
        this.storeResult("select random id", n, l, l2);
        System.out.println("select time for random id " + n + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    void selectZipTable() {
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        int n = 0;
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("SELECT zip FROM zip WHERE zip = ?");
            for (n = 0; n < this.bigops; ++n) {
                preparedStatement.setInt(1, this.nextIntRandom(random, this.smallrows - 1));
                preparedStatement.execute();
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("Select " + (n + 1) + " : " + (stopWatch.elapsedTime() + 1L));
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)n * 1000L / (l + 1L);
        this.storeResult("select random zip (zip table)", n, l, l2);
        System.out.println("select time for random zip from zip table " + n + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    private void countTestID() {
        try {
            StopWatch stopWatch = new StopWatch();
            this.sStatement.execute("SELECT count(*) from TEST where id > -1");
            ResultSet resultSet = this.sStatement.getResultSet();
            resultSet.next();
            long l = stopWatch.elapsedTime();
            long l2 = (long)this.bigrows * 1000L / (l + 1L);
            this.storeResult("count (index on id)", resultSet.getInt(1), l, l2);
            System.out.println("count time (index on id) " + resultSet.getInt(1) + " rows  -- " + l + " ms -- " + l2 + " tps");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void countTestZip() {
        try {
            StopWatch stopWatch = new StopWatch();
            this.sStatement.execute("SELECT count(*) from TEST where zip > -1");
            ResultSet resultSet = this.sStatement.getResultSet();
            resultSet.next();
            long l = stopWatch.elapsedTime();
            long l2 = (long)this.bigrows * 1000L / (l + 1L);
            this.storeResult("count (index on zip)", resultSet.getInt(1), l, l2);
            System.out.println("count time (index on zip) " + resultSet.getInt(1) + " rows  -- " + l + " ms -- " + l2 + " tps");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void countZip() {
        try {
            StopWatch stopWatch = new StopWatch();
            this.sStatement.execute("SELECT count(*) from zip where zip > -1");
            ResultSet resultSet = this.sStatement.getResultSet();
            resultSet.next();
            System.out.println("count time (zip table) " + resultSet.getInt(1) + " rows  -- " + stopWatch.elapsedTime() + " ms");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void updateZip() {
        int n;
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("UPDATE test SET filler = filler || zip WHERE zip = ?");
            for (n = 0; n < this.smallrows; ++n) {
                n3 = this.nextIntRandom(random, this.smallrows - 1);
                preparedStatement.setInt(1, n3);
                if (!this.reportProgress || (n2 += preparedStatement.executeUpdate()) % 10000 >= 20) continue;
                System.out.println("Update " + n2 + " : " + (stopWatch.elapsedTime() + 1L));
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("error : " + n3);
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)(n * 1000) / (l + 1L);
        this.storeResult("update with random zip", n, l, l2);
        System.out.println("update time with random zip " + n + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    void updateID() {
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("UPDATE test SET zip = zip + 1 WHERE id = ? and zip <> " + this.smallrows);
            for (n = 0; n < this.bigops; ++n) {
                n2 = this.nextIntRandom(random, this.bigrows - 1);
                preparedStatement.setInt(1, n2);
                preparedStatement.execute();
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("Update " + (n + 1) + " : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / (stopWatch.elapsedTime() + 1L));
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("error : " + n2);
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)(n * 1000) / (l + 1L);
        this.storeResult("update with random id", n, l, l2);
        System.out.println("update time with random id " + n + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    void updateIDLinear() {
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("UPDATE test SET zip = zip + 1 WHERE id = ? and zip <> " + this.smallrows);
            for (n = 0; n < this.bigops; ++n) {
                n2 = n;
                preparedStatement.setInt(1, n2);
                preparedStatement.execute();
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("Update " + (n + 1) + " : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / (stopWatch.elapsedTime() + 1L));
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("error : " + n2);
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)(n * 1000) / (l + 1L);
        this.storeResult("update with sequential id", n, l, l2);
        System.out.println("update time with sequential id " + n + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    void deleteTest() {
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("DELETE FROM test WHERE id = ?");
            n = 0;
            while (n2 < this.smallops) {
                n3 = this.nextIntRandom(random, this.bigrows);
                preparedStatement.setInt(1, n3);
                n2 += preparedStatement.executeUpdate();
                if (this.reportProgress && (n + 1) % 10000 == 0 || bl && (n + 1) % 100 == 0) {
                    System.out.println("delete " + (n + 1) + " : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / (stopWatch.elapsedTime() + 1L));
                }
                ++n;
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("error : " + n3);
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)(n2 * 1000) / (l + 1L);
        this.storeResult("delete with random id", n2, l, l2);
        System.out.println("delete time for random id " + n2 + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    void deleteZipTable() {
        StopWatch stopWatch = new StopWatch();
        Random random = new Random();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        try {
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("DELETE FROM zip WHERE zip = ?");
            for (n = 0; n <= this.smallrows; ++n) {
                n3 = n;
                preparedStatement.setInt(1, n3);
                n2 += preparedStatement.executeUpdate();
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("delete " + (n + 1) + " : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / (stopWatch.elapsedTime() + 1L));
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("error : " + n3);
            sQLException.printStackTrace();
        }
        long l = stopWatch.elapsedTime();
        long l2 = (long)n2 * 1000L / (l + 1L);
        this.storeResult("delete with random zip", n2, l, l2);
        System.out.println("delete time for random zip " + n2 + " rows  -- " + l + " ms -- " + l2 + " tps");
    }

    void storeResult(String string, int n, long l, long l2) {
        try {
            this.writer.write("<tr><td>" + string + "</td><td>" + n + "</td><td>" + l + "</td><td>" + l2 + "</td></tr>\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void deleteDatabase(String string) {
        FileUtil.delete(string + ".backup");
        FileUtil.delete(string + ".properties");
        FileUtil.delete(string + ".script");
        FileUtil.delete(string + ".data");
        FileUtil.delete(string + ".log");
        FileUtil.delete(string + ".lck");
        FileUtil.delete(string + ".csv");
    }

    int nextIntRandom(Random random, int n) {
        int n2 = Math.abs(random.nextInt());
        return n2 % n;
    }

    public static void main(String[] stringArray) {
        TestCacheSize testCacheSize = new TestCacheSize();
        HsqlProperties hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "test");
        testCacheSize.bigrows = testCacheSize.bigops = hsqlProperties.getIntegerProperty("test.bigops", testCacheSize.bigops);
        testCacheSize.smallops = testCacheSize.bigops / 8;
        testCacheSize.cacheScale = hsqlProperties.getIntegerProperty("test.scale", testCacheSize.cacheScale);
        testCacheSize.logType = hsqlProperties.getProperty("test.logtype", testCacheSize.logType);
        testCacheSize.tableType = hsqlProperties.getProperty("test.tabletype", testCacheSize.tableType);
        testCacheSize.nioMode = hsqlProperties.isPropertyTrue("test.nio", testCacheSize.nioMode);
        if (hsqlProperties.getProperty("test.dbtype", "").equals("mem")) {
            testCacheSize.filepath = "mem:test";
            testCacheSize.filedb = false;
            testCacheSize.shutdown = false;
        }
        testCacheSize.setUp();
        StopWatch stopWatch = new StopWatch();
        testCacheSize.testFillUp();
        testCacheSize.checkResults();
        long l = stopWatch.elapsedTime();
        testCacheSize.storeResult("total test time", 0, (int)l, 0L);
        System.out.println("total test time -- " + stopWatch.elapsedTime() + " ms");
        testCacheSize.tearDown();
    }
}

