/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import junit.framework.TestResult;
import org.hsqldb.test.TestBase;

public class TestBug778213
extends TestBase {
    public TestBug778213(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        PreparedStatement preparedStatement;
        Connection connection = this.newConnection();
        try {
            preparedStatement = connection.prepareStatement("drop table test if exists");
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("create table test(id int)");
            int n = preparedStatement.executeUpdate();
            TestBug778213.assertTrue((String)"expected update count of zero", (n == 0 ? 1 : 0) != 0);
            preparedStatement = connection.prepareStatement("drop table test");
            n = preparedStatement.executeUpdate();
            TestBug778213.assertTrue((String)"expected update count of zero", (n == 0 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            TestBug778213.assertTrue((String)"unable to prepare or execute DDL", (boolean)false);
        }
        finally {
            connection.close();
        }
        connection = this.newConnection();
        try {
            preparedStatement = connection.prepareStatement("create table test(id int)");
            TestBug778213.assertTrue((String)"got data expecting update count", (!preparedStatement.execute() ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            TestBug778213.assertTrue((String)"unable to prepare or execute DDL", (boolean)false);
        }
        finally {
            connection.close();
        }
        connection = this.newConnection();
        boolean bl = true;
        try {
            preparedStatement = connection.prepareStatement("drop table test");
            preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        finally {
            connection.close();
        }
        if (bl) {
            TestBug778213.assertTrue((String)"no exception thrown for executeQuery(DDL)", (boolean)false);
        }
        connection = this.newConnection();
        try {
            preparedStatement = connection.prepareStatement("call identity()");
            preparedStatement.execute();
        }
        catch (Exception exception) {
            TestBug778213.assertTrue((String)"unable to prepare or execute call", (boolean)false);
        }
        finally {
            connection.close();
        }
        bl = false;
        connection = this.newConnection();
        try {
            preparedStatement = connection.prepareStatement("create table test(id int)");
            preparedStatement.addBatch();
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        finally {
            connection.close();
        }
        if (bl) {
            TestBug778213.assertTrue((String)"not expected exception batching prepared DDL", (boolean)false);
        }
        connection = this.newConnection();
        try {
            preparedStatement = connection.prepareStatement("create table test(id int)");
            TestBug778213.assertTrue((String)"expected null ResultSetMetadata for prepared DDL", (null == preparedStatement.getMetaData() ? 1 : 0) != 0);
        }
        finally {
            connection.close();
        }
        connection = this.newConnection();
    }

    public static void main(String[] stringArray) throws Exception {
        TestResult testResult = new TestResult();
        TestBug778213 testBug778213 = new TestBug778213("test");
        testBug778213.run(testResult);
        int n = testResult.failureCount();
        System.out.println("TestBug778213 failure count: " + n);
        Enumeration enumeration = testResult.failures();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }
}

