/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.test.TestBase;

public class TestBatchExecution
extends TestBase {
    static final String drop_table_sql = "drop table test if exists";
    static final String create_cached = "create cached ";
    static final String create_memory = "create memory ";
    static final String create_temp = "create temp ";
    static final String table_sql = "table test(id int primary key,fname varchar(20), lname varchar(20), zip int)";
    static final String insert_sql = "insert into test values(?,?,?,?)";
    static final String update_sql = "update test set fname = 'Hans' where id = ?";
    static final String select_sql = "select * from test where id = ?";
    static final String delete_sql = "delete from test where id = ?";
    static final String call_sql = "call   identity()";
    static final String shutdown_sql = "shutdown compact";
    static final String def_db_path = "batchtest";
    static final int def_runs = 5;
    static final int rows = 10000;
    static Connection conn;
    static Statement stmnt;
    static String url;

    public TestBatchExecution(String string) {
        super(string);
    }

    public void test() throws Exception {
        conn = this.newConnection();
        stmnt = conn.createStatement();
        url = ((TestBase)this).url;
        TestBatchExecution.nonPreparedTest();
        TestBatchExecution.preparedTestOne(5);
    }

    static void print(String string) {
        System.out.print(string);
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void printCommandStats(StopWatch stopWatch, String string) {
        long l = stopWatch.elapsedTime();
        TestBatchExecution.print(stopWatch.elapsedTimeToMessage("10000 " + string));
        TestBatchExecution.println(" " + 10000000L / l + " ops/s.");
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 5;
        String string = def_db_path;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = stringArray[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        Driver driver = (Driver)Class.forName("org.hsqldb.jdbcDriver").newInstance();
        DriverManager.registerDriver(driver);
        String string2 = "jdbc:hsqldb:file:" + string;
        conn = DriverManager.getConnection(string2, "SA", "");
        stmnt = conn.createStatement();
        TestBatchExecution.runTests(n);
    }

    static void runTests(int n) throws Exception {
        TestBatchExecution.println("");
        TestBatchExecution.println("***************************************");
        TestBatchExecution.println("featuring cached (persistent) table");
        TestBatchExecution.println("***************************************");
        TestBatchExecution.println(drop_table_sql);
        stmnt.execute(drop_table_sql);
        TestBatchExecution.println("create cached table test(id int primary key,fname varchar(20), lname varchar(20), zip int)");
        stmnt.execute("create cached table test(id int primary key,fname varchar(20), lname varchar(20), zip int)");
        TestBatchExecution.preparedTestOne(n);
        TestBatchExecution.println(drop_table_sql);
        stmnt.execute(drop_table_sql);
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.println("shutting down database");
        stmnt.execute(shutdown_sql);
        TestBatchExecution.println("---------------------------------------");
        conn = DriverManager.getConnection(url, "SA", "");
        stmnt = conn.createStatement();
        TestBatchExecution.println("");
        TestBatchExecution.println("***************************************");
        TestBatchExecution.println("featuring memory (persistent) table");
        TestBatchExecution.println("***************************************");
        TestBatchExecution.println(drop_table_sql);
        stmnt.execute(drop_table_sql);
        TestBatchExecution.println("create memory table test(id int primary key,fname varchar(20), lname varchar(20), zip int)");
        stmnt.execute("create memory table test(id int primary key,fname varchar(20), lname varchar(20), zip int)");
        TestBatchExecution.preparedTestOne(n);
        TestBatchExecution.println(drop_table_sql);
        stmnt.execute(drop_table_sql);
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.println("shutting down database");
        stmnt.execute(shutdown_sql);
        TestBatchExecution.println("---------------------------------------");
        conn = DriverManager.getConnection(url, "SA", "");
        stmnt = conn.createStatement();
        TestBatchExecution.println("");
        TestBatchExecution.println("***************************************");
        TestBatchExecution.println("featuring temp (transient) table");
        TestBatchExecution.println("***************************************");
        TestBatchExecution.println(drop_table_sql);
        stmnt.execute(drop_table_sql);
        TestBatchExecution.println("create temp table test(id int primary key,fname varchar(20), lname varchar(20), zip int)");
        stmnt.execute("create temp table test(id int primary key,fname varchar(20), lname varchar(20), zip int)");
        TestBatchExecution.preparedTestOne(n);
        TestBatchExecution.println(drop_table_sql);
        stmnt.execute(drop_table_sql);
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.println("shutting down database");
        stmnt.execute(shutdown_sql);
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.preparedTestTwo();
    }

    public static void nonPreparedTest() throws Exception {
        stmnt.addBatch(drop_table_sql);
        stmnt.addBatch("create memory table test(id int primary key,fname varchar(20), lname varchar(20), zip int)");
        stmnt.executeBatch();
    }

    public static void preparedTestOne(int n) throws Exception {
        int n2;
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.println("Preparing Statements:");
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.println(insert_sql);
        TestBatchExecution.println(update_sql);
        TestBatchExecution.println(select_sql);
        TestBatchExecution.println(delete_sql);
        TestBatchExecution.println(call_sql);
        StopWatch stopWatch = new StopWatch();
        PreparedStatement preparedStatement = conn.prepareStatement(insert_sql);
        PreparedStatement preparedStatement2 = conn.prepareStatement(update_sql);
        PreparedStatement preparedStatement3 = conn.prepareStatement(select_sql);
        PreparedStatement preparedStatement4 = conn.prepareStatement(delete_sql);
        CallableStatement callableStatement = conn.prepareCall(call_sql);
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.println(stopWatch.elapsedTimeToMessage("statements prepared"));
        TestBatchExecution.println("---------------------------------------");
        stopWatch.zero();
        for (n2 = 0; n2 < 10000; ++n2) {
            preparedStatement.setInt(1, n2);
            preparedStatement.setString(2, "Julia");
            preparedStatement.setString(3, "Peterson-Clancy");
            preparedStatement.setInt(4, n2);
            preparedStatement2.setInt(1, n2);
            preparedStatement3.setInt(1, n2);
            preparedStatement4.setInt(1, n2);
            preparedStatement.addBatch();
            preparedStatement2.addBatch();
            preparedStatement3.addBatch();
            preparedStatement4.addBatch();
            callableStatement.addBatch();
        }
        TestBatchExecution.println("---------------------------------------");
        TestBatchExecution.println(stopWatch.elapsedTimeToMessage("50000 batch entries created"));
        stopWatch.zero();
        for (n2 = 0; n2 < 1; ++n2) {
            TestBatchExecution.println("---------------------------------------");
            stopWatch.zero();
            preparedStatement.executeBatch();
            TestBatchExecution.printCommandStats(stopWatch, "inserts");
            stopWatch.zero();
            preparedStatement2.executeBatch();
            TestBatchExecution.printCommandStats(stopWatch, "updates");
            stopWatch.zero();
            preparedStatement3.executeBatch();
            TestBatchExecution.printCommandStats(stopWatch, "selects");
            stopWatch.zero();
            preparedStatement4.executeBatch();
            TestBatchExecution.printCommandStats(stopWatch, "deletes");
            stopWatch.zero();
            callableStatement.executeBatch();
            TestBatchExecution.printCommandStats(stopWatch, "calls  ");
        }
    }

    public static void preparedTestTwo() {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            Connection connection = DriverManager.getConnection("jdbc:hsqldb:.", "sa", "");
            System.out.println("con=" + connection);
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate("drop table ttt");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("create table ttt (id integer)");
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO ttt (id) VALUES (?)");
            connection.setAutoCommit(false);
            for (int i = 1; i <= 4; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.addBatch();
                System.out.println("executeBatch() for " + i);
                preparedStatement.executeBatch();
                connection.commit();
            }
            preparedStatement.close();
            ResultSet resultSet = statement.executeQuery("select * from ttt");
            while (resultSet.next()) {
                System.out.println("id = " + resultSet.getInt(1));
            }
            System.out.println("bye.");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }
}

