/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class TestBatchBug {
    static final int DATASET_COUNT = 2;
    static final int DECIMAL_FIELDS_PER_DATASET = 2;
    static final String TABLE_ATTR_CACHED = "CACHED";
    static final String IN_PROCESS_FILE_URL = "jdbc:hsqldb:/temp/hsqldb/perftest";
    static final String HSQLDB_LOCALHOST_URL = "jdbc:hsqldb:hsql://localhost/yourtest";
    static final String TEST_TABLE_NAME = "CSBug";
    static String FIELD_LIST_WITHOUT_ID = "Kennung, Last_Update ";
    static String FIELD_LIST_WITH_ID = "ID, ";
    static String SQL_SELECT_ALL_FIELDS = "SELECT ";
    static int ldfNrFuerKennung;

    public static void main(String[] stringArray) {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            String[] stringArray2 = new String[]{IN_PROCESS_FILE_URL, HSQLDB_LOCALHOST_URL};
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = stringArray2[i];
                String[] stringArray3 = new String[]{TABLE_ATTR_CACHED};
                for (int j = 0; j < stringArray3.length; ++j) {
                    TestBatchBug.testURL(string, TABLE_ATTR_CACHED);
                }
            }
            System.out.println("bye");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void testURL(String string, String string2) throws SQLException {
        System.out.println(string);
        Connection connection = DriverManager.getConnection(string, "sa", "");
        TestBatchBug.reCreateTable(connection, TABLE_ATTR_CACHED);
        TestBatchBug.populateTable(connection);
        connection.close();
    }

    static void reCreateTable(Connection connection, String string) throws SQLException {
        String string2 = "CSBug.csv";
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("DROP TABLE CSBug");
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE ");
        stringBuffer.append(string);
        stringBuffer.append(" TABLE ");
        stringBuffer.append(TEST_TABLE_NAME);
        stringBuffer.append(" (");
        stringBuffer.append("Id integer IDENTITY");
        stringBuffer.append(", ");
        stringBuffer.append("Kennung varchar(20) NOT NULL");
        stringBuffer.append(", last_update TIMESTAMP ");
        stringBuffer.append("DEFAULT CURRENT_TIMESTAMP NOT NULL");
        for (int i = 1; i <= 2; ++i) {
            stringBuffer.append(", Field_" + i + " decimal");
        }
        stringBuffer.append(", UNIQUE(Kennung)");
        stringBuffer.append(")");
        System.out.println(stringBuffer.toString());
        statement.executeUpdate(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(TEST_TABLE_NAME);
        System.out.println(stringBuffer.toString());
        statement.executeUpdate(stringBuffer.toString());
        statement.close();
    }

    static void populateTable(Connection connection) throws SQLException {
        int n;
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        connection.setAutoCommit(false);
        String string = TestBatchBug.createInsertSQL(true, false);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.clearParameters();
        preparedStatement.setString(1, "xxx");
        preparedStatement.setTimestamp(2, timestamp);
        for (n = 0; n < 2; ++n) {
            preparedStatement.setDouble(n + 3, 0.123456789);
        }
        preparedStatement.addBatch();
        preparedStatement.setString(1, "yyy");
        preparedStatement.setTimestamp(2, timestamp);
        for (n = 0; n < 2; ++n) {
            preparedStatement.setDouble(n + 3, 0.123456789);
        }
        preparedStatement.addBatch();
        int[] nArray = preparedStatement.executeBatch();
        connection.setAutoCommit(true);
        preparedStatement.close();
    }

    static String createInsertSQL(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(TEST_TABLE_NAME);
        stringBuffer.append(" (");
        stringBuffer.append(FIELD_LIST_WITHOUT_ID);
        stringBuffer.append(") VALUES (");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String string = "?";
        if (bl) {
            stringBuffer.append(string + ", " + string);
        } else {
            long l = System.currentTimeMillis();
            stringBuffer.append("'Ken");
            stringBuffer.append(++ldfNrFuerKennung + "'");
            string = new Double(0.123456789) + "";
            stringBuffer.append(", '" + timestamp.toString() + "'");
        }
        for (int i = 1; i <= 2; ++i) {
            stringBuffer.append(", " + string);
        }
        stringBuffer.append(")");
        String string2 = stringBuffer.toString();
        System.out.println(string2);
        return string2;
    }

    static {
        for (int i = 1; i <= 2; ++i) {
            FIELD_LIST_WITHOUT_ID = FIELD_LIST_WITHOUT_ID + ", Field_" + i;
        }
        FIELD_LIST_WITH_ID = FIELD_LIST_WITH_ID + FIELD_LIST_WITHOUT_ID;
        SQL_SELECT_ALL_FIELDS = SQL_SELECT_ALL_FIELDS + FIELD_LIST_WITH_ID + " FROM " + TEST_TABLE_NAME;
    }
}

