/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.hsqldb.Server;

public abstract class TestBase
extends TestCase {
    String serverProps;
    String url;
    String user = "sa";
    String password = "";
    Server server;
    boolean isNetwork;

    public TestBase(String string) {
        super(string);
        this.isNetwork = true;
    }

    public TestBase(String string, String string2, boolean bl) {
        super(string);
        this.isNetwork = this.isNetwork = true;
        this.url = string2;
    }

    protected void setUp() {
        if (this.isNetwork) {
            if (this.url == null) {
                this.url = "jdbc:hsqldb:hsql://localhost/test";
            }
            this.server = new Server();
            this.server.setDatabaseName(0, "test");
            this.server.setDatabasePath(0, "mem:test;sql.enforce_strict_size=true");
            this.server.setLogWriter(null);
            this.server.setErrWriter(null);
            this.server.start();
        } else if (this.url == null) {
            this.url = "jdbc:hsqldb:file:test;sql.enforce_strict_size=true";
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println((Object)((Object)this) + ".setUp() error: " + exception.getMessage());
        }
    }

    protected void tearDown() {
        if (this.isNetwork) {
            this.server.stop();
            this.server = null;
        }
    }

    Connection newConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.password);
    }
}

