/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.HsqlProperties;

public class TestAllTypes {
    protected String url = "jdbc:hsqldb:";
    protected String filepath = "/hsql/testalltypes/test";
    boolean network = true;
    String user;
    String password;
    Statement sStatement;
    Connection cConnection;
    boolean reportProgress = false;
    boolean cachedTable = true;
    int cacheScale = 12;
    int logType = 3;
    int writeDelay = 60;
    boolean indexZip = true;
    boolean indexLastName = false;
    boolean addForeignKey = false;
    boolean refIntegrity = true;
    boolean createTempTable = false;
    boolean deleteWhileInsert = false;
    int deleteWhileInsertInterval = 10000;
    int bigrows = 1000;

    protected void setUp() {
        this.user = "sa";
        this.password = "";
        try {
            this.sStatement = null;
            this.cConnection = null;
            HsqlProperties hsqlProperties = new HsqlProperties(this.filepath);
            boolean bl = hsqlProperties.checkFileExists();
            Class.forName("org.hsqldb.jdbcDriver");
            if (!this.network && !(!bl)) {
                this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
                this.sStatement = this.cConnection.createStatement();
                this.sStatement.execute("SET SCRIPTFORMAT " + this.logType);
                this.sStatement.execute("SET LOGSIZE 400");
                this.sStatement.execute("SET WRITE_DELAY " + this.writeDelay);
                this.sStatement.execute("SHUTDOWN");
                this.cConnection.close();
                hsqlProperties.load();
                hsqlProperties.setProperty("hsqldb.cache_scale", "" + this.cacheScale);
                hsqlProperties.save();
                this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
                this.sStatement = this.cConnection.createStatement();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("TestSql.setUp() error: " + exception.getMessage());
        }
    }

    public void testFillUp() {
        StopWatch stopWatch = new StopWatch();
        int n = 4095;
        double d = 0.0;
        String string = "DROP TABLE test IF EXISTS;DROP TABLE zip IF EXISTS;";
        String string2 = "CREATE TABLE zip( zip INT IDENTITY );";
        String string3 = "CREATE " + (this.cachedTable ? "CACHED " : "") + "TABLE test( id INT IDENTITY," + " firstname VARCHAR, " + " lastname VARCHAR, " + " zip INTEGER, " + " longfield BIGINT, " + " doublefield DOUBLE, " + " bigdecimalfield DECIMAL, " + " datefield DATE, " + " filler VARCHAR); ";
        String string4 = "CREATE INDEX idx1 ON TEST (lastname);";
        String string5 = "CREATE INDEX idx2 ON TEST (zip);";
        String string6 = "ALTER TABLE test add constraint c1 FOREIGN KEY (zip) REFERENCES zip(zip);";
        String string7 = "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ";
        try {
            int n2;
            System.out.println("Connecting");
            stopWatch.zero();
            this.cConnection = null;
            this.sStatement = null;
            this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
            System.out.println("connected: " + stopWatch.elapsedTime());
            stopWatch.zero();
            this.sStatement = this.cConnection.createStatement();
            Random random = new Random();
            this.sStatement.execute(string);
            this.sStatement.execute(string2);
            this.sStatement.execute(string3);
            System.out.println("test table with no index");
            if (this.indexLastName) {
                this.sStatement.execute(string4);
                System.out.println("create index on lastname");
            }
            if (this.indexZip) {
                this.sStatement.execute(string5);
                System.out.println("create index on zip");
            }
            if (this.addForeignKey) {
                this.sStatement.execute(string6);
                System.out.println("add foreign key");
            }
            for (n2 = 0; n2 <= n; ++n2) {
                this.sStatement.execute("INSERT INTO zip VALUES(null);");
            }
            PreparedStatement preparedStatement = this.cConnection.prepareStatement("INSERT INTO test (firstname,lastname,zip,longfield,doublefield,bigdecimalfield,datefield,filler) VALUES (?,?,?,?,?,?,?,?)");
            preparedStatement.setString(1, "Julia");
            preparedStatement.setString(2, "Clancy");
            for (n2 = 0; n2 < this.bigrows; ++n2) {
                preparedStatement.setInt(3, this.nextIntRandom(random, n));
                int n3 = this.nextIntRandom(random, string7.length());
                int n4 = this.nextIntRandom(random, string7.length());
                preparedStatement.setLong(4, random.nextLong());
                preparedStatement.setDouble(5, random.nextDouble());
                preparedStatement.setBigDecimal(6, null);
                preparedStatement.setDate(7, new Date(this.nextIntRandom(random, 1000) * 24 * 3600 * 1000));
                String string8 = string7.substring(0, n4);
                preparedStatement.setString(8, n3 + string8);
                preparedStatement.execute();
                if (this.reportProgress && (n2 + 1) % 10000 == 0) {
                    System.out.println("Insert " + (n2 + 1) + " : " + stopWatch.elapsedTime());
                }
                if (!this.deleteWhileInsert || n2 == 0 || n2 % this.deleteWhileInsertInterval != 0) continue;
                this.sStatement.execute("CALL IDENTITY();");
                ResultSet resultSet = this.sStatement.getResultSet();
                resultSet.next();
                int n5 = resultSet.getInt(1);
                this.sStatement.execute("SELECT * INTO TEMP tempt FROM test WHERE id > " + (n5 - 4000) + " ;");
                this.sStatement.execute("DELETE FROM test WHERE id > " + (n5 - 4000) + " ;");
                this.sStatement.execute("INSERT INTO test SELECT * FROM tempt;");
                this.sStatement.execute("DROP TABLE tempt;");
            }
            System.out.println("Total insert: " + n2);
            System.out.println("Insert time: " + stopWatch.elapsedTime() + " rps: " + (long)(n2 * 1000) / stopWatch.elapsedTime());
            stopWatch.zero();
            if (!this.network) {
                this.sStatement.execute("SHUTDOWN");
            }
            this.cConnection.close();
            System.out.println("Shutdown Time: " + stopWatch.elapsedTime());
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
    }

    protected void tearDown() {
    }

    protected void checkResults() {
        try {
            StopWatch stopWatch = new StopWatch();
            this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
            System.out.println("Reopened database: " + stopWatch.elapsedTime());
            stopWatch.zero();
            this.sStatement = this.cConnection.createStatement();
            this.sStatement.execute("SET WRITE_DELAY " + this.writeDelay);
            this.sStatement.execute("SELECT count(*) from TEST");
            ResultSet resultSet = this.sStatement.getResultSet();
            resultSet.next();
            System.out.println("Row Count: " + resultSet.getInt(1));
            System.out.println("Time to count: " + stopWatch.elapsedTime());
            stopWatch.zero();
            this.sStatement.execute("SELECT count(*) from TEST where zip > -1");
            resultSet = this.sStatement.getResultSet();
            resultSet.next();
            System.out.println("Row Count: " + resultSet.getInt(1));
            System.out.println("Time to count: " + stopWatch.elapsedTime());
            this.checkSelects();
            this.checkUpdates();
            stopWatch.zero();
            this.cConnection.close();
            System.out.println("Closed connection: " + stopWatch.elapsedTime());
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
    }

    private void checkSelects() {
        PreparedStatement preparedStatement;
        int n;
        StopWatch stopWatch = new StopWatch();
        int n2 = 4095;
        Random random = new Random();
        boolean bl = false;
        try {
            for (n = 0; n < this.bigrows; ++n) {
                preparedStatement = this.cConnection.prepareStatement("SELECT TOP 1 firstname,lastname,zip,filler FROM test WHERE zip = ?");
                preparedStatement.setInt(1, this.nextIntRandom(random, n2));
                preparedStatement.execute();
                if (n + 1 == 100 && stopWatch.elapsedTime() > 5000L) {
                    bl = true;
                }
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("Select " + (n + 1) + " : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / stopWatch.elapsedTime());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.out.println("Select random zip " + n + " rows : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / stopWatch.elapsedTime());
        stopWatch.zero();
        try {
            for (n = 0; n < this.bigrows; ++n) {
                preparedStatement = this.cConnection.prepareStatement("SELECT firstname,lastname,zip,filler FROM test WHERE id = ?");
                preparedStatement.setInt(1, this.nextIntRandom(random, this.bigrows - 1));
                preparedStatement.execute();
                if ((!this.reportProgress || (n + 1) % 10000 != 0) && (!bl || (n + 1) % 100 != 0)) continue;
                System.out.println("Select " + (n + 1) + " : " + stopWatch.elapsedTime());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.out.println("Select random id " + n + " rows : " + stopWatch.elapsedTime() + " rps: " + (long)(n * 1000) / stopWatch.elapsedTime());
    }

    private void checkUpdates() {
        int n;
        PreparedStatement preparedStatement;
        int n2;
        StopWatch stopWatch = new StopWatch();
        int n3 = 4095;
        Random random = new Random();
        boolean bl = false;
        int n4 = 0;
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                preparedStatement = this.cConnection.prepareStatement("UPDATE test SET filler = filler || zip WHERE zip = ?");
                n = this.nextIntRandom(random, n3 - 1);
                preparedStatement.setInt(1, n);
                if (!this.reportProgress || (n4 += preparedStatement.executeUpdate()) % 10000 >= 20) continue;
                System.out.println("Update " + n4 + " : " + stopWatch.elapsedTime());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.out.println("Update with random zip " + n2 + " UPDATE commands, " + n4 + " rows : " + stopWatch.elapsedTime() + " rps: " + (long)(n4 * 1000) / stopWatch.elapsedTime());
        stopWatch.zero();
        try {
            for (n2 = 0; n2 < this.bigrows; ++n2) {
                preparedStatement = this.cConnection.prepareStatement("UPDATE test SET zip = zip + 1 WHERE id = ?");
                n = this.nextIntRandom(random, this.bigrows - 1);
                preparedStatement.setInt(1, n);
                preparedStatement.execute();
                if ((!this.reportProgress || (n2 + 1) % 10000 != 0) && (!bl || (n2 + 1) % 100 != 0)) continue;
                System.out.println("Update " + (n2 + 1) + " : " + stopWatch.elapsedTime() + " rps: " + (long)(n2 * 1000) / stopWatch.elapsedTime());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.out.println("Update with random id " + n2 + " rows : " + stopWatch.elapsedTime() + " rps: " + (long)(n2 * 1000) / stopWatch.elapsedTime());
    }

    int nextIntRandom(Random random, int n) {
        int n2 = Math.abs(random.nextInt());
        return n2 % n;
    }

    public static void main(String[] stringArray) {
        StopWatch stopWatch = new StopWatch();
        TestAllTypes testAllTypes = new TestAllTypes();
        testAllTypes.setUp();
        testAllTypes.testFillUp();
        testAllTypes.tearDown();
        testAllTypes.checkResults();
        System.out.println("Total Test Time: " + stopWatch.elapsedTime());
    }
}

