/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.test.ExecHarness;

public class SqlToolHarness {
    private static final int MAX_SQLFILE_LEN = 10240;
    private static final String SYNTAX_MSG = "SYNTAX:  java org.hsqldb.test.SqlToolHarness file1.sql [file2.sq...]";
    ExecHarness execHarness = new ExecHarness("java");
    private boolean Verbose = false;
    private static String[] mtString = new String[0];
    private static Pattern[] mtPattern = new Pattern[0];
    static /* synthetic */ Class class$org$hsqldb$util$SqlTool;

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        if (stringArray.length > 0 && stringArray[0].equals("-v")) {
            stringArray = ExecHarness.shift(stringArray);
            System.setProperty("VERBOSE", "true");
        }
        if (stringArray.length < 1) {
            System.err.println(SYNTAX_MSG);
            System.exit(1);
        }
        SqlToolHarness sqlToolHarness = new SqlToolHarness();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            bl = sqlToolHarness.execute(new File(stringArray[i]));
            System.err.println(stringArray[i] + " ==> " + bl);
        }
        System.exit(bl ? 0 : 1);
    }

    public SqlToolHarness() {
        String string = System.getProperty("VERBOSE");
        this.Verbose = string != null && string.trim().length() > 0;
    }

    public boolean execute(File file) throws IOException, InterruptedException {
        int n;
        int n2;
        Metadata metadata = new Metadata(file);
        if (this.Verbose) {
            System.err.println("HARNESS METADATA:\n" + metadata);
        }
        this.execHarness.clear();
        String[] stringArray = new String[metadata.jvmargs.length + 1 + metadata.toolargs.length + (metadata.inputAsFile ? 1 : 0)];
        int n3 = 0;
        for (n2 = 0; n2 < metadata.jvmargs.length; ++n2) {
            stringArray[n3++] = metadata.jvmargs[n2];
        }
        stringArray[n3++] = (class$org$hsqldb$util$SqlTool == null ? (class$org$hsqldb$util$SqlTool = SqlToolHarness.class$("org.hsqldb.util.SqlTool")) : class$org$hsqldb$util$SqlTool).getName();
        for (n2 = 0; n2 < metadata.toolargs.length; ++n2) {
            stringArray[n3++] = metadata.toolargs[n2];
        }
        if (metadata.inputAsFile) {
            stringArray[n3++] = file.toString();
        } else {
            this.execHarness.setInput(file);
        }
        if (this.Verbose) {
            System.err.println("ALL ARGS: " + ExecHarness.stringArrayToString(stringArray));
        }
        this.execHarness.setArgs(stringArray);
        this.execHarness.exec();
        if (this.Verbose) {
            System.err.println("STDOUT ******************************************");
            System.out.print(this.execHarness.getStdout());
            System.err.println("ERROUT ******************************************");
            System.err.print(this.execHarness.getErrout());
            System.err.println("*************************************************");
        }
        if (metadata.exitValue != null && metadata.exitValue.intValue() != this.execHarness.getExitValue()) {
            if (this.Verbose) {
                System.err.println("Failed exit value test");
            }
            return false;
        }
        String string = this.execHarness.getStdout();
        String string2 = this.execHarness.getErrout();
        for (n = 0; n < metadata.rejectErroutPatterns.length; ++n) {
            if (!metadata.rejectErroutPatterns[n].matcher(string2).find()) continue;
            if (this.Verbose) {
                System.err.println("Failed rejectErrOut regex '" + metadata.rejectErroutPatterns[n].pattern() + "'");
            }
            return false;
        }
        for (n = 0; n < metadata.rejectStdoutPatterns.length; ++n) {
            if (!metadata.rejectStdoutPatterns[n].matcher(string).find()) continue;
            if (this.Verbose) {
                System.err.println("Failed rejectStdout regex '" + metadata.rejectStdoutPatterns[n].pattern() + "'");
            }
            return false;
        }
        for (n = 0; n < metadata.requireErroutPatterns.length; ++n) {
            if (metadata.requireErroutPatterns[n].matcher(string2).find()) continue;
            if (this.Verbose) {
                System.err.println("Failed requireErrorOut regex '" + metadata.requireErroutPatterns[n].pattern() + "'");
            }
            return false;
        }
        for (n = 0; n < metadata.requireStdoutPatterns.length; ++n) {
            if (metadata.requireStdoutPatterns[n].matcher(string).find()) continue;
            if (this.Verbose) {
                System.err.println("Failed requireStdOut regex '" + metadata.requireStdoutPatterns[n].pattern() + "'");
            }
            return false;
        }
        return true;
    }

    public static Pattern[] push(Pattern pattern, Pattern[] patternArray) {
        Pattern[] patternArray2 = new Pattern[patternArray.length + 1];
        for (int i = 0; i < patternArray.length; ++i) {
            patternArray2[i] = patternArray[i];
        }
        patternArray2[patternArray2.length - 1] = pattern;
        return patternArray2;
    }

    public static String patternArrayToString(Pattern[] patternArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < patternArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(patternArray[i].pattern());
        }
        return stringBuffer.toString() + '}';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String[] access$800() {
        return mtString;
    }

    static /* synthetic */ Pattern[] access$900() {
        return mtPattern;
    }

    private class Metadata {
        private byte[] ba = new byte[10241];
        private String[] toolargs = SqlToolHarness.access$800();
        private String[] jvmargs = SqlToolHarness.access$800();
        private Pattern[] requireStdoutPatterns = SqlToolHarness.access$900();
        private Pattern[] rejectStdoutPatterns = SqlToolHarness.access$900();
        private Pattern[] requireErroutPatterns = SqlToolHarness.access$900();
        private Pattern[] rejectErroutPatterns = SqlToolHarness.access$900();
        private boolean inputAsFile = false;
        private Integer exitValue = new Integer(0);

        public Metadata(File file) throws FileNotFoundException, IOException {
            String string = this.getHarnessMetaBlock(file);
            Pattern pattern = Pattern.compile("(?m)^\\s*(\\w+)\\s+(.*\\S+)?");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string2;
                if (matcher.groupCount() != 2) {
                    throw new RuntimeException("Pattern '" + pattern + " matched " + matcher.groupCount() + " groups.");
                }
                String string3 = matcher.group(1);
                String string4 = string2 = matcher.groupCount() == 2 ? matcher.group(2) : null;
                if (string3.equals("arg")) {
                    this.toolargs = ExecHarness.push(string2, this.toolargs);
                    continue;
                }
                if (string3.equals("jvmarg")) {
                    this.jvmargs = ExecHarness.push(string2, this.jvmargs);
                    continue;
                }
                if (string3.equals("requireStdoutRegex")) {
                    this.requireStdoutPatterns = SqlToolHarness.push(Pattern.compile(string2), this.requireStdoutPatterns);
                    continue;
                }
                if (string3.equals("rejectStdoutRegex")) {
                    this.rejectStdoutPatterns = SqlToolHarness.push(Pattern.compile(string2), this.rejectStdoutPatterns);
                    continue;
                }
                if (string3.equals("requireErroutRegex")) {
                    this.requireErroutPatterns = SqlToolHarness.push(Pattern.compile(string2), this.requireErroutPatterns);
                    continue;
                }
                if (string3.equals("rejectErroutRegex")) {
                    this.rejectErroutPatterns = SqlToolHarness.push(Pattern.compile(string2), this.rejectErroutPatterns);
                    continue;
                }
                if (string3.equals("inputAsFile")) {
                    this.inputAsFile = Boolean.valueOf(string2);
                    continue;
                }
                if (string3.equals("exitValue")) {
                    this.exitValue = string2 == null ? null : Integer.valueOf(string2);
                    continue;
                }
                throw new IOException("Unknown Metadata directive: " + string3);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("    TOOLARGS: " + ExecHarness.stringArrayToString(this.toolargs) + '\n');
            stringBuffer.append("    JVMARGS: " + ExecHarness.stringArrayToString(this.jvmargs) + '\n');
            stringBuffer.append("    REQUIRE_STDOUT_PATTERNS: " + SqlToolHarness.patternArrayToString(this.requireStdoutPatterns) + '\n');
            stringBuffer.append("    REJECT_STDOUT_PATTERNS: " + SqlToolHarness.patternArrayToString(this.rejectStdoutPatterns) + '\n');
            stringBuffer.append("    REQUIRE_ERROUT_PATTERNS: " + SqlToolHarness.patternArrayToString(this.requireErroutPatterns) + '\n');
            stringBuffer.append("    REJECT_ERROUT_PATTERNS: " + SqlToolHarness.patternArrayToString(this.rejectErroutPatterns) + '\n');
            stringBuffer.append("    INPUTASFILE: " + this.inputAsFile + '\n');
            stringBuffer.append("    EXITVALUE: " + this.exitValue + '\n');
            return stringBuffer.toString();
        }

        private String getHarnessMetaBlock(File file) throws FileNotFoundException, IOException {
            int n;
            int n2 = 0;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            while ((n = bufferedInputStream.read(this.ba, n2, this.ba.length - n2)) > 0) {
                n2 += n;
            }
            if (n > -1) {
                throw new IOException(file.toString() + " is larger than " + (this.ba.length - 1) + " bytes.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            Pattern pattern = Pattern.compile("(?s)(?<=/\\*).*?(?=\\*/)");
            Pattern pattern2 = Pattern.compile("(?m)(^\\s*HARNESS_METADATA\\s+BEGIN\\s*^)(?s)(.*?$)(?-s)(\\s*HARNESS_METADATA\\s+END\\s*$)");
            Matcher matcher = pattern.matcher(new String(this.ba, 0, n2));
            while (matcher.find()) {
                stringBuffer.append(matcher.group() + '\n');
            }
            Matcher matcher2 = pattern2.matcher(stringBuffer);
            while (matcher2.find()) {
                if (matcher2.groupCount() != 3) continue;
                stringBuffer2.append(matcher2.group(2) + '\n');
            }
            return stringBuffer2.toString();
        }
    }
}

