/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.test.ParsedSection;

class ResultSetParsedSection
extends ParsedSection {
    private String delim = System.getProperty("TestUtilFieldDelimiter", ",");
    private String[] expectedRows = null;

    protected ResultSetParsedSection(String[] stringArray) {
        super(stringArray);
        this.type = (char)114;
        this.expectedRows = new String[this.resEndRow + 1];
        for (int i = 0; i <= this.resEndRow; ++i) {
            int n = StringUtil.skipSpaces(stringArray[i], 0);
            this.expectedRows[i] = stringArray[i].substring(n);
        }
    }

    protected String getResultString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getExpectedRows().length; ++i) {
            stringBuffer.append(this.getExpectedRows()[i]).append("\n");
        }
        return stringBuffer.toString();
    }

    protected boolean test(Statement statement) {
        try {
            try {
                statement.execute(this.getSql());
            }
            catch (SQLException sQLException) {
                throw new Exception("Expected a ResultSet, but got the error: " + sQLException.getMessage());
            }
            if (statement.getUpdateCount() != -1) {
                throw new Exception("Expected a ResultSet, but got an update count of " + statement.getUpdateCount());
            }
            ResultSet resultSet = statement.getResultSet();
            int n = 0;
            while (resultSet.next()) {
                if (n < this.getExpectedRows().length) {
                    String[] stringArray = StringUtil.split(this.getExpectedRows()[n], this.delim);
                    if (resultSet.getMetaData().getColumnCount() == stringArray.length) {
                        int n2 = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            n2 = i + 1;
                            String string = resultSet.getString(n2);
                            if (string == null) {
                                if (stringArray[i].equalsIgnoreCase("NULL")) continue;
                                throw new Exception("Expected row " + n + " of the ResultSet to contain:\n" + this.getExpectedRows()[n] + "\nbut field " + n2 + " contained NULL");
                            }
                            if (string.equals(stringArray[i])) continue;
                            throw new Exception("Expected row " + (n + 1) + " of the ResultSet to contain:\n" + this.getExpectedRows()[n] + "\nbut field " + n2 + " contained " + resultSet.getString(n2));
                        }
                    } else {
                        throw new Exception("Expected the ResultSet to contain " + stringArray.length + " fields, but it contained " + resultSet.getMetaData().getColumnCount() + " fields.");
                    }
                }
                ++n;
            }
            if (n != this.getExpectedRows().length) {
                throw new Exception("Expected the ResultSet to contain " + this.getExpectedRows().length + " rows, but it contained " + n + " rows.");
            }
        }
        catch (Exception exception) {
            this.message = exception.getMessage();
            return false;
        }
        return true;
    }

    private String[] getExpectedRows() {
        return this.expectedRows;
    }
}

