/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class JDBCBench {
    public static int tps = 1;
    public static int nbranches = 1;
    public static int ntellers = 10;
    public static int naccounts = 100000;
    public static int nhistory = 864000;
    public static final int TELLER = 0;
    public static final int BRANCH = 1;
    public static final int ACCOUNT = 2;
    int failed_transactions;
    int transaction_count;
    static int n_clients = 10;
    static int n_txn_per_client = 10;
    long start_time;
    static boolean transactions = true;
    static boolean prepared_stmt = false;
    static String tableExtension = "";
    static String createExtension = "";
    static String ShutdownCommand = "";
    static String startupCommand = "";
    static PrintStream TabFile = null;
    static boolean verbose = false;
    MemoryWatcherThread MemoryWatcher;

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-clients")) {
                if (i + 1 >= stringArray.length) continue;
                n_clients = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-driver")) {
                if (i + 1 >= stringArray.length) continue;
                if ((string = stringArray[++i]).equals("org.enhydra.instantdb.jdbc.idbDriver")) {
                    ShutdownCommand = "SHUTDOWN";
                }
                if (string.equals("com.borland.datastore.jdbc.DataStoreDriver")) {
                    // empty if block
                }
                if (string.equals("com.mckoi.JDBCDriver")) {
                    ShutdownCommand = "SHUTDOWN";
                }
                if (!string.equals("org.hsqldb.jdbcDriver")) continue;
                tableExtension = "CREATE CACHED TABLE ";
                ShutdownCommand = "SHUTDOWN";
                startupCommand = "";
                continue;
            }
            if (stringArray[i].equals("-url")) {
                if (i + 1 >= stringArray.length) continue;
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-user")) {
                if (i + 1 >= stringArray.length) continue;
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-tabfile")) {
                if (i + 1 >= stringArray.length) continue;
                ++i;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(stringArray[i]);
                    TabFile = new PrintStream(fileOutputStream);
                }
                catch (Exception exception) {
                    TabFile = null;
                }
                continue;
            }
            if (stringArray[i].equals("-password")) {
                if (i + 1 >= stringArray.length) continue;
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-tpc")) {
                if (i + 1 >= stringArray.length) continue;
                n_txn_per_client = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-init")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-tps")) {
                if (i + 1 >= stringArray.length) continue;
                tps = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-v")) continue;
            verbose = true;
        }
        if (string.length() == 0 || string2.length() == 0) {
            System.out.println("usage: java JDBCBench -driver [driver_class_name] -url [url_to_db] -user [username] -password [password] [-v] [-init] [-tpc n] [-clients n]");
            System.out.println();
            System.out.println("-v          verbose error messages");
            System.out.println("-init       initialize the tables");
            System.out.println("-tpc        transactions per client");
            System.out.println("-clients    number of simultaneous clients");
            System.exit(-1);
        }
        System.out.println("*********************************************************");
        System.out.println("* JDBCBench v1.1                                        *");
        System.out.println("*********************************************************");
        System.out.println();
        System.out.println("Driver: " + string);
        System.out.println("URL:" + string2);
        System.out.println();
        System.out.println("Scale factor value: " + tps);
        System.out.println("Number of clients: " + n_clients);
        System.out.println("Number of transactions per client: " + n_txn_per_client);
        System.out.println();
        try {
            Class.forName(string);
            JDBCBench jDBCBench = new JDBCBench(string2, string3, string4, bl);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public JDBCBench(String string, String string2, String string3, boolean bl) {
        block24: {
            int n;
            this.failed_transactions = 0;
            this.transaction_count = 0;
            this.start_time = 0L;
            Vector<Thread> vector = new Vector<Thread>();
            Thread thread = null;
            Enumeration enumeration = null;
            Connection connection = null;
            connection = JDBCBench.connect(string, string2, string3);
            if (bl) {
                System.out.println("Start: " + new Date().toString());
                System.out.print("Initializing dataset...");
                this.createDatabase(string, string2, string3);
                System.out.println("done.\n");
                System.out.println("Complete: " + new Date().toString());
            }
            if (startupCommand.length() != 0) {
                Statement statement = connection.createStatement();
                statement.execute(startupCommand);
                statement.close();
            }
            System.out.println("* Starting Benchmark Run *");
            this.MemoryWatcher = new MemoryWatcherThread();
            this.MemoryWatcher.start();
            transactions = false;
            prepared_stmt = false;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new ClientThread(n_txn_per_client, string, string2, string3);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
            transactions = true;
            prepared_stmt = false;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new ClientThread(n_txn_per_client, string, string2, string3);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
            transactions = false;
            prepared_stmt = true;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new ClientThread(n_txn_per_client, string, string2, string3);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
            transactions = true;
            prepared_stmt = true;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new ClientThread(n_txn_per_client, string, string2, string3);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
            Object var11_12 = null;
            this.MemoryWatcher.end();
            try {
                this.MemoryWatcher.join();
                if (ShutdownCommand.length() > 0) {
                    Statement statement = connection.createStatement();
                    statement.execute(ShutdownCommand);
                    statement.close();
                    JDBCBench.connectClose(connection);
                }
                if (TabFile != null) {
                    TabFile.close();
                }
                break block24;
            }
            catch (Exception exception) {}
            break block24;
            {
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    Object var11_13 = null;
                    this.MemoryWatcher.end();
                    try {
                        this.MemoryWatcher.join();
                        if (ShutdownCommand.length() > 0) {
                            Statement statement = connection.createStatement();
                            statement.execute(ShutdownCommand);
                            statement.close();
                            JDBCBench.connectClose(connection);
                        }
                        if (TabFile != null) {
                            TabFile.close();
                        }
                        break block24;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.MemoryWatcher.end();
                try {
                    this.MemoryWatcher.join();
                    if (ShutdownCommand.length() > 0) {
                        Statement statement = connection.createStatement();
                        statement.execute(ShutdownCommand);
                        statement.close();
                        JDBCBench.connectClose(connection);
                    }
                    if (TabFile != null) {
                        TabFile.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void reportDone() {
        long l = System.currentTimeMillis();
        double d = ((double)l - (double)this.start_time) / 1000.0;
        if (TabFile != null) {
            TabFile.print(tps + ";" + n_clients + ";" + n_txn_per_client + ";");
        }
        System.out.println("\n* Benchmark Report *");
        System.out.print("* Featuring ");
        if (prepared_stmt) {
            System.out.print("<prepared statements> ");
            if (TabFile != null) {
                TabFile.print("<prepared statements>;");
            }
        } else {
            System.out.print("<direct queries> ");
            if (TabFile != null) {
                TabFile.print("<direct queries>;");
            }
        }
        if (transactions) {
            System.out.print("<transactions> ");
            if (TabFile != null) {
                TabFile.print("<transactions>;");
            }
        } else {
            System.out.print("<auto-commit> ");
            if (TabFile != null) {
                TabFile.print("<auto-commit>;");
            }
        }
        System.out.println("\n--------------------");
        System.out.println("Time to execute " + this.transaction_count + " transactions: " + d + " seconds.");
        System.out.println("Max/Min memory usage: " + this.MemoryWatcher.max + " / " + this.MemoryWatcher.min + " kb");
        System.out.println(this.failed_transactions + " / " + this.transaction_count + " failed to complete.");
        double d2 = (double)(this.transaction_count - this.failed_transactions) / d;
        System.out.println("Transaction rate: " + d2 + " txn/sec.");
        if (TabFile != null) {
            TabFile.print(this.MemoryWatcher.max + ";" + this.MemoryWatcher.min + ";" + this.failed_transactions + ";" + d2 + "\n");
        }
        this.transaction_count = 0;
        this.failed_transactions = 0;
        this.MemoryWatcher.reset();
    }

    public synchronized void incrementTransactionCount() {
        ++this.transaction_count;
    }

    public synchronized void incrementFailedTransactionCount() {
        ++this.failed_transactions;
    }

    void createDatabase(String string, String string2, String string3) throws Exception {
        Statement statement;
        Object object;
        Object object2;
        Connection connection = JDBCBench.connect(string, string2, string3);
        String string4 = connection.getMetaData().getDatabaseProductName();
        System.out.println("DBMS: " + string4);
        transactions = true;
        if (transactions) {
            try {
                connection.setAutoCommit(false);
                System.out.println("In transaction mode");
            }
            catch (SQLException sQLException) {
                transactions = false;
            }
        }
        try {
            int n = 0;
            object2 = connection.createStatement();
            object = "SELECT count(*) ";
            object = (String)object + "FROM   accounts";
            ResultSet resultSet = object2.executeQuery((String)object);
            object2.clearWarnings();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            if (transactions) {
                connection.commit();
            }
            object2.close();
            if (n == naccounts * tps) {
                System.out.println("Already initialized");
                JDBCBench.connectClose(connection);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Drop old tables if they exist");
        try {
            statement = connection.createStatement();
            object2 = "DROP TABLE history";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DROP TABLE accounts";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DROP TABLE tellers";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DROP TABLE branches";
            statement.execute((String)object2);
            statement.clearWarnings();
            if (transactions) {
                connection.commit();
            }
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Creates tables");
        try {
            statement = connection.createStatement();
            object2 = tableExtension.length() > 0 ? tableExtension + " branches (" : "CREATE TABLE branches (";
            object2 = (String)object2 + "Bid         INTEGER NOT NULL PRIMARY KEY, ";
            object2 = (String)object2 + "Bbalance    INTEGER,";
            object2 = (String)object2 + "filler      CHAR(88))";
            if (createExtension.length() > 0) {
                object2 = (String)object2 + createExtension;
            }
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = tableExtension.length() > 0 ? tableExtension + " tellers (" : "CREATE TABLE tellers (";
            object2 = (String)object2 + "Tid         INTEGER NOT NULL PRIMARY KEY,";
            object2 = (String)object2 + "Bid         INTEGER,";
            object2 = (String)object2 + "Tbalance    INTEGER,";
            object2 = (String)object2 + "filler      CHAR(84))";
            if (createExtension.length() > 0) {
                object2 = (String)object2 + createExtension;
            }
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = tableExtension.length() > 0 ? tableExtension + " accounts (" : "CREATE TABLE accounts (";
            object2 = (String)object2 + "Aid         INTEGER NOT NULL PRIMARY KEY, ";
            object2 = (String)object2 + "Bid         INTEGER, ";
            object2 = (String)object2 + "Abalance    INTEGER, ";
            object2 = (String)object2 + "filler      CHAR(84))";
            if (createExtension.length() > 0) {
                object2 = (String)object2 + createExtension;
            }
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = tableExtension.length() > 0 ? tableExtension + " history (" : "CREATE TABLE history (";
            object2 = (String)object2 + "Tid         INTEGER, ";
            object2 = (String)object2 + "Bid         INTEGER, ";
            object2 = (String)object2 + "Aid         INTEGER, ";
            object2 = (String)object2 + "delta       INTEGER, ";
            object2 = (String)object2 + "tstime        TIMESTAMP, ";
            object2 = (String)object2 + "filler      CHAR(22))";
            if (createExtension.length() > 0) {
                object2 = (String)object2 + createExtension;
            }
            statement.execute((String)object2);
            statement.clearWarnings();
            if (transactions) {
                connection.commit();
            }
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Delete elements in table in case Drop didn't work");
        try {
            int n;
            statement = connection.createStatement();
            object2 = "DELETE FROM history";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DELETE FROM accounts";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DELETE FROM tellers";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DELETE FROM branches";
            statement.execute((String)object2);
            statement.clearWarnings();
            if (transactions) {
                connection.commit();
            }
            object = null;
            prepared_stmt = true;
            if (prepared_stmt) {
                try {
                    object2 = "INSERT INTO branches(Bid,Bbalance) VALUES (?,0)";
                    object = connection.prepareStatement((String)object2);
                    System.out.println("Using prepared statements");
                }
                catch (SQLException sQLException) {
                    object = null;
                    prepared_stmt = false;
                }
            }
            System.out.println("Insert data in branches table");
            for (n = 0; n < nbranches * tps; ++n) {
                if (prepared_stmt) {
                    object.setInt(1, n);
                    object.executeUpdate();
                    object.clearWarnings();
                } else {
                    object2 = "INSERT INTO branches(Bid,Bbalance) VALUES (" + n + ",0)";
                    statement.executeUpdate((String)object2);
                }
                if (n % 100 != 0 || !transactions) continue;
                connection.commit();
            }
            if (prepared_stmt) {
                object.close();
            }
            if (transactions) {
                connection.commit();
            }
            if (prepared_stmt) {
                object2 = "INSERT INTO tellers(Tid,Bid,Tbalance) VALUES (?,?,0)";
                object = connection.prepareStatement((String)object2);
            }
            System.out.println("Insert data in tellers table");
            for (n = 0; n < ntellers * tps; ++n) {
                if (prepared_stmt) {
                    object.setInt(1, n);
                    object.setInt(2, n / ntellers);
                    object.executeUpdate();
                    object.clearWarnings();
                } else {
                    object2 = "INSERT INTO tellers(Tid,Bid,Tbalance) VALUES (" + n + "," + n / ntellers + ",0)";
                    statement.executeUpdate((String)object2);
                }
                if (n % 100 != 0 || !transactions) continue;
                connection.commit();
            }
            if (prepared_stmt) {
                object.close();
            }
            if (transactions) {
                connection.commit();
            }
            if (prepared_stmt) {
                object2 = "INSERT INTO accounts(Aid,Bid,Abalance) VALUES (?,?,0)";
                object = connection.prepareStatement((String)object2);
            }
            System.out.println("Insert data in accounts table");
            for (n = 0; n < naccounts * tps; ++n) {
                if (prepared_stmt) {
                    object.setInt(1, n);
                    object.setInt(2, n / naccounts);
                    object.executeUpdate();
                    object.clearWarnings();
                } else {
                    object2 = "INSERT INTO accounts(Aid,Bid,Abalance) VALUES (" + n + "," + n / naccounts + ",0)";
                    statement.executeUpdate((String)object2);
                }
                if (n % 10000 == 0 && transactions) {
                    connection.commit();
                }
                if (n <= 0 || n % 10000 != 0) continue;
                System.out.println("\t" + n + "\t records inserted");
            }
            if (prepared_stmt) {
                object.close();
            }
            if (transactions) {
                connection.commit();
            }
            System.out.println("\t" + naccounts * tps + "\t records inserted");
            statement.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        JDBCBench.connectClose(connection);
    }

    public static int getRandomInt(int n, int n2) {
        int n3 = 0;
        n3 = (int)(Math.random() * (double)(n2 - n + 1));
        return n3 += n;
    }

    public static int getRandomID(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = ntellers * tps - 1;
                break;
            }
            case 1: {
                n3 = nbranches * tps - 1;
                break;
            }
            case 2: {
                n3 = naccounts * tps - 1;
            }
        }
        return JDBCBench.getRandomInt(n2, n3);
    }

    public static Connection connect(String string, String string2, String string3) {
        try {
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return connection;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public static void connectClose(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    class MemoryWatcherThread
    extends Thread {
        long min = 0L;
        long max = 0L;
        boolean keep_running = true;

        public MemoryWatcherThread() {
            this.reset();
            this.keep_running = true;
        }

        public void reset() {
            System.gc();
            long l = Runtime.getRuntime().freeMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            this.min = this.max = l2 - l;
        }

        public void end() {
            this.keep_running = false;
        }

        public void run() {
            while (this.keep_running) {
                long l = Runtime.getRuntime().freeMemory();
                long l2 = Runtime.getRuntime().totalMemory();
                long l3 = l2 - l;
                if (l3 < this.min) {
                    this.min = l3;
                }
                if (l3 > this.max) {
                    this.max = l3;
                }
                try {
                    MemoryWatcherThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class ClientThread
    extends Thread {
        int ntrans = 0;
        Connection Conn;
        PreparedStatement pstmt1 = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        PreparedStatement pstmt4 = null;
        PreparedStatement pstmt5 = null;

        public ClientThread(int n, String string, String string2, String string3) {
            this.ntrans = n;
            this.Conn = JDBCBench.connect(string, string2, string3);
            if (this.Conn == null) {
                return;
            }
            try {
                if (transactions) {
                    this.Conn.setAutoCommit(false);
                }
                if (prepared_stmt) {
                    String string4 = "UPDATE accounts ";
                    string4 = string4 + "SET     Abalance = Abalance + ? ";
                    string4 = string4 + "WHERE   Aid = ?";
                    this.pstmt1 = this.Conn.prepareStatement(string4);
                    string4 = "SELECT Abalance ";
                    string4 = string4 + "FROM   accounts ";
                    string4 = string4 + "WHERE  Aid = ?";
                    this.pstmt2 = this.Conn.prepareStatement(string4);
                    string4 = "UPDATE tellers ";
                    string4 = string4 + "SET    Tbalance = Tbalance + ? ";
                    string4 = string4 + "WHERE  Tid = ?";
                    this.pstmt3 = this.Conn.prepareStatement(string4);
                    string4 = "UPDATE branches ";
                    string4 = string4 + "SET    Bbalance = Bbalance + ? ";
                    string4 = string4 + "WHERE  Bid = ?";
                    this.pstmt4 = this.Conn.prepareStatement(string4);
                    string4 = "INSERT INTO history(Tid, Bid, Aid, delta) ";
                    string4 = string4 + "VALUES (?,?,?,?)";
                    this.pstmt5 = this.Conn.prepareStatement(string4);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }

        public void run() {
            while (this.ntrans-- > 0) {
                int n = JDBCBench.getRandomID(2);
                int n2 = JDBCBench.getRandomID(1);
                int n3 = JDBCBench.getRandomID(0);
                int n4 = JDBCBench.getRandomInt(0, 1000);
                this.doOne(n2, n3, n, n4);
                JDBCBench.this.incrementTransactionCount();
            }
            if (prepared_stmt) {
                try {
                    if (this.pstmt1 != null) {
                        this.pstmt1.close();
                    }
                    if (this.pstmt2 != null) {
                        this.pstmt2.close();
                    }
                    if (this.pstmt3 != null) {
                        this.pstmt3.close();
                    }
                    if (this.pstmt4 != null) {
                        this.pstmt4.close();
                    }
                    if (this.pstmt5 != null) {
                        this.pstmt5.close();
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                }
            }
            JDBCBench.connectClose(this.Conn);
            this.Conn = null;
        }

        int doOne(int n, int n2, int n3, int n4) {
            int n5 = 0;
            if (this.Conn == null) {
                JDBCBench.this.incrementFailedTransactionCount();
                return 0;
            }
            try {
                if (prepared_stmt) {
                    this.pstmt1.setInt(1, n4);
                    this.pstmt1.setInt(2, n3);
                    this.pstmt1.executeUpdate();
                    this.pstmt1.clearWarnings();
                    this.pstmt2.setInt(1, n3);
                    ResultSet resultSet = this.pstmt2.executeQuery();
                    this.pstmt2.clearWarnings();
                    while (resultSet.next()) {
                        n5 = resultSet.getInt(1);
                    }
                    this.pstmt3.setInt(1, n4);
                    this.pstmt3.setInt(2, n2);
                    this.pstmt3.executeUpdate();
                    this.pstmt3.clearWarnings();
                    this.pstmt4.setInt(1, n4);
                    this.pstmt4.setInt(2, n);
                    this.pstmt4.executeUpdate();
                    this.pstmt4.clearWarnings();
                    this.pstmt5.setInt(1, n2);
                    this.pstmt5.setInt(2, n);
                    this.pstmt5.setInt(3, n3);
                    this.pstmt5.setInt(4, n4);
                    this.pstmt5.executeUpdate();
                    this.pstmt5.clearWarnings();
                } else {
                    Statement statement = this.Conn.createStatement();
                    String string = "UPDATE accounts ";
                    string = string + "SET     Abalance = Abalance + " + n4 + " ";
                    string = string + "WHERE   Aid = " + n3;
                    int n6 = statement.executeUpdate(string);
                    statement.clearWarnings();
                    string = "SELECT Abalance ";
                    string = string + "FROM   accounts ";
                    string = string + "WHERE  Aid = " + n3;
                    ResultSet resultSet = statement.executeQuery(string);
                    statement.clearWarnings();
                    while (resultSet.next()) {
                        n5 = resultSet.getInt(1);
                    }
                    string = "UPDATE tellers ";
                    string = string + "SET    Tbalance = Tbalance + " + n4 + " ";
                    string = string + "WHERE  Tid = " + n2;
                    statement.executeUpdate(string);
                    statement.clearWarnings();
                    string = "UPDATE branches ";
                    string = string + "SET    Bbalance = Bbalance + " + n4 + " ";
                    string = string + "WHERE  Bid = " + n;
                    statement.executeUpdate(string);
                    statement.clearWarnings();
                    string = "INSERT INTO history(Tid, Bid, Aid, delta) ";
                    string = string + "VALUES (";
                    string = string + n2 + ",";
                    string = string + n + ",";
                    string = string + n3 + ",";
                    string = string + n4 + ")";
                    statement.executeUpdate(string);
                    statement.clearWarnings();
                    statement.close();
                }
                if (transactions) {
                    this.Conn.commit();
                }
                return n5;
            }
            catch (Exception exception) {
                if (verbose) {
                    System.out.println("Transaction failed: " + exception.getMessage());
                    exception.printStackTrace();
                }
                JDBCBench.this.incrementFailedTransactionCount();
                if (transactions) {
                    try {
                        this.Conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return 0;
            }
        }
    }
}

