/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ExecHarness {
    private static final String SYNTAX_MSG = "SYNTAX:  java org.hsqldb.test.ExecHarness targetprogram [args...]";
    private static final int MAX_PROG_OUTPUT = 10240;
    File input = null;
    String program = null;
    int exitValue = 0;
    boolean executed = false;
    String[] mtStringArray = new String[0];
    String[] args = this.mtStringArray;
    private byte[] ba = new byte[10241];
    private String stdout = null;
    private String errout = null;
    private static final String DEFAULT_CHARSET = "US-ASCII";

    public static void main(String[] stringArray) throws IOException, FileNotFoundException, InterruptedException {
        int n;
        byte[] byArray = new byte[10240];
        if (stringArray.length < 1) {
            System.err.println(SYNTAX_MSG);
            System.exit(1);
        }
        String string = stringArray[0];
        System.err.println("Enter any input that you want passed to SqlTool via stdin\n(end with EOF, like Ctrl-D or Ctrl-Z+ENTER):");
        File file = File.createTempFile("ExecHarness-", ".input");
        String string2 = System.getProperty("harness.charset");
        String string3 = string2 == null ? DEFAULT_CHARSET : string2;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while ((n = System.in.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        ExecHarness execHarness = new ExecHarness(string);
        execHarness.setArgs(ExecHarness.shift(stringArray));
        execHarness.setInput(file);
        execHarness.exec();
        file.delete();
        int n2 = execHarness.getExitValue();
        System.err.println("STDOUT ******************************************");
        System.out.print(execHarness.getStdout());
        System.err.println("ERROUT ******************************************");
        System.err.print(execHarness.getErrout());
        System.err.println("*************************************************");
        System.err.println(string + " exited with value " + n2);
        execHarness.clear();
        System.exit(n2);
    }

    public void exec() throws IOException, InterruptedException {
        int n;
        if (this.executed) {
            throw new IllegalStateException("You have already executed '" + this.program + "'.  Run clear().");
        }
        Process process = Runtime.getRuntime().exec(ExecHarness.unshift(this.program, this.args));
        OutputStream outputStream = process.getOutputStream();
        if (this.input != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.input));
            while ((n = bufferedInputStream.read(this.ba)) > 0) {
                outputStream.write(this.ba, 0, n);
            }
        }
        outputStream.close();
        InputStream inputStream = process.getInputStream();
        int n2 = 0;
        while ((n = inputStream.read(this.ba, n2, this.ba.length - n2)) > 0) {
            n2 += n;
        }
        if (n > -1) {
            throw new IOException(this.program + " generated > " + (this.ba.length - 1) + " bytes of standard output");
        }
        inputStream.close();
        this.executed = true;
        this.stdout = new String(this.ba, 0, n2);
        inputStream = process.getErrorStream();
        n2 = 0;
        while ((n = inputStream.read(this.ba, n2, this.ba.length - n2)) > 0) {
            n2 += n;
        }
        if (n > -1) {
            throw new IOException(this.program + " generated > " + (this.ba.length - 1) + " bytes of error output");
        }
        inputStream.close();
        this.errout = new String(this.ba, 0, n2);
        this.exitValue = process.waitFor();
    }

    public void clear() {
        this.args = this.mtStringArray;
        this.executed = false;
        this.errout = null;
        this.stdout = null;
        this.input = null;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getErrout() {
        return this.errout;
    }

    public void setInput(File file) throws IllegalStateException {
        if (this.executed) {
            throw new IllegalStateException("You have already executed '" + this.program + "'.  Run clear().");
        }
        this.input = file;
    }

    public void setArgs(String[] stringArray) throws IllegalStateException {
        if (this.executed) {
            throw new IllegalStateException("You have already executed '" + this.program + "'.  Run clear().");
        }
        this.args = stringArray;
    }

    public void setArgs(List list) throws IllegalStateException {
        this.setArgs(ExecHarness.listToPrimitiveArray(list));
    }

    int getExitValue() throws IllegalStateException {
        if (!this.executed) {
            throw new IllegalStateException("You have not executed '" + this.program + "' yet");
        }
        return this.exitValue;
    }

    public ExecHarness(String string) {
        this.program = string;
    }

    public static String[] unshift(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        for (int i = 1; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i - 1];
        }
        return stringArray2;
    }

    public static String[] shift(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        return stringArray2;
    }

    public static String[] listToPrimitiveArray(List list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = (String)list.get(i);
        }
        return stringArray;
    }

    public static String[] push(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static String[] pop(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public static String stringArrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString() + '}';
    }
}

