package crypto.typestate;

import typestate.finiteautomata.State;

public class ErrorStateNode implements State {

    public ErrorStateNode() {}

    @Override
    public boolean isErrorState() {
        return true;
    }

    @Override
    public boolean isInitialState() {
        return false;
    }

    @Override
    public boolean isAccepting() {
        return false;
    }

    @Override
    public String toString() {
        return "ERR";
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ErrorStateNode;
    }
}
