## Reporting bugs and proposing enhancements or features
We welcome all contributions! If you have questions, a feature request or some feedback, please use the **issues** feature of GitHub.

The [Issues page](https://github.com/CRANE-toolbox/analysis-pipelines/issues) works rather like your good old forum page, with many additional features specific to programming and git versioning. GitHub provides a [detailed guide](https://guides.github.com/features/issues/) to them, but here are the basics:
1. **Search the existing issues** for similar questions/feature requests/feedback
2. If you find an issue similar enough, you can add to its discussion with your own details
3. If you don't find an issue similar enough, create a new one
4. **Give as much relevant information as possible**. For example, if you want to report a bug or get help with an error, provide both your code/command-line and the error message. If possible, link to the data.
5. Add appropriate labels/tags to the issue. For example, "documentation" if you're missing info in the doc to use the toolbox.
6. Always keep in mind that this is a volunteer project, and contributors do their best to help. **Be nice and patient**.

## Adding to the code base
You are welcome to submit Pull Requests for open issues. In particular, issues tagged "help-wanted" are usually things the core team is struggling with.
Here is the guidelines we ask you to follow when contributing to the code base.
- Comment on the issue to notify everyone of your intention to do so to make sure no one else is working on the same problem.
- Tackle only one issue per PR, unless you've discussed it with the core team before and they agree a grouped PR makes more sense.
- Reference the issue you are tackling in your PR.
- Tag your PR with "need-review" when making your initial submission or after completing the changes requested by your reviewers.
- Check your PR for reviews and be open to suggestions. If a reviewer is requesting changes, they will change the label of your PR from "need-review" to "in-progress".

## Join the team
If you wish to involve yourself further (reviewing PRs, planning for new features, researching machine learning methods, doing user research, ...), you can join the core team by emailing bolduc2 (at) hotmail (dot) fr to get onboarded. We welcome developers, of course, but also designers, researchers from all academic fields, technical writers...

We have chosen to onboard people privately instead of sharing all our resources in the repo for two reasons. First, we wanted to make it easier for users not used to open source projects to find what they need. Second, some of our resources contain private information from user research.
