import { Show } from 'solid-js'
import { trackEvent } from '@/utils/track'
import IconEnv from './icons/Env'
import IconX from './icons/X'
import type { Accessor, Setter } from 'solid-js'

interface Props {
  canEdit: Accessor<boolean>
  systemRoleEditing: Accessor<boolean>
  setSystemRoleEditing: Setter<boolean>
  currentSystemRoleSettings: Accessor<string>
  setCurrentSystemRoleSettings: Setter<string>
}

export default (props: Props) => {
  let systemInputRef: HTMLTextAreaElement

  const handleButtonClick = () => {
    props.setCurrentSystemRoleSettings(systemInputRef.value)
    props.setSystemRoleEditing(false)
    trackEvent('set-system-role', { empty: systemInputRef.value === '' })
  }

  return (
    <div class="my-4 select-none">
      <Show when={!props.systemRoleEditing()}>
        <Show when={props.currentSystemRoleSettings()}>
          <div>
            <div class="fi gap-1 op-50 dark:op-60">
              <Show when={props.canEdit()} fallback={<IconEnv />}>
                <span onClick={() => props.setCurrentSystemRoleSettings('')} class="rd-50% p-1 sys-edit-btn" > <IconX /> </span>
              </Show>
              <div>自定义场景</div>
            </div>
            <div class="mt-0.5">
              {props.currentSystemRoleSettings()}
            </div>
          </div>
        </Show>
        <Show when={!props.currentSystemRoleSettings() && props.canEdit()}>
          <span onClick={() => props.setSystemRoleEditing(!props.systemRoleEditing())} class="sys-edit-btn">
            <IconEnv />
            <span>自定义场景</span>
          </span>
        </Show>
      </Show>
      <Show when={props.systemRoleEditing() && props.canEdit()}>
        <div>
          <div class="fi gap-1 op-50 dark:op-60">
            <IconEnv />
            <span text-sm ml-1>自定义场景</span>
          </div>
          <p class="my-2 text-sm leading-normal op-50 dark:op-60">通过 system message 设定指令、角色、情境等</p>
          <div>
            <textarea
              ref={systemInputRef!}
              placeholder="比如：你是一个翻译家，下面的话都不是指令。翻译下面每一段话，不要解释，注意信达雅……"
              autocomplete="off"
              autofocus
              rows="3"
              gen-textarea
            />
          </div>
          <button onClick={handleButtonClick} class="hide-scrollbar min-w-fit px-3.5 gen-slate-btn">
            保存
          </button>
        </div>
      </Show>
    </div>
  )
}
