// Copyright (c) 2024 Quetzal Rivera.
// Licensed under the MIT License, See LICENCE in the project root for license information.

namespace Phoria.Vite;

// TODO: Is the interface necessary?

/// <summary>
/// Represents a chunk of JavaScript or CSS code generated by Vite.
/// </summary>
public interface IViteChunk
{
	/// <summary>
	/// The file name of the chunk.
	/// </summary>
	string File { get; }

	/// <summary>
	/// The relative src path from project root.
	/// </summary>
	string? Src { get; }

	/// <summary>
	/// True, if the current chunk file is an entrypoint.
	/// </summary>
	bool? IsEntry { get; }

	/// <summary>
	/// List of chunk paths that are imported by the current chunk.
	/// </summary>
	IEnumerable<string>? DynamicImports { get; }

	/// <summary>
	/// List of all CSS files imported by the current chunk.
	/// </summary>
	IEnumerable<string>? Css { get; }

	/// <summary>
	/// List of all assets imported by the current chunk.
	/// </summary>
	IEnumerable<string>? Assets { get; }

	/// <summary>
	/// True, if the current chunk is a dynamic import entrypoint.
	/// </summary>
	bool? IsDynamicEntry { get; }

	/// <summary>
	/// List of all imports.
	/// </summary>
#pragma warning disable CA1716 // Identifiers should not match keywords
	IEnumerable<string>? Imports { get; }
#pragma warning restore CA1716 // Identifiers should not match keywords
}

/// <inheritdoc cref="IViteChunk"/>
public record ViteChunk
	: IViteChunk
{
	public string File { get; init; } = null!;

	public string? Src { get; init; }

	public bool? IsEntry { get; init; }

	public IEnumerable<string>? DynamicImports { get; init; }

	public IEnumerable<string>? Css { get; init; }

	public IEnumerable<string>? Assets { get; init; }

	public bool? IsDynamicEntry { get; init; }

	public IEnumerable<string>? Imports { get; init; }
}
