/*
 Highcharts JS v11.1.0 (2023-06-09)

 Sankey diagram module

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/sankey",["highcharts"],function(q){b(q);b.Highcharts=q;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function q(b,h,l,g){b.hasOwnProperty(h)||(b[h]=g.apply(null,l),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:h,module:b[h]}})))}b=b?b._modules:
{};q(b,"Series/NodesComposition.js",[b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,h){const {series:{prototype:l,prototype:{pointClass:{prototype:g}}}}=b,{defined:v,extend:x,find:e,merge:m,pick:k}=h;var a;(function(a){function c(){this.data=[].concat(this.points||[],this.nodes);return l.destroy.apply(this,arguments)}function b(){this.nodes&&(this.nodes.forEach(a=>{a.destroy()}),this.nodes.length=0);l.setData.apply(this,arguments)}function B(a){const c=arguments,d=this.isNode?
this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==a&&d.forEach(a=>{a&&a.series&&(g.setState.apply(a,c),a.isNode||(a.fromNode.graphic&&g.setState.apply(a.fromNode,c),a.toNode&&a.toNode.graphic&&g.setState.apply(a.toNode,c)))});g.setState.apply(this,c)}function p(a,c,d,e){const f=this.series.options.nodes,n=this.series.options.data,w=n&&n.length||0,z=n&&n[this.index];g.update.call(this,a,this.isNode?!1:c,d,e);this.isNode&&(a=(f||[]).reduce((f,a,n)=>this.id===a.id?n:f,-1),e=
m(f&&f[a]||{},n&&n[this.index]||{}),n&&(z?n[this.index]=z:n.length=w),f?0<=a?f[a]=e:f.push(e):this.series.options.nodes=[e],k(c,!0)&&this.series.chart.redraw(d))}const t=[];a.compose=function(a,e){h.pushUnique(t,a)&&(a=a.prototype,a.setNodeState=B,a.setState=B,a.update=p);h.pushUnique(t,e)&&(a=e.prototype,a.destroy=c,a.setData=b);return e};a.createNode=function(a){const c=this.pointClass;var d=(f,a)=>e(f,f=>f.id===a);let b=d(this.nodes,a);if(!b){d=this.options.nodes&&d(this.options.nodes,a);const f=
(new c).init(this,x({className:"highcharts-node",isNode:!0,id:a,y:1},d));f.linksTo=[];f.linksFrom=[];f.getSum=function(){let a=0,d=0;f.linksTo.forEach(f=>{a+=f.weight||0});f.linksFrom.forEach(f=>{d+=f.weight||0});return Math.max(a,d)};f.offset=function(a,d){let n=0;for(let c=0;c<f[d].length;c++){if(f[d][c]===a)return n;n+=f[d][c].weight}};f.hasShape=function(){let a=0;f.linksTo.forEach(f=>{f.outgoing&&a++});return!f.linksTo.length||a!==f.linksTo.length};f.index=this.nodes.push(f)-1;b=f}b.formatPrefix=
"node";b.name=b.name||b.options.id||"";b.mass=k(b.options.mass,b.options.marker&&b.options.marker.radius,this.options.marker&&this.options.marker.radius,4);return b};a.destroy=c;a.generatePoints=function(){const a=this.chart,c={};l.generatePoints.call(this);this.nodes||(this.nodes=[]);this.colorCounter=0;this.nodes.forEach(a=>{a.linksFrom.length=0;a.linksTo.length=0;a.level=a.options.level});this.points.forEach(d=>{v(d.from)&&(c[d.from]||(c[d.from]=this.createNode(d.from)),c[d.from].linksFrom.push(d),
d.fromNode=c[d.from],a.styledMode?d.colorIndex=k(d.options.colorIndex,c[d.from].colorIndex):d.color=d.options.color||c[d.from].color);v(d.to)&&(c[d.to]||(c[d.to]=this.createNode(d.to)),c[d.to].linksTo.push(d),d.toNode=c[d.to]);d.name=d.name||d.id},this);this.nodeLookup=c};a.setNodeState=B;a.updateNode=p})(a||(a={}));return a});q(b,"Series/Sankey/SankeyPoint.js",[b["Core/Series/Point.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,h,l){({seriesTypes:{column:h}}=h);const {defined:g}=
l;class v extends h.prototype.pointClass{constructor(){super(...arguments);this.toNode=this.series=this.options=this.nodeY=this.nodeX=this.mass=this.linksTo=this.linksFrom=this.linkBase=this.level=this.fromNode=this.className=void 0}applyOptions(h,e){b.prototype.applyOptions.call(this,h,e);g(this.options.level)&&(this.options.column=this.column=this.options.level);return this}getClassName(){return(this.isNode?"highcharts-node ":"highcharts-link ")+b.prototype.getClassName.call(this)}getFromNode(){let b=
-1,e;for(let m=0;m<this.linksTo.length;m++){const k=this.linksTo[m];k.fromNode.column>b&&k.fromNode!==this&&(e=k.fromNode,b=e.column)}return{fromNode:e,fromColumn:b}}setNodeColumn(){g(this.options.column)||(this.column=0===this.linksTo.length?0:this.getFromNode().fromColumn+1)}isValid(){return this.isNode||"number"===typeof this.weight}}return v});q(b,"Series/Sankey/SankeySeriesDefaults.js",[],function(){"";return{borderWidth:0,colorByPoint:!0,curveFactor:.33,dataLabels:{enabled:!0,backgroundColor:"none",
crop:!1,nodeFormat:void 0,nodeFormatter:function(){return this.point.name},format:void 0,formatter:function(){},inside:!0},inactiveOtherPoints:!0,linkOpacity:.5,opacity:1,minLinkWidth:0,nodeWidth:20,nodePadding:10,showInLegend:!1,states:{hover:{linkOpacity:1,opacity:1},inactive:{linkOpacity:.1,opacity:.1,animation:{duration:50}}},tooltip:{followPointer:!0,headerFormat:'<span style="font-size: 0.8em">{series.name}</span><br/>',pointFormat:"{point.fromNode.name} \u2192 {point.toNode.name}: <b>{point.weight}</b><br/>",
nodeFormat:"{point.name}: <b>{point.sum}</b><br/>"}}});q(b,"Series/Sankey/SankeyColumnComposition.js",[b["Core/Utilities.js"]],function(b){const {defined:h,relativeLength:l}=b;var g;(function(b){b.compose=function(b,m){b.sankeyColumn=new g(b,m);return b};class g{constructor(b,m){this.points=b;this.series=m}getTranslationFactor(b){const e=this.points,k=e.slice(),a=b.options.minLinkWidth||0;let c=0,r,g=(b.chart.plotSizeY||0)-(b.options.borderWidth||0)-(e.length-1)*b.nodePadding;for(;e.length;){c=g/
e.sankeyColumn.sum();b=!1;for(r=e.length;r--;)e[r].getSum()*c<a&&(e.splice(r,1),g-=a,b=!0);if(!b)break}e.length=0;k.forEach(a=>{e.push(a)});return c}top(b){const e=this.series,k=e.nodePadding,a=this.points.reduce(function(a,r){0<a&&(a+=k);r=Math.max(r.getSum()*b,e.options.minLinkWidth||0);return a+r},0);return((e.chart.plotSizeY||0)-a)/2}left(b){const e=this.series,k=e.chart,a=e.options.equalNodes,c=k.inverted?k.plotHeight:k.plotWidth,r=e.nodePadding,g=this.points.reduce(function(k,g){0<k&&(k+=r);
g=a?c/g.series.nodes.length-r:Math.max(g.getSum()*b,e.options.minLinkWidth||0);return k+g},0);return((k.plotSizeX||0)-Math.round(g))/2}sum(){return this.points.reduce(function(b,g){return b+g.getSum()},0)}offset(b,g){const e=this.points,a=this.series,c=a.nodePadding;let r=0;if(a.is("organization")&&b.hangsFrom)return{absoluteTop:b.hangsFrom.nodeY};for(let k=0;k<e.length;k++){var y=e[k].getSum();const p=Math.max(y*g,a.options.minLinkWidth||0),t=b.options[a.chart.inverted?"offsetHorizontal":"offsetVertical"],
u=b.options.offset||0;y=y?p+c:0;if(e[k]===b)return{relativeTop:r+(h(t)?l(t,p):l(u,y))};r+=y}}}b.SankeyColumnAdditions=g})(g||(g={}));return g});q(b,"Series/TreeUtilities.js",[b["Core/Color/Color.js"],b["Core/Utilities.js"]],function(b,h){function l(a,b){var c=b.before;const e=b.idRoot,h=b.mapIdToNode[e],p=b.points[a.i],t=p&&p.options||{},u=[];let m=0;a.levelDynamic=a.level-(!1!==b.levelIsConstant?0:h.level);a.name=k(p&&p.name,"");a.visible=e===a.id||!0===b.visible;"function"===typeof c&&(a=c(a,b));
a.children.forEach((c,e)=>{const f=g({},b);g(f,{index:e,siblings:a.children.length,visible:a.visible});c=l(c,f);u.push(c);c.visible&&(m+=c.val)});c=k(t.value,m);a.visible=0<=c&&(0<m||a.visible);a.children=u;a.childrenTotal=m;a.isLeaf=a.visible&&!m;a.val=c;return a}const {extend:g,isArray:q,isNumber:x,isObject:e,merge:m,pick:k}=h;return{getColor:function(a,c){const e=c.index;var g=c.mapOptionsToLevel;const h=c.parentColor,m=c.parentColorIndex,t=c.series;var u=c.colors;const l=c.siblings;var d=t.points,
q=t.chart.options.chart;let f;var n;let w;if(a){d=d[a.i];a=g[a.level]||{};if(g=d&&a.colorByPoint){f=d.index%(u?u.length:q.colorCount);var z=u&&u[f]}if(!t.chart.styledMode){u=d&&d.options.color;q=a&&a.color;if(n=h)n=(n=a&&a.colorVariation)&&"brightness"===n.key&&e&&l?b.parse(h).brighten(e/l*n.to).get():h;n=k(u,q,z,n,t.color)}w=k(d&&d.options.colorIndex,a&&a.colorIndex,f,m,c.colorIndex)}return{color:n,colorIndex:w}},getLevelOptions:function(a){let b={},g,h,l;if(e(a)){l=x(a.from)?a.from:1;var p=a.levels;
h={};g=e(a.defaults)?a.defaults:{};q(p)&&(h=p.reduce((a,b)=>{let c,d;e(b)&&x(b.level)&&(d=m({},b),c=k(d.levelIsConstant,g.levelIsConstant),delete d.levelIsConstant,delete d.level,b=b.level+(c?0:l-1),e(a[b])?m(!0,a[b],d):a[b]=d);return a},{}));p=x(a.to)?a.to:1;for(a=0;a<=p;a++)b[a]=m({},g,e(h[a])?h[a]:{})}return b},setTreeValues:l,updateRootId:function(a){if(e(a)){var b=e(a.options)?a.options:{};b=k(a.rootNode,b.rootId,"");e(a.userOptions)&&(a.userOptions.rootId=b);a.rootNode=b}return b}}});q(b,"Series/Sankey/SankeySeries.js",
[b["Core/Color/Color.js"],b["Core/Globals.js"],b["Series/NodesComposition.js"],b["Series/Sankey/SankeyPoint.js"],b["Series/Sankey/SankeySeriesDefaults.js"],b["Core/Series/SeriesRegistry.js"],b["Series/Sankey/SankeyColumnComposition.js"],b["Series/TreeUtilities.js"],b["Core/Utilities.js"]],function(b,h,l,g,q,x,e,m,k){const {series:a,seriesTypes:{column:c}}=x,{getLevelOptions:r}=m,{clamp:y,extend:B,isObject:p,merge:t,pick:u,relativeLength:v,stableSort:d}=k;class A extends c{constructor(){super(...arguments);
this.translationFactor=this.points=this.options=this.nodeWidth=this.nodes=this.nodePadding=this.nodeLookup=this.group=this.data=this.colDistance=void 0}static getDLOptions(a){const b=p(a.optionsPoint)?a.optionsPoint.dataLabels:{};a=p(a.level)?a.level.dataLabels:{};return t({style:{}},a,b)}createNodeColumns(){const a=[];this.nodes.forEach(function(b){b.setNodeColumn();a[b.column]||(a[b.column]=e.compose([],this));a[b.column].push(b)},this);for(let b=0;b<a.length;b++)"undefined"===typeof a[b]&&(a[b]=
e.compose([],this));return a}order(a,b){const f=this;"undefined"===typeof a.level&&(a.level=b,a.linksFrom.forEach(function(a){a.toNode&&f.order(a.toNode,b+1)}))}generatePoints(){l.generatePoints.apply(this,arguments);const a=this;this.orderNodes&&(this.nodes.filter(function(a){return 0===a.linksTo.length}).forEach(function(b){a.order(b,0)}),d(this.nodes,function(a,b){return a.level-b.level}))}getNodePadding(){let a=this.options.nodePadding||0;if(this.nodeColumns){const b=this.nodeColumns.reduce((a,
b)=>Math.max(a,b.length),0);b*a>this.chart.plotSizeY&&(a=this.chart.plotSizeY/b)}return a}hasData(){return!!this.processedXData.length}pointAttribs(a,c){if(!a)return{};const f=this,e=f.mapOptionsToLevel[(a.isNode?a.level:a.fromNode.level)||0]||{},d=a.options,n=e.states&&e.states[c||""]||{};c=["colorByPoint","borderColor","borderWidth","linkOpacity","opacity"].reduce(function(a,b){a[b]=u(n[b],d[b],e[b],f.options[b]);return a},{});const g=u(n.color,d.color,c.colorByPoint?a.color:e.color);return a.isNode?
{fill:g,stroke:c.borderColor,"stroke-width":c.borderWidth,opacity:c.opacity}:{fill:b.parse(g).setOpacity(c.linkOpacity).get()}}drawTracker(){c.prototype.drawTracker.call(this,this.points);c.prototype.drawTracker.call(this,this.nodes)}drawPoints(){c.prototype.drawPoints.call(this,this.points);c.prototype.drawPoints.call(this,this.nodes)}drawDataLabels(){c.prototype.drawDataLabels.call(this,this.points);c.prototype.drawDataLabels.call(this,this.nodes)}translate(){this.processedXData||this.processData();
this.generatePoints();this.nodeColumns=this.createNodeColumns();this.nodeWidth=v(this.options.nodeWidth,this.chart.plotSizeX);const a=this,b=this.chart,c=this.options,e=this.nodeWidth,d=this.nodeColumns;this.nodePadding=this.getNodePadding();this.translationFactor=d.reduce((b,f)=>Math.min(b,f.sankeyColumn.getTranslationFactor(a)),Infinity);this.colDistance=(b.plotSizeX-e-c.borderWidth)/Math.max(1,d.length-1);a.mapOptionsToLevel=r({from:1,levels:c.levels,to:d.length-1,defaults:{borderColor:c.borderColor,
borderRadius:c.borderRadius,borderWidth:c.borderWidth,color:a.color,colorByPoint:c.colorByPoint,levelIsConstant:!0,linkColor:c.linkColor,linkLineWidth:c.linkLineWidth,linkOpacity:c.linkOpacity,states:c.states}});d.forEach(function(b){b.forEach(function(f){a.translateNode(f,b)})},this);this.nodes.forEach(function(b){b.linksFrom.forEach(function(b){(b.weight||b.isNull)&&b.to&&(a.translateLink(b),b.allowShadow=!1)})})}translateLink(a){var b=(b,c)=>{c=b.offset(a,c)*e;return Math.min(b.nodeY+c,b.nodeY+
(b.shapeArgs&&b.shapeArgs.height||0)-g)};let c=a.fromNode;var f=a.toNode;let d=this.chart,e=this.translationFactor,g=Math.max(a.weight*e,this.options.minLinkWidth);var k=(d.inverted?-this.colDistance:this.colDistance)*this.options.curveFactor;let h=b(c,"linksFrom");b=b(f,"linksTo");let l=c.nodeX,m=this.nodeWidth;f=f.nodeX;var q=a.outgoing,p=f>l+m;d.inverted&&(h=d.plotSizeY-h,b=(d.plotSizeY||0)-b,m=-m,g=-g,p=l>f);a.shapeType="path";a.linkBase=[h,h+g,b,b+g];if(p&&"number"===typeof b)a.shapeArgs={d:[["M",
l+m,h],["C",l+m+k,h,f-k,b,f,b],["L",f+(q?m:0),b+g/2],["L",f,b+g],["C",f-k,b+g,l+m+k,h+g,l+m,h+g],["Z"]]};else if("number"===typeof b){k=f-20-g;q=f-20;p=l+m;const c=p+20,e=c+g,n=h,r=h+g,u=r+20,t=u+(d.plotHeight-h-g),w=t+20,z=w+g,C=b,v=C+g,x=v+20,E=w+.7*g,y=f-.7*g,D=p+.7*g;a.shapeArgs={d:[["M",p,n],["C",D,n,e,r-.7*g,e,u],["L",e,t],["C",e,E,D,z,p,z],["L",f,z],["C",y,z,k,E,k,t],["L",k,x],["C",k,v-.7*g,y,C,f,C],["L",f,v],["C",q,v,q,v,q,x],["L",q,t],["C",q,w,q,w,f,w],["L",p,w],["C",c,w,c,w,c,t],["L",c,
u],["C",c,r,c,r,p,r],["Z"]]}}a.dlBox={x:l+(f-l+m)/2,y:h+(b-h)/2,height:g,width:0};a.tooltipPos=d.inverted?[d.plotSizeY-a.dlBox.y-g/2,d.plotSizeX-a.dlBox.x]:[a.dlBox.x,a.dlBox.y+g/2];a.y=a.plotY=1;a.x=a.plotX=1;a.color||(a.color=c.color)}translateNode(a,b){var c=this.translationFactor;const d=this.chart,e=this.options,{borderRadius:g,borderWidth:f=0}=e;var h=a.getSum();const k=Math.max(Math.round(h*c),this.options.minLinkWidth),m=Math.round(this.nodeWidth);var l=Math.round(f)%2/2,n=b.sankeyColumn.offset(a,
c);b=Math.floor(u(n.absoluteTop,b.sankeyColumn.top(c)+n.relativeTop))+l;l=Math.floor(this.colDistance*a.column+f/2)+v(a.options.offsetHorizontal||0,m)+l;l=d.inverted?d.plotSizeX-l:l;if(a.sum=h){a.shapeType="roundedRect";a.nodeX=l;a.nodeY=b;h=l;c=b;n=a.options.width||e.width||m;let f=a.options.height||e.height||k;const p=y(v("object"===typeof g?g.radius:g||0,n),0,k/2);d.inverted&&(h=l-m,c=d.plotSizeY-b-k,n=a.options.height||e.height||m,f=a.options.width||e.width||k);a.dlOptions=A.getDLOptions({level:this.mapOptionsToLevel[a.level],
optionsPoint:a.options});a.plotX=1;a.plotY=1;a.tooltipPos=d.inverted?[d.plotSizeY-c-f/2,d.plotSizeX-h-n/2]:[h+n/2,c+f/2];a.shapeArgs={x:h,y:c,width:n,height:f,r:p,display:a.hasShape()?"":"none"}}else a.dlOptions={enabled:!1}}}A.defaultOptions=t(c.defaultOptions,q);l.compose(g,A);B(A.prototype,{animate:a.prototype.animate,createNode:l.createNode,forceDL:!0,invertible:!0,isCartesian:!1,orderNodes:!0,noSharedTooltip:!0,pointArrayMap:["from","to","weight"],pointClass:g,searchPoint:h.noop});x.registerSeriesType("sankey",
A);"";return A});q(b,"masters/modules/sankey.src.js",[],function(){})});
//# sourceMappingURL=sankey.js.map