#!/usr/bin/python

# This is a very quick-and-dirty script to synthesize audio using Fourier
# synthesis. It uses a table of initial phases and magnitudes for each
# frequency from 0 Hz (constant) up to 2000 Hz. The audio is voice; nothing
# higher than 2000 Hz is really important to preserve the essence of the
# original clip.

# Fun fact: This uses only 8000 coefficients to produce 22050 samples. By not
# storing some of the frequencies, we manage to produce a smaller
# representation of the audio than the raw samples. This is the basis of
# compression algorithms like MP3 and Vorbis (although those are smarter about
# what they choose not to store).

# This is very, very slow. It could be made to run faster if using numpy arrays
# instead of Python lists, and even faster if using numpy's ifft function
# instead of doubly-nested for loops. I opted not to do this, however, to prove
# a point: you only need math.cos (or math.sin) to synthesize anything you
# want.

from __future__ import division

import sys
import wave
import math
import struct

# This table is formatted like so:
    # (PHASE_RAD, MAG), # 0 Hz (constant)
    # (PHASE_RAD, MAG), # 0.5 Hz
    # (PHASE_RAD, MAG), # 1.0 Hz
    # (PHASE_RAD, MAG), # 1.5 Hz

# That is, it contains the initial phase and amplitude for each frequency
# necessary to reconstruct the original audio:
TABLE = [
    (0.000000, 0.000000),
    (-0.400295, 0.004226),
    (3.043596, 0.001839),
    (0.598743, 0.002009),
    (-3.021320, 0.002769),
    (-0.223488, 0.001318),
    (-1.746296, 0.000727),
    (1.745397, 0.000622),
    (-1.445666, 0.000871),
    (2.040826, 0.001625),
    (-0.652801, 0.001699),
    (2.699947, 0.001733),
    (-0.836445, 0.001463),
    (2.306947, 0.001419),
    (-0.450621, 0.001406),
    (2.253017, 0.001654),
    (-1.795919, 0.001369),
    (0.612547, 0.000563),
    (-2.776715, 0.000435),
    (0.250446, 0.000289),
    (0.104309, 0.000179),
    (-1.374456, 0.000256),
    (-1.373049, 0.000180),
    (1.599945, 0.000306),
    (-0.602955, 0.000462),
    (-2.963904, 0.000758),
    (0.228916, 0.000418),
    (2.147044, 0.000482),
    (0.096516, 0.000542),
    (2.662565, 0.000210),
    (0.104150, 0.000393),
    (-2.422120, 0.000669),
    (1.134510, 0.000457),
    (-0.419218, 0.000398),
    (-2.817030, 0.000394),
    (-0.766546, 0.000681),
    (2.011745, 0.000721),
    (-0.937415, 0.000464),
    (2.975391, 0.000299),
    (2.337355, 0.000228),
    (-0.356598, 0.000122),
    (-2.820914, 0.000522),
    (-0.295730, 0.001007),
    (1.985448, 0.001106),
    (-0.745337, 0.000828),
    (2.274974, 0.000491),
    (2.703236, 0.000121),
    (-2.129620, 0.000863),
    (1.013283, 0.000374),
    (-2.837418, 0.000375),
    (0.786420, 0.000547),
    (-1.088070, 0.000314),
    (1.834410, 0.000667),
    (-1.812520, 0.000572),
    (1.395775, 0.000361),
    (0.401128, 0.000138),
    (-2.866509, 0.000344),
    (0.253285, 0.000684),
    (-1.444218, 0.000248),
    (1.125563, 0.000379),
    (0.856616, 0.001094),
    (0.795991, 0.001056),
    (2.983062, 0.000428),
    (1.676352, 0.000550),
    (-2.766945, 0.000475),
    (-0.986916, 0.000192),
    (1.046797, 0.000378),
    (-2.501403, 0.000691),
    (0.839228, 0.000314),
    (-1.996092, 0.000176),
    (0.262616, 0.000611),
    (-2.741573, 0.000498),
    (0.482728, 0.000439),
    (-2.244689, 0.000580),
    (-0.466760, 0.000712),
    (2.876559, 0.000497),
    (0.496979, 0.000492),
    (-3.015571, 0.000570),
    (-0.901600, 0.000484),
    (-2.891850, 0.000256),
    (-0.314332, 0.000486),
    (2.332627, 0.000433),
    (-1.165725, 0.000270),
    (-0.910532, 0.000129),
    (0.105895, 0.000527),
    (-0.281177, 0.000197),
    (0.951025, 0.000156),
    (-2.038839, 0.000560),
    (-0.291189, 0.000110),
    (-2.464417, 0.000220),
    (2.204207, 0.000133),
    (-3.099982, 0.000294),
    (-1.831600, 0.000389),
    (2.898682, 0.000193),
    (1.289487, 0.000095),
    (1.140332, 0.000374),
    (0.529018, 0.000207),
    (-1.155255, 0.000183),
    (0.230301, 0.000659),
    (-1.695168, 0.000607),
    (-0.370842, 0.000215),
    (-2.703563, 0.000412),
    (0.427958, 0.000424),
    (3.059585, 0.000898),
    (-0.925438, 0.000307),
    (2.595814, 0.000897),
    (0.425480, 0.000690),
    (1.459079, 0.000726),
    (1.418346, 0.000039),
    (1.867845, 0.000478),
    (-0.297963, 0.000527),
    (-1.235498, 0.000520),
    (1.253410, 0.000179),
    (-2.758741, 0.000672),
    (3.044693, 0.000175),
    (-2.349852, 0.000764),
    (0.584971, 0.000648),
    (-2.627896, 0.000150),
    (0.796302, 0.000167),
    (1.108558, 0.000351),
    (-1.568774, 0.001012),
    (1.309275, 0.000620),
    (0.398701, 0.000341),
    (-1.087328, 0.000467),
    (-1.606620, 0.000498),
    (1.063578, 0.000098),
    (3.088468, 0.000591),
    (-2.903915, 0.000289),
    (-2.369462, 0.000421),
    (2.780692, 0.000317),
    (-0.786614, 0.000483),
    (2.427317, 0.000527),
    (-2.951577, 0.000533),
    (-0.887682, 0.000383),
    (0.036345, 0.000804),
    (2.051726, 0.000355),
    (-0.589185, 0.000484),
    (-0.870720, 0.000630),
    (1.702058, 0.000453),
    (2.835333, 0.000119),
    (0.046552, 0.000047),
    (-1.290682, 0.000415),
    (2.505277, 0.000538),
    (1.539145, 0.000172),
    (2.786885, 0.000919),
    (-2.379561, 0.000783),
    (-2.809679, 0.000267),
    (1.231402, 0.000735),
    (-2.097489, 0.000677),
    (-0.374090, 0.000452),
    (-0.550438, 0.001326),
    (-0.785624, 0.000527),
    (-0.437173, 0.001207),
    (0.139013, 0.000309),
    (0.228987, 0.000349),
    (1.435265, 0.000909),
    (0.541081, 0.000737),
    (2.902712, 0.000977),
    (3.083675, 0.000960),
    (-2.789543, 0.000440),
    (2.862792, 0.000597),
    (-2.039135, 0.000623),
    (-1.409314, 0.000947),
    (-1.643585, 0.001407),
    (-1.025942, 0.001945),
    (-0.517361, 0.001845),
    (-0.825965, 0.001445),
    (0.198906, 0.002196),
    (0.447529, 0.001532),
    (0.666709, 0.002043),
    (1.304636, 0.002104),
    (1.847256, 0.002817),
    (2.393400, 0.002410),
    (2.995442, 0.002863),
    (-2.466023, 0.003054),
    (-2.349925, 0.001932),
    (-1.555887, 0.003272),
    (-0.989454, 0.003237),
    (-0.563287, 0.003546),
    (0.206851, 0.003442),
    (0.894963, 0.004596),
    (1.479128, 0.004847),
    (2.229230, 0.005104),
    (2.955876, 0.006121),
    (-2.534776, 0.005519),
    (-1.908554, 0.005937),
    (-1.374571, 0.006762),
    (-0.580279, 0.007465),
    (0.124477, 0.006963),
    (0.865594, 0.007343),
    (1.695915, 0.006735),
    (2.450440, 0.005370),
    (-2.862467, 0.005146),
    (-1.856878, 0.003842),
    (-0.837160, 0.004605),
    (0.320383, 0.004299),
    (1.250602, 0.004112),
    (2.075996, 0.004887),
    (-3.060049, 0.004348),
    (-2.063510, 0.004850),
    (-1.100215, 0.003596),
    (0.143402, 0.003380),
    (0.983064, 0.004028),
    (2.230887, 0.004813),
    (-2.948479, 0.005179),
    (-1.720886, 0.005633),
    (-0.842244, 0.005279),
    (0.229256, 0.006566),
    (1.438613, 0.006056),
    (2.433262, 0.006529),
    (-2.728691, 0.005628),
    (-1.699455, 0.005603),
    (-0.560222, 0.005018),
    (0.705232, 0.006074),
    (1.947034, 0.004923),
    (2.982267, 0.004205),
    (-1.966988, 0.004115),
    (-0.838487, 0.003332),
    (0.592912, 0.004167),
    (1.778955, 0.003819),
    (3.122446, 0.004736),
    (-2.055405, 0.004432),
    (-0.690814, 0.005281),
    (0.737640, 0.004922),
    (2.011342, 0.005218),
    (-2.887763, 0.004453),
    (-1.632271, 0.005673),
    (0.074049, 0.006570),
    (1.069182, 0.006089),
    (2.547713, 0.007324),
    (-2.852470, 0.006155),
    (-1.361565, 0.006556),
    (-0.403891, 0.004942),
    (1.431870, 0.007056),
    (2.773467, 0.004189),
    (-1.912134, 0.005838),
    (-0.395809, 0.003102),
    (0.770484, 0.006464),
    (2.494787, 0.003892),
    (-2.782857, 0.006617),
    (-0.568492, 0.004931),
    (-0.089677, 0.005141),
    (2.403622, 0.005285),
    (2.644330, 0.004145),
    (-0.986675, 0.007046),
    (-0.149127, 0.001486),
    (1.877302, 0.009729),
    (-1.649350, 0.002901),
    (-1.867098, 0.009896),
    (1.143727, 0.006876),
    (0.491970, 0.009784),
    (-2.730663, 0.011341),
    (2.943561, 0.005246),
    (-0.059415, 0.013166),
    (-2.051106, 0.003145),
    (2.492902, 0.012427),
    (-0.355303, 0.005441),
    (-1.112791, 0.009339),
    (2.156652, 0.008572),
    (1.614299, 0.004512),
    (-1.211895, 0.010096),
    (2.841359, 0.002495),
    (1.491847, 0.009883),
    (-1.642731, 0.005148),
    (-1.969770, 0.007777),
    (1.044109, 0.008568),
    (1.335959, 0.003680),
    (-2.220918, 0.009784),
    (-0.003784, 0.003907),
    (0.977832, 0.008627),
    (2.923258, 0.005305),
    (-2.238913, 0.010127),
    (-0.384414, 0.007309),
    (1.007009, 0.010973),
    (-2.819388, 0.007167),
    (-2.034608, 0.006830),
    (0.769974, 0.009268),
    (1.465804, 0.001435),
    (-2.394508, 0.010447),
    (0.699823, 0.005132),
    (0.483974, 0.008658),
    (-2.685144, 0.009833),
    (-2.181524, 0.002831),
    (0.484823, 0.011036),
    (-3.018961, 0.004579),
    (-2.418023, 0.008987),
    (0.406232, 0.010076),
    (1.550346, 0.004495),
    (-2.600360, 0.011381),
    (-0.666319, 0.006184),
    (0.922211, 0.012191),
    (3.075094, 0.009375),
    (-1.713336, 0.014524),
    (0.736310, 0.015332),
    (2.137366, 0.010722),
    (-1.876686, 0.020162),
    (0.579432, 0.010817),
    (1.742585, 0.013131),
    (-1.761282, 0.014820),
    (0.473126, 0.002875),
    (1.859668, 0.010802),
    (-1.389731, 0.008519),
    (-0.614708, 0.005243),
    (2.036968, 0.011600),
    (-2.223900, 0.006122),
    (-0.479025, 0.012952),
    (2.105206, 0.011718),
    (-2.403337, 0.012195),
    (0.193266, 0.017935),
    (2.527253, 0.011435),
    (-1.917174, 0.020915),
    (0.820373, 0.027698),
    (2.927930, 0.014005),
    (-1.636457, 0.027138),
    (1.159433, 0.026566),
    (-2.930935, 0.011160),
    (-0.943118, 0.018472),
    (2.015633, 0.017585),
    (-2.084040, 0.009607),
    (0.166693, 0.015224),
    (3.046558, 0.011372),
    (-1.507035, 0.007045),
    (1.202900, 0.012004),
    (-1.817547, 0.006175),
    (-1.033799, 0.005096),
    (2.361302, 0.010070),
    (-0.347023, 0.006089),
    (-0.581366, 0.003991),
    (-3.012866, 0.008644),
    (1.146389, 0.005226),
    (-0.152539, 0.004688),
    (-2.179519, 0.005472),
    (3.104731, 0.004150),
    (0.799704, 0.007900),
    (-0.593234, 0.002833),
    (-1.914609, 0.008921),
    (1.840321, 0.009762),
    (0.327799, 0.003616),
    (-1.101154, 0.008788),
    (2.788970, 0.008840),
    (1.758457, 0.001985),
    (0.155133, 0.006960),
    (-2.241299, 0.007430),
    (-2.941069, 0.000893),
    (1.544648, 0.006565),
    (-0.564411, 0.005859),
    (-1.816387, 0.002983),
    (2.842700, 0.005473),
    (1.149287, 0.007021),
    (-0.978008, 0.005232),
    (-2.245002, 0.004829),
    (2.631953, 0.009254),
    (-0.083088, 0.007758),
    (-1.153921, 0.005560),
    (-2.639877, 0.007892),
    (0.852789, 0.008539),
    (0.502154, 0.002879),
    (-1.077295, 0.004918),
    (2.516882, 0.007554),
    (1.785682, 0.003267),
    (0.273438, 0.004240),
    (-2.136826, 0.010302),
    (2.196725, 0.002726),
    (0.903468, 0.003082),
    (-0.520364, 0.008491),
    (2.987444, 0.003645),
    (2.280650, 0.002623),
    (1.358664, 0.007370),
    (-1.675597, 0.004172),
    (-2.098781, 0.005463),
    (2.954417, 0.007100),
    (0.133955, 0.008511),
    (-0.808320, 0.006130),
    (-2.181783, 0.004324),
    (1.642622, 0.013334),
    (0.422766, 0.004050),
    (-1.647626, 0.004052),
    (-3.036198, 0.012539),
    (0.300810, 0.001952),
    (-0.107029, 0.005321),
    (-1.137318, 0.009323),
    (2.213387, 0.005517),
    (1.788879, 0.006578),
    (0.405047, 0.005171),
    (-2.194785, 0.009520),
    (-2.862565, 0.004329),
    (0.817969, 0.003887),
    (-0.122536, 0.009673),
    (-2.978745, 0.001528),
    (2.941014, 0.004760),
    (2.000562, 0.007154),
    (-0.736461, 0.006188),
    (-1.240841, 0.008879),
    (-3.071037, 0.006719),
    (1.049659, 0.014450),
    (-0.389265, 0.003693),
    (-2.426251, 0.007870),
    (2.618592, 0.010337),
    (-0.389351, 0.004540),
    (-0.188236, 0.006441),
    (-1.753654, 0.006136),
    (2.030003, 0.008475),
    (1.774612, 0.005465),
    (-0.759565, 0.008604),
    (-2.510910, 0.009289),
    (1.455315, 0.002097),
    (0.954758, 0.007513),
    (-0.906562, 0.003877),
    (-3.008634, 0.004993),
    (-2.776073, 0.006317),
    (0.636432, 0.006155),
    (-0.410747, 0.007268),
    (-1.923641, 0.003318),
    (2.494585, 0.011660),
    (0.814509, 0.005590),
    (-1.285245, 0.008675),
    (-1.744841, 0.007179),
    (1.524977, 0.009084),
    (0.898706, 0.007155),
    (-0.611179, 0.001543),
    (-2.471639, 0.011146),
    (2.252627, 0.004571),
    (0.221931, 0.007205),
    (-0.462095, 0.007283),
    (3.139445, 0.009168),
    (2.266994, 0.005125),
    (0.099385, 0.002954),
    (-0.887315, 0.008134),
    (2.308105, 0.001182),
    (2.428082, 0.006729),
    (1.390341, 0.006283),
    (-1.115169, 0.008602),
    (-1.620395, 0.006145),
    (2.177021, 0.008796),
    (0.879596, 0.010021),
    (-1.822940, 0.005863),
    (-2.179723, 0.009959),
    (2.284961, 0.003265),
    (0.543529, 0.010405),
    (0.237201, 0.004878),
    (-2.428128, 0.010120),
    (2.524537, 0.009526),
    (0.011300, 0.008362),
    (-0.352117, 0.008587),
    (-3.089162, 0.007188),
    (2.292130, 0.005071),
    (-2.944527, 0.000769),
    (-0.253146, 0.008533),
    (-1.940618, 0.002591),
    (2.867262, 0.006404),
    (1.931408, 0.007933),
    (-0.716842, 0.011475),
    (-1.499009, 0.004117),
    (2.271730, 0.006784),
    (1.777681, 0.007090),
    (-1.164646, 0.004852),
    (-0.848393, 0.008212),
    (-2.744424, 0.005996),
    (1.563464, 0.015329),
    (-0.072171, 0.005274),
    (-1.812385, 0.012557),
    (3.068546, 0.007375),
    (0.635888, 0.009995),
    (0.858488, 0.003706),
    (-1.731140, 0.006967),
    (-2.705547, 0.006201),
    (1.540675, 0.004639),
    (0.597372, 0.009743),
    (-1.754778, 0.007470),
    (-3.024067, 0.007270),
    (0.983066, 0.002206),
    (0.502973, 0.006464),
    (-1.100163, 0.000308),
    (-1.789935, 0.005232),
    (-2.777975, 0.006458),
    (1.197245, 0.013453),
    (-0.304765, 0.010135),
    (-2.225165, 0.016871),
    (2.438330, 0.013573),
    (0.178062, 0.016615),
    (-1.138624, 0.006175),
    (3.141080, 0.009726),
    (2.107866, 0.003765),
    (-0.624881, 0.004542),
    (0.533434, 0.006292),
    (-1.882030, 0.002708),
    (-2.772439, 0.007420),
    (1.953960, 0.004767),
    (0.308057, 0.012249),
    (-1.526553, 0.009531),
    (-3.010884, 0.014227),
    (1.364825, 0.012051),
    (-0.239867, 0.017847),
    (-2.489191, 0.014140),
    (2.333566, 0.011882),
    (-0.041067, 0.010409),
    (-1.591366, 0.007726),
    (1.930304, 0.012891),
    (-0.763647, 0.011173),
    (-2.331676, 0.017626),
    (1.516721, 0.021734),
    (-0.087157, 0.025158),
    (-2.371831, 0.029557),
    (2.179754, 0.023369),
    (0.227420, 0.024370),
    (-1.448339, 0.018129),
    (3.063898, 0.022223),
    (0.987802, 0.015510),
    (-0.790343, 0.016682),
    (-3.095434, 0.011706),
    (1.540828, 0.012150),
    (-1.118037, 0.017113),
    (3.048041, 0.012914),
    (1.153712, 0.018934),
    (-0.861771, 0.016437),
    (-2.435003, 0.023738),
    (1.669979, 0.025844),
    (-0.038251, 0.022955),
    (-2.077422, 0.026517),
    (2.535568, 0.016137),
    (0.381557, 0.019043),
    (-1.777410, 0.005909),
    (-2.806883, 0.004954),
    (-2.402695, 0.004148),
    (1.177741, 0.008414),
    (0.686010, 0.002342),
    (-2.218536, 0.007367),
    (2.094426, 0.000964),
    (-0.329995, 0.002993),
    (2.758520, 0.007190),
    (0.355816, 0.004623),
    (-0.718743, 0.012006),
    (-2.978494, 0.012779),
    (1.823221, 0.016969),
    (-0.374246, 0.017246),
    (-1.855197, 0.013719),
    (2.569799, 0.020346),
    (0.950257, 0.011336),
    (-0.891021, 0.019955),
    (-2.850732, 0.010539),
    (1.951734, 0.015623),
    (-0.659499, 0.013793),
    (-2.253083, 0.007835),
    (1.064620, 0.016489),
    (-2.078275, 0.004842),
    (-2.864659, 0.013353),
    (1.054523, 0.012054),
    (-0.568416, 0.008741),
    (-2.394698, 0.012917),
    (2.467450, 0.004565),
    (0.834337, 0.011792),
    (-0.387256, 0.004284),
    (-2.110722, 0.011005),
    (2.499033, 0.009307),
    (1.195120, 0.013471),
    (-1.032707, 0.013787),
    (-2.389564, 0.014752),
    (1.636916, 0.015542),
    (0.182477, 0.011612),
    (-2.168347, 0.015247),
    (1.450056, 0.011909),
    (0.597123, 0.005222),
    (-2.555221, 0.016810),
    (1.490924, 0.006322),
    (-0.050747, 0.014227),
    (-2.356384, 0.010249),
    (2.740099, 0.009864),
    (0.644172, 0.015498),
    (-0.163110, 0.006803),
    (-2.615607, 0.016542),
    (2.162992, 0.005114),
    (0.838618, 0.011953),
    (-1.250131, 0.009075),
    (-2.149929, 0.007817),
    (1.686219, 0.011521),
    (1.129477, 0.008244),
    (-1.754864, 0.011827),
    (-2.481851, 0.001313),
    (1.772798, 0.010100),
    (-1.143400, 0.009139),
    (1.069680, 0.001378),
    (1.691365, 0.014656),
    (-1.436149, 0.011189),
    (-2.584558, 0.011946),
    (1.263058, 0.015261),
    (-0.294249, 0.010395),
    (-2.207110, 0.015410),
    (1.250137, 0.008043),
    (1.664493, 0.015589),
    (-1.230026, 0.011853),
    (-1.032747, 0.007750),
    (2.559492, 0.016638),
    (0.283305, 0.007798),
    (-0.286640, 0.013606),
    (3.138036, 0.011717),
    (2.219444, 0.004159),
    (0.045855, 0.006495),
    (-1.043279, 0.003031),
    (2.334486, 0.004280),
    (-1.021129, 0.005719),
    (0.966879, 0.008644),
    (3.003807, 0.016302),
    (-0.556147, 0.013963),
    (0.562439, 0.016062),
    (-2.776817, 0.025509),
    (-0.069181, 0.010889),
    (0.910897, 0.026592),
    (-2.321026, 0.026356),
    (-1.037338, 0.008378),
    (1.593471, 0.021752),
    (-1.219322, 0.009987),
    (-0.624999, 0.012048),
    (2.882770, 0.015709),
    (1.366954, 0.005250),
    (-0.105292, 0.010268),
    (-1.817959, 0.007143),
    (2.004106, 0.007810),
    (-0.889410, 0.002838),
    (0.446960, 0.008149),
    (2.822851, 0.010307),
    (-1.133784, 0.017176),
    (1.116779, 0.017947),
    (-2.795122, 0.022430),
    (-0.188297, 0.024289),
    (1.449360, 0.029602),
    (-2.203271, 0.046105),
    (-0.042800, 0.022265),
    (1.595694, 0.032932),
    (-1.658169, 0.032440),
    (0.268850, 0.016275),
    (2.684837, 0.033003),
    (-0.795709, 0.023023),
    (0.493200, 0.022422),
    (-2.727447, 0.027146),
    (-0.332745, 0.008096),
    (1.297940, 0.017259),
    (-1.881117, 0.015538),
    (-0.466483, 0.010927),
    (2.341332, 0.012867),
    (-1.615305, 0.005735),
    (0.180219, 0.010500),
    (-3.104370, 0.009436),
    (-1.511426, 0.009776),
    (0.302219, 0.008605),
    (2.457079, 0.014031),
    (-0.810193, 0.008821),
    (-0.227662, 0.010657),
    (-2.932519, 0.017782),
    (-0.366104, 0.005260),
    (0.588625, 0.016141),
    (-2.111409, 0.012451),
    (-2.180278, 0.010049),
    (1.750773, 0.011401),
    (-0.210080, 0.005572),
    (-0.808138, 0.011442),
    (-2.998314, 0.011406),
    (2.943152, 0.007620),
    (0.483346, 0.011312),
    (-1.125850, 0.009214),
    (-2.320644, 0.007480),
    (2.273616, 0.007436),
    (0.188846, 0.001111),
    (-0.651320, 0.009244),
    (-1.852649, 0.004510),
    (-2.721881, 0.005559),
    (2.215176, 0.006672),
    (-1.927643, 0.005510),
    (-0.799756, 0.006362),
    (-2.601493, 0.005302),
    (-3.102195, 0.005613),
    (1.892821, 0.008899),
    (-1.029775, 0.003830),
    (-1.348709, 0.008116),
    (3.069039, 0.007510),
    (2.209825, 0.007374),
    (0.609575, 0.009908),
    (-1.674077, 0.011655),
    (-2.378593, 0.006705),
    (2.333471, 0.010785),
    (0.684815, 0.006464),
    (-0.632956, 0.003214),
    (-1.924652, 0.016315),
    (2.422111, 0.011194),
    (1.552213, 0.008131),
    (-0.582806, 0.009730),
    (-2.629737, 0.011156),
    (-2.706614, 0.006823),
    (1.364151, 0.011899),
    (1.474293, 0.003514),
    (-1.383611, 0.010350),
    (2.826458, 0.012067),
    (-2.625092, 0.002808),
    (1.238832, 0.006928),
    (2.793280, 0.002756),
    (-1.495729, 0.004162),
    (-3.013459, 0.010332),
    (1.513204, 0.005472),
    (1.606799, 0.007916),
    (-0.954135, 0.004742),
    (-2.508802, 0.005340),
    (2.657036, 0.012560),
    (1.173716, 0.011549),
    (-0.067705, 0.005927),
    (-2.021272, 0.009563),
    (2.942966, 0.009065),
    (2.045150, 0.012036),
    (0.583795, 0.014453),
    (-1.916609, 0.011930),
    (2.933518, 0.012803),
    (1.498952, 0.018855),
    (0.223287, 0.009682),
    (1.429068, 0.001926),
    (-2.701017, 0.006845),
    (1.754537, 0.008864),
    (0.848857, 0.009277),
    (-0.160486, 0.005048),
    (1.969652, 0.002587),
    (-0.587958, 0.002026),
    (1.749367, 0.004860),
    (1.167882, 0.007672),
    (0.137137, 0.004542),
    (-2.022872, 0.002383),
    (-3.059067, 0.001461),
    (1.800648, 0.012229),
    (0.536900, 0.009315),
    (-0.460240, 0.009694),
    (-2.474931, 0.006527),
    (1.544003, 0.012259),
    (1.390565, 0.013886),
    (-0.179863, 0.016113),
    (-1.637187, 0.011250),
    (2.197069, 0.009506),
    (0.750851, 0.017580),
    (-0.840351, 0.013952),
    (-1.304281, 0.005831),
    (1.661716, 0.000605),
    (1.483553, 0.006130),
    (0.361527, 0.008261),
    (-0.737669, 0.007036),
    (-0.800714, 0.004452),
    (-0.683277, 0.000479),
    (1.034711, 0.004375),
    (-0.232359, 0.010707),
    (-0.502978, 0.010404),
    (3.077760, 0.001588),
    (-0.809049, 0.004182),
    (0.359340, 0.001374),
    (-0.280431, 0.015320),
    (-1.086650, 0.013838),
    (-2.276931, 0.017769),
    (1.295789, 0.006788),
    (-0.178648, 0.011662),
    (-0.935049, 0.014627),
    (-2.656260, 0.016156),
    (3.064556, 0.005959),
    (-0.192253, 0.009786),
    (-1.431308, 0.011177),
    (-1.881407, 0.007919),
    (-2.566245, 0.009596),
    (2.123103, 0.002708),
    (0.446634, 0.004951),
    (-1.813001, 0.014379),
    (-2.450527, 0.009686),
    (-2.910220, 0.007977),
    (0.956769, 0.005052),
    (-1.828786, 0.005648),
    (-2.268629, 0.006765),
    (2.896676, 0.006455),
    (-2.725451, 0.007089),
    (2.799100, 0.008563),
    (-0.820300, 0.009334),
    (-2.338381, 0.008545),
    (2.519095, 0.013371),
    (1.967571, 0.011640),
    (0.662514, 0.002554),
    (-1.543136, 0.003535),
    (-3.070337, 0.008904),
    (2.490998, 0.008709),
    (1.061812, 0.007022),
    (0.731014, 0.004927),
    (-3.011240, 0.002914),
    (2.944382, 0.011803),
    (1.169483, 0.008612),
    (0.472534, 0.006894),
    (-0.510018, 0.001748),
    (-2.430389, 0.001881),
    (2.424214, 0.004316),
    (1.467618, 0.014510),
    (-0.793080, 0.009789),
    (-1.807004, 0.006814),
    (-0.243459, 0.001051),
    (1.619014, 0.009549),
    (1.666748, 0.005710),
    (-0.425074, 0.003792),
    (-0.074571, 0.001450),
    (1.026645, 0.000203),
    (1.532059, 0.004341),
    (0.113030, 0.011603),
    (-0.640805, 0.008299),
    (-3.000093, 0.005091),
    (-1.950800, 0.005659),
    (0.688300, 0.002151),
    (0.266956, 0.007644),
    (-1.274828, 0.007065),
    (-2.438742, 0.012457),
    (1.958502, 0.007270),
    (1.504025, 0.005360),
    (-0.405838, 0.005159),
    (-1.341091, 0.010345),
    (2.154357, 0.007742),
    (1.891919, 0.008181),
    (-0.161841, 0.008758),
    (-1.218408, 0.018597),
    (-2.017286, 0.010013),
    (2.507727, 0.014811),
    (-0.452774, 0.006439),
    (-2.799268, 0.002591),
    (-2.982645, 0.003346),
    (-2.803508, 0.009311),
    (2.375785, 0.006048),
    (0.744638, 0.008458),
    (1.548187, 0.004995),
    (-2.117456, 0.004329),
    (-2.725635, 0.001796),
    (1.858467, 0.005028),
    (0.123388, 0.005403),
    (-0.669412, 0.006286),
    (-1.022249, 0.005441),
    (-2.998732, 0.016768),
    (2.480040, 0.006820),
    (0.076842, 0.007251),
    (0.117858, 0.003949),
    (-3.096120, 0.013710),
    (2.482132, 0.009762),
    (1.359454, 0.018426),
    (-0.024962, 0.013218),
    (-1.761324, 0.008156),
    (-0.480600, 0.004093),
    (1.353839, 0.012206),
    (-0.120956, 0.005001),
    (-1.274967, 0.013150),
    (-1.873681, 0.007754),
    (3.013517, 0.007480),
    (2.657123, 0.007336),
    (1.096439, 0.006774),
    (1.156768, 0.000364),
    (3.106839, 0.007743),
    (0.496796, 0.003916),
    (1.382477, 0.011614),
    (0.701282, 0.013753),
    (-0.947456, 0.012979),
    (-0.931273, 0.012748),
    (-2.885903, 0.002991),
    (-1.889114, 0.001551),
    (-0.847000, 0.012671),
    (-2.213339, 0.014788),
    (2.920616, 0.026342),
    (2.612300, 0.009167),
    (1.167179, 0.019729),
    (0.469060, 0.009750),
    (-2.425347, 0.004581),
    (-0.069926, 0.006234),
    (0.878284, 0.010073),
    (-0.533558, 0.009332),
    (-0.848118, 0.016859),
    (-2.254928, 0.010073),
    (-2.900103, 0.014136),
    (-2.207207, 0.007850),
    (1.449814, 0.007808),
    (2.836850, 0.009565),
    (-2.928339, 0.014801),
    (1.604627, 0.008206),
    (1.688385, 0.023455),
    (0.433649, 0.018871),
    (-0.157528, 0.025363),
    (-0.708468, 0.008921),
    (-2.501048, 0.014067),
    (-1.457573, 0.016880),
    (0.002601, 0.008458),
    (-2.617004, 0.015805),
    (-3.028169, 0.024699),
    (1.862379, 0.010726),
    (1.712516, 0.021282),
    (0.165311, 0.011207),
    (0.309119, 0.010703),
    (1.775844, 0.007067),
    (2.242359, 0.000561),
    (-0.123465, 0.017758),
    (-0.081680, 0.019503),
    (-1.929482, 0.020479),
    (-1.964497, 0.018395),
    (-3.034283, 0.009086),
    (2.945813, 0.017095),
    (-0.100866, 0.008158),
    (2.049533, 0.020930),
    (2.430454, 0.020484),
    (1.385283, 0.006449),
    (0.216197, 0.034552),
    (-0.104545, 0.015521),
    (-1.620661, 0.021470),
    (-1.618887, 0.016438),
    (2.988085, 0.009732),
    (-2.744461, 0.005219),
    (-0.766966, 0.014709),
    (2.535248, 0.019925),
    (-2.818892, 0.022662),
    (1.639186, 0.014159),
    (1.037378, 0.022081),
    (0.435406, 0.003523),
    (-0.493158, 0.019721),
    (-2.870523, 0.001540),
    (-1.780647, 0.002527),
    (-0.379825, 0.016839),
    (0.099006, 0.004458),
    (-2.488508, 0.030666),
    (-2.365369, 0.023237),
    (1.775053, 0.030267),
    (1.698400, 0.019208),
    (-0.273554, 0.016848),
    (-0.238755, 0.020007),
    (3.089092, 0.016765),
    (-0.666916, 0.010575),
    (1.026498, 0.017324),
    (-1.917624, 0.005394),
    (-1.685984, 0.025415),
    (2.639401, 0.003283),
    (2.825404, 0.020082),
    (0.967609, 0.013579),
    (0.619964, 0.012284),
    (-1.198885, 0.008076),
    (-2.492470, 0.007807),
    (1.418367, 0.009738),
    (2.125101, 0.009313),
    (-0.814451, 0.022646),
    (-0.723340, 0.017781),
    (3.113763, 0.017637),
    (-3.070953, 0.025867),
    (1.112170, 0.036253),
    (0.870648, 0.007310),
    (-0.913744, 0.026764),
    (-2.089362, 0.011351),
    (-3.134564, 0.018707),
    (-2.636704, 0.002625),
    (0.632013, 0.015818),
    (-0.079064, 0.005425),
    (3.029248, 0.010138),
    (-2.832384, 0.010115),
    (1.304247, 0.014592),
    (-0.333515, 0.010596),
    (-0.401458, 0.017964),
    (-1.889945, 0.019876),
    (-2.840097, 0.019426),
    (2.308458, 0.017782),
    (1.669516, 0.027893),
    (-0.124755, 0.011197),
    (-0.963053, 0.016073),
    (-0.972486, 0.016224),
    (2.270090, 0.015079),
    (0.957188, 0.007610),
    (0.556475, 0.006606),
    (-1.596236, 0.024728),
    (-2.670785, 0.022888),
    (2.449047, 0.021683),
    (1.802181, 0.022890),
    (0.343166, 0.027214),
    (-0.154647, 0.020938),
    (-0.883959, 0.013247),
    (-2.451901, 0.030163),
    (-2.564133, 0.008217),
    (2.178329, 0.009809),
    (0.560889, 0.015182),
    (-2.679149, 0.000298),
    (-3.000453, 0.006136),
    (-3.071339, 0.005380),
    (1.241578, 0.017139),
    (-0.428480, 0.013191),
    (-0.907950, 0.017550),
    (-1.681389, 0.032637),
    (2.278451, 0.030423),
    (2.290747, 0.040781),
    (0.845083, 0.029002),
    (-0.580136, 0.040663),
    (-1.237968, 0.032108),
    (-2.195400, 0.027167),
    (2.871536, 0.048939),
    (1.692682, 0.027198),
    (1.194002, 0.034684),
    (-0.124194, 0.040613),
    (-1.413807, 0.028034),
    (-1.672984, 0.028781),
    (-2.751100, 0.023928),
    (2.275336, 0.039920),
    (1.988022, 0.016290),
    (0.736942, 0.029480),
    (-0.664138, 0.043862),
    (-1.581842, 0.011322),
    (-2.461976, 0.025181),
    (2.856333, 0.030501),
    (1.519329, 0.027477),
    (0.882273, 0.013844),
    (-0.006246, 0.032186),
    (-1.749454, 0.043611),
    (-0.665003, 0.005105),
    (2.739442, 0.023571),
    (1.972609, 0.023346),
    (0.345899, 0.003327),
    (-0.339579, 0.012587),
    (-0.078434, 0.017572),
    (-2.971404, 0.012983),
    (-1.824053, 0.002656),
    (-3.098060, 0.010436),
    (1.018654, 0.008165),
    (-0.282498, 0.002256),
    (-1.431505, 0.006036),
    (-0.211732, 0.010385),
    (2.433597, 0.012481),
    (-2.343927, 0.005618),
    (-2.529214, 0.011994),
    (-0.155662, 0.016529),
    (0.831765, 0.017526),
    (2.498210, 0.013310),
    (-1.789128, 0.008159),
    (2.657653, 0.004774),
    (-0.964643, 0.009141),
    (2.875796, 0.005641),
    (-1.421773, 0.007052),
    (0.902084, 0.008071),
    (1.886124, 0.011966),
    (-2.523773, 0.008458),
    (-1.643418, 0.004568),
    (-0.553165, 0.012807),
    (1.216386, 0.012087),
    (2.877864, 0.008202),
    (-2.186153, 0.007479),
    (-2.732498, 0.001045),
    (-0.981269, 0.002964),
    (1.468041, 0.004382),
    (-1.139650, 0.009345),
    (1.246097, 0.011469),
    (3.085302, 0.012485),
    (-1.870109, 0.012231),
    (-0.415539, 0.012815),
    (0.316271, 0.018384),
    (1.541687, 0.019456),
    (-3.000978, 0.016868),
    (-1.799590, 0.007703),
    (-1.613286, 0.004435),
    (1.559408, 0.002328),
    (1.614639, 0.003959),
    (-0.632320, 0.003075),
    (1.373332, 0.006605),
    (-2.705575, 0.009401),
    (-1.044450, 0.009187),
    (-0.029689, 0.009730),
    (1.454271, 0.010799),
    (2.854184, 0.013712),
    (-1.876955, 0.014353),
    (-0.018883, 0.012816),
    (1.483887, 0.004635),
    (2.268894, 0.006561),
    (-2.266230, 0.006731),
    (-0.005462, 0.005775),
    (2.218540, 0.006343),
    (-1.846640, 0.006475),
    (0.004220, 0.011008),
    (1.114132, 0.008654),
    (2.502850, 0.012490),
    (-2.357529, 0.020257),
    (-0.945919, 0.013513),
    (0.610471, 0.015460),
    (2.184960, 0.011661),
    (-2.445714, 0.005326),
    (-0.964688, 0.005055),
    (0.779604, 0.007468),
    (-3.034763, 0.006996),
    (-0.662777, 0.006062),
    (1.528670, 0.007354),
    (-3.092411, 0.011308),
    (-1.499250, 0.010552),
    (-0.425808, 0.014347),
    (1.158571, 0.019304),
    (2.848671, 0.020528),
    (-2.006711, 0.014821),
    (-0.532891, 0.012653),
    (0.810207, 0.012078),
    (2.139085, 0.010063),
    (-2.375468, 0.009351),
    (-0.401713, 0.008611),
    (-3.038073, 0.005406),
    (-1.367497, 0.004931),
    (0.169334, 0.008811),
    (1.539817, 0.014158),
    (2.982705, 0.014154),
    (-1.922299, 0.014675),
    (-0.321341, 0.016048),
    (1.490915, 0.012180),
    (-2.882949, 0.007481),
    (-1.508230, 0.008543),
    (0.271104, 0.007726),
    (1.538959, 0.008441),
    (-2.741211, 0.007328),
    (0.414418, 0.005440),
    (2.649084, 0.014892),
    (-2.116106, 0.015394),
    (-1.086766, 0.017846),
    (0.346836, 0.021276),
    (1.826549, 0.019205),
    (-2.795117, 0.014137),
    (-1.021809, 0.017161),
    (0.935601, 0.011869),
    (2.378379, 0.010715),
    (-2.471747, 0.010934),
    (-0.822631, 0.006604),
    (1.305300, 0.003135),
    (-1.152868, 0.003202),
    (0.312300, 0.009698),
    (1.841463, 0.014612),
    (-2.918240, 0.013205),
    (-1.626119, 0.015366),
    (0.086452, 0.014568),
    (2.018242, 0.011200),
    (-2.431246, 0.010137),
    (-0.648919, 0.015040),
    (1.080542, 0.014506),
    (2.305889, 0.011789),
    (-3.099228, 0.008680),
    (-1.191924, 0.002633),
    (2.838613, 0.009457),
    (-1.642647, 0.014904),
    (-0.182065, 0.016792),
    (1.387655, 0.014098),
    (3.081173, 0.011837),
    (-1.827214, 0.011780),
    (0.285390, 0.012482),
    (2.291969, 0.012134),
    (-2.325394, 0.010367),
    (-0.926333, 0.008797),
    (0.641480, 0.009396),
    (2.494812, 0.002440),
    (1.734685, 0.002197),
    (2.316655, 0.007034),
    (-2.660194, 0.014506),
    (-1.100379, 0.020667),
    (0.347181, 0.019783),
    (1.909475, 0.019963),
    (-2.614777, 0.015363),
    (-0.889908, 0.012733),
    (0.952178, 0.014466),
    (2.685267, 0.019283),
    (-1.684937, 0.015975),
    (-0.226192, 0.008799),
    (1.023562, 0.003416),
    (-1.769702, 0.003193),
    (0.627831, 0.008522),
    (2.307717, 0.013562),
    (-2.395454, 0.017316),
    (-0.670688, 0.018659),
    (0.984116, 0.015749),
    (2.558000, 0.011234),
    (-1.879153, 0.009555),
    (0.251555, 0.009756),
    (2.392947, 0.008955),
    (-2.053492, 0.009007),
    (-0.100937, 0.008648),
    (2.503164, 0.004783),
    (-1.202058, 0.006454),
    (0.438684, 0.011637),
    (1.803492, 0.020967),
    (-2.891402, 0.024482),
    (-1.288930, 0.020657),
    (0.271655, 0.016618),
    (1.978280, 0.012156),
    (-2.116466, 0.007061),
    (-0.056130, 0.003439),
    (2.387953, 0.005039),
    (-2.091630, 0.007339),
    (0.014397, 0.006687),
    (2.196513, 0.004815),
    (-2.108716, 0.006045),
    (0.283870, 0.009065),
    (2.174300, 0.011961),
    (-2.397717, 0.012483),
    (-1.110196, 0.015372),
    (0.583291, 0.017432),
    (2.306790, 0.011385),
    (-2.183322, 0.005009),
    (2.084385, 0.002135),
    (-2.659212, 0.007928),
    (-0.768047, 0.009673),
    (0.622814, 0.007488),
    (2.083533, 0.009532),
    (-2.302558, 0.011415),
    (0.040391, 0.012140),
    (1.899979, 0.009679),
    (-2.706321, 0.010432),
    (-1.112214, 0.011620),
    (0.644674, 0.008852),
    (1.836629, 0.005513),
    (3.013100, 0.003971),
    (3.141015, 0.004691),
    (-1.748644, 0.006994),
    (-0.067821, 0.008681),
    (1.291646, 0.007658),
    (3.104658, 0.009490),
    (-1.249778, 0.007433),
    (0.599853, 0.004045),
    (2.156539, 0.004752),
    (-2.193857, 0.009601),
    (-0.326969, 0.009761),
    (0.859347, 0.005141),
    (1.551062, 0.005807),
    (2.645109, 0.006177),
    (-2.250609, 0.006683),
    (-0.607450, 0.007733),
    (0.607757, 0.006203),
    (1.903581, 0.009157),
    (-2.629869, 0.009204),
    (-1.243881, 0.005559),
    (-0.377387, 0.004650),
    (1.521749, 0.004399),
    (-2.455439, 0.001812),
    (0.737729, 0.000535),
    (1.877913, 0.002441),
    (2.887348, 0.002044),
    (-2.481070, 0.003444),
    (-0.950766, 0.007617),
    (0.739826, 0.007587),
    (2.005961, 0.005814),
    (-3.006943, 0.009090),
    (-1.577352, 0.010064),
    (-0.450437, 0.009887),
    (0.987892, 0.010808),
    (2.448941, 0.007027),
    (-2.731022, 0.004049),
    (-1.415768, 0.001465),
    (1.189556, 0.001010),
    (-0.684007, 0.001240),
    (-2.064701, 0.002280),
    (-0.108202, 0.003753),
    (1.266197, 0.005111),
    (2.799894, 0.007433),
    (-1.653670, 0.008900),
    (-0.128837, 0.006093),
    (1.163123, 0.005880),
    (2.489515, 0.007624),
    (-2.125931, 0.007249),
    (-0.969955, 0.007309),
    (0.638060, 0.005414),
    (1.031126, 0.004848),
    (2.669961, 0.005593),
    (-1.647124, 0.004497),
    (1.180023, 0.003505),
    (2.393215, 0.001749),
    (-2.517648, 0.004660),
    (-0.527564, 0.006003),
    (1.311366, 0.005027),
    (2.657115, 0.005304),
    (-2.265062, 0.004181),
    (-1.332645, 0.006042),
    (0.156488, 0.007975),
    (1.943376, 0.007161),
    (3.043485, 0.004315),
    (-2.086503, 0.005953),
    (-0.209507, 0.005389),
    (1.420004, 0.003207),
    (2.989309, 0.003000),
    (-1.012346, 0.002737),
    (0.605006, 0.002955),
    (2.121151, 0.002600),
    (-2.232318, 0.005097),
    (-0.096533, 0.006499),
    (1.298918, 0.006453),
    (2.573550, 0.008654),
    (-2.468387, 0.008750),
    (-1.401961, 0.007847),
    (0.032062, 0.009222),
    (1.738717, 0.006813),
    (2.941914, 0.003677),
    (-1.796701, 0.004193),
    (0.367501, 0.004357),
    (2.337603, 0.002949),
    (-2.556960, 0.002624),
    (-0.876652, 0.002688),
    (2.070060, 0.001561),
    (-1.850050, 0.000772),
    (-1.256374, 0.003083),
    (0.673215, 0.004791),
    (1.975783, 0.005619),
    (2.934833, 0.006915),
    (-1.787673, 0.011109),
    (-0.283264, 0.007521),
    (0.868027, 0.006345),
    (1.789689, 0.004575),
    (-2.918107, 0.006021),
    (-1.093997, 0.007353),
    (1.204211, 0.006959),
    (-3.042677, 0.002060),
    (2.342377, 0.001432),
    (-1.618970, 0.003519),
    (1.763317, 0.002815),
    (-2.223332, 0.002714),
    (-0.673388, 0.004046),
    (0.712532, 0.004572),
    (2.208036, 0.005534),
    (-2.833695, 0.005968),
    (-1.268694, 0.006212),
    (0.015293, 0.005493),
    (1.551489, 0.006782),
    (-2.818712, 0.007732),
    (-0.618519, 0.005478),
    (0.295371, 0.003652),
    (1.485911, 0.006093),
    (-3.005026, 0.007455),
    (-1.286360, 0.004503),
    (0.731776, 0.003509),
    (-2.900491, 0.004762),
    (-1.197640, 0.004297),
    (0.233994, 0.004151),
    (1.215484, 0.005832),
    (3.029973, 0.006484),
    (-1.882429, 0.006295),
    (-0.034115, 0.006757),
    (1.731259, 0.004487),
    (2.940406, 0.001432),
    (-2.210298, 0.004709),
    (-0.279835, 0.006483),
    (1.732215, 0.005585),
    (-2.898927, 0.003915),
    (-1.169196, 0.002041),
    (-1.578146, 0.000930),
    (0.723721, 0.002339),
    (-2.632589, 0.003063),
    (-0.182181, 0.006427),
    (1.487905, 0.006156),
    (2.909522, 0.007388),
    (-1.685562, 0.007350),
    (0.027620, 0.005206),
    (0.590987, 0.002823),
    (2.301832, 0.005597),
    (-2.017197, 0.006381),
    (0.099264, 0.006025),
    (2.111739, 0.004808),
    (-2.041138, 0.002450),
    (-3.125005, 0.002229),
    (-0.511839, 0.005883),
    (1.735294, 0.005853),
    (-1.961754, 0.005533),
    (0.821529, 0.003765),
    (2.603503, 0.002532),
    (-1.837875, 0.001915),
    (-1.787050, 0.002780),
    (-0.036301, 0.005819),
    (1.912359, 0.008265),
    (-2.587262, 0.007312),
    (-0.902011, 0.007366),
    (0.737505, 0.005334),
    (2.780395, 0.003488),
    (2.200475, 0.002712),
    (-1.692023, 0.005908),
    (0.508861, 0.006975),
    (3.111280, 0.006281),
    (-0.869133, 0.003320),
    (1.496762, 0.002354),
    (-1.228771, 0.002369),
    (1.942458, 0.002177),
    (-1.422291, 0.004112),
    (1.001858, 0.006492),
    (-2.972163, 0.006237),
    (-1.052353, 0.004655),
    (1.029202, 0.001871),
    (2.163158, 0.000206),
    (1.889167, 0.003876),
    (-1.879761, 0.008088),
    (0.367196, 0.009380),
    (2.599076, 0.008723),
    (-1.269835, 0.005745),
    (1.443796, 0.001597),
    (-1.127258, 0.003238),
    (1.439405, 0.006337),
    (-2.454133, 0.007488),
    (0.004031, 0.006827),
    (2.590908, 0.005777),
    (-1.590617, 0.003837),
    (0.446827, 0.002289),
    (2.549185, 0.000825),
    (1.346162, 0.002428),
    (-2.395865, 0.006347),
    (-0.219719, 0.007906),
    (2.061024, 0.008630),
    (-1.654549, 0.005770),
    (0.863700, 0.003635),
    (-2.379551, 0.005663),
    (0.787834, 0.006318),
    (-2.793718, 0.008728),
    (-0.168306, 0.012959),
    (2.420706, 0.013026),
    (-1.556520, 0.010869),
    (1.073216, 0.008315),
    (-2.410438, 0.004396),
    (0.412885, 0.004179),
    (-3.064956, 0.006665),
    (-0.489317, 0.006754),
    (1.875366, 0.007328),
    (-2.057130, 0.005629),
    (-0.030259, 0.003078),
    (2.790055, 0.003251),
    (-0.062525, 0.003286),
    (2.512455, 0.003912),
    (-0.884928, 0.005938),
    (1.986830, 0.007115),
    (-1.849603, 0.007190),
    (0.773831, 0.007088),
    (-2.845211, 0.005953),
    (-0.070934, 0.005476),
    (2.815192, 0.007890),
    (-0.610607, 0.008724),
    (1.942186, 0.009075),
    (-1.773846, 0.009905),
    (0.737567, 0.007973),
    (2.742942, 0.005393),
    (-0.593169, 0.003329),
    (2.634378, 0.003799),
    (-1.211193, 0.005426),
    (1.518468, 0.006319),
    (-2.013510, 0.005045),
    (0.629098, 0.005228),
    (-3.059953, 0.004823),
    (-0.354172, 0.003691),
    (2.646689, 0.003663),
    (-0.601205, 0.006032),
    (1.978577, 0.007268),
    (-1.681437, 0.006899),
    (1.110758, 0.005440),
    (-2.586612, 0.004949),
    (-0.069491, 0.004576),
    (2.450993, 0.003444),
    (-0.953807, 0.003534),
    (1.800339, 0.008582),
    (-2.033313, 0.008225),
    (0.280479, 0.007848),
    (-3.140144, 0.006774),
    (-0.477012, 0.007008),
    (1.894243, 0.007525),
    (-1.525579, 0.006006),
    (1.555930, 0.005205),
    (-1.797324, 0.007424),
    (1.056079, 0.008129),
    (-2.511099, 0.006592),
    (0.225244, 0.005978),
    (2.997701, 0.005554),
    (-0.744373, 0.004949),
    (1.754549, 0.004151),
    (-1.048040, 0.003739),
    (1.549869, 0.005674),
    (-2.360199, 0.005720),
    (0.191176, 0.004077),
    (2.833304, 0.003109),
    (-0.994589, 0.006131),
    (1.367842, 0.006736),
    (-2.246833, 0.007068),
    (0.591751, 0.007725),
    (-2.918337, 0.007696),
    (-0.318915, 0.008305),
    (2.413047, 0.006925),
    (-1.090390, 0.005282),
    (1.653332, 0.006048),
    (-1.795349, 0.007286),
    (0.981907, 0.005802),
    (-2.224270, 0.005742),
    (0.601405, 0.008352),
    (-3.136031, 0.006254),
    (-0.672838, 0.003904),
    (2.627831, 0.003516),
    (-1.001459, 0.004789),
    (1.441325, 0.005416),
    (-1.981875, 0.007432),
    (0.612097, 0.006623),
    (-2.860545, 0.006505),
    (-0.197797, 0.006459),
    (2.216961, 0.006927),
    (-1.363242, 0.006150),
    (1.365637, 0.006165),
    (-2.349893, 0.007874),
    (0.467939, 0.006818),
    (-2.664999, 0.005986),
    (-0.221525, 0.007926),
    (2.308217, 0.006516),
    (-1.567246, 0.003088),
    (2.112915, 0.002559),
    (-1.637185, 0.005150),
    (1.119044, 0.004966),
    (-2.516510, 0.006121),
    (0.317429, 0.005617),
    (2.932968, 0.004323),
    (-0.630148, 0.004799),
    (2.000078, 0.005825),
    (-1.853510, 0.005058),
    (1.165137, 0.006180),
    (-2.191819, 0.009567),
    (0.343026, 0.008322),
    (-2.970975, 0.008880),
    (-0.236809, 0.010801),
    (2.056391, 0.010149),
    (-1.874407, 0.006287),
    (1.786730, 0.004333),
    (-1.816825, 0.005382),
    (0.902133, 0.006136),
    (-2.605180, 0.004986),
    (0.452345, 0.004045),
    (-2.919416, 0.003930),
    (-0.111513, 0.003608),
    (1.839260, 0.004065),
    (-2.261078, 0.003728),
    (-0.079022, 0.001118),
    (-2.727332, 0.002324),
    (0.405264, 0.004364),
    (-3.064241, 0.003109),
    (-0.147838, 0.003877),
    (2.420777, 0.008619),
    (-1.712827, 0.008019),
    (0.932571, 0.006623),
    (-2.093262, 0.007361),
    (0.546241, 0.009915),
    (-3.133750, 0.007785),
    (-0.004678, 0.005364),
    (3.020274, 0.004797),
    (-0.357410, 0.006257),
    (2.283870, 0.006534),
    (-1.522900, 0.005574),
    (1.139289, 0.005096),
    (-1.907696, 0.003807),
    (0.654517, 0.004331),
    (-2.957293, 0.004494),
    (0.381820, 0.002686),
    (2.962826, 0.002708),
    (-0.843245, 0.004694),
    (1.320052, 0.002783),
    (-1.437178, 0.002253),
    (1.390591, 0.006788),
    (-2.436724, 0.007571),
    (-0.170542, 0.006912),
    (3.119287, 0.003398),
    (0.139306, 0.005262),
    (2.353766, 0.006588),
    (-1.393906, 0.007757),
    (1.210967, 0.004735),
    (-2.160790, 0.004337),
    (1.181633, 0.005216),
    (-2.199951, 0.005485),
    (0.132747, 0.005230),
    (3.075671, 0.003417),
    (-0.376157, 0.002271),
    (2.230627, 0.003253),
    (-1.536577, 0.003392),
    (1.723153, 0.001764),
    (-1.757771, 0.005116),
    (0.725508, 0.005743),
    (2.976327, 0.004325),
    (-0.176844, 0.001902),
    (-2.578190, 0.005905),
    (-0.625181, 0.007566),
    (1.839015, 0.009121),
    (-1.671071, 0.005960),
    (1.406626, 0.005468),
    (-2.040470, 0.007804),
    (0.898504, 0.007575),
    (-2.857850, 0.006413),
    (0.000885, 0.003585),
    (-2.906196, 0.004132),
    (-0.291775, 0.004763),
    (2.224539, 0.005547),
    (-1.330701, 0.003412),
    (1.710446, 0.003736),
    (-1.792179, 0.003007),
    (1.762937, 0.002191),
    (-1.540178, 0.000969),
    (0.879417, 0.003627),
    (2.693853, 0.003616),
    (-1.734752, 0.004369),
    (1.060796, 0.002176),
    (-0.325960, 0.002110),
    (1.498159, 0.006250),
    (-2.202201, 0.007741),
    (0.295031, 0.005620),
    (2.718780, 0.004715),
    (0.024639, 0.005119),
    (2.611827, 0.005896),
    (-1.068785, 0.007075),
    (1.534754, 0.005855),
    (-1.535524, 0.003978),
    (1.240752, 0.004524),
    (-1.706956, 0.004388),
    (1.169620, 0.003190),
    (-2.280903, 0.003858),
    (0.095546, 0.005359),
    (2.458216, 0.002920),
    (-1.207540, 0.001998),
    (3.101336, 0.003559),
    (-0.730118, 0.005323),
    (1.484221, 0.005648),
    (-2.230809, 0.003131),
    (-0.522593, 0.000370),
    (-1.864403, 0.003054),
    (0.324397, 0.005751),
    (2.571126, 0.005886),
    (-1.282382, 0.006598),
    (2.016808, 0.003037),
    (-1.371875, 0.003475),
    (1.656724, 0.005761),
    (-1.908516, 0.006756),
    (0.717140, 0.003798),
    (-2.760287, 0.004969),
    (0.519875, 0.003865),
    (2.848605, 0.002607),
    (0.109522, 0.002563),
    (-3.089196, 0.004889),
    (-0.797437, 0.004201),
    (1.237813, 0.003210),
    (1.323327, 0.001431),
    (-2.938628, 0.002645),
    (-1.642130, 0.003224),
    (0.395578, 0.003673),
    (2.420234, 0.005338),
    (-1.079151, 0.003552),
    (2.686623, 0.002582),
    (-1.028420, 0.003739),
    (1.691464, 0.008359),
    (-2.126707, 0.005973),
    (0.279593, 0.007055),
    (-2.805481, 0.004373),
    (0.467205, 0.004615),
    (-3.032415, 0.004545),
    (0.126620, 0.006602),
    (-3.043993, 0.006544),
    (-0.632067, 0.006535),
    (2.229855, 0.003992),
    (-0.059954, 0.002705),
    (2.660080, 0.004222),
    (-1.179408, 0.005954),
    (1.451935, 0.003418),
    (-2.821494, 0.001574),
    (1.538704, 0.002931),
    (-1.480040, 0.004367),
    (0.379636, 0.004440),
    (-3.112576, 0.004727),
    (-0.646974, 0.002881),
    (0.663264, 0.002263),
    (-1.794605, 0.002702),
    (1.601358, 0.001597),
    (-2.660448, 0.004732),
    (0.500477, 0.004994),
    (-2.929952, 0.005742),
    (-0.418811, 0.005445),
    (2.526922, 0.004290),
    (-0.167386, 0.002343),
    (2.531049, 0.004676),
    (-0.924313, 0.006978),
    (1.538830, 0.005947),
    (-2.005961, 0.004759),
    (1.903236, 0.004332),
    (-1.615360, 0.005678),
    (0.721364, 0.006173),
    (-2.540787, 0.005090),
    (0.400554, 0.001282),
    (2.646079, 0.003131),
    (0.315932, 0.002228),
    (2.566588, 0.001919),
    (-1.527302, 0.004658),
    (1.174015, 0.005226),
    (-2.925748, 0.004196),
    (-0.077216, 0.006012),
    (3.037813, 0.002902),
    (0.027888, 0.002524),
    (3.076662, 0.005899),
    (-0.422468, 0.007587),
    (1.984916, 0.006964),
    (-1.584300, 0.006539),
    (1.983881, 0.004470),
    (-1.232539, 0.005795),
    (1.492249, 0.008583),
    (-1.972157, 0.007102),
    (0.966929, 0.005324),
    (-2.136533, 0.006175),
    (0.822063, 0.006749),
    (-2.641953, 0.005174),
    (0.115083, 0.008931),
    (3.030651, 0.008478),
    (-0.938280, 0.005944),
    (1.816343, 0.004206),
    (-0.616747, 0.001896),
    (2.991470, 0.002609),
    (-1.693160, 0.004203),
    (0.888075, 0.003609),
    (2.314382, 0.003823),
    (-1.223219, 0.002638),
    (0.227398, 0.000686),
    (-0.195315, 0.000890),
    (2.381000, 0.003896),
    (-1.284505, 0.004590),
    (0.862660, 0.004244),
    (-1.976939, 0.005153),
    (1.288414, 0.004230),
    (-2.522915, 0.004323),
    (0.928973, 0.005079),
    (-2.328944, 0.007273),
    (0.341483, 0.008109),
    (3.079636, 0.009702),
    (-0.061203, 0.006695),
    (2.663814, 0.006578),
    (-0.490768, 0.010161),
    (2.064106, 0.007318),
    (-2.005527, 0.005820),
    (0.686081, 0.003556),
    (-2.343131, 0.001236),
    (-0.578873, 0.001909),
    (-2.917062, 0.003578),
    (0.074569, 0.003029),
    (1.901270, 0.005851),
    (-1.719169, 0.004021),
    (1.001220, 0.002326),
    (-1.943950, 0.004405),
    (1.068318, 0.006335),
    (-2.189155, 0.003535),
    (0.925607, 0.006254),
    (-2.178162, 0.010048),
    (0.416513, 0.008955),
    (-2.880212, 0.007789),
    (0.318818, 0.007491),
    (-2.831514, 0.010588),
    (-0.231580, 0.011526),
    (2.543221, 0.012756),
    (-0.702358, 0.006459),
    (2.181929, 0.006799),
    (-0.909015, 0.008041),
    (1.978144, 0.005712),
    (-1.574180, 0.005132),
    (1.116632, 0.005687),
    (-1.965268, 0.002603),
    (0.043685, 0.000926),
    (-2.143691, 0.003425),
    (0.602865, 0.000325),
    (2.280730, 0.000956),
    (-0.278795, 0.001307),
    (1.927203, 0.004482),
    (-2.219700, 0.006084),
    (0.759318, 0.004928),
    (-2.949222, 0.002349),
    (0.827434, 0.007016),
    (-2.179901, 0.007059),
    (0.046671, 0.008851),
    (2.765262, 0.010219),
    (-0.646788, 0.009130),
    (2.548506, 0.006009),
    (-1.234298, 0.006369),
    (2.398440, 0.005963),
    (-0.676949, 0.004353),
    (1.985202, 0.007651),
    (-1.426030, 0.003449),
    (1.275277, 0.002917),
    (-1.650472, 0.002146),
    (0.828817, 0.002142),
    (-0.600641, 0.002002),
    (0.523861, 0.002273),
    (-2.337105, 0.002974),
    (-1.723817, 0.004549),
    (1.649139, 0.002241),
    (-2.272313, 0.001851),
    (1.146446, 0.004837),
    (-2.471921, 0.007018),
    (1.107662, 0.006809),
    (-2.732156, 0.006323),
    (0.378871, 0.012353),
    (-2.823100, 0.008611),
    (-0.299886, 0.011212),
    (2.828931, 0.009789),
    (-0.585556, 0.009664),
    (2.620945, 0.009029),
    (-0.901193, 0.008510),
    (2.475222, 0.009008),
    (-1.112543, 0.006420),
    (1.940966, 0.009492),
    (-0.785871, 0.004656),
    (1.662130, 0.006364),
    (-1.618875, 0.007786),
    (1.178115, 0.005410),
    (-1.391395, 0.003559),
    (0.745559, 0.003940),
    (-1.979392, 0.003960),
    (-2.470952, 0.002940),
    (-2.905473, 0.001980),
    (-0.713277, 0.000287),
    (1.389506, 0.006207),
    (-2.465633, 0.005340),
    (0.731431, 0.006126),
    (-2.475294, 0.004474),
    (0.558217, 0.007259),
    (-2.382339, 0.003497),
    (-0.222594, 0.006114),
    (-2.768490, 0.007975),
    (0.077643, 0.005947),
    (2.806152, 0.008374),
    (-0.435650, 0.005956),
    (3.055707, 0.007551),
    (-0.052930, 0.007192),
    (2.705044, 0.006852),
    (0.219345, 0.008100),
    (2.905025, 0.006803),
    (-0.685454, 0.008276),
    (3.086303, 0.003025),
    (-0.445050, 0.004105),
    (2.459988, 0.005103),
    (-0.908327, 0.003052),
    (-2.895838, 0.003614),
    (-1.386786, 0.001687),
    (2.224654, 0.003491),
    (0.681992, 0.005961),
    (-2.481558, 0.002625),
    (0.221084, 0.004128),
    (-2.403719, 0.006363),
    (0.543397, 0.005941),
    (-2.493384, 0.005309),
    (0.347403, 0.005369),
    (-2.573925, 0.007564),
    (0.545886, 0.007159),
    (2.963774, 0.009148),
    (-0.032500, 0.005201),
    (-2.818172, 0.003919),
    (0.073040, 0.007795),
    (-3.116969, 0.005736),
    (0.396848, 0.003646),
    (-2.771229, 0.006064),
    (-0.221777, 0.007428),
    (-2.770617, 0.002012),
    (1.255761, 0.002145),
    (2.653884, 0.005472),
    (0.685980, 0.001195),
    (-1.291061, 0.002361),
    (0.196325, 0.001626),
    (-1.260515, 0.001953),
    (1.598883, 0.004738),
    (-1.798852, 0.004845),
    (1.134128, 0.005335),
    (-1.860507, 0.007655),
    (1.596114, 0.006471),
    (-1.826278, 0.007430),
    (1.423057, 0.009911),
    (-1.501802, 0.007279),
    (1.289091, 0.009254),
    (-2.008982, 0.011346),
    (0.981716, 0.007359),
    (-2.075088, 0.006571),
    (0.838840, 0.010345),
    (-2.551542, 0.012883),
    (0.236642, 0.007798),
    (-2.763159, 0.009797),
    (0.417019, 0.012652),
    (2.920209, 0.005354),
    (0.141292, 0.003462),
    (-2.420652, 0.004247),
    (2.203151, 0.002243),
    (-0.689479, 0.003571),
    (2.429053, 0.003145),
    (-0.377931, 0.004983),
    (3.059427, 0.006153),
    (-0.016671, 0.004259),
    (2.603971, 0.005669),
    (-0.132084, 0.004682),
    (2.987909, 0.002662),
    (-0.659562, 0.006090),
    (2.578985, 0.006288),
    (-0.887117, 0.005063),
    (2.489289, 0.008600),
    (-0.595288, 0.013856),
    (2.243735, 0.015771),
    (-0.951556, 0.011377),
    (2.329357, 0.016682),
    (-0.965323, 0.017743),
    (1.786893, 0.007820),
    (-0.940246, 0.009141),
    (2.337012, 0.008677),
    (-1.773512, 0.002309),
    (2.637355, 0.002122),
    (-0.598927, 0.001098),
    (-0.257896, 0.000520),
    (1.357899, 0.002923),
    (-2.081526, 0.001409),
    (0.437337, 0.004022),
    (-2.156194, 0.003292),
    (0.384378, 0.004881),
    (-2.486927, 0.011508),
    (0.511959, 0.007752),
    (-2.912822, 0.009909),
    (0.819049, 0.012646),
    (-2.320524, 0.012832),
    (0.526798, 0.016542),
    (-2.691930, 0.010139),
    (0.996204, 0.011946),
    (-2.356463, 0.014684),
    (-0.382257, 0.007105),
    (-2.232851, 0.005615),
    (1.336313, 0.005978),
    (2.652369, 0.004473),
    (1.136729, 0.003589),
    (-1.126808, 0.002249),
    (0.017050, 0.003304),
    (-1.569801, 0.004431),
    (1.662749, 0.004024),
    (-1.736801, 0.005962),
    (1.760853, 0.005439),
    (-1.151932, 0.005443),
    (2.368236, 0.011270),
    (-0.809509, 0.011175),
    (2.243396, 0.012107),
    (-0.391509, 0.018013),
    (2.628644, 0.016617),
    (-0.927469, 0.021304),
    (2.390688, 0.018217),
    (-0.794633, 0.008697),
    (2.104000, 0.015417),
    (-1.193826, 0.012616),
    (0.855366, 0.006352),
    (-1.245602, 0.005066),
    (1.558583, 0.005879),
    (-2.655182, 0.006139),
    (-0.859922, 0.000513),
    (-1.871552, 0.001704),
    (-1.045674, 0.000801),
    (1.397450, 0.006657),
    (-2.449220, 0.004607),
    (0.765883, 0.008585),
    (-1.767099, 0.011603),
    (1.092472, 0.010668),
    (-2.125767, 0.016845),
    (1.344193, 0.013255),
    (-1.701201, 0.010838),
    (1.519434, 0.020835),
    (-1.611023, 0.018674),
    (1.346543, 0.013407),
    (-1.713417, 0.016642),
    (1.429581, 0.013547),
    (-1.875544, 0.011674),
    (1.042911, 0.007334),
    (-1.871223, 0.003601),
    (1.816709, 0.007355),
    (-2.030642, 0.004647),
    (0.497105, 0.003999),
    (-0.955693, 0.005559),
    (0.975441, 0.002077),
    (-3.061101, 0.001951),
    (3.097061, 0.007037),
    (0.444654, 0.003636),
    (-1.813537, 0.003221),
    (0.792626, 0.013439),
    (-2.183832, 0.015477),
    (0.879901, 0.013382),
    (-2.210864, 0.020772),
    (1.108546, 0.023909),
    (-2.332778, 0.022746),
    (0.701489, 0.021215),
    (-2.127354, 0.015628),
    (0.925775, 0.014996),
    (-2.255936, 0.012826),
    (0.906269, 0.007574),
    (-2.065822, 0.005317),
    (2.280434, 0.004009),
    (-1.380545, 0.003460),
    (1.533324, 0.003816),
    (0.037325, 0.004993),
    (2.621960, 0.003935),
    (-0.994386, 0.006317),
    (-3.096834, 0.009790),
    (-0.521464, 0.009953),
    (2.266560, 0.010843),
    (0.387494, 0.011742),
    (-2.916734, 0.013967),
    (-0.078704, 0.015123),
    (-2.221486, 0.016190),
    (1.197399, 0.020717),
    (-2.275978, 0.029314),
    (1.053666, 0.035146),
    (-1.822391, 0.026878),
    (1.218456, 0.025912),
    (-1.719806, 0.029261),
    (1.843452, 0.021090),
    (-0.971409, 0.016173),
    (2.531883, 0.022485),
    (-0.139400, 0.023342),
    (-2.989347, 0.021609),
    (0.267857, 0.024024),
    (-2.497164, 0.026653),
    (0.941194, 0.023591),
    (-2.004181, 0.021185),
    (1.496925, 0.023957),
    (-1.143925, 0.020098),
    (2.403340, 0.021887),
    (-0.726369, 0.027888),
    (2.900115, 0.020555),
    (0.345381, 0.026743),
    (-2.934115, 0.032729),
    (0.460806, 0.025997),
    (-2.181508, 0.028445),
    (0.950733, 0.030421),
    (-2.059685, 0.024989),
    (1.463195, 0.021275),
    (-1.420206, 0.015518),
    (2.207690, 0.013083),
    (-0.555819, 0.013721),
    (-3.015145, 0.011169),
    (0.536195, 0.014113),
    (-2.369960, 0.014653),
    (1.176145, 0.016657),
    (-1.904002, 0.015838),
    (1.564012, 0.012348),
    (-1.276599, 0.013313),
    (2.181019, 0.010368),
    (-0.479930, 0.009176),
    (2.979795, 0.005024),
    (1.212779, 0.009042),
    (-2.131429, 0.014205),
    (1.083527, 0.007013),
    (-1.004845, 0.016180),
    (1.774227, 0.021986),
    (-1.520848, 0.009472),
    (2.604152, 0.010516),
    (-0.648175, 0.012961),
    (2.947475, 0.005712),
    (0.455704, 0.008647),
    (-2.914149, 0.007366),
    (1.468551, 0.004642),
    (-1.791673, 0.006616),
    (1.728750, 0.001734),
    (-0.335310, 0.004748),
    (-2.960835, 0.003887),
    (0.884622, 0.008631),
    (-2.431349, 0.009074),
    (1.137522, 0.007871),
    (-1.773913, 0.011939),
    (1.380844, 0.012300),
    (-1.662997, 0.012160),
    (1.154092, 0.008514),
    (-1.485611, 0.002246),
    (2.412951, 0.005634),
    (-2.178484, 0.004275),
    (-0.899481, 0.009185),
    (1.426539, 0.012126),
    (-1.624989, 0.005460),
    (2.178024, 0.010755),
    (-1.517159, 0.012467),
    (1.490356, 0.004319),
    (-0.415814, 0.007708),
    (2.052662, 0.009224),
    (-2.139099, 0.004190),
    (-2.398533, 0.001739),
    (-1.447175, 0.001344),
    (-0.270219, 0.003484),
    (2.903557, 0.001635),
    (0.372581, 0.005745),
    (3.110419, 0.007168),
    (0.169662, 0.004034),
    (-2.393003, 0.005844),
    (0.842752, 0.006176),
    (-2.206717, 0.008137),
    (0.680054, 0.006156),
    (-2.177720, 0.002796),
    (1.261772, 0.003392),
    (-2.282764, 0.002707),
    (-0.275730, 0.001968),
    (1.215216, 0.002558),
    (0.604370, 0.001620),
    (2.746625, 0.008265),
    (-1.500121, 0.010607),
    (0.528482, 0.003438),
    (-0.053315, 0.007436),
    (2.125308, 0.010903),
    (-1.905572, 0.005368),
    (-3.131090, 0.003432),
    (-0.860792, 0.007078),
    (1.307629, 0.003890),
    (-0.688081, 0.001778),
    (1.452182, 0.004885),
    (-2.482325, 0.005175),
    (0.980111, 0.004395),
    (-2.251562, 0.007302),
    (0.475667, 0.006879),
    (-2.693757, 0.007127),
    (0.248890, 0.005177),
    (-2.809300, 0.002760),
    (0.106867, 0.003777),
    (2.806548, 0.002873),
    (-0.577785, 0.001984),
    (1.502290, 0.002314),
    (2.783574, 0.001991),
    (-2.531835, 0.005456),
    (-0.963808, 0.006280),
    (0.219015, 0.005255),
    (1.046054, 0.008377),
    (2.750336, 0.009753),
    (-2.119218, 0.004753),
    (-1.606146, 0.006386),
    (0.225890, 0.009431),
    (2.222293, 0.005092),
    (1.674820, 0.001903),
    (-2.993383, 0.004999),
    (-1.046342, 0.003740),
    (2.435322, 0.003281),
    (-1.310593, 0.006172),
    (1.550110, 0.005342),
    (-1.535704, 0.004434),
    (1.512793, 0.004853),
    (-1.138229, 0.004523),
    (1.720751, 0.006601),
    (-2.060269, 0.005671),
    (1.006722, 0.002092),
    (-1.702985, 0.003049),
    (0.958629, 0.002986),
    (-2.293267, 0.003346),
    (0.170014, 0.004541),
    (2.139797, 0.004000),
    (2.217036, 0.004105),
    (-2.524236, 0.010569),
    (-0.708570, 0.011397),
    (0.544984, 0.007238),
    (1.406383, 0.011225),
    (-3.137858, 0.012623),
    (-1.948565, 0.007635),
    (-1.212667, 0.008643),
    (0.237131, 0.008995),
    (1.922721, 0.004144),
    (1.533495, 0.000733),
    (2.507000, 0.003810),
    (-0.920291, 0.002897),
    (2.320445, 0.003129),
    (-0.818982, 0.004810),
    (2.364756, 0.005540),
    (-1.174747, 0.006412),
    (1.349724, 0.004914),
    (-0.748608, 0.002785),
    (2.254363, 0.007241),
    (-1.678157, 0.007246),
    (0.905840, 0.004353),
    (-1.316514, 0.001625),
    (2.109476, 0.004616),
    (-1.548352, 0.008036),
    (0.847348, 0.011879),
    (2.953016, 0.007502),
    (2.106245, 0.005111),
    (-2.197526, 0.017760),
    (-0.142619, 0.017664),
    (1.755882, 0.006857),
    (1.309307, 0.006778),
    (-3.012436, 0.013095),
    (-0.923850, 0.009780),
    (1.645437, 0.002168),
    (-0.050006, 0.006778),
    (2.230230, 0.007535),
    (-1.516806, 0.003604),
    (3.110633, 0.003209),
    (-0.669650, 0.006331),
    (1.646435, 0.005490),
    (-1.996670, 0.001312),
    (-2.888109, 0.002637),
    (-0.523188, 0.005724),
    (1.708077, 0.007210),
    (-2.626506, 0.003453),
    (-2.572271, 0.003412),
    (-0.638159, 0.008052),
    (1.536499, 0.009129),
    (-2.253581, 0.007283),
    (0.224354, 0.002090),
    (-1.085977, 0.005856),
    (1.246169, 0.010502),
    (-2.768164, 0.008329),
    (-0.893476, 0.002459),
    (-0.793566, 0.005228),
    (1.221887, 0.008159),
    (3.131504, 0.006350),
    (-1.828702, 0.001848),
    (-1.732654, 0.005295),
    (0.076106, 0.007194),
    (1.838326, 0.003769),
    (1.829760, 0.003695),
    (-2.516806, 0.008479),
    (-0.402973, 0.007687),
    (1.074794, 0.001457),
    (1.048192, 0.007396),
    (-2.958332, 0.012148),
    (-0.692858, 0.011388),
    (1.584214, 0.005310),
    (0.373493, 0.002305),
    (2.892161, 0.006665),
    (-1.245615, 0.007868),
    (1.014365, 0.005918),
    (3.035888, 0.002834),
    (2.890452, 0.001972),
    (-1.301520, 0.005367),
    (0.952077, 0.004318),
    (-3.074138, 0.001500),
    (-3.057868, 0.001536),
    (-0.666069, 0.003310),
    (1.617476, 0.002704),
    (2.907368, 0.001089),
    (-2.954471, 0.003747),
    (-1.253188, 0.005022),
    (0.281288, 0.003048),
    (0.433739, 0.003339),
    (2.175598, 0.008377),
    (-2.249141, 0.009425),
    (-0.805977, 0.004959),
    (-0.410506, 0.007850),
    (1.244198, 0.012457),
    (-3.094964, 0.011228),
    (-1.311737, 0.003863),
    (-1.168573, 0.004216),
    (0.935848, 0.006478),
    (-2.948909, 0.005869),
    (-0.104360, 0.002806),
    (-3.111688, 0.001488),
    (0.919028, 0.002834),
    (-2.750293, 0.005864),
    (-0.237234, 0.005656),
    (2.729590, 0.003740),
    (0.155355, 0.004060),
    (-3.107729, 0.005305),
    (-0.182160, 0.005160),
    (2.829167, 0.005269),
    (-0.449284, 0.004532),
    (2.600330, 0.006163),
    (-1.212465, 0.007607),
    (1.130976, 0.005244),
    (-0.396300, 0.002967),
    (1.980983, 0.009736),
    (-2.239924, 0.010583),
    (-0.428895, 0.005502),
    (0.047662, 0.004601),
    (1.704997, 0.008768),
    (-2.550566, 0.007833),
    (-0.740959, 0.003773),
    (-0.056954, 0.003400),
    (1.918491, 0.005315),
    (-2.063182, 0.003761),
    (0.980437, 0.001944),
    (-1.803249, 0.001754),
    (1.503793, 0.000545),
    (-1.754681, 0.002300),
    (0.781540, 0.004717),
    (-2.870560, 0.003658),
    (0.590023, 0.002518),
    (-2.677304, 0.003534),
    (0.720276, 0.002848),
    (-2.221589, 0.005040),
    (0.215990, 0.006615),
    (2.500137, 0.004774),
    (-0.960168, 0.002417),
    (-2.771953, 0.000596),
    (0.507877, 0.003161),
    (2.927249, 0.005278),
    (-1.013863, 0.005084),
    (0.628297, 0.002745),
    (1.336011, 0.003831),
    (-3.110401, 0.006677),
    (-0.908972, 0.007343),
    (1.330011, 0.004583),
    (2.526239, 0.000539),
    (-3.114854, 0.004008),
    (-0.666733, 0.006221),
    (1.929025, 0.004447),
    (-1.316285, 0.003466),
    (1.369400, 0.003779),
    (-2.031540, 0.001637),
    (1.940551, 0.003136),
    (-1.718179, 0.005448),
    (0.788359, 0.004806),
    (-2.707455, 0.003729),
    (-0.318321, 0.001560),
    (-0.249391, 0.001921),
    (1.669899, 0.003188),
    (-2.433468, 0.003123),
    (-0.528334, 0.001784),
    (0.985327, 0.001096),
    (2.563205, 0.002185),
    (-1.372920, 0.003718),
    (0.971433, 0.004385),
    (-3.133073, 0.002729),
    (-2.652007, 0.001229),
    (-1.113200, 0.004237),
    (1.131142, 0.005271),
    (-2.909345, 0.004612),
    (-0.690760, 0.002195),
    (-1.238321, 0.001571),
    (1.150078, 0.004507),
    (-2.772393, 0.004013),
    (0.340560, 0.002099),
    (-2.887453, 0.004238),
    (-0.720798, 0.003142),
    (0.483279, 0.000995),
    (0.725291, 0.002567),
    (3.077279, 0.004407),
    (-0.714257, 0.003473),
    (2.480191, 0.002400),
    (-0.042558, 0.002019),
    (-2.894187, 0.003633),
    (-0.070986, 0.005339),
    (2.445351, 0.005368),
    (-1.171812, 0.003440),
    (2.254443, 0.001481),
    (-0.137081, 0.002780),
    (2.686723, 0.004772),
    (-0.983387, 0.006199),
    (1.548473, 0.005512),
    (-2.196762, 0.002072),
    (2.513887, 0.002271),
    (-1.301500, 0.005146),
    (1.225611, 0.005429),
    (-2.410121, 0.003535),
    (0.871458, 0.003825),
    (-2.324670, 0.003647),
    (0.588926, 0.001679),
    (-1.160507, 0.002112),
    (1.395789, 0.004526),
    (-2.446177, 0.004342),
    (-0.247914, 0.002117),
    (-0.137273, 0.000754),
    (1.526379, 0.003931),
    (-2.166281, 0.004707),
    (0.483169, 0.003819),
    (-2.776664, 0.002723),
    (0.696600, 0.002093),
    (-1.915323, 0.002552),
    (0.787678, 0.003897),
    (-2.879278, 0.003749),
    (0.055804, 0.002844),
    (-2.641282, 0.002931),
    (0.270283, 0.004631),
    (-3.072649, 0.004787),
    (-0.108441, 0.004871),
    (2.787725, 0.003806),
    (-0.279343, 0.003087),
    (2.949701, 0.002250),
    (-0.463058, 0.002008),
    (-2.899058, 0.002179),
    (-0.015983, 0.004279),
    (2.580473, 0.005022),
    (-1.158831, 0.003586),
    (2.871523, 0.001184),
    (0.010142, 0.003301),
    (2.680689, 0.004881),
    (-0.987829, 0.004999),
    (1.774553, 0.002928),
    (-1.161933, 0.001979),
    (2.231414, 0.003798),
    (-1.079782, 0.004724),
    (1.965095, 0.003788),
    (-1.458620, 0.004680),
    (1.390580, 0.004025),
    (-2.041557, 0.001890),
    (1.870065, 0.002018),
    (-1.928571, 0.002527),
    (0.779512, 0.002103),
    (-2.762579, 0.002260),
    (0.089848, 0.001620),
    (1.729396, 0.000471),
    (2.824602, 0.001414),
    (-1.230344, 0.001916),
    (1.468093, 0.001994),
    (-2.321822, 0.000988),
    (2.839564, 0.000645),
    (-0.693980, 0.002511),
    (1.757827, 0.004362),
    (-2.079809, 0.003843),
    (0.889999, 0.002157),
    (-1.126987, 0.002357),
    (1.737859, 0.004697),
    (-1.889114, 0.004321),
    (1.025659, 0.003650),
    (-1.870105, 0.003951),
    (0.824287, 0.005112),
    (-3.053051, 0.004760),
    (-0.270788, 0.002982),
    (-2.384085, 0.001688),
    (0.574768, 0.003696),
    (-3.053524, 0.003611),
    (-0.117364, 0.002707),
    (-2.922585, 0.001800),
    (0.092901, 0.002042),
    (3.096275, 0.002019),
    (0.119534, 0.002308),
    (-3.019359, 0.002745),
    (-0.090408, 0.003005),
    (-2.982667, 0.003146),
    (-0.005303, 0.004778),
    (2.918737, 0.004497),
    (-0.221303, 0.003407),
    (2.895210, 0.004256),
    (-0.575500, 0.005947),
    (2.486824, 0.005977),
    (-1.111098, 0.006042),
    (1.766824, 0.005698),
    (-1.278005, 0.005223),
    (1.888106, 0.005710),
    (-1.913657, 0.005202),
    (0.770269, 0.003852),
    (-2.380616, 0.001576),
    (1.706465, 0.001234),
    (-1.898772, 0.002005),
    (1.000795, 0.002131),
    (-1.609685, 0.001025),
    (2.159656, 0.002129),
    (-1.419004, 0.003016),
    (1.504808, 0.002567),
    (-1.543425, 0.001027),
    (2.205603, 0.001801),
    (-1.265753, 0.002603),
    (1.751667, 0.002542),
    (-1.620434, 0.002275),
    (1.512589, 0.003061),
    (-1.402090, 0.002564),
    (1.596140, 0.005262),
    (-2.040240, 0.005488),
    (0.846662, 0.003357),
    (-1.928654, 0.002431),
    (0.844521, 0.003796),
    (-2.398958, 0.003776),
    (0.462249, 0.003112),
    (-3.047379, 0.002861),
    (0.433351, 0.002763),
    (-2.405947, 0.003045),
    (0.211181, 0.002678),
    (3.054064, 0.001744),
    (1.666212, 0.001167),
    (-1.578883, 0.002615),
    (0.732495, 0.003492),
    (-2.779779, 0.002596),
    (0.911350, 0.001682),
    (-2.177296, 0.003304),
    (0.568201, 0.005202),
    (-2.681937, 0.005592),
    (0.201058, 0.004397),
    (-2.888402, 0.004315),
    (0.131752, 0.006594),
    (2.814172, 0.006680),
    (-1.038881, 0.004894),
    (2.239715, 0.003329),
    (-0.644903, 0.002847),
    (2.490315, 0.002738),
    (-0.614591, 0.003569),
    (2.214868, 0.003729),
    (-1.506082, 0.001602),
    (-2.871128, 0.001111),
    (-0.181821, 0.003007),
    (2.321813, 0.002655),
    (-1.243549, 0.001647),
    (2.175104, 0.001509),
    (-0.542308, 0.001494),
    (2.906966, 0.002535),
    (-0.554113, 0.003237),
    (2.277780, 0.002832),
    (-0.107976, 0.002060),
    (2.992819, 0.004780),
    (-0.757099, 0.005931),
    (1.820998, 0.004661),
    (-1.103145, 0.002927),
    (2.156991, 0.004182),
    (-1.216639, 0.005582),
    (1.620334, 0.005772),
    (-1.798787, 0.004967),
    (1.211804, 0.003486),
    (-1.752907, 0.002661),
    (1.155897, 0.002760),
    (-2.026503, 0.002423),
    (1.343532, 0.001911),
    (-2.075642, 0.002053),
    (0.975842, 0.002144),
    (-1.475876, 0.002545),
    (1.552956, 0.002877),
    (-2.254349, 0.002194),
    (1.659836, 0.001902),
    (-1.071411, 0.003685),
    (1.563685, 0.004344),
    (-2.035393, 0.004442),
    (1.071681, 0.004180),
    (-2.009951, 0.004887),
    (0.670501, 0.006169),
    (-2.757179, 0.006519),
    (0.115851, 0.005060),
    (-3.096779, 0.003718),
    (0.318071, 0.002829),
    (-2.605827, 0.003578),
    (0.176031, 0.003927),
    (2.785290, 0.003293),
    (-0.083972, 0.001414),
    (-2.482366, 0.002287),
    (0.289271, 0.003189),
    (3.088265, 0.002961),
    (-0.184104, 0.002012),
    (-2.933919, 0.001196),
    (0.609290, 0.001985),
    (-2.722950, 0.002296),
    (-0.400809, 0.001138),
    (2.992523, 0.001264),
    (0.084836, 0.001558),
    (-2.466880, 0.001397),
    (0.592711, 0.002828),
    (-3.090387, 0.003294),
    (0.376254, 0.001874),
    (-2.137463, 0.003285),
    (0.456786, 0.005275),
    (-2.967028, 0.004894),
    (-0.112376, 0.003515),
    (3.073584, 0.002500),
    (0.204557, 0.003030),
    (-3.043120, 0.004265),
    (-0.340224, 0.004908),
    (2.593586, 0.004252),
    (-0.449855, 0.002780),
    (3.009438, 0.002985),
    (-0.158506, 0.004159),
    (2.687178, 0.003915),
    (-0.680550, 0.002365),
    (-2.725997, 0.001267),
    (0.153709, 0.004101),
    (2.878950, 0.005446),
    (-0.713878, 0.005096),
    (2.199186, 0.004157),
    (-0.767665, 0.003751),
    (2.501861, 0.004181),
    (-0.912187, 0.004393),
    (2.136284, 0.004006),
    (-1.034650, 0.002964),
    (2.110103, 0.002700),
    (-0.915980, 0.003328),
    (2.138341, 0.004063),
    (-1.386564, 0.003844),
    (1.605456, 0.002697),
    (-0.782948, 0.002383),
    (2.527874, 0.003682),
    (-1.007270, 0.003997),
    (1.865210, 0.003149),
    (-0.842049, 0.002355),
    (2.313736, 0.003399),
    (-1.328601, 0.004924),
    (1.374282, 0.005872),
    (-2.194160, 0.004702),
    (0.673061, 0.002470),
    (-1.586478, 0.002410),
    (1.508992, 0.004345),
    (-2.259761, 0.004027),
    (-0.111816, 0.001894),
    (0.499736, 0.001963),
    (2.760642, 0.002992),
    (-1.144483, 0.002474),
    (1.377304, 0.001417),
    (-1.062762, 0.000493),
    (2.982866, 0.001515),
    (-0.671772, 0.003428),
    (2.026231, 0.005083),
    (-1.645655, 0.005096),
    (1.085729, 0.003189),
    (-1.085334, 0.001553),
    (2.454094, 0.004365),
    (-1.226428, 0.006374),
    (1.261170, 0.007536),
    (-2.649950, 0.005691),
    (-1.194455, 0.000623),
    (-1.101184, 0.005355),
    (1.197786, 0.007623),
    (-2.552575, 0.005629),
    (0.152086, 0.001941),
    (-0.611360, 0.000907),
    (2.251952, 0.003448),
    (-1.547384, 0.005139),
    (0.986003, 0.005298),
    (-3.082037, 0.003487),
    (-0.969892, 0.000881),
    (-1.287533, 0.002645),
    (1.341470, 0.005047),
    (-2.326806, 0.004998),
    (0.394272, 0.003554),
    (-2.269096, 0.001026),
    (2.159307, 0.003326),
    (-1.332942, 0.005559),
    (1.231333, 0.006684),
    (-2.513342, 0.006005),
    (0.103602, 0.002747),
    (-1.565655, 0.002003),
    (1.108495, 0.007322),
    (-2.643796, 0.010312),
    (-0.038426, 0.009062),
    (2.770934, 0.005348),
    (0.252034, 0.002808),
    (-2.463609, 0.004292),
    (0.379230, 0.005515),
    (3.046397, 0.005002),
    (-0.768448, 0.002877),
    (1.070048, 0.000589),
    (1.342667, 0.002163),
    (-2.370778, 0.003481),
    (0.191037, 0.004168),
    (2.936639, 0.003464),
    (-0.410263, 0.000916),
    (-1.397556, 0.002343),
    (1.198729, 0.005995),
    (-2.487728, 0.007161),
    (0.008443, 0.005826),
    (-2.992162, 0.002756),
    (0.895758, 0.004093),
    (-2.635576, 0.006791),
    (-0.027070, 0.008226),
    (2.726767, 0.006713),
    (-0.807582, 0.002877),
    (-2.498636, 0.001369),
    (0.743429, 0.004814),
    (-2.801696, 0.006082),
    (-0.250436, 0.004815),
    (2.197371, 0.002458),
    (0.087399, 0.000497),
    (-2.362995, 0.002032),
    (0.206614, 0.003249),
    (3.013153, 0.003907),
    (-0.457514, 0.003884),
    (2.628022, 0.002471),
    (0.843540, 0.001983),
    (-2.434997, 0.004961),
    (0.361716, 0.006038),
    (-3.119144, 0.004542),
    (0.464573, 0.001617),
    (-1.771737, 0.003555),
    (0.945175, 0.006347),
    (-2.852785, 0.006602),
    (-0.244762, 0.005919),
    (2.936241, 0.002758),
    (0.127000, 0.003330),
    (-3.068299, 0.005211),
    (0.019432, 0.005606),
    (3.069017, 0.005921),
    (-0.275353, 0.005274),
    (2.953312, 0.003771),
    (0.281804, 0.003593),
    (-3.135530, 0.004814),
    (-0.296416, 0.005218),
    (2.428396, 0.004036),
    (-0.799944, 0.002608),
    (2.848945, 0.001999),
    (-0.037408, 0.003537),
    (-3.048621, 0.004647),
    (-0.202842, 0.005835),
    (2.668576, 0.004993),
    (-0.247081, 0.002764),
    (-3.016555, 0.004747),
    (-0.109630, 0.005479),
    (2.610663, 0.004635),
    (-0.508870, 0.003267),
    (2.932105, 0.003028),
    (-0.134701, 0.004432),
    (2.826082, 0.004560),
    (-0.476271, 0.004779),
    (2.825662, 0.003708),
    (-0.180273, 0.002523),
    (-3.098197, 0.002925),
    (0.171103, 0.003003),
    (-2.732309, 0.002326),
    (0.764551, 0.002593),
    (-2.985712, 0.003128),
    (-0.020897, 0.002620),
    (-2.937395, 0.001930),
    (0.125841, 0.004294),
    (3.102256, 0.005228),
    (-0.223347, 0.006117),
    (2.950816, 0.006109),
    (-0.317748, 0.005894),
    (3.037342, 0.005952),
    (0.005899, 0.004880),
    (3.066460, 0.004118),
    (0.283301, 0.003344),
    (-2.742668, 0.002753),
    (0.560633, 0.002560),
    (-2.467216, 0.002128),
    (0.512898, 0.003046),
    (-2.729141, 0.003667),
    (0.013303, 0.004276),
    (-3.109006, 0.004591),
    (0.032285, 0.004554),
    (-2.903676, 0.005202),
    (0.311084, 0.005856),
    (-2.951533, 0.007739),
    (0.101487, 0.007166),
    (3.081154, 0.006100),
    (-0.006436, 0.006297),
    (2.848944, 0.006244),
    (-0.554872, 0.006195),
    (2.375406, 0.004945),
    (-0.888400, 0.004260),
    (2.531909, 0.003672),
    (-0.719986, 0.003773),
    (2.685056, 0.003473),
    (-0.175441, 0.003406),
    (2.899132, 0.004238),
    (-0.243140, 0.003082),
    (-3.123517, 0.002343),
    (0.451102, 0.003070),
    (-2.859600, 0.003498),
    (0.111165, 0.003981),
    (3.108530, 0.003560),
    (-0.099259, 0.003219),
    (-2.893902, 0.003399),
    (0.234136, 0.003809),
    (-2.927356, 0.004833),
    (0.266695, 0.004831),
    (-2.836706, 0.004927),
    (0.458564, 0.005308),
    (-2.906472, 0.005768),
    (-0.058912, 0.005503),
    (2.960324, 0.003952),
    (-0.147536, 0.003993),
    (2.897162, 0.003848),
    (-0.349450, 0.003318),
    (2.996160, 0.003409),
    (-0.029237, 0.003890),
    (-3.070359, 0.004547),
    (0.172713, 0.004300),
    (-2.883617, 0.003802),
    (0.562445, 0.004061),
    (-2.518098, 0.004062),
    (0.730663, 0.003342),
    (-1.888840, 0.003106),
    (1.249745, 0.003365),
    (-1.767196, 0.003591),
    (1.308592, 0.003988),
    (-2.150486, 0.004531),
    (0.815618, 0.005087),
    (-2.564702, 0.006468),
    (0.399992, 0.007557),
    (-2.874776, 0.007324),
    (0.270949, 0.007631),
    (-2.818224, 0.007174),
    (0.398607, 0.006869),
    (-2.644364, 0.006552),
    (0.450387, 0.005177),
    (-2.635112, 0.004092),
    (0.790696, 0.002916),
    (-1.973699, 0.002607),
    (1.156371, 0.002965),
    (-2.220834, 0.003175),
    (0.805812, 0.002955),
    (-2.503354, 0.002451),
    (0.724767, 0.003042),
    (-2.283001, 0.003251),
    (1.075530, 0.003612),
    (-1.825986, 0.004866),
    (1.338120, 0.005301),
    (-1.901278, 0.006227),
    (1.287152, 0.007073),
    (-1.936239, 0.007083),
    (1.036717, 0.006510),
    (-2.234993, 0.004801),
    (0.823136, 0.004033),
    (-2.241703, 0.002833),
    (1.234722, 0.002175),
    (-1.713852, 0.002828),
    (1.363737, 0.003114),
    (-1.640953, 0.003414),
    (1.625945, 0.003730),
    (-1.520351, 0.003925),
    (1.855983, 0.004337),
    (-1.267446, 0.004777),
    (1.829580, 0.005020),
    (-1.119531, 0.004379),
    (2.134456, 0.004630),
    (-1.010504, 0.005891),
    (1.914458, 0.005746),
    (-1.281785, 0.004354),
    (2.082986, 0.004894),
    (-1.225129, 0.006456),
    (1.793173, 0.006053),
    (-1.221155, 0.004885),
    (2.061022, 0.005657),
    (-1.087265, 0.007217),
    (1.946435, 0.007558),
    (-1.231082, 0.006639),
    (1.962001, 0.005965),
    (-1.136013, 0.005522),
    (2.039690, 0.004859),
    (-1.031656, 0.004848),
    (2.201712, 0.004575),
    (-0.928984, 0.004100),
    (2.150160, 0.005044),
    (-1.024309, 0.005333),
    (2.013235, 0.004543),
    (-1.132960, 0.004181),
    (2.237890, 0.004181),
    (-0.699864, 0.004458),
    (2.473856, 0.004128),
    (-0.462586, 0.003562),
    (3.129040, 0.004015),
    (-0.069581, 0.004858),
    (2.941975, 0.004922),
    (-0.087378, 0.003534),
    (3.110988, 0.003133),
    (0.014225, 0.002920),
    (3.109670, 0.002697),
    (-0.167705, 0.003596),
    (2.861097, 0.003715),
    (-0.493257, 0.003594),
    (2.727614, 0.004337),
    (-0.285741, 0.004480),
    (2.919505, 0.004474),
    (-0.124776, 0.004560),
    (-2.921402, 0.004105),
    (0.676162, 0.004723),
    (-2.348144, 0.005841),
    (0.893126, 0.006780),
    (-2.197246, 0.007684),
    (0.901526, 0.007802),
    (-2.305928, 0.007457),
    (0.793866, 0.006825),
    (-2.332566, 0.006032),
    (0.668589, 0.005557),
    (-2.657014, 0.005476),
    (0.445176, 0.005328),
    (-2.806295, 0.004960),
    (0.329347, 0.004616),
    (-2.608413, 0.004352),
    (0.744959, 0.004361),
    (-2.172637, 0.004588),
    (1.161923, 0.004792),
    (-1.734852, 0.005269),
    (1.540780, 0.006440),
    (-1.547839, 0.006599),
    (1.680499, 0.005290),
    (-1.365253, 0.005012),
    (2.018809, 0.004879),
    (-1.015480, 0.005710),
    (1.947679, 0.006704),
    (-1.584971, 0.004903),
    (1.523467, 0.003661),
    (-1.298743, 0.004825),
    (1.419985, 0.005218),
    (-1.919137, 0.004776),
    (1.403984, 0.002769),
    (-1.067772, 0.002950),
    (2.412654, 0.005048),
    (-0.786222, 0.005505),
    (2.378152, 0.005807),
    (-0.462183, 0.005788),
    (2.916278, 0.006635),
    (-0.223665, 0.007444),
    (2.906627, 0.007332),
    (-0.156014, 0.006487),
    (3.116297, 0.005692),
    (0.206704, 0.005481),
    (-2.864770, 0.006193),
    (0.018936, 0.007284),
    (3.013052, 0.006564),
    (-0.124485, 0.004424),
    (-3.118459, 0.005022),
    (0.148325, 0.006580),
    (-3.091484, 0.007474),
    (-0.093060, 0.007717),
    (3.135318, 0.006515),
    (0.182850, 0.005964),
    (-2.809211, 0.006108),
    (0.503338, 0.006454),
    (-2.547998, 0.006082),
    (0.727989, 0.004895),
    (-2.099851, 0.004391),
    (1.300037, 0.005445),
    (-1.718687, 0.006100),
    (1.375001, 0.004687),
    (-1.897449, 0.004053),
    (1.615547, 0.003785),
    (-1.234003, 0.003170),
    (1.866351, 0.003962),
    (-1.281492, 0.004458),
    (1.931119, 0.002745),
    (-0.726169, 0.003995),
    (2.423608, 0.007411),
    (-1.017150, 0.008693),
    (1.914771, 0.008371),
    (-1.178917, 0.006634),
    (2.120543, 0.006300),
    (-0.738399, 0.007042),
    (2.462198, 0.006523),
    (-0.759388, 0.007075),
    (2.641991, 0.006436),
    (-0.263403, 0.004815),
    (3.064083, 0.005621),
    (0.159763, 0.006996),
    (-3.016183, 0.005702),
    (0.160349, 0.005032),
    (-2.514095, 0.005888),
    (0.781549, 0.006802),
    (-2.472393, 0.008312),
    (0.619495, 0.009253),
    (-2.638664, 0.008171),
    (0.583015, 0.007793),
    (-2.450488, 0.008739),
    (0.642660, 0.010384),
    (-2.528456, 0.010233),
    (0.373691, 0.007883),
    (-2.693510, 0.006014),
    (1.205368, 0.005777),
    (-1.809726, 0.006662),
    (1.157910, 0.006895),
    (-1.722223, 0.005056),
    (2.048360, 0.004001),
    (-0.930100, 0.005875),
    (2.302982, 0.007926),
    (-0.915877, 0.007280),
    (2.243291, 0.005655),
    (-0.393446, 0.005900),
    (2.841008, 0.007056),
    (-0.440458, 0.007664),
    (2.700884, 0.006452),
    (-0.282073, 0.005159),
    (-2.898476, 0.006200),
    (0.356652, 0.008570),
    (-3.035260, 0.011651),
    (-0.109306, 0.011856),
    (2.992746, 0.008494),
    (0.118950, 0.008013),
    (-2.869064, 0.009473),
    (0.229592, 0.008966),
    (-2.929487, 0.007912),
    (0.545328, 0.006448),
    (-2.108980, 0.006457),
    (1.030547, 0.007736),
    (-2.152421, 0.008311),
    (1.109215, 0.005791),
    (-1.697395, 0.004608),
    (1.962715, 0.005192),
    (-0.940992, 0.005629),
    (2.223563, 0.005912),
    (-0.701413, 0.005544),
    (2.872340, 0.006337),
    (-0.030419, 0.008060),
    (3.049439, 0.009025),
    (-0.175334, 0.009297),
    (-3.132241, 0.008719),
    (0.219468, 0.009402),
    (-3.023620, 0.011229),
    (0.029092, 0.010773),
    (-3.138464, 0.008805),
    (0.095284, 0.007644),
    (-2.748313, 0.006977),
    (0.649236, 0.006256),
    (-2.442208, 0.006588),
    (0.940972, 0.007159),
    (-1.879971, 0.006430),
    (1.442195, 0.007185),
    (-1.619275, 0.009107),
    (1.556696, 0.009467),
    (-1.608096, 0.008467),
    (1.684019, 0.007994),
    (-1.176944, 0.007317),
    (2.171122, 0.007431),
    (-0.811013, 0.008042),
    (2.525339, 0.007976),
    (-0.332629, 0.008164),
    (2.996845, 0.009303),
    (-0.113123, 0.010835),
    (3.086399, 0.011688),
    (0.117312, 0.011084),
    (-2.825231, 0.010414),
    (0.592990, 0.011578),
    (-2.356252, 0.012999),
    (0.819157, 0.013820),
    (-2.226384, 0.014411),
    (1.184396, 0.014000),
    (-1.741473, 0.013331),
    (1.537735, 0.013593),
    (-1.314437, 0.013104),
    (2.116898, 0.012105),
    (-0.741211, 0.012944),
    (2.727740, 0.015332),
    (-0.208913, 0.016021),
    (3.055399, 0.015209),
    (0.253361, 0.015593),
    (-2.524757, 0.016477),
    (0.797513, 0.017397),
    (-2.156133, 0.019933),
    (1.208512, 0.021559),
    (-1.815301, 0.019947),
    (1.432829, 0.019285),
    (-1.450757, 0.018398),
    (1.917096, 0.015036),
    (-0.970574, 0.012949),
    (2.604690, 0.012636),
    (-0.126872, 0.012898),
    (-3.016118, 0.012918),
    (0.357179, 0.013895),
    (-2.512346, 0.014239),
    (0.800095, 0.012399),
    (-2.133566, 0.011432),
    (1.302002, 0.010726),
    (-1.474648, 0.008826),
    (2.089414, 0.007471),
    (-0.551823, 0.008226),
    (3.003895, 0.009947),
    (0.001503, 0.011560),
    (-3.027474, 0.011903),
    (0.268851, 0.011675),
    (-2.776837, 0.011133),
    (0.505925, 0.008956),
    (-2.326798, 0.007035),
    (1.167950, 0.005578),
    (-1.609501, 0.004977),
    (1.945182, 0.005278),
    (-1.017548, 0.005844),
    (2.255508, 0.005319),
    (-0.729611, 0.004354),
    (2.774167, 0.003749),
    (-0.041158, 0.003498),
    (3.011099, 0.003713),
    (-0.404324, 0.002808),
    (2.559421, 0.000961),
    (-2.584110, 0.000118),
    (0.860668, 0.000146),
    (-2.884278, 0.000863),
    (0.939528, 0.001521),
    (-2.122371, 0.002198),
    (0.638252, 0.003212),
    (-2.525069, 0.004513),
    (0.602400, 0.004320),
    (-2.954322, 0.004160),
    (0.139859, 0.003899),
    (-3.096709, 0.003270),
    (0.014012, 0.003164),
    (3.092456, 0.002653),
    (-0.282399, 0.002167),
    (2.619527, 0.001861),
    (-0.536099, 0.001034),
    (2.474636, 0.000953),
    (-0.781001, 0.001304),
    (1.877399, 0.001584),
    (-1.795984, 0.001743),
    (0.757359, 0.001630),
    (-2.612470, 0.001454),
    (0.658437, 0.001034),
    (2.791002, 0.000901),
    (-0.536069, 0.001132),
    (2.012019, 0.000940),
    (-1.289028, 0.001024),
    (1.177676, 0.001762),
    (-2.088409, 0.002253),
    (0.763628, 0.001657),
    (-3.089952, 0.002040),
    (-0.103117, 0.002380),
    (2.102117, 0.001194),
    (-1.532427, 0.001748),
    (1.933847, 0.001345),
    (-1.557959, 0.001531),
    (1.336827, 0.002262),
    (-1.790758, 0.001977),
    (1.191312, 0.002042),
    (-1.950741, 0.002066),
    (0.862092, 0.001603),
    (-2.241737, 0.001355),
    (0.610232, 0.000743),
    (3.073875, 0.000548),
    (0.174318, 0.000457),
    (-2.589178, 0.000823),
    (0.158402, 0.001358),
    (2.991982, 0.001708),
    (-0.352128, 0.001988),
    (3.098193, 0.001841),
    (0.041592, 0.002022),
    (3.026200, 0.002324),
    (-0.344957, 0.002015),
    (2.756574, 0.001401),
    (-0.301197, 0.000543),
    (-1.588049, 0.000836),
    (1.153553, 0.000991),
    (-2.912867, 0.001086),
    (-1.040450, 0.000375),
    (0.843232, 0.000375),
    (-1.546353, 0.000210),
    (2.435368, 0.000705),
    (-0.879367, 0.000923),
    (2.294215, 0.001098),
    (-0.734506, 0.001653),
    (3.008987, 0.001869),
    (0.097964, 0.002261),
    (2.930371, 0.003502),
    (-0.361451, 0.003582),
    (2.665447, 0.003187),
    (-0.719497, 0.003449),
    (2.232481, 0.003277),
    (-1.394913, 0.002513),
    (1.634898, 0.002996),
    (-1.666258, 0.003209),
    (1.120229, 0.003698),
    (-2.167887, 0.003707),
    (0.889752, 0.003467),
    (-2.357618, 0.003385),
    (0.851079, 0.003122),
    (-2.315679, 0.003099),
    (0.600120, 0.003255),
    (-2.959600, 0.002705),
    (-0.254015, 0.001963),
    (2.381155, 0.001419),
    (-1.422410, 0.001283),
    (1.468905, 0.001302),
    (-1.709141, 0.000662),
    (0.956801, 0.000695),
    (-2.181607, 0.000579),
    (2.143923, 0.000457),
    (0.461785, 0.000924),
    (-2.695880, 0.001069),
    (-0.581408, 0.000836),
    (2.280805, 0.000506),
    (0.958306, 0.001157),
    (-2.444014, 0.001527),
    (0.160361, 0.001670),
    (3.090273, 0.001105),
    (-0.001399, 0.001325),
    (-3.101033, 0.001801),
    (-0.227088, 0.002054),
    (2.600583, 0.002101),
    (-0.606584, 0.002272),
    (2.628353, 0.002242),
    (-0.411304, 0.002336),
    (2.617144, 0.002421),
    (-0.852516, 0.002946),
    (2.302779, 0.002737),
    (-0.805824, 0.001873),
    (1.677366, 0.001494),
    (-1.420434, 0.001531),
    (2.214176, 0.001226),
    (-1.256233, 0.001463),
    (1.238284, 0.001734),
    (-1.960729, 0.001723),
    (1.456289, 0.001473),
    (-1.854068, 0.001861),
    (1.293531, 0.002107),
    (-1.770800, 0.002081),
    (1.299847, 0.002186),
    (-2.030575, 0.002602),
    (0.877551, 0.001981),
    (-2.664272, 0.001415),
    (0.588361, 0.000938),
    (2.945633, 0.000681),
    (-0.977998, 0.001095),
    (0.931862, 0.000608),
    (-2.748636, 0.000967),
    (0.337803, 0.000834),
    (2.685903, 0.001953),
    (-1.098825, 0.003013),
    (1.534722, 0.003962),
    (-1.904985, 0.003977),
    (1.131148, 0.003919),
    (-2.219242, 0.003973),
    (0.844386, 0.004127),
    (-2.463108, 0.003697),
    (0.540471, 0.003798),
    (-2.836902, 0.003287),
    (-0.025524, 0.003200),
    (2.814800, 0.003297),
    (-0.550922, 0.002983),
    (2.415765, 0.002297),
    (-0.704731, 0.002504),
    (2.338258, 0.003049),
    (-0.920382, 0.002673),
    (2.489641, 0.001962),
    (-0.683575, 0.002597),
    (2.058356, 0.003527),
    (-1.544319, 0.002680),
    (1.071211, 0.001391),
    (-1.674554, 0.000455),
    (1.627269, 0.000856),
    (-1.535163, 0.000961),
    (1.122295, 0.001008),
    (-1.668992, 0.000750),
    (2.756966, 0.000260),
    (-0.696217, 0.001290),
    (2.189206, 0.001980),
    (-1.350436, 0.002305),
    (1.918156, 0.001628),
    (-0.834344, 0.001837),
    (2.269140, 0.002827),
    (-1.232883, 0.003026),
    (1.614900, 0.002726),
    (-1.687446, 0.002233),
    (1.209424, 0.001619),
    (-2.337067, 0.001309),
    (1.162585, 0.001443),
    (-1.627924, 0.001746),
    (0.964666, 0.001697),
    (-2.350542, 0.002140),
    (1.065421, 0.001407),
    (-2.168191, 0.001886),
    (1.002536, 0.002010),
    (-2.258060, 0.001777),
    (1.206688, 0.001692),
    (-1.973888, 0.002066),
    (0.938834, 0.002986),
    (-2.647171, 0.002994),
    (0.135983, 0.002549),
    (3.096607, 0.002176),
    (0.132524, 0.002380),
    (3.060158, 0.002685),
    (-0.274482, 0.003575),
    (2.670291, 0.003619),
    (-0.836893, 0.003165),
    (2.263896, 0.002807),
    (-0.777388, 0.002427),
    (2.132087, 0.002541),
    (-1.310170, 0.002329),
    (1.358283, 0.002310),
    (-2.363827, 0.002101),
    (-0.258066, 0.002030),
    (1.712647, 0.002167),
    (-2.628776, 0.001430),
    (-0.401116, 0.000914),
    (-0.597348, 0.000718),
    (1.599905, 0.001071),
    (-2.344358, 0.002098),
    (0.357027, 0.002939),
    (3.096150, 0.002864),
    (-0.371499, 0.002215),
    (3.089509, 0.001835),
    (0.017748, 0.002670),
    (2.879832, 0.003552),
    (-0.472609, 0.004143),
    (2.455140, 0.003548),
    (-1.068108, 0.003458),
    (2.035930, 0.002995),
    (-1.018335, 0.002677),
    (1.948412, 0.003918),
    (-1.449785, 0.005642),
    (1.210659, 0.005038),
    (-2.602039, 0.005425),
    (0.319022, 0.004219),
    (-3.036785, 0.001995),
    (0.092807, 0.000952),
    (-2.180179, 0.001536),
    (0.767675, 0.002068),
    (-2.798339, 0.001619),
    (0.420060, 0.000458),
    (-1.142161, 0.000888),
    (1.850060, 0.001606),
    (-1.771869, 0.002239),
    (0.940603, 0.002478),
    (-2.694166, 0.001759),
    (0.635243, 0.000941),
    (-2.094405, 0.001913),
    (0.861763, 0.002622),
    (-2.713010, 0.002875),
    (0.214249, 0.003008),
    (3.109967, 0.002536),
    (-0.276979, 0.001922),
    (-2.834341, 0.000884),
    (0.898035, 0.001708),
    (-2.658293, 0.002230),
    (0.244552, 0.001628),
    (-2.717469, 0.001155),
    (0.588588, 0.001347),
    (-2.629829, 0.001597),
    (0.456305, 0.001848),
    (-2.827508, 0.002039),
    (0.212659, 0.002466),
    (3.138793, 0.002356),
    (-0.309609, 0.002131),
    (3.008087, 0.002078),
    (-0.037398, 0.002716),
    (2.894784, 0.002657),
    (-0.703732, 0.002213),
    (2.622530, 0.001746),
    (-0.169415, 0.001988),
    (2.848151, 0.002862),
    (-0.461965, 0.003352),
    (2.413249, 0.003525),
    (-1.129100, 0.003544),
    (1.731976, 0.003494),
    (-1.394616, 0.002601),
    (1.695869, 0.002012),
    (-1.536287, 0.002252),
    (1.371998, 0.002049),
    (-2.258840, 0.002269),
    (0.622440, 0.002008),
    (2.945159, 0.001333),
    (-1.116300, 0.000911),
    (1.723423, 0.000575),
    (-2.169878, 0.000692),
    (1.146935, 0.001230),
    (-2.517366, 0.001484),
    (0.215173, 0.002526),
    (3.125349, 0.002790),
    (-0.275757, 0.003269),
    (2.697910, 0.004002),
    (-0.860252, 0.004139),
    (2.012792, 0.003922),
    (-1.167657, 0.003572),
    (1.778740, 0.004391),
    (-1.776487, 0.004542),
    (1.006254, 0.003637),
    (-2.499365, 0.003072),
    (0.468432, 0.002942),
    (-2.908882, 0.001818),
    (0.203141, 0.000912),
    (-2.076317, 0.000411),
    (1.272296, 0.000964),
    (-2.087370, 0.001492),
    (0.984766, 0.001064),
    (-1.196641, 0.000656),
    (1.835552, 0.001423),
    (-1.684533, 0.001927),
    (1.172219, 0.002185),
    (-1.989498, 0.002217),
    (0.962949, 0.002091),
    (-2.327175, 0.002414),
    (0.755356, 0.002494),
    (-2.614185, 0.002958),
    (0.320327, 0.003012),
    (3.029759, 0.002292),
    (-0.254053, 0.001340),
    (-3.060469, 0.000903),
    (0.223117, 0.000923),
    (-2.362091, 0.000689),
    (1.060412, 0.001442),
    (-2.364795, 0.001794),
    (0.281487, 0.001862),
    (-2.934008, 0.001102),
    (-0.063604, 0.000513),
    (-2.476446, 0.001335),
    (0.733934, 0.002007),
    (-2.888520, 0.001829),
    (-0.205156, 0.001323),
    (2.530442, 0.000616),
    (1.231343, 0.000509),
    (-1.626502, 0.001662),
    (1.251663, 0.002656),
    (-2.220768, 0.002674),
    (0.830946, 0.002567),
    (-2.308184, 0.004103),
    (0.480375, 0.005604),
    (3.109716, 0.006128),
    (-0.391438, 0.005839),
    (2.541753, 0.005372),
    (-0.848071, 0.004924),
    (2.083599, 0.004657),
    (-1.191174, 0.003951),
    (1.714190, 0.003654),
    (-1.572514, 0.003187),
    (1.512469, 0.002701),
    (-1.680268, 0.002830),
    (1.028216, 0.002879),
    (-2.641085, 0.002411),
    (0.139915, 0.001336),
    (2.401830, 0.000343),
    (-1.575532, 0.000307),
    (0.214711, 0.000493),
    (-3.105012, 0.001036),
    (-0.216914, 0.001451),
    (2.589378, 0.001904),
    (-0.802132, 0.002177),
    (2.155599, 0.002580),
    (-1.020918, 0.002449),
    (1.828084, 0.002603),
    (-1.686026, 0.003041),
    (1.151631, 0.003081),
    (-2.129920, 0.002255),
    (0.905752, 0.001046),
    (-2.257024, 0.000564),
    (1.152391, 0.001205),
    (-1.870288, 0.001480),
    (1.319552, 0.000690),
    (-0.279618, 0.000385),
    (2.638503, 0.001397),
    (-0.856605, 0.002442),
    (2.001141, 0.002677),
    (-1.258234, 0.002672),
    (1.823238, 0.002823),
    (-1.322650, 0.003625),
    (1.467808, 0.003807),
    (-2.125032, 0.003306),
    (1.009853, 0.001637),
    (-1.870102, 0.002099),
    (0.950292, 0.002581),
    (-2.426670, 0.001242),
    (1.627659, 0.000877),
    (-1.383866, 0.002048),
    (1.763917, 0.002483),
    (-1.504511, 0.002851),
    (1.275435, 0.003556),
    (-1.995887, 0.003859),
    (1.112342, 0.003202),
    (-2.063342, 0.003378),
    (0.878334, 0.003201),
    (-2.305540, 0.002863),
    (0.935235, 0.002462),
    (-2.303629, 0.002513),
    (0.840926, 0.002459),
    (-2.485660, 0.002300),
    (0.181539, 0.002231),
    (2.943618, 0.001887),
    (0.202030, 0.000836),
    (-2.332573, 0.001151),
    (0.762143, 0.001385),
    (-1.876033, 0.001632),
    (1.133956, 0.002379),
    (-2.185138, 0.003037),
    (0.910810, 0.003233),
    (-2.370618, 0.004057),
    (0.687969, 0.004187),
    (-2.693278, 0.003633),
    (0.251926, 0.003245),
    (-2.865147, 0.003447),
    (0.303271, 0.003818),
    (3.109756, 0.003790),
    (-0.323807, 0.003497),
    (2.751467, 0.002679),
    (-0.386483, 0.002515),
    (2.558986, 0.002605),
    (-0.947234, 0.002097),
    (2.258383, 0.000565),
    (1.125443, 0.000708),
    (-2.504495, 0.001931),
    (0.447862, 0.003306),
    (-2.997901, 0.004481),
    (-0.270787, 0.004505),
    (2.558626, 0.003756),
    (-0.611082, 0.003173),
    (2.243439, 0.003076),
    (-0.970836, 0.002962),
    (2.030182, 0.001951),
    (-1.518238, 0.002011),
    (1.287771, 0.001604),
    (-2.423055, 0.000656),
    (-2.405657, 0.000492),
    (0.609568, 0.000778),
    (-2.544886, 0.001306),
    (0.584430, 0.001941),
    (-2.959635, 0.002372),
    (-0.025993, 0.002402),
    (-3.091389, 0.002259),
    (0.159490, 0.002934),
    (3.002811, 0.003198),
    (-0.558888, 0.003745),
    (2.355333, 0.002929),
    (-1.116358, 0.002316),
    (2.582423, 0.002362),
    (-0.690331, 0.002501),
    (1.998454, 0.003029),
    (-1.516426, 0.002097),
    (1.510661, 0.001658),
    (-1.163896, 0.000696),
    (2.497710, 0.000785),
    (-0.575641, 0.001408),
    (2.221044, 0.001237),
    (-1.183465, 0.000844),
    (-2.267167, 0.000082),
    (0.394024, 0.000747),
    (-2.675403, 0.002067),
    (0.199922, 0.002416),
    (3.013306, 0.003138),
    (-0.298262, 0.002711),
    (2.703109, 0.003483),
    (-0.524895, 0.004537),
    (2.201813, 0.005551),
    (-1.470124, 0.005116),
    (1.165728, 0.004670),
    (-2.018913, 0.003247),
    (0.802904, 0.002122),
    (-2.688233, 0.001624),
    (-0.539330, 0.000914),
    (1.467633, 0.000498),
    (2.957062, 0.001011),
    (-0.453830, 0.001038),
    (-3.112539, 0.001242),
    (-0.000794, 0.001170),
    (2.327558, 0.002061),
    (-0.863918, 0.002447),
    (2.009453, 0.002276),
    (-1.229396, 0.002216),
    (1.723556, 0.001910),
    (-1.408341, 0.001590),
    (1.700743, 0.001344),
    (-1.154349, 0.001800),
    (2.356739, 0.001816),
    (-0.669062, 0.001274),
    (2.569706, 0.001726),
    (-1.017077, 0.002510),
    (1.773575, 0.003653),
    (-1.627243, 0.002929),
    (1.192171, 0.002807),
    (-1.918077, 0.001749),
    (0.988273, 0.001647),
    (-1.791450, 0.002030),
    (1.295227, 0.001695),
    (-1.820620, 0.001465),
    (1.143614, 0.001263),
    (-2.198887, 0.001156),
    (2.174616, 0.000553),
    (-1.079976, 0.001138),
    (1.729829, 0.001961),
    (-1.848954, 0.001278),
    (1.203957, 0.001127),
    (-1.201559, 0.001057),
    (1.478130, 0.001785),
    (-1.741068, 0.001543),
    (0.186716, 0.000876),
    (-0.732995, 0.000611),
    (2.818388, 0.001058),
    (-1.083614, 0.001401),
    (2.572264, 0.002293),
    (-0.848499, 0.002473),
    (2.038805, 0.003273),
    (-1.260450, 0.002748),
    (1.709684, 0.003378),
    (-1.390085, 0.002823),
    (1.511375, 0.002566),
    (-1.547771, 0.002823),
    (1.192941, 0.002421),
    (-2.144946, 0.001904),
    (0.681207, 0.001421),
    (-1.870711, 0.001730),
    (1.392296, 0.000491),
    (-2.405102, 0.000788),
    (2.264012, 0.001348),
    (-1.026614, 0.001458),
    (2.066973, 0.002493),
    (-0.927900, 0.002411),
    (1.928028, 0.003723),
    (-1.199349, 0.004595),
    (1.497583, 0.004479),
    (-1.899257, 0.004393),
    (0.724364, 0.002959),
    (-2.347996, 0.002683),
    (1.250598, 0.001834),
    (-1.998988, 0.002219),
    (0.924652, 0.002102),
    (-2.840875, 0.002434),
    (0.650523, 0.001061),
    (-0.960815, 0.000901),
    (1.624288, 0.002481),
    (-1.645427, 0.002596),
    (1.240510, 0.002472),
    (-1.776728, 0.002178),
    (0.912127, 0.002194),
    (-1.812845, 0.002559),
    (1.724692, 0.002096),
    (-1.822458, 0.003344),
    (1.042703, 0.002857),
    (-2.918170, 0.002554),
    (0.767771, 0.001104),
    (-1.227694, 0.001179),
    (1.530786, 0.002768),
    (-1.800755, 0.002761),
    (0.765531, 0.002714),
    (-2.478134, 0.001862),
    (0.140894, 0.001237),
    (-1.797512, 0.001372),
    (1.493366, 0.001736),
    (-2.286349, 0.002726),
    (0.337942, 0.001266),
    (2.167122, 0.000890),
    (3.002462, 0.001230),
    (-0.191518, 0.001843),
    (2.293666, 0.002949),
    (-0.898114, 0.003109),
    (1.780066, 0.002032),
    (-0.946123, 0.002450),
    (2.011905, 0.003018),
    (-1.572577, 0.005142),
    (1.148470, 0.004438),
    (-2.575397, 0.004612),
    (0.200846, 0.002954),
    (2.721128, 0.002283),
    (-3.110942, 0.000493),
    (-0.215036, 0.001296),
    (1.738845, 0.001778),
    (-0.878853, 0.001202),
    (2.858067, 0.001226),
    (-0.387630, 0.003311),
    (2.421391, 0.003504),
    (-1.307266, 0.003951),
    (1.648532, 0.002681),
    (-1.677989, 0.002112),
    (1.881119, 0.001963),
    (-1.670113, 0.001557),
    (1.997783, 0.002632),
    (-0.973338, 0.002383),
    (1.623443, 0.003245),
    (-1.508412, 0.002324),
    (1.302732, 0.001852),
    (-0.985310, 0.002754),
    (2.099221, 0.002614),
    (-1.530047, 0.003778),
    (1.266875, 0.002632),
    (-2.446620, 0.002277),
    (1.696662, 0.001312),
    (-1.422126, 0.001271),
    (1.494006, 0.002017),
    (-1.851520, 0.000854),
    (1.029396, 0.001198),
    (-0.453193, 0.000749),
    (-2.789813, 0.001076),
    (-0.439796, 0.002464),
    (2.507055, 0.002417),
    (-0.987715, 0.002392),
    (2.245908, 0.002386),
    (-1.283704, 0.002407),
    (2.032652, 0.002678),
    (-1.236379, 0.002362),
    (1.642829, 0.003832),
    (-1.681516, 0.003158),
    (0.861447, 0.003213),
    (-2.568969, 0.001834),
    (-0.843474, 0.001585),
    (0.469144, 0.001314),
    (2.940698, 0.002131),
    (-1.127902, 0.002011),
    (2.500326, 0.001191),
    (-0.012388, 0.001084),
    (2.445170, 0.002342),
    (-0.926312, 0.002665),
    (1.751859, 0.002998),
    (-1.513220, 0.002838),
    (1.274800, 0.001716),
    (-1.728802, 0.001093),
    (1.124490, 0.000815),
    (-0.754571, 0.000721),
    (-2.933319, 0.001708),
    (-0.348470, 0.001629),
    (2.875834, 0.001726),
    (0.183511, 0.001558),
    (2.840652, 0.002413),
    (-0.479564, 0.002966),
    (2.174734, 0.002424),
    (-1.133058, 0.002952),
    (1.832838, 0.002158),
    (-1.592092, 0.001716),
    (2.228337, 0.000979),
    (-0.758775, 0.001489),
    (2.499426, 0.001976),
    (-1.035252, 0.001568),
    (2.407309, 0.001354),
    (0.554997, 0.001394),
    (-3.072487, 0.001786),
    (-0.371183, 0.002498),
    (2.757747, 0.001421),
    (-0.470199, 0.001826),
    (2.655198, 0.002068),
    (-0.586030, 0.001332),
    (-3.052219, 0.001445),
    (-0.285065, 0.002421),
    (2.753500, 0.003766),
    (-0.445660, 0.003008),
    (2.259077, 0.003009),
    (-0.936142, 0.002280),
    (2.845038, 0.001764),
    (-0.080696, 0.002679),
    (2.754339, 0.002891),
    (-0.869483, 0.002863),
    (2.251068, 0.002321),
    (-0.712493, 0.001791),
    (2.485023, 0.002336),
    (-0.937926, 0.002236),
    (1.875444, 0.002517),
    (-1.404862, 0.001913),
    (1.730009, 0.001334),
    (-1.083892, 0.000888),
    (0.552785, 0.000294),
    (1.647632, 0.000344),
    (-2.248861, 0.001503),
    (0.662158, 0.001517),
    (-2.865379, 0.001374),
    (0.567878, 0.001417),
    (-2.775186, 0.001742),
    (0.216560, 0.001912),
    (2.873410, 0.002264),
    (-0.385307, 0.002476),
    (2.075223, 0.002009),
    (-1.408525, 0.001114),
    (-1.137398, 0.000667),
    (1.247893, 0.001053),
    (-2.585601, 0.001503),
    (0.560658, 0.001209),
    (-1.892009, 0.001033),
    (1.578332, 0.001614),
    (-2.086952, 0.001808),
    (0.784850, 0.001966),
    (-2.406182, 0.001424),
    (0.788569, 0.001737),
    (-2.480173, 0.001403),
    (0.543674, 0.001157),
    (-2.055048, 0.001033),
    (1.100681, 0.002230),
    (-1.987949, 0.002561),
    (0.811724, 0.002945),
    (-2.516995, 0.003231),
    (0.576612, 0.001747),
    (-2.271980, 0.001428),
    (0.883272, 0.002296),
    (-2.458566, 0.001987),
    (0.466631, 0.001145),
    (-2.614795, 0.000721),
    (0.894669, 0.001373),
    (-1.964556, 0.001409),
    (1.124138, 0.001164),
    (-1.820984, 0.001765),
    (1.175615, 0.002522),
    (-2.051623, 0.002628),
    (1.068056, 0.001856),
    (-1.790078, 0.001979),
    (1.576598, 0.001820),
    (-1.279741, 0.001207),
    (2.203023, 0.002333),
    (-0.915197, 0.003473),
    (1.772784, 0.003339),
    (-1.695952, 0.003795),
    (1.238250, 0.002211),
    (-2.246754, 0.001278),
    (0.980948, 0.001031),
    (-2.351113, 0.001162),
    (0.974710, 0.000215),
    (0.059293, 0.000344),
    (2.642291, 0.000825),
    (-0.100654, 0.001756),
    (3.046544, 0.002343),
    (-0.508054, 0.002877),
    (2.331872, 0.002831),
    (-1.016516, 0.002637),
    (2.498667, 0.001830),
    (-0.287797, 0.001106),
    (2.776995, 0.001341),
    (-0.710505, 0.000996),
    (2.387081, 0.001310),
    (-0.097797, 0.001339),
    (2.687473, 0.000825),
    (-0.620302, 0.000944),
    (-2.669350, 0.001393),
    (-0.147578, 0.001882),
    (2.650743, 0.002501),
    (-0.714168, 0.001800),
    (2.939423, 0.002158),
    (0.114312, 0.001859),
    (2.703142, 0.001732),
    (-0.013345, 0.001717),
    (-2.938920, 0.001348),
    (0.537716, 0.001585),
    (-2.211766, 0.002123),
    (0.723934, 0.003009),
    (-2.683485, 0.003356),
    (0.070288, 0.002764),
    (-3.127466, 0.002571),
    (0.221016, 0.001729),
    (3.044719, 0.001952),
    (0.354615, 0.001724),
    (-1.744889, 0.001126),
    (1.184346, 0.002531),
    (-2.068700, 0.003646),
    (0.852454, 0.003916),
    (-2.473245, 0.004315),
    (0.441203, 0.003999),
    (-2.946983, 0.003326),
    (-0.083278, 0.002358),
    (2.615640, 0.001728),
    (-1.015346, 0.000564),
    (0.305480, 0.000941),
    (2.276279, 0.000798),
    (-1.095184, 0.001756),
    (1.901732, 0.001799),
    (-1.650567, 0.001910),
    (1.509120, 0.001706),
    (-1.591140, 0.001616),
    (1.405632, 0.002178),
    (-1.946785, 0.001691),
    (0.237708, 0.000908),
    (1.096716, 0.001057),
    (-2.762734, 0.002331),
    (-0.300276, 0.003990),
    (2.570762, 0.003773),
    (-1.056032, 0.002491),
    (2.190316, 0.002589),
    (-0.829787, 0.002489),
    (1.825420, 0.002427),
    (-1.382988, 0.002162),
    (1.359737, 0.001327),
    (-1.802917, 0.001197),
    (-2.752761, 0.000136),
    (-0.789616, 0.000654),
    (2.902664, 0.001324),
    (0.585518, 0.000862),
    (-2.739899, 0.001937),
    (0.492710, 0.002900),
    (-2.686862, 0.002252),
    (0.350962, 0.002790),
    (-2.745184, 0.003318),
    (0.148729, 0.003008),
    (-2.710685, 0.002492),
    (0.775039, 0.001381),
    (-2.678975, 0.001828),
    (0.675303, 0.002178),
    (-2.813132, 0.002492),
    (0.220738, 0.003148),
    (3.120594, 0.002348),
    (-0.678630, 0.002020),
    (2.553855, 0.000792),
    (-0.455732, 0.000329),
    (-2.947722, 0.000939),
    (1.841923, 0.000386),
    (0.109132, 0.000641),
    (2.466746, 0.001736),
    (-0.883026, 0.003569),
    (1.792113, 0.004180),
    (-1.836430, 0.003367),
    (0.836683, 0.001861),
    (-1.669470, 0.001155),
    (2.527206, 0.001296),
    (-1.154603, 0.000819),
    (2.039097, 0.001688),
    (0.713808, 0.000950),
    (-1.729703, 0.000925),
    (-0.391092, 0.002657),
    (2.515673, 0.003392),
    (-1.132539, 0.002988),
    (2.037661, 0.002475),
    (-1.404592, 0.002271),
    (1.757293, 0.002139),
    (-0.901637, 0.001256),
    (2.118398, 0.002088),
    (-0.798420, 0.001542),
    (-2.714730, 0.000222),
    (0.530811, 0.000920),
    (-2.128105, 0.002052),
    (0.976643, 0.002316),
    (-2.664389, 0.003409),
    (0.563374, 0.002751),
    (-2.148685, 0.000821),
    (1.052399, 0.002036),
    (-2.066020, 0.003281),
    (0.833912, 0.002361),
    (-2.667889, 0.001941),
    (0.795832, 0.001526),
    (-1.977465, 0.001500),
    (1.472026, 0.002249),
    (-2.028483, 0.002530),
    (0.866638, 0.003334),
    (-2.138501, 0.002666),
    (0.570752, 0.001884),
    (-1.957501, 0.001664),
    (2.105474, 0.002541),
    (-1.523463, 0.003204),
    (1.427763, 0.003449),
    (-1.556441, 0.001547),
    (1.940930, 0.001007),
    (-0.582056, 0.002147),
    (2.593088, 0.002813),
    (-0.777960, 0.002442),
    (2.303151, 0.001774),
    (-0.488620, 0.001998),
    (3.029364, 0.002213),
    (0.100942, 0.001869),
    (2.818483, 0.003302),
    (-0.488217, 0.004088),
    (2.318287, 0.002240),
    (-0.776969, 0.001856),
    (3.096915, 0.002766),
    (-0.115068, 0.003227),
    (2.707130, 0.004226),
    (-0.592725, 0.003589),
    (2.094997, 0.001813),
    (-0.272767, 0.000870),
    (-2.618030, 0.002093),
    (0.439106, 0.002514),
    (-2.780087, 0.001966),
    (-0.204160, 0.000851),
    (0.481641, 0.000105),
    (2.283965, 0.002297),
    (-1.313672, 0.002746),
    (1.195753, 0.003197),
    (-1.850583, 0.001789),
    (0.293574, 0.000122),
    (-1.731033, 0.001237),
    (2.042484, 0.002222),
    (-1.706945, 0.001206),
    (0.592679, 0.002452),
    (3.133190, 0.000941),
    (-1.814421, 0.001826),
    (0.255976, 0.001915),
    (2.819881, 0.002787),
    (-0.818810, 0.001785),
    (2.247670, 0.001337),
    (0.372620, 0.001061),
    (-2.537605, 0.001565),
    (0.360664, 0.002852),
    (-3.011427, 0.002385),
    (-0.006325, 0.001233),
    (-1.646860, 0.001617),
    (1.594493, 0.003206),
    (-1.942338, 0.004206),
    (1.017496, 0.004959),
    (-2.382837, 0.003189),
    (0.617889, 0.002310),
    (-1.544149, 0.002361),
    (1.851118, 0.002318),
    (-2.223785, 0.003071),
    (0.917846, 0.003418),
    (-1.945765, 0.000537),
    (2.506256, 0.000316),
    (-0.990230, 0.002177),
    (1.973329, 0.002377),
    (-1.648746, 0.002402),
    (1.303532, 0.001733),
    (-1.599027, 0.000371),
    (3.124163, 0.000884),
    (-0.134800, 0.002179),
    (2.702524, 0.002511),
    (-0.844033, 0.002032),
    (2.101632, 0.000567),
    (0.981003, 0.001297),
    (-2.345514, 0.002593),
    (0.439943, 0.002909),
    (-3.108843, 0.002525),
    (0.181148, 0.001214),
    (-0.621296, 0.001619),
    (2.167449, 0.001828),
    (-1.604283, 0.003510),
    (1.364863, 0.003360),
    (-2.245665, 0.002521),
    (1.394096, 0.001517),
    (-0.724479, 0.002473),
    (2.003590, 0.002278),
    (-1.839559, 0.003320),
    (1.233324, 0.001768),
    (2.234633, 0.000591),
    (-2.657537, 0.000698),
    (0.130953, 0.002157),
    (-2.839097, 0.002054),
    (-0.466985, 0.001424),
    (2.771710, 0.001076),
    (1.281833, 0.001255),
    (-2.023711, 0.002626),
    (0.798869, 0.003607),
    (-2.508148, 0.003286),
    (0.209870, 0.001620),
    (-2.630370, 0.001162),
    (1.572383, 0.002063),
    (-1.771051, 0.002393),
    (1.189590, 0.002818),
    (-2.044219, 0.001537),
    (2.476396, 0.000450),
    (-0.384934, 0.001839),
    (2.335530, 0.003140),
    (-1.037422, 0.003358),
    (1.740147, 0.002331),
    (-1.639429, 0.001334),
    (2.836302, 0.000751),
    (0.196725, 0.001979),
    (3.037956, 0.002514),
    (-0.438531, 0.002639),
    (-3.043886, 0.001623),
    (1.037550, 0.001543),
    (-2.699695, 0.001928),
    (0.717319, 0.003305),
    (-2.053416, 0.002581),
    (0.686604, 0.002235),
    (-1.938411, 0.002345),
    (2.347689, 0.002604),
    (-0.833881, 0.003024),
    (1.800621, 0.003879),
    (-1.129399, 0.003353),
    (2.536678, 0.001039),
    (-0.394822, 0.001821),
    (-2.989741, 0.004059),
    (0.387821, 0.003265),
    (-3.099178, 0.002594),
    (0.652583, 0.003083),
    (-1.635066, 0.002794),
    (1.298447, 0.001609),
    (-1.832255, 0.003774),
    (1.729271, 0.003884),
    (-1.291815, 0.001819),
    (2.639107, 0.002195),
    (-0.098184, 0.004170),
    (-3.136514, 0.002734),
    (-0.805350, 0.002419),
    (3.093624, 0.004123),
    (0.591538, 0.003769),
    (-2.612008, 0.003215),
    (0.604035, 0.003897),
    (-2.472344, 0.002278),
    (-0.436157, 0.001100),
    (-2.141231, 0.000551),
    (2.416304, 0.002329),
    (-0.769209, 0.001904),
    (1.913267, 0.002070),
    (-0.567417, 0.001558),
    (-2.685272, 0.001376),
    (0.124600, 0.000982),
    (2.858730, 0.001826),
    (-0.131864, 0.001453),
    (2.071903, 0.001065),
    (-2.689961, 0.000432),
    (-0.572790, 0.001183),
    (1.730115, 0.000459),
    (-2.265299, 0.000661),
    (1.628315, 0.000957),
    (-1.315589, 0.000506),
    (-1.644455, 0.000493),
    (0.706039, 0.000398),
]

LENGTH = 2.0
SAMPLE_RATE = 11025

output = [0] * int(LENGTH * SAMPLE_RATE)

print('Please wait. This is kinda slow; there are ways to do it MUCH faster, but this script exists to prove a point...')

progress = 0

for freq, (phase_offset, magnitude) in enumerate(TABLE):
    # Update progress bar to keep the user satisfied...
    percentage = (freq*100)//len(TABLE)
    if percentage > progress:
        progress = percentage
        if percentage%10 == 0:
            sys.stdout.write('%')
        elif percentage%10 == 9:
            sys.stdout.write('0')
        elif percentage%10 == 8:
            sys.stdout.write('%d' % ((percentage+3)//10))
        else:
            sys.stdout.write('.')
        sys.stdout.flush()

    # Format frequency in Hz:
    freq *= 0.5

    # Angular frequency is radians per second:
    angular_freq = freq * math.pi * 2

    # Now we mix (sum) the frequency into the output:
    for i in range(len(output)):
        # i (sample number) to time (seconds):
        time = i / SAMPLE_RATE

        phase = angular_freq * time + phase_offset

        output[i] += math.sin(phase) * magnitude

sys.stdout.write('\n')
print('Okay; writing to synthesized.wav...')

w = wave.open('synthesized.wav', 'w')
w.setnchannels(1)
w.setsampwidth(1)
w.setframerate(SAMPLE_RATE)
for sample in output:
    sample = min(max(sample, -1), 1)
    w.writeframes(struct.pack('B', int(sample*127)+127))
w.close()
