

# Spyro 1 Practice Rom

This mod for the original Spyro the Dragon adds practice features for speedrunners including but not limited to: *full save-states*, *a level select*, *timing functionalities*, *automatic collectable resetting*, *custom skins*, *visualizations*, and many other quality of life features.

This can be played on PS1, PS2, PS3, and most emulators.   
*(however to use the full savestate functionality, you must have a PS2 75k-90k)*

## Default Hotkeys:
1. Open Custom Menu (**L2 + R2 + Triangle**)
2. Open Level Select (**Select**)
3. Quick Fly In To Current Level (**L1 + R1 + Triangle**)
4. Savestate/Loadstate (**L3** to save, **R3** to load)
5. Switch Savestate Slot (**Right Stick** **Left** & **Right**)
6. Moon-jump (**L1 + R1 + L2 + R2 + X**)
7. Respawn Spyro (**L1 + R1 + Circle**)
8. Give Key (**Triangle x3**)

# Downloads
**Be sure to download the correct version for the platform you are going to play on**
## PS2 (75k-90k)
To download the patched rom and get practicing, download the bin & cue here:
   
[PS2 (75k-90k Download)](https://github.com/C0mposer/Spyro-1-Practice-Rom/releases/download/fullrelease3.2/Spyro.1.Practice.Rom.PS2.Deckard.zip)

*Note: To play this rom on **PS2** requires either a [MechaPwn'd](https://github.com/MechaResearch/MechaPwn) or modchipped PS2 to read the burned disc. Must be a CD not a DVD.*

## PS2 (30k-70k)
*Note, the 30k-70k models of PS2's are not capable of full savestates, however they are capable of partial savestates.*
  
To download the patched rom and get practicing, download the bin & cue here:

[PS2 (30k-70k Download)](https://github.com/C0mposer/Spyro-1-Practice-Rom/releases/download/fullrelease3.2/Spyro.1.Practice.Rom.PS2.IOP.zip)


*Note: To play this rom on **PS2** requires either a [MechaPwn'd](https://github.com/MechaResearch/MechaPwn) or modchipped PS2 to read the burned disc. Must be a CD not a DVD.*
   
## PS1/EMU
To download the patched rom and get practicing, download the bin & cue here:
   
[PS1/EMU Download](https://github.com/C0mposer/Spyro-1-Practice-Rom/releases/download/fullrelease3.2/Spyro.1.Practice.Rom.PS1.zip)

## Menu Features:

## IL Settings
### IL Mode:
This setting lets you practice & time individual level runs for most categories! [Click here to view the IL spreadsheet](https://www.docs.google.com/spreadsheets/d/1FLkc8-dGTO4jJhAi5nDrhm0h6qlVflPlAIlXAYEylsg/edit#gid=1140931951)

- Once you enter/re-fly in to a level, a timer will keep track of its time starting the first frame the HUD starts coming down from the fly in.
- Once you leave through a vortex/through the pause menu, it will then stop the first frame the HUD for the "RETURNING HOME" text starts coming down in the loading screen.
- The loading screen will then display your individual level time in big text, and underneath display the loadless version of the same time to account for dragons in slightly smaller text.
- It will also reload you back into the same level to let you practice on loop.
- This timer should be accurate within 1 frame (~0.03) in most situations.
	 
### IL Timer Display: 
This setting controls the main display setting for the IL Timer

- **IL TIMER DISPLAY AT END** mode displays the IL timer on screen only when you finish a level. This is to reduce minor lag that could be caused from the extra rendering of the text mobys.
- **TIMER ALWAYS** mode displays the IL timer on screen at all times, as well as at the end.    

### Display At Dragon: 
This setting will render the IL Timer when you freed a dragon.

### Display Landing: 
This setting will render the IL Timer when land on the ground.

### Loop Level: 
This setting controls if the level should loop upon exiting in IL Mode.

## Manual Timer Settings
### Manual Timer: 
This setting displays an on screen timer that resets upon reloading your state/reloading spyro, and stops upon pausing. Can be used for manually timing movement, routes, & tricks in game!

### Manual Timer Display Mode
- **DISPLAY ON STOPPED** mode displays the timer on screen only when you pause to stop the timer. This is to reduce minor lag that could be caused from the extra rendering of the text mobys.
- **DISPLAY ALWAYS** mode displays the timer on screen at all times.


## Savestate Settings
### Current Slot
This lets you change your current savestate slot manually.

### Save Button
This lets you change your savestate button from 3 options:
- L3
- Start
- L3 x2 (twice in a row)

### Load Button
This lets you change your loadstate button from 2 options:
- R3
- Select

### Switch Slot
This lets you change your hotkey for switching savestate slots from 2 options:
- Rstick Left & Right
- L1 + R1 + Dpad Left & Right

## Misc Settings
### Sparx Mode:
- **SPARX NORMAL** mode is sparx's normal behavior.
- **PERMA SPARX ON** mode keeps sparx gold at all times, and your health will never deplete.
- **SPARXLESS ON** mode keeps sparx dead at all times, allowing for sparxless practice.
	 
### Show Dragon Touch:
This setting shows the amount of frames you lost to a dragon touch (30fps).


### Disable Portal
With **Disable Portal** enabled, it will automatically load a savestate the moment the camera touches the portal. This allows you to practice portal entries much more effeciently.

If you have manual timer on, the timer will stop the moment the camera touches the portal, allowing you to time portal entries as well.


### Track Consistency
With **Track Consistency** on, you can easily keep track of your consistentcy at tricks/hard movement from within the game.
When you turn it on you will notice 2 numbers in the bottom left, a numerator and denominator. 
The numerator represents your successful attempts at something, and the denominator represents your total attempts at something.  

Here are the controls:  
**Loadstate Button** - Automatically increase total attempts  
**Right Stick Up** - Manually increase successful attempts  
**Right Stick Down** - Manually decrease successful attempts  
**L2 + R2 + Right Stick Up** - Manually increase total attempts  
**L2 + R2 + Right Stick Down** - Manually decrease total attempts  
**L2 + R2** - Show tracker for 2 seconds  
**Loadstate Button x3** - Reset both total and successful attempts back to 0  

*(alt hotkey for PS1/70k and below)*
**HOLD L2 & R2 + PRESS Circle x3** - Reset both total and successful attempts back to 0  
	 
### Show Sparx Range
With **Show Sparx Range** on, it will draw an octagon around Spyro representing sparx's range for gem collection.

### Super Mode
With **Super Mode** enabled, you can supercharge & superfly in any level!  
To superfly, simply glide.   
To supercharge, first jump, then press square twice when in the air.  
While supercharging you can increase your supercharge speed with **R1**, and decrease your supercharge speed with **L1**.  

## Cosmetic Menu
### BG Color:
You can select the pause/inventory menu color from a range of pre-selected options.
### Spyro Skin:
Choose from our selection of Spyro Skins.
### Flame Skin:
Choose from our selection of Flame Skins.
### Sparx Skin:
Choose from our selection of Sparx Skins.

### Skin Credits
Skins included are made by:
Composer, OddKara, Pepper, Texensis, & Jayobean!

Also credit to Pepper for the custom portrait in Gnasty's Loot, as well as the splash screen :)

### Custom Spyro Skin
If you would like to patch in your own custom spyro skin into the practice rom, see here:
**[Spyro 1 Practice Rom Skin Patcher](https://github.com/C0mposer/Spyro1PracticeRomSkinPatcher)**

	 

## Other Features:

### Automatically Skips Intro:
Skips straight to "The Adventure Continues..."
	
### Nestor Skip:
Nestor is always skippable like any other dragon. Allows for faster nestor skip practice.

### Rat Practice:
- Freeze/Unfreeze rat - *Triangle 2 times*  
  
Allows for a longer time to set up rat-surf.  
The rat is saved as a part of the sudo-savestate (L3/R3) as well

### Open/Close heads in Gnasty's World
- Open/Close Twilight Harbor - *L2 3 times*   
- Open/Close Gnasty Gnorc - *R2 3 times*   
- Open/Close Gnasty's Loot - *R1 3 times*   

### Credits Skip Teleport
- Warp to end of Gnasty Gnorc fight - *L1 + R1 + X*   

### Loot Plane Teleports
- Warp before plane 2 with key - *L1 + R1 + X*   
- Warp before plane 1 with key - *L1 + R1 + Square*   

### Moonjump
- Moonjump by press *L2 + R2 + L1 + R1 + X*  

# Patch Game
If you wish to patch your own personal spyro 1 .bin file instead, visit here:
[Patch Personal Spyro 1 bin](https://c0mposer.github.io/Spyro-1-Practice-Rom/)

## Compiling & Building
If you wish to compile the mod yourself, you'll need a few prerequisites
1. Compiling this mod requires the [psx-modding-toolchain by Redhot](https://github.com/mateusfavarin/psx-modding-toolchain). 
2. Once you have installed it and its pre-requisites, place the folder [from the source code download](https://github.com/C0mposer/Spyro-1-Practice-Codes/archive/refs/heads/master.zip), into the **/games/** folder of your psx-modding-toolchain directory.
4. Place your personal spyro 1 bin file in **/build/** and rename it to **spyro1.bin**
5. Browse to the **/mods/PracticeCodes/** directory, and open the MOD.bat file. From here you should be prompted with multiple options in a command line gui

#### Building BIN/CUE
	
	1. First type 1 then press enter to compile, then, either type 3 PS2_NTSC version, or type 1 for the NTSC version which will work for all other platforms.
	2. After it has compiled, type 4 then enter for "Build Iso", then, type 3 PS2_NTSC version, or type 1 for the NTSC version which will work for all other platforms.
	3. After it has built, your bin/cue should be in /build/
	4. Be sure you built for the correct version. PS2_NTSC will not work on PS1/EMU, and visa-versa.

#### Generating xdelta patch
	
	1. First type 1 then press enter to compile, then, type 3 for the PS2_NTSC version, or type 1 for the NTSC version which will work for all other platforms.
	2. After it has compiled, type 5 then press enter for "Generate xdetla Patch", then type 3 for the PS2_NTSC version, or type 1 for the NTSC version which will work for all other platforms.
	3. After it has built, your xdelta patch should be in /build/
	4. Be sure you built for the correct version. PS2_NTSC will not work on PS1/EMU, and visa-versa.
	

## Tools Used In Creation

 - [psx-modding-toolchain by Redhot](https://github.com/mateusfavarin/psx-modding-toolchain) for the automation of compiling C code to MIPS object code targeted for the PS1, and building a bin/cue with the mod files injected correctly.
 - [Bizhawk](https://github.com/TASEmulators/BizHawk) for searching/poking PS1 ram values easily
 - [PCSX-Redux](https://github.com/grumpycoders/pcsx-redux/) for hot-reloading mods in for quick testing. Also for its debugging features.
 - [Ghidra](https://github.com/NationalSecurityAgency/ghidra) in combination with the [PSX Executable Loader Plugin](https://github.com/lab313ru/ghidra_psx_ldr) for reverse engineering functions in the game.

## Contact

If you need any help building this project, or are just trying to get into spyro/game modding in general, feel free to reach out to us on discord: **Composer** & **OddKara** :)
