# 1.2 Code editors

A code editor is the place where programmers spend most of their time.

There are two archetypes: IDE and lightweight editors. Many people feel comfortable choosing one tool of each type.

## IDE

The term [IDE](https://en.wikipedia.org/wiki/Integrated_development_environment "IDE") (Integrated Development Environment) means a powerful editor with many features that usually operates on a “whole project”. As the name suggests, that’s not just an editor, but a full-scale “development environment”.

An IDE loads the project (can be many files), allows navigation between files, provides autocompletion based on the whole project (not just the open file), integrates with a version management system (like git), a testing environment and other “project-level” stuff.

If you haven’t considered selecting an IDE yet, look at the following variants:

* [WebStorm](http://www.jetbrains.com/webstorm/ "WebStorm") for frontend development and other editors of the same company if you need additional languages.

* [Visual Studio](https://www.visualstudio.com/ "Visual Studio") is fine if you’re a .NET developer, and a free version is available (Visual Studio Community)

* [Netbeans](http://netbeans.org/ "Netbeans").

All of the IDEs except Visual Studio are available on Windows, MacOs and Linux. Visual Studio doesn’t work on Linux.

Most IDEs are paid, but have a trial period. Their cost is usually negligible compared to a qualified developer’s salary, so just choose the best one for you.

## Lightweight editors

“Lightweight editors” are not as powerful as IDEs, but they’re fast, elegant and simple.

They are mainly used to instantly open and edit a file.

The main difference between a “lightweight editor” and an “IDE” is that an IDE works on a project-level, so it loads much more data on start, analyzes the project structure if needed and so on. A lightweight editor is much faster if we need only one file.

In practice, lightweight editors may have a lot of plugins including directory-level syntax analyzers and autocompleters, so there’s no strict border between a lightweight editor and an IDE.

The following options deserve your attention:

* [Visual Studio Code](https://code.visualstudio.com/ "Visual Studio Code") (cross-platform, free).

* [Atom](https://atom.io/ "Atom") (cross-platform, free).

* [Sublime Text](http://www.sublimetext.com/ "Sublime Text") (cross-platform, shareware).

* [Notepad++](https://notepad-plus-plus.org/ "Notepad++") (Windows, free).

* [Vim](http://www.vim.org/ "Vim") and [Emacs](https://www.gnu.org/software/emacs/ "Emacs") are also cool, if you know how to use them.

## My favorites

The personal preference of the author is to have both an IDE for projects and a lightweight editor for quick and easy file editing.

I’m using as a lightweight editor – [Sublime Text](http://www.sublimetext.com/ "Sublime Text") or [Vim](http://www.vim.org/ "Vim").

## Let’s not argue

using for a long time and are happy with.

There are other great editors in our big world. Please choose the one you like the most.

The choice of an editor, like any other tool, is individual and depends on your projects, habits, personal preferences.
