# 1.1 An Introduction to JavaScript

Let’s see what’s so special about JavaScript, what we can achieve with it and which other technologies play well with it.

## What is JavaScript?

JavaScript was initially created to “make webpages alive”.

The programs in this language are called scripts. They can be written right in the HTML and execute automatically as the page loads.

Scripts are provided and executed as a plain text. They don’t need a special preparation or a compilation to run.

In this aspect, JavaScript is very different from another language called [Java](https://en.wikipedia.org/wiki/Java "Java").

***
#### Why JavaScript?

When JavaScript was created, it initially had another name: “LiveScript”. But Java language was very popular at that time, so it was decided that positioning a new language as a “younger brother” of Java would help.

But as it evolved, JavaScript became a fully independent language, with its own specification called [ECMAScript](https://en.wikipedia.org/wiki/ECMAScript "ECMAScript"), and now it has no relation to Java at all.
***

At present, JavaScript can execute not only in the browser, but also on the server, or actually on any device where there exists a special program called the [JavaScript engine](https://en.wikipedia.org/wiki/JavaScript_engine "JavaScript engine").

The browser has an embedded engine, sometimes it’s also called a “JavaScript virtual machine”.

Different engines have different “codenames”, for example:

- [V8](https://en.wikipedia.org/wiki/JavaScript_engine "V8") – in Chrome and Opera.

- [SpiderMonkey](https://en.wikipedia.org/wiki/SpiderMonkey "SpiderMonkey") – in Firefox.

- ... There are other codenames like “Trident”, “Chakra” for different versions of IE, “ChakraCore” for Microsoft Edge, “Nitro” and “SquirrelFish” for Safari etc.

The terms above are good to remember, because they are used in developer articles on the internet. We’ll use them too. For instance, if “a feature X is supported by V8”, then it probably works in Chrome and Opera.

***
#### How engines work?

Engines are complicated. But the basics are easy.

1. The engine (embedded if it’s a browser) reads (“parses”) the script.
2. Then it converts (“compiles”) the script to the machine language.
3. And then the machine code runs, pretty fast.

The engine applies optimizations on every stage of the process. It even watches the compiled script as it runs, analyzes the data that flows through it and applies optimizations to the machine code based on that knowledge. At the end, scripts are quite fast.
***

## What can in-browser JavaScript do?

The modern JavaScript is a “safe” programming language. It does not provide low-level access to memory or CPU, because it was initially created for browsers which do not require it.

The capabilities greatly depend on the environment that runs JavaScript. For instance, [Node.JS](https://en.wikipedia.org/wiki/Node.js "Node.JS") supports functions that allow JavaScript to read/write arbitrary files, perform network requests etc.

In-browser JavaScript can do everything related to webpage manipulation, interaction with the user and the webserver.

For instance, in-browser JavaScript is able to:

* Add new HTML to the page, change the existing content, modify styles.

* React to user actions, run on mouse clicks, pointer movements, key presses.

* Send requests over the network to remote servers, download and upload files (so-called [AJAX](https://en.wikipedia.org/wiki/Ajax_(programming) "AJAX") and [COMET](https://en.wikipedia.org/wiki/Comet_(programming) "COMET") technologies).

* Get and set cookies, ask questions to the visitor, show messages.

* Remember the data on the client-side (“local storage”).

## What CAN’T in-browser JavaScript do?

JavaScript’s abilities in the browser are limited for the sake of the user’s safety. The aim is to prevent an evil webpage from accessing private information or harming the user’s data.

The examples of such restrictions are:

* JavaScript on a webpage may not read/write arbitrary files on the hard disk, copy them or execute programs. It has no direct access to OS system functions. 

  Modern browsers allow it to work with files, but the access is limited and only provided if the user does certain actions, like “dropping” a file into a browser window or selecting it via an <input> tag.

  There are ways to interact with camera/microphone and other devices, but they require a user’s explicit permission. So a JavaScript-enabled page may not sneakily enable a web-camera, observe the surroundings and send the information to the [NSA](https://en.wikipedia.org/wiki/National_Security_Agency "NSA").

* Different tabs/windows generally do not know about each other. Sometimes they do, for example when one window uses JavaScript to open the other one. But even in this case, JavaScript from one page may not access the other if they come from different sites (from a different domain, protocol or port).

  This is called the “Same Origin Policy”. To work around that, both pages must contain a special JavaScript code that handles data exchange.

  The limitation is again for user’s safety. A page from http://anysite.com which a user has opened must not be able to access another browser tab with the URL http://gmail.com and steal information from there.

* JavaScript can easily communicate over the net to the server where the current page came from. But its ability to receive data from other sites/domains is crippled. Though possible, it requires explicit agreement (expressed in HTTP headers) from the remote side. Once again, that’s safety limitations.

## What makes JavaScript unique?

There are at least three great things about JavaScript:

* Full integration with HTML/CSS.

* Simple things done simply.

* Supported by all major browsers and enabled by default.

Combined, these three things exist only in JavaScript and no other browser technology.

That’s what makes JavaScript unique. That’s why it’s the most widespread tool to create browser interfaces.

While planning to learn a new technology, it’s beneficial to check its perspectives. So let’s move on to the modern trends that include new languages and browser abilities.

## Languages “over” JavaScript

The syntax of JavaScript does not suit everyone’s needs. Different people want different features.

That’s to be expected, because projects and requirements are different for everyone.

So recently a plethora of new languages appeared, which are transpiled (converted) to JavaScript before they run in the browser.

Modern tools make the transpilation very fast and transparent, actually allowing developers to code in another language and autoconverting it “under the hood”.

Examples of such languages:

* [CoffeeScript](http://coffeescript.org/ "CoffeeScript") is a “syntactic sugar” for JavaScript, it introduces shorter syntax, allowing to write more precise and clear code. Usually Ruby devs like it.

* [TypeScript](http://www.typescriptlang.org/ "TypeScript") is concentrated on adding “strict data typing”, to simplify development and support of complex systems. It is developed by Microsoft.

* [Dart](https://www.dartlang.org/ "Dart") is a standalone language that has its own engine that runs in non-browser environments (like mobile apps). It was initially offered by Google as a replacement for JavaScript, but as of now, browsers require it to be transpiled to JavaScript just like the ones above.

There are more. Of course even if we use one of those languages, we should also know JavaScript, to really understand what we’re doing.

## Summary

* JavaScript was initially created as a browser-only language, but now it is used in many other environments as well.

* At this moment, JavaScript has a unique position as the most widely-adopted browser language with full integration with HTML/CSS.

* There are many languages that get “transpiled” to JavaScript and provide certain features. It is recommended to take a look at them, at least briefly, after mastering JavaScript.
