# PART 1

The JavaScript Language

Here we learn JavaScript, starting from scratch and go on to advanced concepts like OOP.

We concentrate on the language itself here, with the minimum of environment-specific notes.

### An Introduction

1.1 [An Introduction to JavaScript](pages/1.1-An-Introduction-to-JavaScript.md)

1.2 [Code editors](pages/1.2-Code-editors.md)

1.3 [Developer console](pages/1.3-Developer-console.md)

### JavaScript Fundamentals

2.1 [Hello, world!](pages/2.1-Hello-world.md)

2.2 [Code structure](pages/2.2-Code-structure.md)

2.3 [The modern mode, "use strict"](pages/2.3-The-modern-mode.md)

2.4 [Variables](pages/2.4-Variables.md)

2.5 [Data types](pages/2.5-Data-types.md)

2.6 [Type conversions](pages/2.6-Type-conversions.md)

2.7 [Operators](pages/2.7-Operators.md)

2.8 [Comparisons](pages/2.8-Comparisons.md)

2.9 [Interaction: alert, prompt, confirm](pages/2.9-Interaction.md)

2.10 [Conditional operators: if, '?'](pages/2.10-Conditional-operators.md)

2.11 [Logical operators](pages/2.11-Logical-operators.md)

2.12 [Loops: while and for](pages/2.12-Loops.md)

2.13 [The "switch" statement](pages/2.13-The-switch-statement.md)

2.14 [Functions](pages/2.14-Functions.md)

2.15 [Function expressions and arrows](pages/2.15-Function-expressions-and-arrows.md)

2.16 [JavaScript specials](pages/2.16-JavaScript-specials.md)

### Code quality

3.1 Debugging in Chrome

3.2 Coding style

3.3 Comments

3.4 Ninja code

3.5 Automated testing with mocha

3.6 Polyfills

### Objects: the basics

4.1 [Objects](pages/4.1-Objects.md)

4.2 [Garbage collection](pages/4.2-Garbage-collection.md)

4.3 [Symbol type](pages/4.3-Symbol-type.md)

4.4 [Object methods, "this"](pages/4.4-Object-methods.md)

4.5 [Object to primitive conversion](pages/4.5-Object-to-primitive-conversion.md)

4.6 [Constructor, operator "new"](pages/4.6-Constructor-new.md)

### Data types

5.1 [Methods of primitives](pages/5.1-Primitives-methods.md)

5.2 Numbers

5.3 Strings

5.4 Arrays

5.5 Array methods

5.6 Iterables

5.7 Map, Set, WeakMap and WeakSet

5.8 Object.keys, values, entries

5.9 Destructuring assignment

5.10 Date and time

5.11 JSON methods, toJSON