/* Adopt from JOS/xv6 */

/* Simple linker script for the JOS kernel.
   See the GNU ld 'info' manual ("info ld") to learn the syntax. */

OUTPUT_FORMAT("elf32-i386", "elf32-i386", "elf32-i386")
OUTPUT_ARCH(i386)
ENTRY(_start)

SECTIONS
{
	/* BUGENC：VMA / link address */
	/* Link the kernel at this address: "." means the current address */
	. = 0xE0100000;

	PROVIDE(kernStart = .);

	/* AT(...) gives the load address of this section, which tells
	   the boot loader where to load the kernel in physical memory */
	/* BUGENC: LMA */
	.text : AT(0x100000) {
		*(.text .stub .text.* .gnu.linkonce.t.*)
	}

	PROVIDE(etext = .);	/* Define the 'etext' symbol to this value */

	.rodata : {
		*(.rodata .rodata.* .gnu.linkonce.r.*)
	}

	/* Include debugging information in kernel memory */
	.stab : {
		PROVIDE(__STAB_BEGIN__ = .);
		*(.stab);
		PROVIDE(__STAB_END__ = .);
	}

	.stabstr : {
		PROVIDE(__STABSTR_BEGIN__ = .);
		*(.stabstr);
		PROVIDE(__STABSTR_END__ = .);
	}

	/* Adjust the address for the data segment to the next page */
	. = ALIGN(0x1000);

	/* The data segment */
	.data : {
		*(.data)

		/* Put the embedded elf here to get the correct load
		   address (pa) of 001xxxxx */
		/* PROVIDE(embUserElf = .); */
                *(.embuser*)
	}

	.bss : {
		PROVIDE(edata = .);
		*(.bss)
		PROVIDE(end = .);
		BYTE(0)
	}

	PROVIDE(kernEnd = .);

	/DISCARD/ : {
		*(.eh_frame .note.GNU-stack)
	}
}
