# Contributing to MLstatkit

First off, thanks for taking the time to contribute!

The following is a set of guidelines for contributing to MLstatkit, which are hosted on [GitHub](https://github.com/Brritany/MLstatkit). These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for MLstatkit. Following these guidelines helps maintainers and the community understand your report, reproduce the behavior, and find related reports.

Before creating bug reports, please check [this list](https://github.com/Brritany/MLstatkit/issues) as you might find out that you don't need to create one. When you are creating a bug report, please include as many details as possible.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for MLstatkit, including completely new features and minor improvements to existing functionality. Before creating enhancement suggestions, please check [this list](https://github.com/Brritany/MLstatkit/issues) to see if the enhancement has already been suggested. When suggesting enhancements, please provide as clear and detailed a description as possible, including any relevant examples or documents.

### Pull Requests

The process described here has several goals:

- Maintain MLstatkit's quality
- Fix problems that are important to users
- Engage the community in working toward the best possible MLstatkit

#### Getting Started

- Fork the repository on GitHub and clone your fork locally.
- Install any required dependencies.
- Create a branch for your edits.

#### Making Changes

- Make your changes in a new git branch.
- Write or adapt tests as needed.
- Run the full project test suite with your changes and ensure all tests pass.

#### Submitting Your Changes

- Push your changes to a branch in your fork of the repository.
- Submit a pull request to the main MLstatkit repository.
- The MLstatkit team will review your pull request and either merge it, request changes, or provide feedback.

We look forward to your contributions. Thank you for helping us improve MLstatkit!
