"""Added a quiz to the database

Revision ID: 9adfe1ce4468
Revises: fb007aeff87b
Create Date: 2023-07-07 16:15:07.987402

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = '9adfe1ce4468'
down_revision = 'fb007aeff87b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('option', schema=None) as batch_op:
        batch_op.add_column(sa.Column('content', sa.String(length=255), nullable=False))
        batch_op.alter_column('is_correct',
               existing_type=mysql.TINYINT(display_width=1),
               nullable=True)
        batch_op.drop_column('option_text')

    with op.batch_alter_table('question', schema=None) as batch_op:
        batch_op.add_column(sa.Column('content', sa.String(length=255), nullable=False))
        batch_op.drop_column('question_text')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('question', schema=None) as batch_op:
        batch_op.add_column(sa.Column('question_text', mysql.VARCHAR(length=255), nullable=False))
        batch_op.drop_column('content')

    with op.batch_alter_table('option', schema=None) as batch_op:
        batch_op.add_column(sa.Column('option_text', mysql.VARCHAR(length=255), nullable=False))
        batch_op.alter_column('is_correct',
               existing_type=mysql.TINYINT(display_width=1),
               nullable=False)
        batch_op.drop_column('content')

    # ### end Alembic commands ###
