## What's new in Low-Latency HLS

https://developer.apple.com/wwdc20/10228

Presenter: _Roger Pantos_

- Comes out of beta this year
- Available in iOS 14, tvOS 14, watchOS 7 and this year's macOS
- Includes support for bit-rate switching, FairPlay Streaming, fMP4 CMAF, ad insertion, captioning
- Native app support, no entitlement necessary
- [draft-pantos-hls-rfc8216bis07](https://tools.ietf.org/html/draft-pantos-hls-rfc8216bis-07) and later now includes LL-HLS
- Includes Low-Latency Server Configuration Profile
- Includes CDN tune-in algorithm
- Updated informative articles on [developer.apple.com](https://developer.apple.com/)
  - [Protocol Extension for Low-Latency HLS](https://developer.apple.com/documentation/http_live_streaming/protocol_extension_for_low-latency_hls_preliminary_specification)
  - [HLS Authoring Specification for Apple Devices](https://developer.apple.com/documentation/http_live_streaming/hls_authoring_specification_for_apple_devices)
- **Significant changes and improvements to the protocol**
  - **Reducing segment delay**
    - Approach described last year using HTTP/2 Push to send segment with Playlist is not compatible with some delivery models
    - **Replaced Push with Blocking Preload Hints**
      - Client requests next part in advance
      - Server will hold on to the request until it can send it
      - Also triggers global CDN cache fill
      - [Discover HLS Blocking Preload Hints session](https://developer.apple.com/videos/play/wwdc2020/10229/) for more information
  - **Other improvements**
    - Eliminated HLS report
      - All Rendition Reports are provided unconditionally
    - Defined EXT-X-DATERANGE handling for Playlist Delta Updates
      - [Optimize Live Streams with HLS Playlist Delta Updates](https://developer.apple.com/videos/play/wwdc2020/10230/) session for more detailed information
    - Added signaling of gaps in Parts and Rendition Reports
      - New attributes: GAP=YES in EXT-X-PART and EXTT-X-RENDITION-REPORT
      - This allowing clients to deal better with encoded outages in Low-Latency streams
- **Low-Latency HLS Tools changes**
  - Reference implementation now produces fMP4/CMAF
  - Added self-contained LL-HLS origin written in Go
  - Incorporated Low-Latency HLS tools into the regular HLS tools package
    - Find out more in [Improve Stream Authoring with HLS Tools](https://developer.apple.com/videos/play/wwdc2020/10225/) session
- **Summary of important changes**
  - Replaced HTTP/2 Push with Preloading Hinting
  - Simplified Delivery Directives
  - Generate CMAF in reference tools
- **Everything is included in the current HLS spec**
