## Get your test results faster

https://developer.apple.com/wwdc20/10221

Presenters: _Sean Olszewski_

- **The Testing Feedback Loop**
  - Write tests > run tests > Interpret result >if sufficient confidence [ > Next task] else go back to write tests
  - Short feedback loops is important because that means you get results from your tests faster, you can ship features to your users faster.
  - Real world example: Result bundle from that CI job, which never finished. Due to dead lock, poorly chosen timeout.
- **Execution Time Allowance [NEW in XCode 12]**
  - When enabled, Xcode enforces a limit on the amount of time each individual test can take. When a test exceeds this limit, Xcode will first capture spin dump, then kill the test that hung, restart the test runner, so that the rest of the suite can execute.
  - A spin dump shows you which functions each thread is spending the most time in. It's also possible to manually capture spin dump from Terminal using the spin dump command or from within Activity Monitor. 
  - By default, each test gets 10 minutes. If you need to a specific test or test class, you can use the `executionTimeAllowance` API to special case a particular test or subclass. For values under 60 seconds, they'll be rounded up to 60 seconds, the nearest whole minute.
  - Prevent a test requests unlimited time by enforcing a maximum allowance.
  - You can customize the default time allowance and a maximum allowance either via a setting in the Test Plan or through an Xcodebuild option.
  - Use `XCTest`'s performance APIs to automate testing for regressions in the performance. Use Instruments to identify what parts of your code are slow,
- **Parallel Distributed Testing**
  - Xcode build will distribute tests to each run destination by class. Each device runs a single test class at a time.
  - If you're testing logic that is device or OS specific, this can lead to unexpected failures or skipped tests.
