## Explore app clips

https://developer.apple.com/wwdc20/10174

Presenters: _James Savage, Luming Yin_

- **What is an App Clip?**
    - App Clip Experience URL is required to run App Clips which are parts of your app
    - On-demand app experiences
- **App Clip Experiences**
    - App Clip URLs are similar to Universal Links
    - Registered using App Store Connect
    - Surfaced through user actions via NFC / QR codes / links in Safari or other apps / Apple App Clip codes combine the ease of NFC and visual codes so they can be tapped or scanned
- **New App Clip Target in Xcode**
    - Contains all assets
    - Needs to be submitted along with the app for review
    - It gets downloaded separately if the app is not installed on user’s device
    - Should be as small as possible for quick downloads (less than 10MB but with enough assets to load UI quickly)
    - Focused user flows - one at a time
- **Demo**
    - Ordering smoothies
    - New App Clip target embedded in the application
        - Name and bundle ID for App Clip added
        - It can build and run with boilerplate code right away
    - Add code and resources
        - `NutritionFacts` dependency added
        - Create new Assets Catalog as shared assets
            - Drag App Icon, Colors and other image assets required for app clip into the shared assets catalog
        - Add the required model and view files to App Clip target
            - Let go of unwanted Swift files like navigation
        - Conditionally compile out the references to files not added to App Clip
            - Build Settings > Swift Compiler custom flags > Active Compilation Conditions > Add APPCLIP condition for required schemes.
            - Use #if !APPCLIP to compile out unwanted references in Swift code
    - Write code for App Clip
        - Add required models and views to the new AppClip
        - Include existing views in the App Clip’s content view
- **Technology Overview**
    - App Clips are built using same UI components as an app
    - When launched, it receives `NSUserActivity`
        - Use the URL to identify the type of experience to be handled
    - Unlike extensions, App Clip can make use of all iOS SDK APIs
        - Note: Access to sensitive data is limited
        - Always check if data is available
    - New location confirmation API helps get the location quickly without requesting full access
    - New API for migrating data from App Clip to main app using shared data container once installed
    - App Clip and its local storage will be deleted after period of inactivity
        - Not included in backups
    - Can not be launched via Universal Links or custom URL schemes
    - Can not include bundle extensions like content blockers
- **Device states and transitions**
    - User scans QR code
    - iOS locates, downloads and runs the App Clip
    - If the App Clip is not revisited for a while, the App Clip and its data gets deleted
        - Treat App Clip data as cache; which can be deleted
    - If the App Clip is visited frequently, its lifespan will be extended and data may never be cleared
        - When user downloads your app, iOS will automatically migrate the data container and the permissions that were already granted by the user
        - iOS still deletes the App Clip and its container after copying the data container to the app
- **Other technologies**
    - Apple Pay
    - Notifications
    - SwiftUI
    - `SKOverlay` / `AppStoreOverlayModifier` (refer to [What’s new with in-app purchase](https://developer.apple.com/wwdc20/10661/) session)
    - `ASAuthorizationController` for sign in or sign up