## Design for location privacy

https://developer.apple.com/wwdc20/10162

Presenter: _Rachel Needle_

- Today people share precise location data
- **In iOS 14, Core Location allowing users to control and share their approximate location**
- All kinds of apps will be impacted by this change (even Apple's apps)
- **How to adapt the app** to work without precise location?
  - **Prioritize user control**
    - Give everyone control over their location data they share and respect their preferences
    - Don't require precise location
    - Replace precise data with approximate where possible
    - Identify where else you use precise location and remove non-essential uses of precise location
  - **Build trust through transparency**
    - Communicate with people about what data your app uses and how that data is used
    - Make status easy to access
    - Allow users to change their decision
  - **Offer proportional value**
    - Only ask for precise location when you really need it
    - Request precise location in response to user action
    - Position the request close to the value it provides
  - Consider checking out these two sessions to **get detailed information**
    - [Build trust through better privacy](https://github.com/Blackjacx/WWDC#build-trust-through-better-privacy)
    - [What's new in location](https://github.com/Blackjacx/WWDC#whats-new-in-location)
