## Configure and link your app clips

https://developer.apple.com/wwdc20/10146/

Presenters: _Ada Chan, Luming Yin_

- **Intro**
  - App Clips provide entry points to your users to experience your app with minimal friction.
  - Use deep-linked navigation to present the App Clip
- **User Quest**
  - User is in a smoothie shop. They see an NFC tag and tap it using the phone.
  - An app clip shows up on the phone's lockscreen with summarized detail about that smoothie.
  - User taps "open" and a single screen of your app shows up.
  - User can then proceed to the payment via Apple Pay.
- **Activation**
  - Tapping NFC tags or scanning QR codes - they're just deep links after all (a URL)
  - Maps and Siri Nearby Suggestions (for registered businesses)
  - Smart app banner in your website (shown in Safari and Messages)
  - Apple App Clip codes will be introduced later this year (it's a prettified QR code)
  - If the user already has the your app installed, following an App Clip link will open the full app instead.
- **Setup**
  - Configure web server and App Clip for link handling
    - Web Server: Update the apple-app-site-association file
    - App Clip: Add associated domains entitlement and handle NSUserActivity
  - Configure App Clip default and advanced experiences on App Store Connect
    - Layout requirements:
      - Title: 18 chars limit
      - Subtitle: 43 chars limit
      - Image:
        - Size: 3000 x 2000px
        - Aspect Ratio: 3:2
        - Format: png/jpg
        - Transparency: No
    - **Best Practices**
      - URL mapping is based on **most specific** prefix match against registered App Clip experience URLs
      - Your App Clip must be able to launch using an exact registered URL. For example:
        - App registers https://bikesrental.com/rent instead of https://website.com/rent?bikeID=2
        - When receiving https://website.com/rent?bikeID=2, it should be able to deliver the https://website.com/rent App Clip
        - App is responsible for parsing the remaining arguments and presenting the specific bike with ID 2
        - You can also register a more specific URL if you want to provide a different and more specific App Clip experience for it
  - Configure the Smart App Banner to open App Clip (add this if the content of your web page can be delivered as a better and more streamlined app experience)
    - Add/update your website's HTML to add the Smart App Banner meta tag
- **Test**
  - Specify an App Clip URL under the `_XCAppClipURL` environment variable to launch App Clip from Xcode
  - TestFlight - new App Clips section in App Store Connect