## Design for intelligence: Apps, evolved

https://developer.apple.com/wwdc20/10086

Presenter: _Mark Mikin_

- This is one of those "why" sessions. Why we should build something?
- **Intelligent System Experience**
  - The main idea is to be proactive
  - Intelligence is how the OS works with the apps that people use every day to make the "every day" easier for people
  - Intelligence is design (it should be viewed as a design practice)
- **Living design**. What is that?
  - The core job of the designer is to help people accomplish something
  - One of the key ways a designer can leverage this is by using elements familiar to the user
  - People use a signifier or a symbol
  - For example, "Share" button. In the case of iOS, almost everyone can easily recognize the "default" share symbol because it consistently gets used across a lot of apps
  - Intelligence is a platform convention, it's in a static glyph or icon, like the share button. It's live
  - Intelligence manifests itself by adapting to how the system, the platform, conforms to how people use their devices
  - Intelligence is expected (people expect their devices and apps to be smart)
- **Extensibility**
  - Intelligence is powered by an app through extensibility
  - Apps have actually been evolving over time
  - A lot of the technologies built by Apple that are foundational to the intelligence system (starting from App Extensions debuted at WWDC 2014 and ending with App Clips so far)
  - It's built to help growing ecosystem of devices and apps
  - Intelligence system is built from a foundation of respecting users privacy
- In the next sessions about system intelligence, Apple's team will try to cover it from a few different angles
