## Eliminate animation hitches with XCTest

https://developer.apple.com/wwdc20/10077

Presenter: _Tanuja Mohan_

- **Hitch:** A frame appears on screen later than expected
- **VSYNC:** Time the screen swaps the frame onto the display 
- **Hitch time:** Time in *ms* that a frame is late to display
- **Hitch ratio:** Hitch time in **ms** per second for a given duration
- Apple doesn't use frames per second (fps) since:
  - 60 or 120 fps is not always the desired target
  - Display may intentionally not be updated
  - Target frame rate may intentionally be lower than possible
- Hitch ratio is always comparable across tests, following ratios are recommended:
  - Good: < 5ms/s
  - Warning: 5..10ms/s - users will start recognizing hitches
  - Critical: >10ms/s
- Can be measured using `XCTestMetrics` and unit tests or for production apps using `MetricsKit` and Xcode Organizer
- `XCTOSSignpostMetric` gives you the following when using an animation os_signpost interval:
  - Duration
  - Total count of hitches
  - Total duration of hitches
  - Hitch time ratio
  - Frame rate
  - Frame count
- Specify an animation os_signpost interval by:
  - `os_signpost(.animationBegin, log: logHandle, name: "performanceAnimationInterval")`
  - `os_signpost(.end, log: logHandle, name: "performanceAnimationInterval")`
- UIKit has pre-defined metrics:
  - `XCTOSSignpostMetric.navigationTransitionMetric`
  - `XCTOSSignpostMetric.customNavigationTransitionMetric`
  - `XCTOSSignpostMetric.scrollDecelerationMetric`
  - `XCTOSSignpostMetric.scrollDraggingMetric`
- Application state can be reset to avoid tests influencing themselves: `XCTMeasureOptions().invocationOptions = [.manualStop]`
- Listen to a live testing session at [8:15](https://developer.apple.com/wwdc20/10077/?time=498)